/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class WithinCodeAnnotationPointcut
extends NameBindingPointcut {
    private ExactAnnotationTypePattern annotationTypePattern;
    private ShadowMunger munger = null;

    public WithinCodeAnnotationPointcut(ExactAnnotationTypePattern type) {
        this.annotationTypePattern = type;
        this.pointcutKind = (byte)16;
    }

    public WithinCodeAnnotationPointcut(ExactAnnotationTypePattern type, ShadowMunger munger) {
        this(type);
        this.munger = munger;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo info) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        Object toMatchAgainst = null;
        Member member = shadow.getEnclosingCodeSignature();
        ResolvedMember rMember = member.resolve(shadow.getIWorld());
        if (rMember == null) {
            if (member.getName().startsWith("ajc$")) {
                return FuzzyBoolean.NO;
            }
            shadow.getIWorld().getLint().unresolvableMember.signal(member.toString(), this.getSourceLocation());
            return FuzzyBoolean.NO;
        }
        this.annotationTypePattern.resolve(shadow.getIWorld());
        return this.annotationTypePattern.matches(rMember);
    }

    protected void resolveBindings(IScope scope, Bindings bindings) {
        this.annotationTypePattern = (ExactAnnotationTypePattern)this.annotationTypePattern.resolveBindings(scope, bindings, true);
    }

    protected void resolveBindingsFromRTTI() {
    }

    protected Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        ExactAnnotationTypePattern newType = (ExactAnnotationTypePattern)this.annotationTypePattern.remapAdviceFormals(bindings);
        WithinCodeAnnotationPointcut ret = new WithinCodeAnnotationPointcut(newType, bindings.getEnclosingAdvice());
        ret.copyLocationFrom(this);
        return ret;
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        if (this.annotationTypePattern instanceof BindingAnnotationTypePattern) {
            BindingAnnotationTypePattern btp = (BindingAnnotationTypePattern)this.annotationTypePattern;
            TypeX annotationType = btp.annotationType;
            Var var = shadow.getWithinCodeAnnotationVar(annotationType);
            if (var == null) {
                return Literal.FALSE;
            }
            if (state.get(btp.getFormalIndex()) != null) {
                ISourceLocation pcdSloc = this.getSourceLocation();
                ISourceLocation shadowSloc = shadow.getSourceLocation();
                Message errorMessage = new Message("Cannot use @pointcut to match at this location and bind a formal to type '" + var.getType() + "' - the formal is already bound to type '" + state.get(btp.getFormalIndex()).getType() + "'" + ".  The secondary source location points to the problematic binding.", shadowSloc, true, new ISourceLocation[]{pcdSloc});
                shadow.getIWorld().getMessageHandler().handleMessage(errorMessage);
                state.setErroneousVar(btp.getFormalIndex());
            }
            state.set(btp.getFormalIndex(), var);
        }
        return Literal.TRUE;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(18);
        this.annotationTypePattern.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        AnnotationTypePattern type = AnnotationTypePattern.read(s, context);
        WithinCodeAnnotationPointcut ret = new WithinCodeAnnotationPointcut((ExactAnnotationTypePattern)type);
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof WithinCodeAnnotationPointcut)) {
            return false;
        }
        WithinCodeAnnotationPointcut o = (WithinCodeAnnotationPointcut)other;
        return o.annotationTypePattern.equals(this.annotationTypePattern);
    }

    public int hashCode() {
        int result = 17;
        result = 23 * result + this.annotationTypePattern.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("@withincode(");
        buf.append(this.annotationTypePattern.toString());
        buf.append(")");
        return buf.toString();
    }
}

