/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Member;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.lang.JoinPoint;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;

public class WithinPointcut
extends Pointcut {
    TypePattern typePattern;

    public WithinPointcut(TypePattern type) {
        this.typePattern = type;
        this.pointcutKind = (byte)2;
    }

    private FuzzyBoolean isWithinType(ResolvedTypeX type) {
        while (type != null) {
            if (this.typePattern.matchesStatically(type)) {
                return FuzzyBoolean.YES;
            }
            type = type.getDeclaringType();
        }
        return FuzzyBoolean.NO;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo info) {
        return this.isWithinType(info.getType());
    }

    public FuzzyBoolean match(Shadow shadow) {
        ResolvedTypeX enclosingType = shadow.getIWorld().resolve(shadow.getEnclosingType(), true);
        if (enclosingType == ResolvedTypeX.MISSING) {
            Message msg = new Message(WeaverMessages.format("cantFindTypeWithinpcd", shadow.getEnclosingType().getName()), shadow.getSourceLocation(), true, new ISourceLocation[]{this.getSourceLocation()});
            shadow.getIWorld().getMessageHandler().handleMessage(msg);
        }
        return this.isWithinType(enclosingType);
    }

    public FuzzyBoolean match(JoinPoint jp, JoinPoint.StaticPart encJp) {
        return this.isWithinType(encJp.getSignature().getDeclaringType());
    }

    public boolean matchesDynamically(Object thisObject, Object targetObject, Object[] args) {
        return true;
    }

    public FuzzyBoolean matchesStatically(String joinpointKind, Member member, Class thisClass, Class targetClass, Member withinCode) {
        if (!(member == null || joinpointKind.equals(Shadow.ConstructorCall.getName()) || joinpointKind.equals(Shadow.MethodCall.getName()) || joinpointKind.equals(Shadow.FieldGet.getName()) || joinpointKind.equals(Shadow.FieldSet.getName()))) {
            return this.isWithinType(member.getDeclaringClass());
        }
        return this.isWithinType(thisClass);
    }

    private FuzzyBoolean isWithinType(Class type) {
        while (type != null) {
            if (this.typePattern.matchesStatically(type)) {
                return FuzzyBoolean.YES;
            }
            type = type.getDeclaringClass();
        }
        return FuzzyBoolean.NO;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(2);
        this.typePattern.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        TypePattern type = TypePattern.read(s, context);
        WithinPointcut ret = new WithinPointcut(type);
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.typePattern = this.typePattern.resolveBindings(scope, bindings, false, false);
    }

    public void resolveBindingsFromRTTI() {
        this.typePattern = this.typePattern.resolveBindingsFromRTTI(false, false);
    }

    public void postRead(ResolvedTypeX enclosingType) {
        this.typePattern.postRead(enclosingType);
    }

    public boolean equals(Object other) {
        if (!(other instanceof WithinPointcut)) {
            return false;
        }
        WithinPointcut o = (WithinPointcut)other;
        return o.typePattern.equals(this.typePattern);
    }

    public int hashCode() {
        int result = 43;
        result = 37 * result + this.typePattern.hashCode();
        return result;
    }

    public String toString() {
        return "within(" + this.typePattern + ")";
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        return this.match(shadow).alwaysTrue() ? Literal.TRUE : Literal.FALSE;
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        return new WithinPointcut(this.typePattern);
    }
}

