/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.core.index;

import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.core.util.SimpleSet;

public class EntryResult {

private char[] word;
private HashtableOfObject[] documentTables;
private SimpleSet documentNames;

public EntryResult(char[] word, HashtableOfObject table) {
	this.word = word;
	if (table != null)
		this.documentTables = new HashtableOfObject[] {table};
}
public void addDocumentName(String documentName) {
	if (this.documentNames == null)
		this.documentNames = new SimpleSet(3);
	this.documentNames.add(documentName);
}
public void addDocumentTable(HashtableOfObject table) {
	if (this.documentTables == null) {
		this.documentTables = new HashtableOfObject[] {table};
		return;
	}

	int length = this.documentTables.length;
	System.arraycopy(this.documentTables, 0, this.documentTables = new HashtableOfObject[length + 1], 0, length);
	this.documentTables[length] = table;
}
public char[] getWord() {
	return this.word;
}
public String[] getDocumentNames(Index index) throws java.io.IOException {
	if (this.documentTables != null) {
		for (int i = 0, l = this.documentTables.length; i < l; i++) {
			Object offset = this.documentTables[i].get(word);
			int[] numbers = index.diskIndex.readDocumentNumbers(offset);
			for (int j = 0, k = numbers.length; j < k; j++)
				addDocumentName(index.diskIndex.readDocumentName(numbers[j]));
		}
	}

	if (this.documentNames == null)
		return new String[0];

	String[] names = new String[this.documentNames.elementSize];
	int count = 0;
	Object[] values = this.documentNames.values;
	for (int i = 0, l = values.length; i < l; i++)
		if (values[i] != null)
			names[count++] = (String) values[i];
	return names;
}
public boolean isEmpty() {
	return this.documentTables == null && this.documentNames == null;
}
}
