/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;

public abstract class AbstractLayout
implements LayoutManager {
    private Dimension preferredSize;

    protected abstract Dimension calculatePreferredSize(IFigure var1);

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return this.calculatePreferredSize(container);
    }

    protected Dimension getBorderPreferredSize(IFigure container) {
        if (container.getBorder() == null) {
            return new Dimension();
        }
        return container.getBorder().getPreferredSize(container);
    }

    public Object getConstraint(IFigure child) {
        return null;
    }

    public Dimension getMinimumSize(IFigure container) {
        return this.getPreferredSize(container);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        if (this.preferredSize == null) {
            this.preferredSize = this.calculatePreferredSize(container, wHint, hHint);
        }
        return this.preferredSize;
    }

    public Dimension getPreferredSize(IFigure container) {
        return this.getPreferredSize(container, -1, -1);
    }

    public void invalidate() {
        this.preferredSize = null;
    }

    public void invalidate(IFigure figure) {
        this.invalidate();
    }

    public void remove(IFigure child) {
        this.invalidate();
    }

    public void setConstraint(IFigure figure, Object constraint) {
        this.invalidate(figure);
    }

    public abstract void layout(IFigure var1);
}

