/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;

public class Insets
implements Cloneable,
Serializable {
    public int left;
    public int top;
    public int bottom;
    public int right;
    static final long serialVersionUID = 1L;

    public Insets() {
    }

    public Insets(Insets i) {
        this(i.top, i.left, i.bottom, i.right);
    }

    public Insets(int i) {
        this(i, i, i, i);
    }

    public Insets(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Insets add(Insets insets) {
        this.top += insets.top;
        this.bottom += insets.bottom;
        this.left += insets.left;
        this.right += insets.right;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof Insets) {
            Insets i = (Insets)o;
            return i.top == this.top && i.bottom == this.bottom && i.left == this.left && i.right == this.right;
        }
        return false;
    }

    public Insets getAdded(Insets insets) {
        return new Insets(this).add(insets);
    }

    public int getHeight() {
        return this.top + this.bottom;
    }

    public Insets getTransposed() {
        return new Insets(this).transpose();
    }

    public int getWidth() {
        return this.left + this.right;
    }

    public boolean isEmpty() {
        return this.left == 0 && this.right == 0 && this.top == 0 && this.bottom == 0;
    }

    public String toString() {
        return "Insets(t=" + this.top + ",l=" + this.left + ",b=" + this.bottom + ",r=" + this.right + ")";
    }

    public Insets transpose() {
        int temp = this.top;
        this.top = this.left;
        this.left = temp;
        temp = this.right;
        this.right = this.bottom;
        this.bottom = temp;
        return this;
    }
}

