/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.examples;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.examples.AspectJExampleCreationWizardPage;
import org.eclipse.ajdt.examples.AspectJExampleMessages;
import org.eclipse.ajdt.examples.AspectJExamplePlugin;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class AspectJExampleCreationOperation
implements IRunnableWithProgress {
    private IResource fElementToOpen = null;
    private AspectJExampleCreationWizardPage[] fPages;
    private IOverwriteQuery fOverwriteQuery;

    public AspectJExampleCreationOperation(AspectJExampleCreationWizardPage[] aspectJExampleCreationWizardPageArray, IOverwriteQuery iOverwriteQuery) {
        this.fPages = aspectJExampleCreationWizardPageArray;
        this.fOverwriteQuery = iOverwriteQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(AspectJExampleMessages.getString("ExampleProjectCreationOperation.op_desc"), this.fPages.length);
            IWorkspaceRoot iWorkspaceRoot = AspectJExamplePlugin.getWorkspace().getRoot();
            for (int i = 0; i < this.fPages.length; ++i) {
                this.createProject(iWorkspaceRoot, this.fPages[i], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        finally {
            iProgressMonitor.done();
        }
        AJDTUtils.verifyWorkbenchConfiguration();
    }

    public IResource getElementToOpen() {
        return this.fElementToOpen;
    }

    private void createProject(IWorkspaceRoot iWorkspaceRoot, AspectJExampleCreationWizardPage aspectJExampleCreationWizardPage, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        String string;
        IConfigurationElement iConfigurationElement = aspectJExampleCreationWizardPage.getConfigurationElement();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("import");
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("nature");
        IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement.getChildren("references");
        int n = iConfigurationElementArray == null ? 0 : iConfigurationElementArray.length;
        int n2 = iConfigurationElementArray2 == null ? 0 : iConfigurationElementArray2.length;
        int n3 = iConfigurationElementArray3 == null ? 0 : iConfigurationElementArray3.length;
        iProgressMonitor.beginTask(AspectJExampleMessages.getString("ExampleProjectCreationOperation.op_desc_proj"), n + 1);
        String string2 = aspectJExampleCreationWizardPage.getName();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = iConfigurationElementArray2[i].getAttribute("id");
        }
        IProject[] iProjectArray = new IProject[n3];
        for (int i = 0; i < n3; ++i) {
            iProjectArray[i] = iWorkspaceRoot.getProject(iConfigurationElementArray3[i].getAttribute("id"));
        }
        IProject iProject = this.configNewProject(iWorkspaceRoot, string2, stringArray, iProjectArray, iProgressMonitor);
        for (int i = 0; i < n; ++i) {
            this.doImports(iProject, iConfigurationElementArray[i], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        this.setSrcFolder(iProject);
        String string3 = iConfigurationElement.getAttribute("open");
        if (string3 != null && string3.length() > 0 && (string = iProject.findMember((IPath)new Path(string3))) != null) {
            this.fElementToOpen = string;
        }
        if ((string = iConfigurationElement.getAttribute("build")) != null) {
            AspectJPreferences.setActiveBuildConfigurationName((IProject)iProject, (String)string);
        }
        ProjectBuildConfigurator projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(iProject);
        projectBuildConfigurator.reInit();
        try {
            IFile iFile;
            BuildConfiguration buildConfiguration;
            IResource[] iResourceArray = iProject.members(1);
            int n4 = 0;
            for (int i = 0; i < iResourceArray.length; ++i) {
                if (iResourceArray[i].getType() == 2 || !"ajproperties".equals(iResourceArray[i].getFileExtension()) || !iResourceArray[i].exists()) continue;
                ++n4;
            }
            if (n4 > 1 && (buildConfiguration = projectBuildConfigurator.getBuildConfiguration(iFile = (IFile)iProject.findMember(BuildConfiguration.STANDARD_BUILD_CONFIGURATION_NAME + "." + "ajproperties"))) != null) {
                projectBuildConfigurator.removeBuildConfiguration(buildConfiguration);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private IProject configNewProject(IWorkspaceRoot iWorkspaceRoot, String string, String[] stringArray, IProject[] iProjectArray, IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        try {
            IProject iProject = iWorkspaceRoot.getProject(string);
            if (!iProject.exists()) {
                iProject.create(null);
            }
            if (!iProject.isOpen()) {
                iProject.open(null);
            }
            IProjectDescription iProjectDescription = iProject.getDescription();
            iProjectDescription.setLocation(null);
            iProjectDescription.setNatureIds(stringArray);
            iProjectDescription.setReferencedProjects(iProjectArray);
            iProject.setDescription(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProjectDescription = iProject.getDescription();
            ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
            if (this.contains(iCommandArray, "org.eclipse.jdt.core.javabuilder")) {
                iProjectDescription.setBuildSpec(this.remove(iCommandArray, "org.eclipse.jdt.core.javabuilder"));
                iProject.setDescription(iProjectDescription, null);
            }
            AJDTUtils.addAjrtToBuildPath((IProject)iProject);
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            try {
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                IClasspathEntry iClasspathEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
                int n = iClasspathEntryArray.length;
                IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[n + 1];
                System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, n);
                iClasspathEntryArray2[n] = iClasspathEntry;
                iJavaProject.setRawClasspath(iClasspathEntryArray2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
            return iProject;
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    private boolean contains(ICommand[] iCommandArray, String string) {
        boolean bl = false;
        for (int i = 0; i < iCommandArray.length; ++i) {
            if (!iCommandArray[i].getBuilderName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ICommand[] remove(ICommand[] iCommandArray, String string) {
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length - 1];
        int n = 0;
        for (int i = 0; i < iCommandArray.length; ++i) {
            if (iCommandArray[i].getBuilderName().equals(string)) continue;
            iCommandArray2[n++] = iCommandArray[i];
        }
        return iCommandArray2;
    }

    private void doImports(IProject iProject, IConfigurationElement iConfigurationElement, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            Object object;
            IPath iPath;
            String string = iConfigurationElement.getAttribute("dest");
            if (string == null || string.length() == 0) {
                iPath = iProject.getFullPath();
            } else {
                object = iProject.getFolder(string);
                if (!object.exists()) {
                    object.create(true, true, null);
                }
                iPath = object.getFullPath();
            }
            object = iConfigurationElement.getAttribute("src");
            if (object == null) {
                object = "";
                AspectJExamplePlugin.log("projectsetup descriptor: import missing");
                return;
            }
            ZipFile zipFile = this.getZipFileFromPluginDir((String)object);
            this.importFilesFromZip(zipFile, iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    private void setSrcFolder(IProject iProject) {
        try {
            IResource iResource = iProject.findMember("src");
            if (iResource != null && iResource.getType() == 2) {
                IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                boolean bl = false;
                for (int i = 0; !bl && i < iClasspathEntryArray.length; ++i) {
                    if (iClasspathEntryArray[i].getEntryKind() != 3) continue;
                    iClasspathEntryArray[i] = JavaCore.newSourceEntry((IPath)iResource.getFullPath());
                    iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new NullProgressMonitor());
                    bl = true;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    private ZipFile getZipFileFromPluginDir(String string) throws CoreException {
        try {
            URL uRL = new URL(AspectJExamplePlugin.getDefault().getBundle().getEntry("/"), string);
            return new ZipFile(Platform.asLocalURL((URL)uRL).getFile());
        }
        catch (IOException iOException) {
            String string2 = string + ": " + iOException.getMessage();
            Status status = new Status(4, AspectJExamplePlugin.getPluginId(), 4, string2, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile zipFile, IPath iPath, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(zipFile);
        ImportOperation importOperation = new ImportOperation(iPath, (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, this.fOverwriteQuery);
        importOperation.run(iProgressMonitor);
    }
}

