/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;

public class JavaSearchPattern
extends SearchPattern {
    boolean isCaseSensitive;
    boolean isErasureMatch;
    int matchMode;
    public static final int MATCH_MODE_MASK = 7;
    public static final int MATCH_RULE_INDEX_MASK = 15;
    char[][] typeSignatures;
    char[][][] typeArguments;

    protected JavaSearchPattern(int patternKind, int matchRule) {
        super(matchRule);
        this.kind = patternKind;
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.isErasureMatch = (matchRule & 0x10) != 0;
        this.matchMode = matchRule & 7;
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    int getMatchMode() {
        return this.matchMode;
    }

    boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    boolean isErasureMatch() {
        return this.isErasureMatch;
    }

    public boolean isParameterized() {
        return this.typeArguments != null && this.typeArguments.length > 0;
    }

    void computeSignature(String signature) {
        char[] source = signature.replace('/', '.').replace('$', '.').toCharArray();
        char[][] signatures = new char[10][];
        int signaturesCount = 0;
        int[] lengthes = new int[10];
        int typeArgsCount = 0;
        int paramOpening = 0;
        boolean parameterized = false;
        int idx = 0;
        int ln = source.length;
        while (idx < ln) {
            switch (source[idx]) {
                case '>': {
                    if (--paramOpening != 0) break;
                    if (signaturesCount == lengthes.length) {
                        char[][] cArray = signatures;
                        signatures = new char[signaturesCount + 10][];
                        System.arraycopy(cArray, 0, signatures, 0, signaturesCount);
                        int[] nArray = lengthes;
                        lengthes = new int[signaturesCount + 10];
                        System.arraycopy(nArray, 0, lengthes, 0, signaturesCount);
                    }
                    lengthes[signaturesCount] = typeArgsCount;
                    typeArgsCount = 0;
                    break;
                }
                case '<': {
                    if (++paramOpening != 1) break;
                    typeArgsCount = 0;
                    parameterized = true;
                    break;
                }
                case '*': 
                case ';': {
                    if (paramOpening != 1) break;
                    ++typeArgsCount;
                    break;
                }
                case '.': {
                    if (paramOpening != 0) break;
                    if (signaturesCount == lengthes.length) {
                        char[][] cArray = signatures;
                        signatures = new char[signaturesCount + 10][];
                        System.arraycopy(cArray, 0, signatures, 0, signaturesCount);
                        int[] nArray = lengthes;
                        lengthes = new int[signaturesCount + 10];
                        System.arraycopy(nArray, 0, lengthes, 0, signaturesCount);
                    }
                    signatures[signaturesCount] = new char[idx + 1];
                    System.arraycopy(source, 0, signatures[signaturesCount], 0, idx);
                    signatures[signaturesCount][idx] = 59;
                    ++signaturesCount;
                }
            }
            ++idx;
        }
        this.typeSignatures = new char[signaturesCount + 1][];
        if (parameterized) {
            this.typeArguments = new char[signaturesCount + 1][][];
        }
        this.typeSignatures[0] = source;
        if (parameterized) {
            this.typeArguments[0] = Signature.getTypeArguments(source);
            int cfr_ignored_0 = lengthes[signaturesCount];
            this.typeArguments[0].getClass();
        }
        int i = 1;
        int j = signaturesCount - 1;
        while (i <= signaturesCount) {
            this.typeSignatures[i] = signatures[j];
            if (parameterized) {
                this.typeArguments[i] = Signature.getTypeArguments(signatures[j]);
                int cfr_ignored_1 = lengthes[j];
                this.typeArguments[i].getClass();
            }
            ++i;
            --j;
        }
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this.matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this.isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this.isCaseSensitive);
                }
                case 2: {
                    if (!this.isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this.isCaseSensitive);
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    protected StringBuffer print(StringBuffer output) {
        output.append(", ");
        if (this.typeSignatures != null && this.typeSignatures.length > 0) {
            output.append("signature:\"");
            output.append(this.typeSignatures[0]);
            output.append("\", ");
        }
        switch (this.getMatchMode()) {
            case 0: {
                output.append("exact match,");
                break;
            }
            case 1: {
                output.append("prefix match,");
                break;
            }
            case 2: {
                output.append("pattern match,");
            }
        }
        if (this.isCaseSensitive()) {
            output.append(" case sensitive");
        } else {
            output.append(" case insensitive");
        }
        if (this.isErasureMatch()) {
            output.append(", erasure only");
        }
        return output;
    }

    public final String toString() {
        return this.print(new StringBuffer(30)).toString();
    }
}

