/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelObjectType;

final class BcelField
extends ResolvedMember {
    private Field field;
    private boolean isAjSynthetic;
    private boolean isSynthetic = false;
    private ResolvedTypeX[] annotationTypes;
    private AnnotationX[] annotations;
    private World world;

    BcelField(BcelObjectType declaringType, Field field) {
        super(Member.FIELD, declaringType.getResolvedTypeX(), field.getAccessFlags(), field.getName(), field.getSignature());
        this.field = field;
        this.world = declaringType.getResolvedTypeX().getWorld();
        this.unpackAttributes(this.world);
        this.checkedExceptions = TypeX.NONE;
    }

    private void unpackAttributes(World world) {
        Attribute[] attrs = this.field.getAttributes();
        List as = BcelAttributes.readAjAttributes(this.getDeclaringType().getClassName(), attrs, this.getSourceContext(world), world.getMessageHandler());
        Iterator iter = as.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.AjSynthetic) {
                this.isAjSynthetic = true;
                continue;
            }
            throw new BCException("weird field attribute " + a);
        }
        this.isAjSynthetic = false;
        for (int i = attrs.length - 1; i >= 0; --i) {
            if (!(attrs[i] instanceof Synthetic)) continue;
            this.isSynthetic = true;
        }
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean hasAnnotation(TypeX ofType) {
        Annotation[] anns = this.field.getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            Annotation annotation = anns[i];
            if (!annotation.getTypeName().equals(ofType.getName())) continue;
            return true;
        }
        return false;
    }

    public ResolvedTypeX[] getAnnotationTypes() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotationTypes;
    }

    private void ensureAnnotationTypesRetrieved() {
        if (this.annotationTypes == null) {
            Annotation[] annos = this.field.getAnnotations();
            this.annotationTypes = new ResolvedTypeX[annos.length];
            this.annotations = new AnnotationX[annos.length];
            for (int i = 0; i < annos.length; ++i) {
                ResolvedTypeX rtx;
                Annotation annotation = annos[i];
                this.annotationTypes[i] = rtx = this.world.resolve(TypeX.forName(annotation.getTypeName()));
                this.annotations[i] = new AnnotationX(annotation, this.world);
            }
        }
    }

    public void addAnnotation(AnnotationX annotation) {
        this.ensureAnnotationTypesRetrieved();
        int len = this.annotations.length;
        AnnotationX[] ret = new AnnotationX[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        len = this.annotationTypes.length;
        ResolvedTypeX[] ret2 = new ResolvedTypeX[len + 1];
        System.arraycopy(this.annotationTypes, 0, ret2, 0, len);
        ret2[len] = this.world.resolve(TypeX.forName(annotation.getTypeName()));
        this.annotationTypes = ret2;
        this.field.addAnnotation(annotation.getBcelAnnotation());
    }
}

