/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.FileUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AnnotationOnTypeMunger;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.IWeaver;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.WeaverMetrics;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelClassWeaver;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.CflowPointcut;
import org.aspectj.weaver.patterns.ConcreteCflowPointcut;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.PointcutRewriter;
import org.aspectj.weaver.patterns.WithinPointcut;

public class BcelWeaver
implements IWeaver {
    private BcelWorld world;
    private CrosscuttingMembersSet xcutSet;
    private IProgressListener progressListener = null;
    private double progressMade;
    private double progressPerClassFile;
    private boolean inReweavableMode = false;
    private List addedClasses = new ArrayList();
    private List deletedTypenames = new ArrayList();
    private Manifest manifest = null;
    private boolean needToReweaveWorld = false;
    private List shadowMungerList = null;
    private List typeMungerList = null;
    private List declareParentsList = null;
    private ZipOutputStream zipOutputStream;
    private Set alreadyConfirmedReweavableState;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String WEAVER_MANIFEST_VERSION = "1.0";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String WEAVER_CREATED_BY = "AspectJ Compiler";
    static /* synthetic */ Class class$org$aspectj$weaver$patterns$WithinPointcut;
    static /* synthetic */ Class class$org$aspectj$weaver$patterns$KindedPointcut;

    public BcelWeaver(BcelWorld world) {
        WeaverMetrics.reset();
        this.world = world;
        this.xcutSet = world.getCrosscuttingMembersSet();
    }

    public BcelWeaver() {
        this(new BcelWorld());
    }

    public void setShadowMungers(List l) {
        this.shadowMungerList = l;
    }

    public void addLibraryAspect(String aspectName) {
        ResolvedTypeX type = this.world.resolve(aspectName);
        if (!type.isAspect()) {
            throw new RuntimeException("unimplemented");
        }
        this.xcutSet.addOrReplaceAspect(type);
    }

    public void addLibraryJarFile(File inFile) throws IOException {
        List addedAspects = null;
        addedAspects = inFile.isDirectory() ? this.addAspectsFromDirectory(inFile) : this.addAspectsFromJarFile(inFile);
        Iterator i = addedAspects.iterator();
        while (i.hasNext()) {
            ResolvedTypeX aspectX = (ResolvedTypeX)i.next();
            this.xcutSet.addOrReplaceAspect(aspectX);
        }
    }

    private List addAspectsFromJarFile(File inFile) throws FileNotFoundException, IOException {
        ZipEntry entry;
        ZipInputStream inStream = new ZipInputStream(new FileInputStream(inFile));
        ArrayList addedAspects = new ArrayList();
        while ((entry = inStream.getNextEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            this.addIfAspect(FileUtil.readAsByteArray(inStream), entry.getName(), addedAspects);
            inStream.closeEntry();
        }
        inStream.close();
        return addedAspects;
    }

    private List addAspectsFromDirectory(File dir) throws FileNotFoundException, IOException {
        ArrayList addedAspects = new ArrayList();
        File[] classFiles = FileUtil.listFiles(dir, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".class");
            }
        });
        for (int i = 0; i < classFiles.length; ++i) {
            FileInputStream fis = new FileInputStream(classFiles[i]);
            byte[] bytes = FileUtil.readAsByteArray(fis);
            this.addIfAspect(bytes, classFiles[i].getAbsolutePath(), addedAspects);
        }
        return addedAspects;
    }

    private void addIfAspect(byte[] bytes, String name, List toList) throws IOException {
        ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), name);
        JavaClass jc = parser.parse();
        ResolvedTypeX.Name type = this.world.addSourceObjectType(jc).getResolvedTypeX();
        if (((ResolvedTypeX)type).isAspect()) {
            toList.add(type);
        }
    }

    public List addDirectoryContents(File inFile, File outDir) throws IOException {
        ArrayList<UnwovenClassFile> addedClassFiles = new ArrayList<UnwovenClassFile>();
        File[] files = FileUtil.listFiles(inFile, new FileFilter(){

            public boolean accept(File f) {
                boolean accept = !f.isDirectory();
                return accept;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            addedClassFiles.add(this.addClassFile(files[i], inFile, outDir));
        }
        return addedClassFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List addJarFile(File inFile, File outDir, boolean canBeDirectory) {
        Message message;
        ArrayList<UnwovenClassFile> addedClassFiles = new ArrayList<UnwovenClassFile>();
        this.needToReweaveWorld = true;
        ZipFile inJar = null;
        try {
            if (inFile.isDirectory() && canBeDirectory) {
                addedClassFiles.addAll(this.addDirectoryContents(inFile, outDir));
            } else {
                inJar = new JarFile(inFile);
                this.addManifest(((JarFile)inJar).getManifest());
                Enumeration<JarEntry> entries = ((JarFile)inJar).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    InputStream inStream = ((JarFile)inJar).getInputStream(entry);
                    byte[] bytes = FileUtil.readAsByteArray(inStream);
                    String filename = entry.getName();
                    UnwovenClassFile classFile = new UnwovenClassFile(new File(outDir, filename).getAbsolutePath(), bytes);
                    if (filename.endsWith(".class")) {
                        this.addClassFile(classFile);
                        addedClassFiles.add(classFile);
                    }
                    inStream.close();
                }
                inJar.close();
            }
        }
        catch (FileNotFoundException ex) {
            message = new Message("Could not find input jar file " + inFile.getPath() + ", ignoring", new SourceLocation(inFile, 0), false);
            this.world.getMessageHandler().handleMessage(message);
        }
        catch (IOException ex) {
            Message message2 = new Message("Could not read input jar file " + inFile.getPath() + "(" + ex.getMessage() + ")", new SourceLocation(inFile, 0), true);
            this.world.getMessageHandler().handleMessage(message2);
        }
        finally {
            if (inJar != null) {
                try {
                    inJar.close();
                }
                catch (IOException ex) {
                    message = new Message("Could not close input jar file " + inFile.getPath() + "(" + ex.getMessage() + ")", new SourceLocation(inFile, 0), true);
                    this.world.getMessageHandler().handleMessage(message);
                }
            }
        }
        return addedClassFiles;
    }

    public boolean needToReweaveWorld() {
        return this.needToReweaveWorld;
    }

    public void addClassFile(UnwovenClassFile classFile) {
        this.addedClasses.add(classFile);
        this.world.addSourceObjectType(classFile.getJavaClass());
    }

    public UnwovenClassFile addClassFile(File classFile, File inPathDir, File outDir) throws IOException {
        FileInputStream fis = new FileInputStream(classFile);
        byte[] bytes = FileUtil.readAsByteArray(fis);
        String filename = classFile.getAbsolutePath().substring(inPathDir.getAbsolutePath().length() + 1);
        UnwovenClassFile ucf = new UnwovenClassFile(new File(outDir, filename).getAbsolutePath(), bytes);
        if (filename.endsWith(".class")) {
            this.addClassFile(ucf);
        }
        fis.close();
        return ucf;
    }

    public void deleteClassFile(String typename) {
        this.deletedTypenames.add(typename);
        this.world.deleteSourceObjectType(TypeX.forName(typename));
    }

    public void prepareForWeave() {
        this.needToReweaveWorld = false;
        CflowPointcut.clearCaches();
        Iterator i = this.addedClasses.iterator();
        while (i.hasNext()) {
            UnwovenClassFile jc = (UnwovenClassFile)i.next();
            String name = jc.getClassName();
            ResolvedTypeX type = this.world.resolve(name);
            if (!type.isAspect()) continue;
            this.needToReweaveWorld |= this.xcutSet.addOrReplaceAspect(type);
        }
        i = this.deletedTypenames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!this.xcutSet.deleteAspect(TypeX.forName(name))) continue;
            this.needToReweaveWorld = true;
        }
        this.shadowMungerList = this.xcutSet.getShadowMungers();
        this.rewritePointcuts(this.shadowMungerList);
        this.typeMungerList = this.xcutSet.getTypeMungers();
        this.declareParentsList = this.xcutSet.getDeclareParents();
        Collections.sort(this.shadowMungerList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
    }

    private void rewritePointcuts(List shadowMungers) {
        PointcutRewriter rewriter = new PointcutRewriter();
        Iterator iter = shadowMungers.iterator();
        while (iter.hasNext()) {
            int numFormals;
            Advice advice;
            ShadowMunger munger = (ShadowMunger)iter.next();
            Pointcut p = munger.getPointcut();
            Pointcut newP = rewriter.rewrite(p);
            if (munger instanceof Advice && (advice = (Advice)munger).getSignature() != null && (numFormals = advice.getBaseParameterCount()) > 0) {
                String[] names = advice.getBaseParameterNames(this.world);
                this.validateBindings(newP, p, numFormals, names);
            }
            munger.setPointcut(newP);
        }
        HashMap pcMap = new HashMap();
        Iterator iter2 = shadowMungers.iterator();
        while (iter2.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter2.next();
            Pointcut p = munger.getPointcut();
            munger.setPointcut(this.shareEntriesFromMap(p, pcMap));
        }
    }

    private Pointcut shareEntriesFromMap(Pointcut p, Map pcMap) {
        if (p instanceof NameBindingPointcut) {
            return p;
        }
        if (p instanceof IfPointcut) {
            return p;
        }
        if (p instanceof ConcreteCflowPointcut) {
            return p;
        }
        if (p instanceof AndPointcut) {
            AndPointcut apc = (AndPointcut)p;
            Pointcut left = this.shareEntriesFromMap(apc.getLeft(), pcMap);
            Pointcut right = this.shareEntriesFromMap(apc.getRight(), pcMap);
            return new AndPointcut(left, right);
        }
        if (p instanceof OrPointcut) {
            OrPointcut opc = (OrPointcut)p;
            Pointcut left = this.shareEntriesFromMap(opc.getLeft(), pcMap);
            Pointcut right = this.shareEntriesFromMap(opc.getRight(), pcMap);
            return new OrPointcut(left, right);
        }
        if (p instanceof NotPointcut) {
            NotPointcut npc = (NotPointcut)p;
            Pointcut not = this.shareEntriesFromMap(npc.getNegatedPointcut(), pcMap);
            return new NotPointcut(not);
        }
        if (pcMap.containsKey(p)) {
            return (Pointcut)pcMap.get(p);
        }
        pcMap.put(p, p);
        return p;
    }

    private void validateBindings(Pointcut dnfPointcut, Pointcut userPointcut, int numFormals, String[] names) {
        if (numFormals == 0) {
            return;
        }
        if (dnfPointcut.couldMatchKinds().isEmpty()) {
            return;
        }
        if (dnfPointcut instanceof OrPointcut) {
            OrPointcut orBasedDNFPointcut = (OrPointcut)dnfPointcut;
            Pointcut[] leftBindings = new Pointcut[numFormals];
            Pointcut[] rightBindings = new Pointcut[numFormals];
            this.validateOrBranch(orBasedDNFPointcut, userPointcut, numFormals, names, leftBindings, rightBindings);
        } else {
            Pointcut[] bindings = new Pointcut[numFormals];
            this.validateSingleBranch(dnfPointcut, userPointcut, numFormals, names, bindings);
        }
    }

    private void validateOrBranch(OrPointcut pc, Pointcut userPointcut, int numFormals, String[] names, Pointcut[] leftBindings, Pointcut[] rightBindings) {
        Pointcut left = pc.getLeft();
        Pointcut right = pc.getRight();
        if (left instanceof OrPointcut) {
            Pointcut[] newRightBindings = new Pointcut[numFormals];
            this.validateOrBranch((OrPointcut)left, userPointcut, numFormals, names, leftBindings, newRightBindings);
        } else if (left.couldMatchKinds().size() > 0) {
            this.validateSingleBranch(left, userPointcut, numFormals, names, leftBindings);
        }
        if (right instanceof OrPointcut) {
            Pointcut[] newLeftBindings = new Pointcut[numFormals];
            this.validateOrBranch((OrPointcut)right, userPointcut, numFormals, names, newLeftBindings, rightBindings);
        } else if (right.couldMatchKinds().size() > 0) {
            this.validateSingleBranch(right, userPointcut, numFormals, names, rightBindings);
        }
        Set kindsInCommon = left.couldMatchKinds();
        kindsInCommon.retainAll(right.couldMatchKinds());
        if (!kindsInCommon.isEmpty() && this.couldEverMatchSameJoinPoints(left, right)) {
            ArrayList<String> ambiguousNames = new ArrayList<String>();
            for (int i = 0; i < numFormals; ++i) {
                if (leftBindings[i].equals(rightBindings[i])) continue;
                ambiguousNames.add(names[i]);
            }
            if (!ambiguousNames.isEmpty()) {
                this.raiseAmbiguityInDisjunctionError(userPointcut, ambiguousNames);
            }
        }
    }

    private void validateSingleBranch(Pointcut pc, Pointcut userPointcut, int numFormals, String[] names, Pointcut[] bindings) {
        int i;
        boolean[] foundFormals = new boolean[numFormals];
        for (i = 0; i < foundFormals.length; ++i) {
            foundFormals[i] = false;
        }
        this.validateSingleBranchRecursion(pc, userPointcut, foundFormals, names, bindings);
        for (i = 0; i < foundFormals.length; ++i) {
            if (foundFormals[i]) continue;
            this.raiseUnboundFormalError(names[i], userPointcut);
        }
    }

    private void validateSingleBranchRecursion(Pointcut pc, Pointcut userPointcut, boolean[] foundFormals, String[] names, Pointcut[] bindings) {
        block12: {
            block11: {
                NameBindingPointcut nnbp;
                if (!(pc instanceof NotPointcut)) break block11;
                NotPointcut not = (NotPointcut)pc;
                if (!(not.getNegatedPointcut() instanceof NameBindingPointcut) || (nnbp = (NameBindingPointcut)not.getNegatedPointcut()).getBindingAnnotationTypePatterns().isEmpty() || nnbp.getBindingTypePatterns().isEmpty()) break block12;
                this.raiseNegationBindingError(userPointcut);
                break block12;
            }
            if (pc instanceof AndPointcut) {
                AndPointcut and = (AndPointcut)pc;
                this.validateSingleBranchRecursion(and.getLeft(), userPointcut, foundFormals, names, bindings);
                this.validateSingleBranchRecursion(and.getRight(), userPointcut, foundFormals, names, bindings);
            } else if (pc instanceof NameBindingPointcut) {
                List btps = ((NameBindingPointcut)pc).getBindingTypePatterns();
                Iterator iter = btps.iterator();
                while (iter.hasNext()) {
                    BindingTypePattern btp = (BindingTypePattern)iter.next();
                    int index = btp.getFormalIndex();
                    bindings[index] = pc;
                    if (foundFormals[index]) {
                        this.raiseAmbiguousBindingError(names[index], userPointcut);
                        continue;
                    }
                    foundFormals[index] = true;
                }
                List baps = ((NameBindingPointcut)pc).getBindingAnnotationTypePatterns();
                Iterator iter2 = baps.iterator();
                while (iter2.hasNext()) {
                    BindingAnnotationTypePattern bap = (BindingAnnotationTypePattern)iter2.next();
                    int index = bap.getFormalIndex();
                    bindings[index] = pc;
                    if (foundFormals[index]) {
                        this.raiseAmbiguousBindingError(names[index], userPointcut);
                        continue;
                    }
                    foundFormals[index] = true;
                }
            } else if (pc instanceof ConcreteCflowPointcut) {
                ConcreteCflowPointcut cfp = (ConcreteCflowPointcut)pc;
                int[] slots = cfp.getUsedFormalSlots();
                for (int i = 0; i < slots.length; ++i) {
                    bindings[slots[i]] = cfp;
                    if (foundFormals[slots[i]]) {
                        this.raiseAmbiguousBindingError(names[slots[i]], userPointcut);
                        continue;
                    }
                    foundFormals[slots[i]] = true;
                }
            }
        }
    }

    private boolean couldEverMatchSameJoinPoints(Pointcut left, Pointcut right) {
        if (left instanceof OrPointcut || right instanceof OrPointcut) {
            return true;
        }
        WithinPointcut leftWithin = (WithinPointcut)this.findFirstPointcutIn(left, class$org$aspectj$weaver$patterns$WithinPointcut == null ? (class$org$aspectj$weaver$patterns$WithinPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.WithinPointcut")) : class$org$aspectj$weaver$patterns$WithinPointcut);
        WithinPointcut rightWithin = (WithinPointcut)this.findFirstPointcutIn(right, class$org$aspectj$weaver$patterns$WithinPointcut == null ? (class$org$aspectj$weaver$patterns$WithinPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.WithinPointcut")) : class$org$aspectj$weaver$patterns$WithinPointcut);
        if (leftWithin != null && rightWithin != null && !leftWithin.couldEverMatchSameJoinPointsAs(rightWithin)) {
            return false;
        }
        KindedPointcut leftKind = (KindedPointcut)this.findFirstPointcutIn(left, class$org$aspectj$weaver$patterns$KindedPointcut == null ? (class$org$aspectj$weaver$patterns$KindedPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.KindedPointcut")) : class$org$aspectj$weaver$patterns$KindedPointcut);
        KindedPointcut rightKind = (KindedPointcut)this.findFirstPointcutIn(right, class$org$aspectj$weaver$patterns$KindedPointcut == null ? (class$org$aspectj$weaver$patterns$KindedPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.KindedPointcut")) : class$org$aspectj$weaver$patterns$KindedPointcut);
        return leftKind == null || rightKind == null || leftKind.couldEverMatchSameJoinPointsAs(rightKind);
    }

    private Pointcut findFirstPointcutIn(Pointcut toSearch, Class toLookFor) {
        if (toSearch instanceof NotPointcut) {
            return null;
        }
        if (toLookFor.isInstance(toSearch)) {
            return toSearch;
        }
        if (toSearch instanceof AndPointcut) {
            AndPointcut apc = (AndPointcut)toSearch;
            Pointcut left = this.findFirstPointcutIn(apc.getLeft(), toLookFor);
            if (left != null) {
                return left;
            }
            return this.findFirstPointcutIn(apc.getRight(), toLookFor);
        }
        return null;
    }

    private void raiseNegationBindingError(Pointcut userPointcut) {
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("negationDoesntAllowBinding"), userPointcut.getSourceContext().makeSourceLocation(userPointcut), null);
    }

    private void raiseAmbiguousBindingError(String name, Pointcut userPointcut) {
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("ambiguousBindingInPC", name), userPointcut.getSourceContext().makeSourceLocation(userPointcut), null);
    }

    private void raiseAmbiguityInDisjunctionError(Pointcut userPointcut, List names) {
        StringBuffer formalNames = new StringBuffer(names.get(0).toString());
        for (int i = 1; i < names.size(); ++i) {
            formalNames.append(", ");
            formalNames.append(names.get(i));
        }
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("ambiguousBindingInOrPC", formalNames), userPointcut.getSourceContext().makeSourceLocation(userPointcut), null);
    }

    private void raiseUnboundFormalError(String name, Pointcut userPointcut) {
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("unboundFormalInPC", name), userPointcut.getSourceContext().makeSourceLocation(userPointcut), null);
    }

    public void addManifest(Manifest newManifest) {
        if (this.manifest == null) {
            this.manifest = newManifest;
        }
    }

    public Manifest getManifest(boolean shouldCreate) {
        if (this.manifest == null && shouldCreate) {
            this.manifest = new Manifest();
            Attributes attributes = this.manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, WEAVER_MANIFEST_VERSION);
            attributes.put(CREATED_BY, WEAVER_CREATED_BY);
        }
        return this.manifest;
    }

    public Collection weave(File file) throws IOException {
        BufferedOutputStream os = FileUtil.makeOutputStream(file);
        this.zipOutputStream = new ZipOutputStream(os);
        this.prepareForWeave();
        Collection c = this.weave(new IClassFileProvider(){

            public Iterator getClassFileIterator() {
                return BcelWeaver.this.addedClasses.iterator();
            }

            public IWeaveRequestor getRequestor() {
                return new IWeaveRequestor(){

                    public void acceptResult(UnwovenClassFile result) {
                        try {
                            BcelWeaver.this.writeZipEntry(result.filename, result.bytes);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    public void processingReweavableState() {
                    }

                    public void addingTypeMungers() {
                    }

                    public void weavingAspects() {
                    }

                    public void weavingClasses() {
                    }

                    public void weaveCompleted() {
                    }
                };
            }
        });
        this.zipOutputStream.close();
        return c;
    }

    public Collection weave(IClassFileProvider input) throws IOException {
        BcelObjectType classType;
        String className;
        UnwovenClassFile classFile;
        ArrayList<String> wovenClassNames = new ArrayList<String>();
        IWeaveRequestor requestor = input.getRequestor();
        requestor.processingReweavableState();
        this.prepareToProcessReweavableState();
        Iterator i = input.getClassFileIterator();
        while (i.hasNext()) {
            UnwovenClassFile classFile2 = (UnwovenClassFile)i.next();
            String className2 = classFile2.getClassName();
            BcelObjectType classType2 = this.getClassType(className2);
            this.processReweavableStateIfPresent(className2, classType2);
        }
        requestor.addingTypeMungers();
        ArrayList<String> typesToProcess = new ArrayList<String>();
        Iterator iter = input.getClassFileIterator();
        while (iter.hasNext()) {
            UnwovenClassFile clf = (UnwovenClassFile)iter.next();
            typesToProcess.add(clf.getClassName());
        }
        while (typesToProcess.size() > 0) {
            this.weaveParentsFor(typesToProcess, (String)typesToProcess.get(0));
        }
        Iterator i2 = input.getClassFileIterator();
        while (i2.hasNext()) {
            classFile = (UnwovenClassFile)i2.next();
            className = classFile.getClassName();
            this.addNormalTypeMungers(className);
        }
        requestor.weavingAspects();
        i2 = input.getClassFileIterator();
        while (i2.hasNext()) {
            classFile = (UnwovenClassFile)i2.next();
            className = classFile.getClassName();
            classType = BcelWorld.getBcelObjectType(this.world.resolve(className));
            if (!classType.isAspect()) continue;
            this.weaveAndNotify(classFile, classType, requestor);
            wovenClassNames.add(className);
        }
        requestor.weavingClasses();
        i2 = input.getClassFileIterator();
        while (i2.hasNext()) {
            classFile = (UnwovenClassFile)i2.next();
            className = classFile.getClassName();
            classType = BcelWorld.getBcelObjectType(this.world.resolve(className));
            if (classType.isAspect()) continue;
            this.weaveAndNotify(classFile, classType, requestor);
            wovenClassNames.add(className);
        }
        this.addedClasses = new ArrayList();
        this.deletedTypenames = new ArrayList();
        if (this.world.behaveInJava5Way && this.world.getLint().adviceDidNotMatch.isEnabled()) {
            List l = this.world.getCrosscuttingMembersSet().getShadowMungers();
            Iterator iter2 = l.iterator();
            while (iter2.hasNext()) {
                AnnotationX[] anns;
                BcelMethod meth;
                BcelAdvice ba;
                ShadowMunger element = (ShadowMunger)iter2.next();
                if (!(element instanceof BcelAdvice) || (ba = (BcelAdvice)element).hasMatchedSomething() || (meth = (BcelMethod)ba.getSignature()) == null || Utility.isSuppressing(anns = meth.getAnnotations(), "adviceDidNotMatch")) continue;
                this.world.getLint().adviceDidNotMatch.signal(ba.getDeclaringAspect().toString(), element.getSourceLocation());
            }
        }
        requestor.weaveCompleted();
        return wovenClassNames;
    }

    private void weaveParentsFor(List typesForWeaving, String typeToWeave) {
        ResolvedTypeX rtx = this.world.resolve(typeToWeave);
        ResolvedTypeX superType = rtx.getSuperclass();
        if (superType != null && typesForWeaving.contains(superType.getClassName())) {
            this.weaveParentsFor(typesForWeaving, superType.getClassName());
        }
        ResolvedTypeX[] interfaceTypes = rtx.getDeclaredInterfaces();
        for (int i = 0; i < interfaceTypes.length; ++i) {
            ResolvedTypeX rtxI = interfaceTypes[i];
            if (!typesForWeaving.contains(rtxI.getClassName())) continue;
            this.weaveParentsFor(typesForWeaving, rtxI.getClassName());
        }
        this.weaveParentTypeMungers(rtx);
        typesForWeaving.remove(typeToWeave);
    }

    public void prepareToProcessReweavableState() {
        if (this.inReweavableMode) {
            this.world.showMessage(IMessage.INFO, WeaverMessages.format("reweavableMode"), null, null);
        }
        this.alreadyConfirmedReweavableState = new HashSet();
    }

    public void processReweavableStateIfPresent(String className, BcelObjectType classType) {
        WeaverStateInfo wsi = classType.getWeaverState();
        if (wsi != null && wsi.isReweavable()) {
            this.world.showMessage(IMessage.INFO, WeaverMessages.format("processingReweavable", className, classType.getSourceLocation().getSourceFile()), null, null);
            Set aspectsPreviouslyInWorld = wsi.getAspectsAffectingType();
            if (aspectsPreviouslyInWorld != null) {
                Iterator iter = aspectsPreviouslyInWorld.iterator();
                while (iter.hasNext()) {
                    boolean exists;
                    String requiredTypeName = (String)iter.next();
                    if (this.alreadyConfirmedReweavableState.contains(requiredTypeName)) continue;
                    ResolvedTypeX rtx = this.world.resolve(TypeX.forName(requiredTypeName), true);
                    boolean bl = exists = rtx != ResolvedTypeX.MISSING;
                    if (!exists) {
                        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("missingReweavableType", requiredTypeName, className), classType.getSourceLocation(), null);
                        continue;
                    }
                    if (!this.world.getMessageHandler().isIgnoring(IMessage.INFO)) {
                        this.world.showMessage(IMessage.INFO, WeaverMessages.format("verifiedReweavableType", requiredTypeName, rtx.getSourceLocation().getSourceFile()), null, null);
                    }
                    this.alreadyConfirmedReweavableState.add(requiredTypeName);
                }
            }
            classType.setJavaClass(Utility.makeJavaClass(classType.getJavaClass().getFileName(), wsi.getUnwovenClassFileData()));
        } else {
            classType.resetState();
        }
    }

    private void weaveAndNotify(UnwovenClassFile classFile, BcelObjectType classType, IWeaveRequestor requestor) throws IOException {
        LazyClassGen clazz = this.weaveWithoutDump(classFile, classType);
        classType.finishedWith();
        if (clazz != null) {
            UnwovenClassFile[] newClasses = this.getClassFilesFor(clazz);
            for (int i = 0; i < newClasses.length; ++i) {
                requestor.acceptResult(newClasses[i]);
            }
        } else {
            requestor.acceptResult(classFile);
        }
    }

    public BcelObjectType getClassType(String forClass) {
        return BcelWorld.getBcelObjectType(this.world.resolve(forClass));
    }

    public void addParentTypeMungers(String typeName) {
        this.weaveParentTypeMungers(this.world.resolve(typeName));
    }

    public void addNormalTypeMungers(String typeName) {
        this.weaveNormalTypeMungers(this.world.resolve(typeName));
    }

    public UnwovenClassFile[] getClassFilesFor(LazyClassGen clazz) {
        List childClasses = clazz.getChildClasses(this.world);
        UnwovenClassFile[] ret = new UnwovenClassFile[1 + childClasses.size()];
        ret[0] = new UnwovenClassFile(clazz.getFileName(), clazz.getJavaClass(this.world).getBytes());
        int index = 1;
        Iterator iter = childClasses.iterator();
        while (iter.hasNext()) {
            UnwovenClassFile.ChildClass element = (UnwovenClassFile.ChildClass)iter.next();
            UnwovenClassFile childClass = new UnwovenClassFile(clazz.getFileName() + "$" + element.name, element.bytes);
            ret[index++] = childClass;
        }
        return ret;
    }

    public void weaveParentTypeMungers(ResolvedTypeX onType) {
        boolean typeChanged;
        onType.clearInterTypeMungers();
        ArrayList<DeclareParents> decpToRepeat = new ArrayList<DeclareParents>();
        ArrayList decaToRepeat = new ArrayList();
        boolean aParentChangeOccurred = false;
        boolean anAnnotationChangeOccurred = false;
        Iterator i = this.declareParentsList.iterator();
        while (i.hasNext()) {
            DeclareParents decp = (DeclareParents)i.next();
            typeChanged = this.applyDeclareParents(decp, onType);
            if (typeChanged) {
                aParentChangeOccurred = true;
                continue;
            }
            if (decp.getChild().isStarAnnotation()) continue;
            decpToRepeat.add(decp);
        }
        i = this.xcutSet.getDeclareAnnotationOnTypes().iterator();
        while (i.hasNext()) {
            DeclareAnnotation decA = (DeclareAnnotation)i.next();
            typeChanged = this.applyDeclareAtType(decA, onType, true);
            if (!typeChanged) continue;
            anAnnotationChangeOccurred = true;
        }
        while ((aParentChangeOccurred || anAnnotationChangeOccurred) && !decpToRepeat.isEmpty()) {
            boolean typeChanged2;
            aParentChangeOccurred = false;
            anAnnotationChangeOccurred = false;
            ArrayList<DeclareParents> decpToRepeatNextTime = new ArrayList<DeclareParents>();
            Iterator iter = decpToRepeat.iterator();
            while (iter.hasNext()) {
                DeclareParents decp = (DeclareParents)iter.next();
                typeChanged2 = this.applyDeclareParents(decp, onType);
                if (typeChanged2) {
                    aParentChangeOccurred = true;
                    continue;
                }
                decpToRepeatNextTime.add(decp);
            }
            iter = this.xcutSet.getDeclareAnnotationOnTypes().iterator();
            while (iter.hasNext()) {
                DeclareAnnotation decA = (DeclareAnnotation)iter.next();
                typeChanged2 = this.applyDeclareAtType(decA, onType, false);
                if (!typeChanged2) continue;
                anAnnotationChangeOccurred = true;
            }
            decpToRepeat = decpToRepeatNextTime;
        }
    }

    private boolean applyDeclareAtType(DeclareAnnotation decA, ResolvedTypeX onType, boolean reportProblems) {
        boolean didSomething = false;
        if (decA.matches(onType)) {
            AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decA.getSourceLocation(), onType.getSourceLocation());
            if (onType.hasAnnotation(decA.getAnnotationX().getSignature())) {
                return false;
            }
            AnnotationX annoX = decA.getAnnotationX();
            boolean problemReported = this.verifyTargetIsOK(decA, onType, annoX, reportProblems);
            if (!problemReported) {
                didSomething = true;
                AnnotationOnTypeMunger newAnnotationTM = new AnnotationOnTypeMunger(annoX);
                newAnnotationTM.setSourceLocation(decA.getSourceLocation());
                onType.addInterTypeMunger(new BcelTypeMunger(newAnnotationTM, decA.getAspect().resolve(this.world)));
                decA.copyAnnotationTo(onType);
            }
        }
        return didSomething;
    }

    private boolean verifyTargetIsOK(DeclareAnnotation decA, ResolvedTypeX onType, AnnotationX annoX, boolean outputProblems) {
        boolean problemReported = false;
        if (annoX.specifiesTarget() && (onType.isAnnotation() && !annoX.allowedOnAnnotationType() || !annoX.allowedOnRegularType())) {
            if (outputProblems) {
                if (decA.isExactPattern()) {
                    this.world.getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("incorrectTargetForDeclareAnnotation", onType.getName(), annoX.stringify(), annoX.getValidTargets()), decA.getSourceLocation()));
                } else if (this.world.getLint().invalidTargetForAnnotation.isEnabled()) {
                    this.world.getLint().invalidTargetForAnnotation.signal(new String[]{onType.getName(), annoX.stringify(), annoX.getValidTargets()}, decA.getSourceLocation(), new ISourceLocation[]{onType.getSourceLocation()});
                }
            }
            problemReported = true;
        }
        return problemReported;
    }

    private boolean applyDeclareParents(DeclareParents p, ResolvedTypeX onType) {
        boolean didSomething = false;
        List newParents = p.findMatchingNewParents(onType, true);
        if (!newParents.isEmpty()) {
            didSomething = true;
            BcelObjectType classType = BcelWorld.getBcelObjectType(onType);
            Iterator j = newParents.iterator();
            while (j.hasNext()) {
                ResolvedTypeX newParent = (ResolvedTypeX)j.next();
                classType.addParent(newParent);
                NewParentTypeMunger newParentMunger = new NewParentTypeMunger(newParent);
                newParentMunger.setSourceLocation(p.getSourceLocation());
                onType.addInterTypeMunger(new BcelTypeMunger(newParentMunger, this.xcutSet.findAspectDeclaringParents(p)));
            }
        }
        return didSomething;
    }

    public void weaveNormalTypeMungers(ResolvedTypeX onType) {
        Iterator i = this.typeMungerList.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            if (!m.matches(onType)) continue;
            onType.addInterTypeMunger(m);
        }
    }

    public LazyClassGen weaveWithoutDump(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        return this.weave(classFile, classType, false);
    }

    LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        LazyClassGen ret = this.weave(classFile, classType, true);
        if (this.progressListener != null) {
            this.progressMade += this.progressPerClassFile;
            this.progressListener.setProgress(this.progressMade);
            this.progressListener.setText("woven: " + classFile.getFilename());
        }
        return ret;
    }

    private LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType, boolean dump) throws IOException {
        if (classType.isSynthetic()) {
            if (dump) {
                this.dumpUnchanged(classFile);
            }
            return null;
        }
        List shadowMungers = this.fastMatch(this.shadowMungerList, classType.getResolvedTypeX());
        List typeMungers = classType.getResolvedTypeX().getInterTypeMungers();
        classType.getResolvedTypeX().checkInterTypeMungers();
        LazyClassGen clazz = null;
        if (shadowMungers.size() > 0 || typeMungers.size() > 0 || classType.isAspect() || this.world.getDeclareAnnotationOnMethods().size() > 0 || this.world.getDeclareAnnotationOnFields().size() > 0) {
            clazz = classType.getLazyClassGen();
            try {
                boolean isChanged = BcelClassWeaver.weave(this.world, clazz, shadowMungers, typeMungers);
                if (isChanged) {
                    if (dump) {
                        this.dump(classFile, clazz);
                    }
                    return clazz;
                }
            }
            catch (RuntimeException re) {
                System.err.println("trouble in: ");
                throw re;
            }
            catch (Error re) {
                System.err.println("trouble in: ");
                clazz.print(System.err);
                throw re;
            }
        }
        if (dump) {
            this.dumpUnchanged(classFile);
            return clazz;
        }
        return null;
    }

    private void dumpUnchanged(UnwovenClassFile classFile) throws IOException {
        if (this.zipOutputStream != null) {
            this.writeZipEntry(this.getEntryName(classFile.getJavaClass().getClassName()), classFile.getBytes());
        } else {
            classFile.writeUnchangedBytes();
        }
    }

    private String getEntryName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private void dump(UnwovenClassFile classFile, LazyClassGen clazz) throws IOException {
        if (this.zipOutputStream != null) {
            String mainClassName = classFile.getJavaClass().getClassName();
            this.writeZipEntry(this.getEntryName(mainClassName), clazz.getJavaClass(this.world).getBytes());
            if (!clazz.getChildClasses(this.world).isEmpty()) {
                Iterator i = clazz.getChildClasses(this.world).iterator();
                while (i.hasNext()) {
                    UnwovenClassFile.ChildClass c = (UnwovenClassFile.ChildClass)i.next();
                    this.writeZipEntry(this.getEntryName(mainClassName + "$" + c.name), c.bytes);
                }
            }
        } else {
            classFile.writeWovenBytes(clazz.getJavaClass(this.world).getBytes(), clazz.getChildClasses(this.world));
        }
    }

    private void writeZipEntry(String name, byte[] bytes) throws IOException {
        ZipEntry newEntry = new ZipEntry(name);
        this.zipOutputStream.putNextEntry(newEntry);
        this.zipOutputStream.write(bytes);
        this.zipOutputStream.closeEntry();
    }

    private List fastMatch(List list, ResolvedTypeX type) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        FastMatchInfo info = new FastMatchInfo(type, null);
        ArrayList<ShadowMunger> result = new ArrayList<ShadowMunger>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            FuzzyBoolean fb = munger.getPointcut().fastMatch(info);
            WeaverMetrics.recordFastMatchTypeResult(fb);
            if (!fb.maybeTrue()) continue;
            result.add(munger);
        }
        return result;
    }

    public void setProgressListener(IProgressListener listener, double previousProgress, double progressPerClassFile) {
        this.progressListener = listener;
        this.progressMade = previousProgress;
        this.progressPerClassFile = progressPerClassFile;
    }

    public void setReweavableMode(boolean mode, boolean compress) {
        this.inReweavableMode = mode;
        WeaverStateInfo.setReweavableModeDefaults(mode, compress);
        BcelClassWeaver.setReweavableMode(mode, compress);
    }

    public boolean isReweavable() {
        return this.inReweavableMode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

