/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.TypePattern;

class AnyWithAnnotationTypePattern
extends TypePattern {
    public AnyWithAnnotationTypePattern(AnnotationTypePattern atp) {
        super(false, false);
        this.annotationPattern = atp;
    }

    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        return true;
    }

    protected boolean matchesExactly(ResolvedTypeX type) {
        this.annotationPattern.resolve(type.getWorld());
        return this.annotationPattern.matches(type).alwaysTrue();
    }

    protected boolean matchesExactly(ResolvedTypeX type, ResolvedTypeX annotatedType) {
        this.annotationPattern.resolve(type.getWorld());
        return this.annotationPattern.matches(annotatedType).alwaysTrue();
    }

    public FuzzyBoolean matchesInstanceof(ResolvedTypeX type) {
        return FuzzyBoolean.YES;
    }

    protected boolean matchesExactly(Class type) {
        return true;
    }

    public FuzzyBoolean matchesInstanceof(Class type) {
        return FuzzyBoolean.YES;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(10);
        this.annotationPattern.write(s);
        this.writeLocation(s);
    }

    public static TypePattern read(VersionedDataInputStream s, ISourceContext c) throws IOException {
        AnnotationTypePattern annPatt = AnnotationTypePattern.read(s, c);
        AnyWithAnnotationTypePattern ret = new AnyWithAnnotationTypePattern(annPatt);
        ret.readLocation(c, s);
        return ret;
    }

    protected boolean matchesSubtypes(ResolvedTypeX type) {
        return true;
    }

    public boolean isStar() {
        return false;
    }

    public String toString() {
        return this.annotationPattern + " *";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnyWithAnnotationTypePattern)) {
            return false;
        }
        AnyWithAnnotationTypePattern awatp = (AnyWithAnnotationTypePattern)obj;
        return this.annotationPattern.equals(awatp);
    }

    public int hashCode() {
        return this.annotationPattern.hashCode();
    }
}

