/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public class PerCflow
extends PerClause {
    private boolean isBelow;
    private Pointcut entry;

    public PerCflow(Pointcut entry, boolean isBelow) {
        this.entry = entry;
        this.isBelow = isBelow;
    }

    public Set couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        return FuzzyBoolean.YES;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.entry.resolve(scope);
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        Expr myInstance = Expr.makeCallExpr(AjcMemberMaker.perCflowAspectOfMethod(this.inAspect), Expr.NONE, this.inAspect);
        state.setAspectInstance(myInstance);
        return Test.makeCall(AjcMemberMaker.perCflowHasAspectMethod(this.inAspect), Expr.NONE);
    }

    public PerClause concretize(ResolvedTypeX inAspect) {
        PerCflow ret = new PerCflow(this.entry, this.isBelow);
        ret.inAspect = inAspect;
        if (inAspect.isAbstract()) {
            return ret;
        }
        ResolvedMember cflowStackField = new ResolvedMember(Member.FIELD, inAspect, 25, TypeX.forName("org.aspectj.runtime.internal.CFlowStack"), "ajc$perCflowStack", TypeX.NONE);
        World world = inAspect.getWorld();
        CrosscuttingMembers xcut = inAspect.crosscuttingMembers;
        Collection previousCflowEntries = xcut.getCflowEntries();
        Pointcut concreteEntry = this.entry.concretize(inAspect, 0, null);
        ArrayList innerCflowEntries = new ArrayList(xcut.getCflowEntries());
        innerCflowEntries.removeAll(previousCflowEntries);
        xcut.addConcreteShadowMunger(Advice.makePerCflowEntry(world, concreteEntry, this.isBelow, cflowStackField, inAspect, innerCflowEntries));
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        PerClause.PERCFLOW.write(s);
        this.entry.write(s);
        s.writeBoolean(this.isBelow);
        this.writeLocation(s);
    }

    public static PerClause readPerClause(VersionedDataInputStream s, ISourceContext context) throws IOException {
        PerCflow ret = new PerCflow(Pointcut.read(s, context), s.readBoolean());
        ret.readLocation(context, s);
        return ret;
    }

    public PerClause.Kind getKind() {
        return PerClause.PERCFLOW;
    }

    public String toString() {
        return "percflow(" + this.inAspect + " on " + this.entry + ")";
    }
}

