/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.MessageWriter;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.WeavingClassLoader;

public class WeavingAdaptor {
    public static final String WEAVING_ADAPTOR_VERBOSE = "aj.weaving.verbose";
    public static final String SHOW_WEAVE_INFO_PROPERTY = "org.aspectj.weaver.showWeaveInfo";
    private boolean enabled = true;
    private boolean verbose = WeavingAdaptor.getVerbose();
    private BcelWorld bcelWorld = null;
    private BcelWeaver weaver = null;
    private WeavingAdaptorMessageHandler messageHandler = null;
    private GeneratedClassHandler generatedClassHandler;
    private Map generatedClasses = new HashMap();

    public WeavingAdaptor(WeavingClassLoader loader) {
        this.generatedClassHandler = loader;
        this.init(this.getFullClassPath((ClassLoader)((Object)loader)), this.getFullAspectPath((ClassLoader)((Object)loader)));
    }

    public WeavingAdaptor(GeneratedClassHandler handler, URL[] classURLs, URL[] aspectURLs) {
        this.generatedClassHandler = handler;
        this.init(FileUtil.makeClasspath(classURLs), FileUtil.makeClasspath(aspectURLs));
    }

    private List getFullClassPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            } else {
                this.warn("cannot determine classpath");
            }
            loader = loader.getParent();
        }
        list.addAll(0, WeavingAdaptor.makeClasspath(System.getProperty("sun.boot.class.path")));
        return list;
    }

    private List getFullAspectPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof WeavingClassLoader) {
                URL[] urls = ((WeavingClassLoader)((Object)loader)).getAspectURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            }
            loader = loader.getParent();
        }
        return list;
    }

    private static boolean getVerbose() {
        return Boolean.getBoolean(WEAVING_ADAPTOR_VERBOSE);
    }

    private void init(List classPath, List aspectPath) {
        this.messageHandler = new WeavingAdaptorMessageHandler(new PrintWriter(System.err));
        if (this.verbose) {
            this.messageHandler.dontIgnore(IMessage.INFO);
        } else {
            this.messageHandler.ignore(IMessage.INFO);
        }
        if (Boolean.getBoolean(SHOW_WEAVE_INFO_PROPERTY)) {
            this.messageHandler.dontIgnore(IMessage.WEAVEINFO);
        }
        this.info("using classpath: " + classPath);
        this.info("using aspectpath: " + aspectPath);
        this.bcelWorld = new BcelWorld(classPath, (IMessageHandler)this.messageHandler, null);
        this.bcelWorld.setXnoInline(false);
        this.bcelWorld.getLint().loadDefaultProperties();
        this.weaver = new BcelWeaver(this.bcelWorld);
        this.registerAspectLibraries(aspectPath);
    }

    public void addURL(URL url) {
        File libFile = new File(url.getPath());
        try {
            this.weaver.addLibraryJarFile(libFile);
        }
        catch (IOException ex) {
            this.warn("bad library: '" + libFile + "'");
        }
    }

    public byte[] weaveClass(String name, byte[] bytes) throws IOException {
        if (this.shouldWeave(name)) {
            this.info("weaving '" + name + "'");
            bytes = this.getWovenBytes(name, bytes);
        }
        return bytes;
    }

    private boolean shouldWeave(String name) {
        name = name.replace('/', '.');
        boolean b = this.enabled && !this.generatedClasses.containsKey(name) && this.shouldWeaveName(name) && this.shouldWeaveAspect(name);
        return b;
    }

    private boolean shouldWeaveName(String name) {
        return !name.startsWith("org.apache.bcel.") && !name.startsWith("org.aspectj.") && !name.startsWith("java.") && !name.startsWith("javax.");
    }

    private boolean shouldWeaveAspect(String name) {
        ResolvedTypeX type = this.bcelWorld.resolve(name);
        return type == null || !type.isAspect();
    }

    private byte[] getWovenBytes(String name, byte[] bytes) throws IOException {
        WeavingClassFileProvider wcp = new WeavingClassFileProvider(name, bytes);
        this.weaver.weave(wcp);
        return wcp.getBytes();
    }

    private void registerAspectLibraries(List aspectPath) {
        Iterator i = aspectPath.iterator();
        while (i.hasNext()) {
            String libName = (String)i.next();
            this.addAspectLibrary(libName);
        }
        this.weaver.prepareForWeave();
    }

    private void addAspectLibrary(String aspectLibraryName) {
        File aspectLibrary = new File(aspectLibraryName);
        if (aspectLibrary.isFile() && aspectLibraryName.endsWith(".jar")) {
            try {
                this.info("adding aspect library: '" + aspectLibrary + "'");
                this.weaver.addLibraryJarFile(aspectLibrary);
            }
            catch (IOException ex) {
                this.error("exception adding aspect library: '" + ex + "'");
            }
        } else {
            this.error("bad aspect library: '" + aspectLibrary + "'");
        }
    }

    private static List makeClasspath(String cp) {
        ArrayList<String> ret = new ArrayList<String>();
        if (cp != null) {
            StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                ret.add(tok.nextToken());
            }
        }
        return ret;
    }

    private boolean info(String message) {
        return MessageUtil.info(this.messageHandler, message);
    }

    private boolean warn(String message) {
        return MessageUtil.warn(this.messageHandler, message);
    }

    private boolean error(String message) {
        return MessageUtil.error(this.messageHandler, message);
    }

    private class WeavingClassFileProvider
    implements IClassFileProvider {
        private List unwovenClasses = new ArrayList();
        private UnwovenClassFile wovenClass;

        public WeavingClassFileProvider(String name, byte[] bytes) {
            UnwovenClassFile unwoven = new UnwovenClassFile(name, bytes);
            this.unwovenClasses.add(unwoven);
            WeavingAdaptor.this.bcelWorld.addSourceObjectType(unwoven.getJavaClass());
        }

        public byte[] getBytes() {
            return this.wovenClass.getBytes();
        }

        public Iterator getClassFileIterator() {
            return this.unwovenClasses.iterator();
        }

        public IWeaveRequestor getRequestor() {
            return new IWeaveRequestor(){

                public void acceptResult(UnwovenClassFile result) {
                    if (WeavingClassFileProvider.this.wovenClass == null) {
                        WeavingClassFileProvider.this.wovenClass = result;
                    } else {
                        String className = result.getClassName();
                        WeavingAdaptor.this.generatedClasses.put(className, result);
                        WeavingAdaptor.this.generatedClassHandler.acceptClass(className, result.getBytes());
                    }
                }

                public void processingReweavableState() {
                }

                public void addingTypeMungers() {
                }

                public void weavingAspects() {
                }

                public void weavingClasses() {
                }

                public void weaveCompleted() {
                }
            };
        }
    }

    private class WeavingAdaptorMessageHandler
    extends MessageWriter {
        private Set ignoring = new HashSet();
        private IMessage.Kind failKind;

        public WeavingAdaptorMessageHandler(PrintWriter writer) {
            super(writer, true);
            this.ignore(IMessage.WEAVEINFO);
            this.failKind = IMessage.ERROR;
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            boolean result = super.handleMessage(message);
            if (0 <= message.getKind().compareTo(this.failKind)) {
                throw new AbortException(message);
            }
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return null != kind && this.ignoring.contains(kind);
        }

        public void ignore(IMessage.Kind kind) {
            if (null != kind && !this.ignoring.contains(kind)) {
                this.ignoring.add(kind);
            }
        }

        public void dontIgnore(IMessage.Kind kind) {
            if (null != kind) {
                this.ignoring.remove(kind);
            }
        }
    }
}

