/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.contribution.xref.internal.core.XReferenceAdapterFactory;
import org.eclipse.contribution.xref.internal.ui.XReferenceViewUpdateJob;
import org.eclipse.contribution.xref.ui.views.XReferenceView;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class XReferenceUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.contribution.xref.ui";
    private static XReferenceUIPlugin plugin;
    private ResourceBundle resourceBundle;
    public static XReferenceView xrefView;
    private static Image relImage;
    private static Image evaluateImage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        relImage = null;
        evaluateImage = null;
    }

    public XReferenceUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.contribution.xref.internal.ui.XReferenceUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerAdapter();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static XReferenceUIPlugin getDefault() {
        return plugin;
    }

    public void setXReferenceView(XReferenceView view) {
        xrefView = view;
    }

    public static void refresh() {
        if (xrefView != null) {
            XReferenceViewUpdateJob.getInstance().schedule();
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = XReferenceUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getFormattedString(String key, String arg) {
        return XReferenceUIPlugin.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(XReferenceUIPlugin.getResourceString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void registerAdapter() {
        XReferenceAdapterFactory xra = new XReferenceAdapterFactory();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)xra, (Class)clazz);
        IAdapterManager iAdapterManager2 = Platform.getAdapterManager();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager2.registerAdapters((IAdapterFactory)xra, (Class)clazz2);
        IAdapterManager iAdapterManager3 = Platform.getAdapterManager();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.contribution.xref.core.IXReferenceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager3.registerAdapters((IAdapterFactory)xra, (Class)clazz3);
        IAdapterManager iAdapterManager4 = Platform.getAdapterManager();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ui.IEditorPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager4.registerAdapters((IAdapterFactory)xra, (Class)clazz4);
    }

    public Image getEvaluateImage() {
        if (evaluateImage == null) {
            try {
                URL pluginInstallURL = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
                ImageDescriptor d = ImageDescriptor.createFromURL((URL)new URL(pluginInstallURL, "icons/update.gif"));
                evaluateImage = d.createImage();
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Couldn't create evaluateImage");
            }
        }
        return evaluateImage;
    }

    public Image getXReferenceImage() {
        if (relImage == null) {
            try {
                URL pluginInstallURL = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
                ImageDescriptor d = ImageDescriptor.createFromURL((URL)new URL(pluginInstallURL, "icons/arrow.gif"));
                relImage = d.createImage();
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Couldn't create relImage");
            }
        }
        return relImage;
    }
}

