/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.resources.AJDTIcon;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class ImageDecorator
implements ILabelDecorator {
    private ArrayList listeners;
    private ImageDescriptorRegistry fRegistry;
    private boolean preventRecursion = false;
    private TreeHierarchyLayoutProblemsDecorator problemsDecorator;
    private DecoratorManager decman;
    private ImageDescriptor halfFilledPackageID;
    private ImageDescriptor activeConfigFileImage;
    private BuildConfigurator buildConfor;
    private AspectJImages iconRegistry = new AspectJImages();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    public ImageDecorator() {
        this.listeners = new ArrayList(2);
        this.problemsDecorator = new TreeHierarchyLayoutProblemsDecorator();
        this.decman = WorkbenchPlugin.getDefault().getDecoratorManager();
        this.halfFilledPackageID = AspectJImages.BC_HALF_FILLED_PACKAGE.getImageDescriptor();
        this.activeConfigFileImage = AspectJImages.BC_SELECTED_FILE.getImageDescriptor();
        this.buildConfor = BuildConfigurator.getBuildConfigurator();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image decorateImage(Image image, Object element) {
        ProjectBuildConfigurator pbc;
        if (this.preventRecursion) {
            return null;
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit comp = (ICompilationUnit)element;
            try {
                element = comp.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
                element = null;
            }
        }
        Image img = null;
        if (element instanceof AJCodeElement) {
            img = this.getImageLabel(AspectJImages.AJ_CODE.getImageDescriptor());
        } else if (element instanceof IAspectJElement) {
            try {
                IAspectJElement ajElem = (IAspectJElement)element;
                IProgramElement.Accessibility acceb = ajElem.getAJAccessibility();
                AJDTIcon icon = acceb == null ? (ajElem.getAJKind() == IProgramElement.Kind.ADVICE ? (AJDTIcon)this.iconRegistry.getAdviceIcon(ajElem.getAJExtraInformation(), false) : (AJDTIcon)this.iconRegistry.getIcon(ajElem.getAJKind())) : (AJDTIcon)this.iconRegistry.getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility());
                if (icon != null) {
                    img = this.getImageLabel(this.getJavaImageDescriptor(icon.getImageDescriptor(), image.getBounds(), this.computeJavaAdornmentFlags((IJavaElement)ajElem)));
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException3 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_2, ajc$tjp_1);
            }
        } else if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(file.getName())) {
                pbc = this.buildConfor.getProjectBuildConfigurator(file.getProject());
                if (pbc == null) {
                    return null;
                }
                if (pbc.getActiveBuildConfiguration().isIncluded((IResource)file)) {
                    Rectangle rect = image.getBounds();
                    img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT, rect, 0));
                } else {
                    Rectangle rect = image.getBounds();
                    img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, rect, 0));
                }
            } else if ("ajproperties".equals(file.getFileExtension()) && (pbc = this.buildConfor.getProjectBuildConfigurator(file.getProject())) != null && file.equals((Object)pbc.getActiveBuildConfiguration().getFile())) {
                img = this.getImageLabel(this.getJavaImageDescriptor(this.activeConfigFileImage, image.getBounds(), 0));
            }
        } else if (element instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element;
            pbc = this.buildConfor.getProjectBuildConfigurator(pack.getJavaProject());
            if (pbc == null) {
                return null;
            }
            BuildConfiguration bc = pbc.getActiveBuildConfiguration();
            try {
                if (ImageDecorator.containsIncludedFiles(bc, pack)) {
                    if (ImageDecorator.containsExcludedFiles(bc, pack)) {
                        img = this.getImageLabel(this.getJavaImageDescriptor(this.halfFilledPackageID, image.getBounds(), 0));
                    } else if (!pack.containsJavaResources()) {
                        img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_PACKAGE, image.getBounds(), 0));
                    }
                } else if (ImageDecorator.containsExcludedFiles(bc, pack)) {
                    img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE, image.getBounds(), 0));
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException4 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException4, this, ajc$tjp_3, ajc$tjp_1);
            }
        }
        if ((element instanceof IMethod || element instanceof SourceType) && AspectJPreferences.isAdviceDecoratorActive() && AJModel.getInstance().isAdvised((IJavaElement)element)) {
            Image baseImage = img;
            if (baseImage == null) {
                baseImage = image;
            }
            MyCompositeImageDesc overlay = new MyCompositeImageDesc(baseImage);
            img = this.getRegistry().get((ImageDescriptor)overlay);
        }
        if (img != null) {
            this.preventRecursion = true;
            img = this.problemsDecorator.decorateImage(img, element);
            img = this.decman.decorateImage(img, element);
            this.preventRecursion = false;
            return img;
        }
        return null;
    }

    public static boolean containsIncludedFiles(BuildConfiguration bc, IPackageFragment pack) {
        try {
            IJavaElement[] javachildren = pack.getChildren();
            int i = 0;
            while (i < javachildren.length) {
                IResource res = javachildren[i].getCorrespondingResource();
                if (res != null && res.getType() == 1 && bc.isIncluded(res)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_4, ajc$tjp_5);
        }
        return false;
    }

    public static boolean containsExcludedFiles(BuildConfiguration bc, IPackageFragment pack) {
        try {
            IJavaElement[] javachildren = pack.getChildren();
            int i = 0;
            while (i < javachildren.length) {
                IResource res = javachildren[i].getCorrespondingResource();
                if (res != null && res.getType() == 1 && !bc.isIncluded(res)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_6, ajc$tjp_7);
        }
        return false;
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public ImageDescriptor getJavaImageDescriptor(ImageDescriptor descriptor, Rectangle rect, int adorflags) {
        int flags = rect.width == 16 ? 2 : 0;
        Point size = ImageDecorator.useSmallSize(flags) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, adorflags, size);
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public String decorateText(String text, Object element) {
        if (element instanceof AJCompilationUnit) {
            return text.replaceFirst(".java", ".aj");
        }
        if (element instanceof IAspectJElement) {
            try {
                IProgramElement.Kind kind = ((IAspectJElement)element).getAJKind();
                if (kind != IProgramElement.Kind.ASPECT && kind != IProgramElement.Kind.ADVICE && kind != IProgramElement.Kind.POINTCUT && kind != IProgramElement.Kind.INTER_TYPE_METHOD && kind != IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                    return text.substring(0, text.length() - 2);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_8, ajc$tjp_9);
            }
        }
        return null;
    }

    private int computeJavaAdornmentFlags(IJavaElement element) {
        int flags = 0;
        if (element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract((int)(modifiers = member.getFlags())) && ImageDecorator.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 2;
                }
                if (Flags.isSynchronized((int)modifiers) && ImageDecorator.confirmSynchronized((IJavaElement)member)) {
                    flags |= 4;
                }
                if (Flags.isStatic((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 8;
                }
                if (Flags.isDeprecated((int)modifiers)) {
                    flags |= 0x400;
                }
                if (member.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)((IType)member))) {
                    flags |= 0x10;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_10, ajc$tjp_11);
            }
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return ((IType)element).isClass();
        }
        return element.getDeclaringType().isClass();
    }

    private static boolean isInterfaceField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement member) {
        return member.getElementType() != 7;
    }

    static {
        Factory factory = new Factory("ImageDecorator.java", Class.forName("org.eclipse.ajdt.buildconfigurator.ImageDecorator"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 109);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-decorateImage-org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.swt.graphics.Image:java.lang.Object:-image:element:--org.eclipse.swt.graphics.Image-"), 102);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 419);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-computeJavaAdornmentFlags-org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.IJavaElement:-element:--int-"), 393);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 136);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 190);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 306);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-containsIncludedFiles-org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.ajdt.buildconfigurator.BuildConfiguration:org.eclipse.jdt.core.IPackageFragment:-bc:pack:--boolean-"), 289);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 332);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-containsExcludedFiles-org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.ajdt.buildconfigurator.BuildConfiguration:org.eclipse.jdt.core.IPackageFragment:-bc:pack:--boolean-"), 315);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 385);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-decorateText-org.eclipse.ajdt.buildconfigurator.ImageDecorator-java.lang.String:java.lang.Object:-text:element:--java.lang.String-"), 376);
    }

    class MyCompositeImageDesc
    extends CompositeImageDescriptor {
        private Image fBaseImage;
        private Point fSize;
        static /* synthetic */ Class class$0;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;

        public MyCompositeImageDesc(Image baseImage) {
            this.fBaseImage = baseImage;
            this.fSize = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.fBaseImage.getImageData(), 0, 0);
            ImageData overlayImageData = AspectJImages.ADVICE_OVERLAY.getImageDescriptor().getImageData();
            int xValue = 0;
            int yValue = 0;
            this.drawImage(overlayImageData, xValue, yValue);
        }

        public boolean equals(Object object) {
            block8: {
                block7: {
                    if (object == null) break block7;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ajdt.buildconfigurator.ImageDecorator$MyCompositeImageDesc");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ClassNotFoundException classNotFoundException2 = classNotFoundException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                            throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                        }
                    }
                    if (clazz.equals(object.getClass())) break block8;
                }
                return false;
            }
            MyCompositeImageDesc other = (MyCompositeImageDesc)((Object)object);
            return this.fBaseImage.equals((Object)other.fBaseImage) && this.fSize.equals((Object)other.fSize);
        }

        public int hashCode() {
            return this.fBaseImage.hashCode() | this.fSize.hashCode();
        }

        protected Point getSize() {
            return this.fSize;
        }

        static {
            Factory factory = new Factory("ImageDecorator.java", Class.forName("org.eclipse.ajdt.buildconfigurator.ImageDecorator$MyCompositeImageDesc"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.ImageDecorator$MyCompositeImageDesc-java.lang.ClassNotFoundException-<missing>-"), 263);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-equals-org.eclipse.ajdt.buildconfigurator.ImageDecorator$MyCompositeImageDesc-java.lang.Object:-object:--boolean-"), 263);
        }
    }
}

