/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;

public class PropertyPageManager {
    private static RegistryPageContributor jdtProjectPropertyPage = null;
    private static RegistryPageContributor jdtJavaProjectPropertyPage = null;
    private static boolean jdtPropertyPageActive = true;
    static final String projectID = "org.eclipse.core.resources.IProject";
    static final String javaProjectID = "org.eclipse.jdt.core.IJavaProject";
    static final String buildPathsPageID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";

    private PropertyPageManager() {
    }

    public static void unregisterJDTPropertyPage() {
        if (jdtProjectPropertyPage == null) {
            PropertyPageManager.extractJDTRegistryPageContributors();
        }
        if (PropertyPageManager.isJDTPropertyPageActive()) {
            PropertyPageContributorManager ppcm = PropertyPageContributorManager.getManager();
            int beforeCount = PropertyPageManager.getBuildPathContributorsCount(ppcm, buildPathsPageID);
            ppcm.unregisterContributor((IObjectContributor)jdtProjectPropertyPage, projectID);
            ppcm.unregisterContributor((IObjectContributor)jdtJavaProjectPropertyPage, javaProjectID);
            int afterCount = PropertyPageManager.getBuildPathContributorsCount(ppcm, buildPathsPageID);
            if (afterCount != beforeCount - 2) {
                ppcm.unregisterContributor((IObjectContributor)jdtProjectPropertyPage, javaProjectID);
                ppcm.unregisterContributor((IObjectContributor)jdtJavaProjectPropertyPage, projectID);
                afterCount = PropertyPageManager.getBuildPathContributorsCount(ppcm, buildPathsPageID);
            }
            if (afterCount != beforeCount - 2) {
                AJDTEventTrace.generalEvent("Failed to unregister Java Build Path property pages");
            } else {
                AJDTEventTrace.generalEvent("Successfully unregistered Java Build Path property pages");
            }
            jdtPropertyPageActive = false;
        }
    }

    private static int getBuildPathContributorsCount(PropertyPageContributorManager ppcm, String pageId) {
        int count = 0;
        Iterator iter = ppcm.getContributors().iterator();
        while (iter.hasNext()) {
            List v = (List)iter.next();
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                RegistryPageContributor rpc = (RegistryPageContributor)iter2.next();
                if (!rpc.getPageId().equals(buildPathsPageID)) continue;
                ++count;
            }
        }
        return count;
    }

    public static void registerJDTPropertyPage() {
        if (jdtProjectPropertyPage == null) {
            PropertyPageManager.extractJDTRegistryPageContributors();
        }
        if (!PropertyPageManager.isJDTPropertyPageActive()) {
            PropertyPageContributorManager ppcm = PropertyPageContributorManager.getManager();
            ppcm.registerContributor((IObjectContributor)jdtProjectPropertyPage, projectID);
            ppcm.registerContributor((IObjectContributor)jdtJavaProjectPropertyPage, javaProjectID);
            jdtPropertyPageActive = true;
        }
    }

    private static void extractJDTRegistryPageContributors() {
        ArrayList<RegistryPageContributor> list = new ArrayList<RegistryPageContributor>(3);
        PropertyPageContributorManager ppcm = PropertyPageContributorManager.getManager();
        Iterator iter = ppcm.getContributors().iterator();
        while (iter.hasNext()) {
            List v = (List)iter.next();
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                RegistryPageContributor rpc = (RegistryPageContributor)iter2.next();
                if (!rpc.getPageId().equals(buildPathsPageID)) continue;
                list.add(rpc);
            }
        }
        jdtProjectPropertyPage = (RegistryPageContributor)list.get(0);
        jdtJavaProjectPropertyPage = (RegistryPageContributor)list.get(1);
        jdtPropertyPageActive = true;
    }

    public static boolean isJDTPropertyPageActive() {
        return jdtPropertyPageActive;
    }
}

