/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import org.eclipse.ajdt.buildconfigurator.editor.BuildContentsSection;
import org.eclipse.ajdt.buildconfigurator.editor.BuildPage;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.swt.widgets.Composite;

public class SrcSection
extends BuildContentsSection
implements IModelChangedListener {
    private static String SECTION_TITLE = "AJPropsEditor.SrcSection.title";
    private static String SECTION_DESC = "AJPropsEditor.SrcSection.desc";

    public SrcSection(BuildPage page, Composite parent) {
        super(page, parent);
        this.getSection().setText(AspectJUIPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(AspectJUIPlugin.getResourceString(SECTION_DESC));
    }

    protected void initializeCheckState() {
        super.initializeCheckState();
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry srcIncl = build.getEntry("src.includes");
        IBuildEntry srcExcl = build.getEntry("src.excludes");
        if (srcIncl == null) {
            return;
        }
        super.initializeCheckState(srcIncl, srcExcl);
    }

    protected void deleteFolderChildrenFromEntries(IFolder folder) {
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry srcIncl = build.getEntry("src.includes");
        IBuildEntry srcExcl = build.getEntry("src.excludes");
        String parentFolder = this.getResourceFolderName(folder.getProjectRelativePath().toString());
        this.removeChildren(srcIncl, parentFolder);
        this.removeChildren(srcExcl, parentFolder);
    }

    protected void handleBuildCheckStateChange(boolean wasTopParentChecked) {
        IResource resource = this.fParentResource;
        String resourceName = this.fParentResource.getFullPath().removeFirstSegments(1).toString();
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry includes = build.getEntry("src.includes");
        IBuildEntry excludes = build.getEntry("src.excludes");
        resourceName = this.handleResourceFolder(resource, resourceName);
        if (this.isChecked) {
            this.handleCheck(includes, excludes, resourceName, resource, wasTopParentChecked, "src.includes");
        } else {
            this.handleUncheck(includes, excludes, resourceName, resource, "src.excludes");
        }
        this.deleteEmptyEntries();
    }
}

