/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildModel;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.ui.model.IDocumentKey;

public class Build
implements IBuild {
    private BuildModel fModel;
    private HashMap fEntries = new HashMap();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public Build(BuildModel model) {
        this.fModel = model;
    }

    public void add(IBuildEntry entry) throws CoreException {
        this.fEntries.put(entry.getName(), entry);
        this.fModel.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this.fModel, 1, new Object[]{entry}, null));
    }

    public void addWithoutNotify(IBuildEntry entry) {
        this.fEntries.put(entry.getName(), entry);
    }

    public IBuildEntry[] getBuildEntries() {
        return this.fEntries.values().toArray(new IBuildEntry[this.fEntries.size()]);
    }

    public IBuildEntry getEntry(String name) {
        return (IBuildEntry)this.fEntries.get(name);
    }

    public void remove(IBuildEntry entry) throws CoreException {
        this.fEntries.remove(entry.getName());
        this.fModel.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this.fModel, 2, new Object[]{entry}, null));
    }

    public void removeWithoutNotify(IBuildEntry entry) {
        this.fEntries.remove(entry.getName());
    }

    public void write(String indent, PrintWriter writer) {
    }

    public void load(InputStream source) throws IOException {
        this.fEntries.clear();
        Properties properties = new Properties();
        properties.load(source);
        Enumeration<Object> iter = properties.keys();
        while (iter.hasMoreElements()) {
            String name = iter.nextElement().toString();
            BuildEntry entry = (BuildEntry)this.fModel.getFactory().createEntry(name);
            entry.processEntry(properties.get(name).toString());
            this.fEntries.put(name, entry);
        }
        this.adjustOffsets(this.fModel.getDocument());
    }

    public void adjustOffsets(IDocument document) {
        int lines = document.getNumberOfLines();
        try {
            IDocumentKey currentKey = null;
            int i = 0;
            while (i < lines) {
                int length;
                int offset = document.getLineOffset(i);
                String line = document.get(offset, length = document.getLineLength(i));
                if (line.startsWith("#") | line.startsWith("!")) {
                    if (currentKey != null) {
                        currentKey.setLength(offset - 1 - currentKey.getOffset());
                        currentKey = null;
                    }
                } else if ((line = line.trim()).length() != 0) {
                    if (currentKey != null) {
                        if (!line.endsWith("\\")) {
                            currentKey.setLength(offset + document.getLineLength(i) - currentKey.getOffset());
                            currentKey = null;
                        }
                    } else {
                        String name;
                        int index = line.indexOf(61);
                        if (index == -1) {
                            index = line.indexOf(58);
                        }
                        if (index == -1) {
                            index = line.indexOf(32);
                        }
                        if (index == -1) {
                            index = line.indexOf(9);
                        }
                        if ((currentKey = (IDocumentKey)this.getEntry(name = index != -1 ? line.substring(0, index).trim() : line)) != null) {
                            while (Character.isSpaceChar(document.getChar(offset))) {
                                ++offset;
                            }
                            currentKey.setOffset(offset);
                            if (!line.endsWith("\\")) {
                                currentKey.setLength(document.getLineOffset(i) + document.getLineLength(i) - currentKey.getOffset());
                                currentKey = null;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            BadLocationException badLocationException2 = badLocationException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException2, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    static {
        Factory factory = new Factory("Build.java", Class.forName("org.eclipse.ajdt.buildconfigurator.editor.model.Build"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.editor.model.Build-org.eclipse.jface.text.BadLocationException-<missing>-"), 135);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-adjustOffsets-org.eclipse.ajdt.buildconfigurator.editor.model.Build-org.eclipse.jface.text.IDocument:-document:--void-"), 89);
    }
}

