/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.internal.ui.AspectJProjectNature;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;

public class Builder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        final IProject project = this.getProject();
        if (AspectJProjectNature.hasNewBuilder(project)) {
            return null;
        }
        boolean removeOldBuilder = true;
        if (AspectJPreferences.isAutoBuilderMigrationEnabled()) {
            removeOldBuilder = AspectJPreferences.isAutoBuilderMigrationSetToRemoveOldBuilder();
        } else {
            final boolean[] settings = new boolean[2];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion(null, (String)AspectJUIPlugin.getResourceString("Builder.migration.title"), (String)AspectJUIPlugin.getFormattedResourceString("Builder.migration.message", project.getName()), (String)AspectJUIPlugin.getResourceString("Builder.migration.toggle"), (boolean)true, null, null);
                    System.out.println("ret: " + dialog.getReturnCode());
                    settings[0] = dialog.getReturnCode() == 2;
                    settings[1] = dialog.getToggleState();
                }
            });
            if (settings[1]) {
                AspectJPreferences.setAutoBuilderMigrationRemoveOldBuilder(settings[0]);
                AspectJPreferences.setAutoBuilderMigrationEnabled(true);
            }
            removeOldBuilder = settings[0];
        }
        AspectJProjectNature.addNewBuilder(project);
        if (!AspectJProjectNature.hasNewBuilder(project)) {
            AJLog.log((String)"AJDT migration builder: addition of new builder failed!");
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)AspectJUIPlugin.getResourceString("Builder.migration.failed.title"), (String)AspectJUIPlugin.getFormattedResourceString("Builder.migration.failed.message", project.getName()));
                }
            });
            return null;
        }
        if (removeOldBuilder) {
            AspectJProjectNature.removeOldBuilder(project);
        }
        String jobName = AspectJUIPlugin.getFormattedResourceString("Builder.migration.build", project.getName());
        Job buildJob = new Job(jobName){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;

            public IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(6, monitor);
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                }
                return Status.OK_STATUS;
            }

            static {
                Factory factory = new Factory("Builder.java", Class.forName("org.eclipse.ajdt.internal.builder.Builder$3"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.Builder$3-org.eclipse.core.runtime.CoreException-<missing>-"), 132);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.builder.Builder$3-org.eclipse.core.runtime.IProgressMonitor:-monitor:--org.eclipse.core.runtime.IStatus-"), 129);
            }
        };
        buildJob.schedule();
        return null;
    }
}

