/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.visualiser.NodeHolder;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MarkerUpdating {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    public static void deleteAllMarkers(final IProject project) {
        try {
            AspectJPlugin.getWorkspace().run(new IWorkspaceRunnable(){
                private static final JoinPoint.StaticPart ajc$tjp_0;
                private static final JoinPoint.StaticPart ajc$tjp_1;

                public void run(IProgressMonitor monitor) {
                    try {
                        project.deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.sourceadvicemarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
                    }
                }

                static {
                    Factory factory = new Factory("MarkerUpdating.java", Class.forName("org.eclipse.ajdt.internal.builder.MarkerUpdating$1"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating$1-org.eclipse.core.runtime.CoreException-<missing>-"), 60);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.builder.MarkerUpdating$1-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 53);
                }
            }, null);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public static void addNewMarkers(final IProject project) {
        try {
            AspectJPlugin.getWorkspace().run(new IWorkspaceRunnable(){
                private static final JoinPoint.StaticPart ajc$tjp_0;
                private static final JoinPoint.StaticPart ajc$tjp_1;

                public void run(IProgressMonitor monitor) {
                    try {
                        project.accept(new IResourceVisitor(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public boolean visit(IResource resource) {
                                if (resource instanceof IFolder) {
                                    return true;
                                }
                                if (resource instanceof IFile) {
                                    if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(resource.getName())) {
                                        MarkerUpdating.access$0((IFile)resource);
                                    }
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
                    }
                }

                static {
                    Factory factory = new Factory("MarkerUpdating.java", Class.forName("org.eclipse.ajdt.internal.builder.MarkerUpdating$2"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating$2-org.eclipse.core.runtime.CoreException-<missing>-"), 88);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.builder.MarkerUpdating$2-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 74);
                }
            }, null);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_2, ajc$tjp_3);
        }
    }

    private static void addMarkersToFile(IFile file) {
        IProject project = file.getProject();
        if (project == null || !project.isOpen() || !AspectJPlugin.isAJProject((IProject)project)) {
            return;
        }
        String path = file.getRawLocation().toOSString();
        Map m = StructureModelUtil.getLinesToAspectMap(path, true);
        if (m != null) {
            Set keys = m.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                Integer linenumberInt = (Integer)o;
                Vector v = (Vector)m.get(o);
                try {
                    boolean sameType = true;
                    boolean runtimeTst = false;
                    if (v.size() > 1) {
                        NodeHolder first = (NodeHolder)v.get(0);
                        String adviceType = first.node.getExtraInfo() == null ? null : first.node.getExtraInfo().getExtraAdviceInformation();
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            NodeHolder element = (NodeHolder)iter.next();
                            boolean bl = runtimeTst = runtimeTst || element.runtimeTest;
                            if (adviceType != null) {
                                if (element.node.getExtraInfo() == null) {
                                    sameType = false;
                                    continue;
                                }
                                sameType = sameType && adviceType.equals(element.node.getExtraInfo().getExtraAdviceInformation());
                                continue;
                            }
                            boolean bl2 = sameType = sameType && element.node.getExtraInfo() == null;
                        }
                    } else if (v.size() == 1) {
                        runtimeTst = ((NodeHolder)v.get((int)0)).runtimeTest;
                    }
                    boolean runtimeTest = runtimeTst;
                    boolean useDefaultAdviceMarker = !sameType;
                    int j = 0;
                    while (j < v.size()) {
                        NodeHolder noddyHolder = (NodeHolder)v.get(j);
                        IProgramElement sn = noddyHolder.node;
                        MarkerUpdating.createMarker(linenumberInt, runtimeTest, (IResource)file, sn, useDefaultAdviceMarker, noddyHolder.runtimeTest, noddyHolder.adviceType);
                        ++j;
                    }
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_4, ajc$tjp_5);
                    CoreException ce = coreException2;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception creating advice marker", ce);
                }
            }
        }
    }

    private static IMarker createMarker(int linenumberInt, boolean runtimeTest, IResource ir, IProgramElement programElement, boolean useDefaultAdviceMarker, boolean nodeRuntimeTest, String adviceType) throws CoreException {
        IMarker marker;
        String label = programElement.toLinkLabelString();
        if (useDefaultAdviceMarker) {
            marker = runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicadvicemarker") : (adviceType == "" ? ir.createMarker("org.eclipse.ajdt.ui.declarationmarker") : ir.createMarker("org.eclipse.ajdt.ui.advicemarker"));
        } else if (adviceType.equals("before")) {
            marker = runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicbeforeadvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.beforeadvicemarker");
        } else if (adviceType.equals("around")) {
            marker = runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicaroundadvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.aroundadvicemarker");
        } else if (adviceType.startsWith("after")) {
            marker = runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicafteradvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.afteradvicemarker");
        } else if (adviceType.startsWith("advises")) {
            String subType = adviceType.substring("advises".length());
            marker = subType.startsWith("before") ? ir.createMarker("org.eclipse.ajdt.ui.sourcebeforeadvicemarker") : (subType.startsWith("after") ? ir.createMarker("org.eclipse.ajdt.ui.sourceafteradvicemarker") : (subType.startsWith("around") ? ir.createMarker("org.eclipse.ajdt.ui.sourcearoundadvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.sourceadvicemarker")));
            IProgramElement.Kind kind = programElement.getKind();
            IProgramElement.Accessibility acc = programElement.getAccessibility();
            char markerKind = '?';
            if (kind == IProgramElement.Kind.CODE) {
                markerKind = 'C';
            } else if (kind == IProgramElement.Kind.METHOD || kind == IProgramElement.Kind.CONSTRUCTOR) {
                markerKind = 'M';
            } else if (kind == IProgramElement.Kind.FIELD) {
                markerKind = 'F';
            } else if (kind == IProgramElement.Kind.ASPECT) {
                markerKind = 'A';
            }
            char markerAcc = '?';
            if (acc == IProgramElement.Accessibility.PUBLIC) {
                markerAcc = 'G';
            } else if (acc == IProgramElement.Accessibility.PROTECTED) {
                markerAcc = 'Y';
            } else if (acc == IProgramElement.Accessibility.PACKAGE) {
                markerAcc = 'B';
            } else if (acc == IProgramElement.Accessibility.PRIVATE) {
                markerAcc = 'R';
            }
            marker.setAttribute("acckind", (Object)("" + markerKind + markerAcc));
        } else {
            marker = adviceType.equals("annotates") ? ir.createMarker("org.eclipse.ajdt.ui.sourceannotatedmarker") : (adviceType.equals("declared on") ? ir.createMarker("org.eclipse.ajdt.ui.sourceitdmarker") : (programElement.getKind().equals(IProgramElement.Kind.DECLARE_ANNOTATION_AT_CONSTRUCTOR) || programElement.getKind().equals(IProgramElement.Kind.DECLARE_ANNOTATION_AT_FIELD) || programElement.getKind().equals(IProgramElement.Kind.DECLARE_ANNOTATION_AT_METHOD) || programElement.getKind().equals(IProgramElement.Kind.DECLARE_ANNOTATION_AT_TYPE) ? ir.createMarker("org.eclipse.ajdt.ui.annotatedmarker") : ir.createMarker("org.eclipse.ajdt.ui.itdmarker")));
        }
        marker.setAttribute("lineNumber", linenumberInt);
        if (nodeRuntimeTest) {
            label = String.valueOf(label) + " " + AspectJUIPlugin.getResourceString("AspectJEditor.runtimetest");
        }
        marker.setAttribute("message", (Object)label);
        marker.setAttribute("priority", 2);
        ISourceLocation sLoc2 = programElement.getSourceLocation();
        marker.setAttribute("sourceLocationOfAdvice", (Object)(String.valueOf(sLoc2.getSourceFile().getAbsolutePath()) + ":::" + sLoc2.getLine() + ":::" + sLoc2.getEndLine() + ":::" + sLoc2.getColumn()));
        return marker;
    }

    static /* synthetic */ void access$0(IFile iFile) {
        MarkerUpdating.addMarkersToFile(iFile);
    }

    static {
        Factory factory = new Factory("MarkerUpdating.java", Class.forName("org.eclipse.ajdt.internal.builder.MarkerUpdating"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.runtime.CoreException-<missing>-"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-deleteAllMarkers-org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.resources.IProject:-project:--void-"), 49);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.runtime.CoreException-<missing>-"), 91);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-addNewMarkers-org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.resources.IProject:-project:--void-"), 71);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.runtime.CoreException-ce-"), 176);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-addMarkersToFile-org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.resources.IFile:-file:--void-"), 99);
    }
}

