/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildManager;
import org.aspectj.asm.AsmManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.internal.builder.AJModelUtils;
import org.eclipse.ajdt.internal.builder.MarkerUpdating;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.xref.internal.ui.XReferenceUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;

public class UIBuildListener
implements IAJBuildListener {
    private static final int CONFIG_FILE_WRITE_ERROR = -10;
    private HashMap outjars = null;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;

    public void preAJBuild(int kind, IProject project, IProject[] requiredProjects) {
        boolean inc;
        if (!AspectJPreferences.isAJDTPrefConfigShowing()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AJDTUtils.verifyWorkbenchConfiguration();
                }
            });
        }
        String kindS = null;
        if (kind == 9) {
            kindS = "AUTOBUILD";
        }
        if (kind == 10) {
            kindS = "INCREMENTALBUILD";
        }
        if (kind == 6) {
            kindS = "FULLBUILD";
        }
        String mode = "";
        mode = AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getIncrementalMode() && kind != 6 ? "Incremental AspectJ compilation" : "Full AspectJ compilation";
        AJLog.log((String)("build: Kind=" + kindS + " Project=" + project.getName() + " Mode=" + mode));
        AsmManager.attemptIncrementalModelRepairs = inc = AspectJPreferences.getIncrementalOption(project);
        ProjectProperties props = AspectJUIPlugin.getDefault().getAjdtProjectProperties();
        List projectFiles = props.getProjectSourceFiles(project, CoreUtils.ASPECTJ_SOURCE_FILTER);
        this.updateBuildConfigIfNecessary(project, projectFiles);
        boolean haveClearedMarkers = false;
        int i = 0;
        while (i < requiredProjects.length) {
            String referencedMessage = "The project cannot be built until its prerequisite " + requiredProjects[i].getName() + " is rebuilt. Cleaning and rebuilding all projects is recommended";
            if (this.projectAlreadyMarked(project, referencedMessage)) {
                if (kind == 6) {
                    props.clearMarkers(true);
                    CompilerTaskListManager.clearOtherProjectMarkers(project);
                } else {
                    props.clearMarkers(false);
                }
                this.markProject(project, referencedMessage);
                haveClearedMarkers = true;
            }
            ++i;
        }
        if (!haveClearedMarkers) {
            if (kind == 6) {
                props.clearMarkers(true);
                CompilerTaskListManager.clearOtherProjectMarkers(project);
            } else {
                props.clearMarkers(false);
            }
        }
        BuildManager buildManager = Ajde.getDefault().getBuildManager();
        if (!AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getBuildAsm()) {
            AJLog.log((String)("build: No structure model to be built for project: " + project.getName()));
            buildManager.setBuildModelMode(false);
        } else {
            buildManager.setBuildModelMode(true);
        }
        MarkerUpdating.deleteAllMarkers(project);
    }

    private boolean projectAlreadyMarked(IProject project, String errorMessage) {
        try {
            IMarker[] problemMarkers = project.findMarkers("org.eclipse.jdt.core.problem", false, 2);
            if (problemMarkers.length > 0) {
                int j = 0;
                while (j < problemMarkers.length) {
                    IMarker marker = problemMarkers[j];
                    int markerSeverity = marker.getAttribute("severity", -1);
                    String markerMessage = marker.getAttribute("message", "no message");
                    if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                        return true;
                    }
                    ++j;
                }
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
            CoreException e = coreException2;
            AJLog.log((String)("build: Problem occured finding the markers for project " + project.getName() + ": " + e.getStackTrace()));
        }
        return false;
    }

    private void markProject(IProject project, String errorMessage) {
        try {
            IMarker errorMarker = project.createMarker("org.eclipse.jdt.core.problem");
            errorMarker.setAttribute("message", (Object)errorMessage);
            errorMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
            CoreException e = coreException2;
            AJLog.log((String)("build: Problem occured creating the error marker for project " + project.getName() + ": " + e.getStackTrace()));
        }
    }

    private void updateBuildConfigIfNecessary(IProject project, List projectFiles) {
        if (this.getBuildFilePath(project).endsWith(".generated.lst")) {
            try {
                this.writeBuildConfigFile(projectFiles, project);
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_4, ajc$tjp_5);
            }
        }
    }

    private String getBuildFilePath(IProject project) {
        String buildfile = AspectJPlugin.getBuildConfigurationFile((IProject)project);
        return buildfile;
    }

    private void writeBuildConfigFile(List projectFiles, IProject project) throws CoreException {
        String configurationFilename = this.getBuildFilePath(project);
        try {
            FileWriter fw = new FileWriter(configurationFilename);
            BufferedWriter bw = new BufferedWriter(fw);
            Iterator it = projectFiles.iterator();
            while (it.hasNext()) {
                File jf = (File)it.next();
                String fileName = jf.toString();
                if (!fileName.endsWith(".java") && !fileName.endsWith(".aj")) continue;
                bw.write(fileName);
                bw.write(System.getProperty("line.separator", "\n"));
            }
            bw.flush();
            fw.flush();
            bw.close();
            IResource res = project.findMember(".generated.lst");
            if (res != null) {
                res.refreshLocal(0, null);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_6, ajc$tjp_7);
            Exception e = exception2;
            Status status = new Status(4, "org.eclipse.ajdt.ui", -10, AspectJUIPlugin.getResourceString("configFileCreateError"), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public void postAJBuild(IProject project, boolean buildCancelled, boolean noSourceChanges) {
        AspectJUIPlugin.getDefault().getAjdtProjectProperties().flushClasspathCache();
        if (noSourceChanges) {
            MarkerUpdating.addNewMarkers(project);
            return;
        }
        String buildPrereqsMessage = AspectJUIPlugin.getFormattedResourceString("buildPrereqsMessage", project.getName());
        if (buildCancelled) {
            this.markReferencingProjects(project, buildPrereqsMessage);
        } else {
            this.removeMarkerOnReferencingProjects(project, buildPrereqsMessage);
        }
        CompilerTaskListManager.showOutstandingProblems();
        if (!AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getBuildAsm()) {
            AspectJEditor.forceEditorUpdates(project);
        }
        StructureModelUtil.wipeCache();
        this.checkOutJarEntry(project);
        MarkerUpdating.addNewMarkers(project);
        if (AspectJPreferences.isAdviceDecoratorActive()) {
            AJModelUtils.refreshOutlineViews();
        }
        if (AspectJUIPlugin.getDefault().getDisplay().isDisposed()) {
            AJLog.log((String)"Not updating vis or xref view, display is disposed!");
        } else {
            AspectJUIPlugin.getDefault().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
                        AJDTContentProvider provider = (AJDTContentProvider)ProviderManager.getContentProvider();
                        provider.reset();
                        VisualiserPlugin.refresh();
                    }
                }
            });
            AspectJUIPlugin.getDefault().getDisplay().syncExec(new Runnable(){

                public void run() {
                    XReferenceUIPlugin.refresh();
                }
            });
        }
    }

    private void markReferencingProjects(IProject project, String errorMessage) {
        IProject[] referencingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < referencingProjects.length) {
            IProject referencingProject = referencingProjects[i];
            if (!this.projectAlreadyMarked(referencingProject, errorMessage)) {
                this.markProject(referencingProject, errorMessage);
            }
            ++i;
        }
    }

    private void removeMarkerOnReferencingProjects(IProject project, String errorMessage) {
        try {
            IProject[] referencingProjects = this.getDependingProjects(project);
            int i = 0;
            while (i < referencingProjects.length) {
                IProject referencingProject = referencingProjects[i];
                IMarker[] problemMarkers = referencingProject.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                if (problemMarkers.length > 0) {
                    int j = 0;
                    while (j < problemMarkers.length) {
                        IMarker marker = problemMarkers[j];
                        int markerSeverity = marker.getAttribute("severity", -1);
                        String markerMessage = marker.getAttribute("message", "no message");
                        if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                            marker.delete();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_8, ajc$tjp_9);
            CoreException e = coreException2;
            AJLog.log((String)("build: Problem occured either finding the markers for project " + project.getName() + ", or deleting the error marker: " + e.getStackTrace()));
        }
    }

    private void checkOutJarEntry(IProject project) {
        String outJar = AspectJUIPlugin.getDefault().getAjdtProjectProperties().getOutJar();
        if (outJar != null && !outJar.equals("")) {
            if (this.outjars == null) {
                this.outjars = new HashMap();
            }
            IPath newPath = this.getRelativePath(project, outJar);
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)newPath.makeAbsolute(), null, null);
            if (this.outjars.containsKey(project)) {
                if (!this.outjars.get(project).equals(newEntry)) {
                    IClasspathEntry oldEntry = (IClasspathEntry)this.outjars.get(project);
                    this.outjars.remove(project);
                    this.removeOutjarFromDependingProjects(project, oldEntry);
                    this.outjars.put(project, newEntry);
                    this.updateDependingProjectsWithJar(project, newEntry);
                }
            } else {
                this.outjars.put(project, newEntry);
                this.updateDependingProjectsWithJar(project, newEntry);
            }
        } else if (this.outjars != null && this.outjars.containsKey(project)) {
            IClasspathEntry oldEntry = (IClasspathEntry)this.outjars.get(project);
            this.outjars.remove(project);
            if (this.outjars.size() == 0) {
                this.outjars = null;
            }
            this.removeOutjarFromDependingProjects(project, oldEntry);
        }
    }

    private void removeOutjarFromDependingProjects(IProject project, IClasspathEntry unwantedEntry) {
        IProject[] dependingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < dependingProjects.length) {
            IJavaProject javaProject = JavaCore.create((IProject)dependingProjects[i]);
            if (javaProject != null) {
                try {
                    IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                    ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                    int j = 0;
                    while (j < cpEntry.length) {
                        if (!cpEntry[j].equals(unwantedEntry)) {
                            newEntries.add(cpEntry[j]);
                        }
                        ++j;
                    }
                    IClasspathEntry[] newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                    javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_10, ajc$tjp_11);
                }
            }
            ++i;
        }
    }

    private void updateDependingProjectsWithJar(IProject project, IClasspathEntry newEntry) {
        IProject[] dependingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < dependingProjects.length) {
            block6: {
                IJavaProject javaProject = JavaCore.create((IProject)dependingProjects[i]);
                if (javaProject != null) {
                    try {
                        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                        int j = 0;
                        while (j < cpEntry.length) {
                            if (!cpEntry[j].equals(newEntry)) {
                                newEntries.add(cpEntry[j]);
                                ++j;
                                continue;
                            }
                            break block6;
                        }
                        newEntries.add(newEntry);
                        IClasspathEntry[] newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                        javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_12, ajc$tjp_13);
                    }
                }
            }
            ++i;
        }
    }

    private IProject[] getDependingProjects(IProject project) {
        IProject[] referencingProjects = project.getReferencingProjects();
        IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects((IProject)project).get(0);
        IProject[] dependingProjects = new IProject[referencingProjects.length + classFolderReferences.length];
        int i = 0;
        while (i < referencingProjects.length) {
            dependingProjects[i] = referencingProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderReferences.length) {
            dependingProjects[i + referencingProjects.length] = classFolderReferences[i];
            ++i;
        }
        return dependingProjects;
    }

    private IPath getRelativePath(IProject project, String outJar) {
        StringBuffer sb = new StringBuffer(outJar);
        int index = sb.lastIndexOf(project.getName());
        Path path = index > 0 ? new Path(sb.substring(sb.lastIndexOf(project.getName()))) : new Path(outJar);
        return path.makeAbsolute();
    }

    static {
        Factory factory = new Factory("UIBuildListener.java", Class.forName("org.eclipse.ajdt.internal.builder.UIBuildListener"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-e-"), 175);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-projectAlreadyMarked-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:java.lang.String:-project:errorMessage:--boolean-"), 160);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-<missing>-"), 428);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-removeOutjarFromDependingProjects-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathEntry:-project:unwantedEntry:--void-"), 411);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-<missing>-"), 454);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateDependingProjectsWithJar-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathEntry:-project:newEntry:--void-"), 434);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-e-"), 187);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-markProject-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:java.lang.String:-project:errorMessage:--void-"), 184);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-<missing>-"), 202);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateBuildConfigIfNecessary-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:java.util.List:-project:projectFiles:--void-"), 199);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-java.lang.Exception-e-"), 245);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-writeBuildConfigFile-org.eclipse.ajdt.internal.builder.UIBuildListener-java.util.List:org.eclipse.core.resources.IProject:-projectFiles:project:-org.eclipse.core.runtime.CoreException:-void-"), 221);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-e-"), 361);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-removeMarkerOnReferencingProjects-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:java.lang.String:-project:errorMessage:--void-"), 340);
    }
}

