/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.ui.AJDTConfigSettings;
import org.eclipse.ajdt.internal.ui.dialogs.MessageDialogWithToggle;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.wizards.AJDTPrefConfigWizard;
import org.eclipse.ajdt.javamodel.AJCompilationUnitUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class AJDTUtils {
    private static final Point SMALL_SIZE;
    private static final Point BIG_SIZE;
    private static final int SMALL_ICONS_MASK = 32;
    private static Hashtable imageDescriptorCache;
    private static Job refreshJob;
    private static int previousExecutionTime;
    private static final String ID_NATURE = "org.eclipse.ajdt.ui.ajnature";
    private static boolean myEclipseMessageDisplayed;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;

    static {
        Factory factory = new Factory("AJDTUtils.java", Class.forName("org.eclipse.ajdt.internal.core.AJDTUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 172);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-addAjrtToBuildPath-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 158);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 863);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-hasAJPluginDependency-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--boolean-"), 846);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.runtime.CoreException-e-"), 896);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-removeAJPluginDependency-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 881);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 978);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-removeAjrtFromBuildPath-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 955);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 1025);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-verifyAjrtVersion-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-current:--void-"), 986);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 265);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-checkMyEclipseNature-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 247);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 429);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-projectHasNoSrc-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--boolean-"), 412);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 585);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-removeMarkerOnReferencingProjects-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 549);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 638);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-importRuntimePlugin-org.eclipse.ajdt.internal.core.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 619);
        SMALL_SIZE = new Point(16, 16);
        BIG_SIZE = new Point(22, 16);
        imageDescriptorCache = new Hashtable();
        myEclipseMessageDisplayed = false;
    }

    public static String getWorkspacePath() {
        return AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public static String getResourcePath(IResource resource) {
        return resource.getLocation().toOSString();
    }

    public static ImageDescriptor decorate(ImageDescriptor base, int decorations) {
        Point size = AJDTUtils.useSmallSize(decorations) ? SMALL_SIZE : BIG_SIZE;
        String key = new String(String.valueOf(base.toString()) + ":::" + decorations + ":::" + size.toString());
        if (imageDescriptorCache.get(key) != null) {
            return (ImageDescriptor)imageDescriptorCache.get(key);
        }
        JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(base, decorations, size);
        imageDescriptorCache.put(key, imageDescriptor);
        return imageDescriptor;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 0x20) != 0;
    }

    public static void addAjrtToBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            IClasspathEntry ajrtLIB = JavaCore.newVariableEntry((IPath)new Path("ASPECTJRT_LIB"), null, null);
            int originalCPLength = originalCP.length;
            IClasspathEntry[] newCP = new IClasspathEntry[originalCPLength + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCPLength);
            newCP[originalCPLength] = ajrtLIB;
            javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public static void addAspectJNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = ID_NATURE;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        if (project.hasNature("org.eclipse.pde.PluginNature")) {
            if (!AJDTUtils.hasAJPluginDependency(project)) {
                AJDTUtils.getAndPrepareToChangePDEModel(project);
                AJDTUtils.addAJPluginDependency(project);
            }
        } else {
            AJDTUtils.addAjrtToBuildPath(project);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AJDTUtils.verifyWorkbenchConfiguration();
            }
        });
        BuildConfigurator.getBuildConfigurator().setup(project);
        AJCompilationUnitManager.INSTANCE.initCompilationUnits(project);
        AJDTUtils.checkMyEclipseNature(project);
        AJDTUtils.refreshPackageExplorer();
    }

    public static void checkMyEclipseNature(IProject project) {
        try {
            if ((project.hasNature("com.genuitec.eclipse.j2eedt.core.webnature") || project.hasNature("com.genuitec.eclipse.j2eedt.core.ejbnature")) && !myEclipseMessageDisplayed) {
                myEclipseMessageDisplayed = true;
                IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                MessageDialog.openInformation((Shell)window.getShell(), (String)AspectJUIPlugin.getResourceString("myEclipse.natureDetected.title"), (String)AspectJUIPlugin.getResourceString("myEclipse.natureDetected.message"));
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_2, ajc$tjp_3);
        }
    }

    private static boolean projectHasNoSrc(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return false;
        }
        boolean foundSrc = false;
        try {
            IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
            int j = 0;
            while (j < cpEntry.length) {
                IClasspathEntry entry = cpEntry[j];
                if (entry.getEntryKind() == 3) {
                    foundSrc = true;
                    break;
                }
                ++j;
            }
            if (!foundSrc) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_4, ajc$tjp_5);
        }
        return false;
    }

    private static void removeMarkerOnReferencingProjects(IProject project) {
        try {
            String errorMessage = "The project cannot be built until its prerequisite " + project.getName() + " is rebuilt. Cleaning and rebuilding all projects is recommended";
            IProject[] refProjects = project.getReferencingProjects();
            IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects((IProject)project).get(0);
            IProject[] referencingProjects = new IProject[refProjects.length + classFolderReferences.length];
            int i = 0;
            while (i < refProjects.length) {
                referencingProjects[i] = refProjects[i];
                ++i;
            }
            i = 0;
            while (i < classFolderReferences.length) {
                referencingProjects[i + refProjects.length] = classFolderReferences[i];
                ++i;
            }
            i = 0;
            while (i < referencingProjects.length) {
                IProject referencingProject = referencingProjects[i];
                IMarker[] problemMarkers = referencingProject.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                if (problemMarkers.length > 0) {
                    int j = 0;
                    while (j < problemMarkers.length) {
                        IMarker marker = problemMarkers[j];
                        int markerSeverity = marker.getAttribute("severity", -1);
                        String markerMessage = marker.getAttribute("message", "no message");
                        if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                            marker.delete();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_6, ajc$tjp_7);
        }
    }

    private static void addAJPluginDependency(IProject project) {
        IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        boolean autoImport = false;
        if (AspectJPreferences.askPDEAutoImport() && AJDTUtils.confirmPDEAutoAddImport(window) || AspectJPreferences.doPDEAutoImport()) {
            autoImport = true;
        }
        if (autoImport) {
            AJDTUtils.importRuntimePlugin(project);
        } else {
            MessageDialog.openWarning((Shell)window.getShell(), (String)AspectJUIPlugin.getResourceString("NoAutoPluginImportDialog.title"), (String)AspectJUIPlugin.getResourceString("NoAutoPluginImportDialog.message"));
        }
    }

    private static void importRuntimePlugin(IProject project) {
        ManifestEditor manEd = AJDTUtils.getAndPrepareToChangePDEModel(project);
        if (manEd != null) {
            IPluginModel model = (IPluginModel)manEd.getAggregateModel();
            try {
                AJDTUtils.addImportToPDEModel(model, "org.aspectj.runtime");
                manEd.doSave((IProgressMonitor)new NullProgressMonitor());
                project.build(6, "org.eclipse.ajdt.core.ajbuilder", null, null);
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_8, ajc$tjp_9);
            }
        } else {
            MessageDialog.openError((Shell)AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AspectJUIPlugin.getResourceString("AutoPluginImportDialog.noEditor.title"), (String)AspectJUIPlugin.getResourceString("AutoPluginImportDialog.noEditor.message"));
        }
    }

    private static void addImportToPDEModel(IPluginModel model, String importId) throws CoreException {
        IPluginImport importNode = model.getPluginFactory().createImport();
        importNode.setId(importId);
        model.getPluginBase().add(importNode);
        IFile manifestFile = (IFile)model.getUnderlyingResource();
        manifestFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ManifestEditor getPDEManifestEditor(IProject project) {
        String pluginId = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel(project).getPluginBase().getId();
        ManifestEditor manEd = null;
        IEditorReference[] eRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < eRefs.length) {
            IEditorReference er = eRefs[i];
            if (er.getId().equals("org.eclipse.pde.ui.manifestEditor") && er.getPartName().equals(pluginId)) {
                IEditorReference manEdRef = er;
                manEd = (ManifestEditor)manEdRef.getPart(true);
                break;
            }
            ++i;
        }
        return manEd;
    }

    public static ManifestEditor getAndPrepareToChangePDEModel(IProject project) {
        String pluginId = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel(project).getPluginBase().getId();
        ManifestEditor.openPluginEditor((String)pluginId);
        ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
        if (manEd != null) {
            manEd.setActivePage("dependencies");
        }
        return manEd;
    }

    public static void verifyWorkbenchConfiguration() {
        boolean showWizard = true;
        Bundle bundle = AspectJUIPlugin.getDefault().getBundle();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (AspectJPreferences.isAJDTPrefConfigDone(version)) {
            showWizard = false;
        }
        if (AJDTConfigSettings.isAnalyzeAnnotationsDisabled() && !AJDTConfigSettings.isAspectJEditorDefault()) {
            showWizard = false;
        }
        if (showWizard && !AspectJPreferences.isAJDTPrefConfigShowing()) {
            AspectJPreferences.setAJDTPrefConfigShowing(true);
            AJDTPrefConfigWizard wizard = new AJDTPrefConfigWizard();
            wizard.init();
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                AspectJPreferences.setAJDTPrefConfigDone(true, version);
            }
        }
    }

    public static void removeAspectJNature(IProject project) throws CoreException {
        AJCompilationUnitUtils.removeCUsfromJavaModelAndCloseEditors(project);
        AspectJUIPlugin ajPlugin = AspectJUIPlugin.getDefault();
        AspectJPlugin.getDefault().setCurrentProject(project);
        ajPlugin.getAjdtProjectProperties().clearMarkers(true);
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length - 1];
        int newPosition = 0;
        int i = 0;
        while (i < prevNatures.length) {
            if (!prevNatures[i].equals(ID_NATURE)) {
                if (newPosition < newNatures.length) {
                    newNatures[newPosition++] = prevNatures[i];
                } else {
                    newNatures = prevNatures;
                    break;
                }
            }
            ++i;
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        if (project.hasNature("org.eclipse.pde.PluginNature")) {
            if (AJDTUtils.hasAJPluginDependency(project)) {
                AJDTUtils.getAndPrepareToChangePDEModel(project);
                AJDTUtils.removeAJPluginDependency(project);
            }
        } else {
            AJDTUtils.removeAjrtFromBuildPath(project);
        }
        AJDTUtils.removeMarkerOnReferencingProjects(project);
        BuildConfigurator.getBuildConfigurator().restoreJDTState(project);
        AJDTUtils.refreshPackageExplorer();
    }

    private static boolean hasAJPluginDependency(IProject project) {
        ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
        IPluginModel model = null;
        IPluginImport[] imports = null;
        if (manEd == null) {
            try {
                IPackageFragmentRoot[] dependencies = JavaCore.create((IProject)project).getPackageFragmentRoots();
                int i = 0;
                while (i < dependencies.length) {
                    if (dependencies[i].getElementName().equals("aspectjrt.jar")) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_10, ajc$tjp_11);
            }
            return false;
        }
        model = (IPluginModel)manEd.getAggregateModel();
        imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport importObj = imports[i];
            if (importObj.getId().equals("org.aspectj.runtime")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void removeAJPluginDependency(IProject project) {
        IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (AspectJPreferences.askPDEAutoRemoveImport() && AJDTUtils.confirmPDEAutoRemoveImport(window) || AspectJPreferences.doPDEAutoRemoveImport()) {
            ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
            if (manEd != null) {
                IPluginModel model = (IPluginModel)manEd.getAggregateModel();
                try {
                    AJDTUtils.removeImportFromPDEModel(model, "org.aspectj.runtime");
                    manEd.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_12, ajc$tjp_13);
                    CoreException e = coreException2;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AutoPluginRemoveErrorDialog.title"), AspectJUIPlugin.getResourceString("AutoPluginRemoveErrorDialog.message"), e);
                }
            } else {
                MessageDialog.openError((Shell)AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AspectJUIPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.title"), (String)AspectJUIPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.message"));
            }
        }
    }

    private static void removeImportFromPDEModel(IPluginModel model, String importId) throws CoreException {
        IPluginImport[] imports = model.getPluginBase().getImports();
        IPluginImport doomed = null;
        int i = 0;
        while (i < imports.length) {
            IPluginImport importObj = imports[i];
            if (importObj.getId().equals(importId)) {
                doomed = importObj;
                break;
            }
            ++i;
        }
        if (doomed != null) {
            model.getPluginBase().remove(doomed);
        }
        IFile manifestFile = (IFile)model.getUnderlyingResource();
        manifestFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeAjrtFromBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> tempCP = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < originalCP.length) {
                IPath path = originalCP[i].getPath();
                if (!path.toOSString().endsWith("ASPECTJRT_LIB") && !path.toOSString().endsWith("aspectjrt.jar")) {
                    tempCP.add(originalCP[i]);
                }
                ++i;
            }
            if (originalCP.length != tempCP.size()) {
                IClasspathEntry[] newCP = tempCP.toArray(new IClasspathEntry[tempCP.size()]);
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_14, ajc$tjp_15);
        }
    }

    public static void verifyAjrtVersion(IProject current) {
        IJavaProject javaProject = JavaCore.create((IProject)current);
        String ajrtPath = CoreUtils.getAspectjrtClasspath();
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> tempCP = new ArrayList<IClasspathEntry>();
            boolean changed = false;
            int i = 0;
            while (i < originalCP.length) {
                IPath path = originalCP[i].getPath();
                if (path.toOSString().endsWith("aspectjrt.jar")) {
                    IClasspathEntry ajrtCP = JavaCore.newLibraryEntry((IPath)new Path(ajrtPath), null, null);
                    tempCP.add(ajrtCP);
                    changed = true;
                    AJDTEventTrace.generalEvent("In project " + current.getName() + " - replacing " + originalCP[i].getPath() + " with " + ajrtCP.getPath());
                } else {
                    tempCP.add(originalCP[i]);
                }
                ++i;
            }
            if (changed) {
                IClasspathEntry[] newCP = tempCP.toArray(new IClasspathEntry[tempCP.size()]);
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_16, ajc$tjp_17);
        }
    }

    private static boolean confirmPDEAutoAddImport(IWorkbenchWindow window) {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion(window.getShell(), AspectJUIPlugin.getResourceString("PluginImportDialog.importConfirmTitle"), AspectJUIPlugin.getResourceString("PluginImportDialog.importConfirmMsg"), AspectJUIPlugin.getResourceString("PluginImportDialog.importConfirmToggleMsg"), false);
        int result = dialog.getReturnCode();
        if (result >= 0 && dialog.getToggleState()) {
            if (result == 0) {
                AspectJPreferences.setDoPDEAutoImport(true);
                AspectJPreferences.setAskPDEAutoImport(false);
            } else {
                AspectJPreferences.setDoPDEAutoImport(false);
                AspectJPreferences.setAskPDEAutoImport(false);
            }
        }
        return result == 0;
    }

    private static boolean confirmPDEAutoRemoveImport(IWorkbenchWindow window) {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion(window.getShell(), AspectJUIPlugin.getResourceString("PluginImportDialog.removeImportConfirmTitle"), AspectJUIPlugin.getResourceString("PluginImportDialog.removeImportConfirmMsg"), AspectJUIPlugin.getResourceString("PluginImportDialog.removeImportConfirmToggleMsg"), false);
        int result = dialog.getReturnCode();
        if (result >= 0 && dialog.getToggleState()) {
            if (result == 0) {
                AspectJPreferences.setDoPDEAutoRemoveImport(true);
                AspectJPreferences.setAskPDEAutoRemoveImport(false);
            } else {
                AspectJPreferences.setDoPDEAutoRemoveImport(false);
                AspectJPreferences.setAskPDEAutoRemoveImport(false);
            }
        }
        return result == 0;
    }

    public static ImageDescriptor decorate(ImageDescriptor base, IProgramElement pNode) {
        int flags = 0;
        if (pNode != null) {
            IMessage sMessage;
            List modifiers = pNode.getModifiers();
            if (modifiers != null) {
                if (modifiers.contains(IProgramElement.Modifiers.ABSTRACT)) {
                    flags |= 1;
                }
                if (modifiers.contains(IProgramElement.Modifiers.FINAL)) {
                    flags |= 2;
                }
                if (modifiers.contains(IProgramElement.Modifiers.SYNCHRONIZED)) {
                    flags |= 4;
                }
                if (modifiers.contains(IProgramElement.Modifiers.STATIC)) {
                    flags |= 8;
                }
            }
            if (pNode.getKind() == IProgramElement.Kind.CONSTRUCTOR || pNode.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                flags |= 0x200;
            }
            if (pNode.isRunnable()) {
                flags |= 0x10;
            }
            if (pNode.isOverrider()) {
                flags |= 0x80;
            }
            if (pNode.isImplementor()) {
                flags |= 0x100;
            }
            if ((sMessage = pNode.getMessage()) != null) {
                if (sMessage.getKind() == IMessage.ERROR) {
                    flags |= 0x40;
                } else if (sMessage.getKind() == IMessage.WARNING) {
                    flags |= 0x20;
                }
            }
        }
        return AJDTUtils.decorate(base, flags);
    }

    public static void refreshPackageExplorer() {
        int delay = 5 * previousExecutionTime;
        if (delay < 250) {
            delay = 250;
        } else if (delay > 5000) {
            delay = 5000;
        }
        AJDTUtils.getRefreshPackageExplorerJob().schedule((long)delay);
    }

    private static Job getRefreshPackageExplorerJob() {
        if (refreshJob == null) {
            refreshJob = new RefreshPackageExplorerJob();
        }
        return refreshJob;
    }

    private static class RefreshPackageExplorerJob
    extends UIJob {
        RefreshPackageExplorerJob() {
            super(AspectJUIPlugin.getResourceString("utils.refresh.explorer.job"));
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            long start = System.currentTimeMillis();
            PackageExplorerPart pep = PackageExplorerPart.getFromActivePerspective();
            if (pep != null) {
                pep.getTreeViewer().refresh();
            }
            previousExecutionTime = (int)(System.currentTimeMillis() - start);
            return Status.OK_STATUS;
        }
    }
}

