/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;

public class AJMainMethodSearchEngine
extends MainMethodSearchEngine {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;

    public Object[] searchMainMethodsIncludingAspects(IProgressMonitor pm, IJavaSearchScope scope, int style, boolean includeSubtypes) throws JavaModelException {
        pm.beginTask(LauncherMessages.getString((String)"MainMethodSearchEngine.1"), 200);
        SubProgressMonitor javaSearchMonitor = new SubProgressMonitor(pm, 100);
        IType[] mainTypes = super.searchMainMethods((IProgressMonitor)javaSearchMonitor, scope, style, includeSubtypes);
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IType> mainList = new ArrayList<IType>(Arrays.asList(mainTypes));
        SubProgressMonitor ajSearchMonitor = new SubProgressMonitor(pm, 100);
        ajSearchMonitor.beginTask(LauncherMessages.getString((String)"MainMethodSearchEngine.1"), 100);
        double ticksPerProject = Math.floor(100.0f / (float)projects.length);
        if (ticksPerProject < 1.0) {
            ticksPerProject = 1.0;
        }
        int i = 0;
        while (i < projects.length) {
            try {
                IJavaProject jp;
                if (projects[i].hasNature("org.eclipse.ajdt.ui.ajnature") && (jp = JavaCore.create((IProject)projects[i])) != null) {
                    if (scope.encloses((IJavaElement)jp)) {
                        Set aspects = this.getAllAspects(jp);
                        mainList.addAll(aspects);
                    } else {
                        IPath[] enclosingPaths = scope.enclosingProjectsAndJars();
                        int j = 0;
                        while (j < enclosingPaths.length) {
                            IPath path = enclosingPaths[j];
                            if (path.equals((Object)jp.getPath())) {
                                IJavaElement[] children = jp.getChildren();
                                mainList.addAll(this.searchJavaElements(scope, children));
                            }
                            ++j;
                        }
                    }
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            }
            ajSearchMonitor.internalWorked(ticksPerProject);
            ++i;
        }
        ajSearchMonitor.done();
        pm.done();
        return mainList.toArray();
    }

    public Object[] searchMainMethodsIncludingAspects(IRunnableContext context, final IJavaSearchScope scope, final int style, final boolean includeSubtypes) throws InvocationTargetException, InterruptedException {
        int allFlags = 24;
        Assert.isTrue(((style | allFlags) == allFlags ? 1 : 0) != 0);
        final Object[][] res = new Object[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    res[0] = AJMainMethodSearchEngine.this.searchMainMethodsIncludingAspects(pm, scope, style, includeSubtypes);
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException2 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
                    JavaModelException e = javaModelException2;
                    throw new InvocationTargetException(e);
                }
            }

            static {
                Factory factory = new Factory("AJMainMethodSearchEngine.java", Class.forName("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine$1-org.eclipse.jdt.core.JavaModelException-e-"), 128);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine$1-org.eclipse.core.runtime.IProgressMonitor:-pm:-java.lang.reflect.InvocationTargetException:-void-"), 126);
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }

    private List searchJavaElements(IJavaSearchScope scope, IJavaElement[] children) throws JavaModelException {
        ArrayList aspectsFound = new ArrayList();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IPackageFragment) {
                aspectsFound.addAll(this.searchPackage(scope, (IPackageFragment)children[i]));
            } else if (children[i] instanceof IPackageFragmentRoot) {
                IJavaElement[] grandchildren = ((IPackageFragmentRoot)children[i]).getChildren();
                aspectsFound.addAll(this.searchJavaElements(scope, grandchildren));
            }
            ++i;
        }
        return aspectsFound;
    }

    private List searchPackage(IJavaSearchScope scope, IPackageFragment packageFragment) throws JavaModelException {
        ArrayList aspectsFound = new ArrayList();
        if (scope.encloses((IJavaElement)packageFragment)) {
            Set aspects = this.getAllAspects(packageFragment);
            aspectsFound.addAll(aspects);
        } else {
            aspectsFound.addAll(this.searchUnitsInPackage(scope, packageFragment));
        }
        return aspectsFound;
    }

    private List searchUnitsInPackage(IJavaSearchScope scope, IPackageFragment packageFragment) throws JavaModelException {
        return new ArrayList(this.getAllAspects(packageFragment));
    }

    private Set getAllAspects(IJavaProject jp) {
        try {
            return new HashSet(this.getActiveMainTypesFromAJCompilationUnits(AJCompilationUnitManager.INSTANCE.getAJCompilationUnits(jp)));
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
            return new HashSet();
        }
    }

    private Set getAllAspects(IPackageFragment packageElement) {
        List aspects = new ArrayList();
        try {
            aspects = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitsForPackage(packageElement);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_4, ajc$tjp_5);
        }
        return new HashSet(this.getActiveMainTypesFromAJCompilationUnits(aspects));
    }

    private List getActiveMainTypesFromAJCompilationUnits(List aspects) {
        ArrayList<IType> mainTypes = new ArrayList<IType>();
        try {
            Iterator iter = aspects.iterator();
            while (iter.hasNext()) {
                AJCompilationUnit element = (AJCompilationUnit)iter.next();
                if (!BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(element.getJavaProject()).getActiveBuildConfiguration().isIncluded(element.getCorrespondingResource())) continue;
                IType[] types = element.getAllTypes();
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    IMethod[] methods = type.getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        if (methods[j].isMainMethod()) {
                            mainTypes.add(type);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_6, ajc$tjp_7);
        }
        return mainTypes;
    }

    static {
        Factory factory = new Factory("AJMainMethodSearchEngine.java", Class.forName("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-java.lang.Exception-<missing>-"), 97);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-searchMainMethodsIncludingAspects-org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-org.eclipse.core.runtime.IProgressMonitor:org.eclipse.jdt.core.search.IJavaSearchScope:int:boolean:-pm:scope:style:includeSubtypes:-org.eclipse.jdt.core.JavaModelException:-[Ljava.lang.Object;-"), 59);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-org.eclipse.core.runtime.CoreException-<missing>-"), 212);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAllAspects-org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-org.eclipse.jdt.core.IJavaProject:-jp:--java.util.Set-"), 211);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-java.lang.Exception-<missing>-"), 228);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAllAspects-org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-org.eclipse.jdt.core.IPackageFragment:-packageElement:--java.util.Set-"), 225);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-java.lang.Exception-<missing>-"), 260);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getActiveMainTypesFromAJCompilationUnits-org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine-java.util.List:-aspects:--java.util.List-"), 242);
    }
}

