/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.core.ICoreOperations;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;

public class UICoreOperations
implements ICoreOperations {
    public boolean isFullBuildRequested(IProject project) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null && pbc.fullBuildRequested()) {
            pbc.requestFullBuild(false);
            return true;
        }
        return false;
    }

    public boolean sourceFilesChanged(IResourceDelta dta, IProject project) {
        if (dta == null) {
            return true;
        }
        String resname = dta.getFullPath().toString();
        if (resname.endsWith(".java") || resname.endsWith(".aj")) {
            ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
            BuildConfiguration bc = pbc.getActiveBuildConfiguration();
            List includedFileNames = bc.getIncludedJavaFileNames(CoreUtils.ASPECTJ_SOURCE_FILTER);
            return includedFileNames.contains(dta.getResource().getLocation().toOSString());
        }
        if (resname.endsWith(".lst") && !resname.endsWith("/generated.lst")) {
            return true;
        }
        boolean kids_results = false;
        int i = 0;
        IResourceDelta[] kids = dta.getAffectedChildren();
        while (!kids_results && i < kids.length) {
            kids_results |= this.sourceFilesChanged(kids[i], project);
            ++i;
        }
        return kids_results;
    }
}

