/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;

public class BuildOptionsAdapter
implements org.aspectj.ajde.BuildOptionsAdapter {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public Map getJavaOptionsMap() {
        Map optionsMap = null;
        try {
            JavaProject project = (JavaProject)AspectJPlugin.getDefault().getCurrentProject().getNature("org.eclipse.jdt.core.javanature");
            optionsMap = project.getOptions(true);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        if (optionsMap == null) {
            return JavaCore.getOptions();
        }
        return optionsMap;
    }

    public String toString() {
        StringBuffer formattedOptions = new StringBuffer();
        formattedOptions.append("Current Compiler options set:");
        formattedOptions.append("[Incremental compilation=" + this.getIncrementalMode() + "]");
        formattedOptions.append("[NonStandard options='" + this.getNonStandardOptions() + "']");
        return formattedOptions.toString();
    }

    public boolean getLenientSpecMode() {
        return false;
    }

    public String getNonStandardOptions() {
        IProject currentProject = AspectJPlugin.getDefault().getCurrentProject();
        String nonStandardOptions = AspectJPreferences.getCompilerOptions(currentProject);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getNonStandardOptions called, returning :" + nonStandardOptions);
        }
        nonStandardOptions = String.valueOf(nonStandardOptions) + AspectJPreferences.getLintOptions(currentProject);
        nonStandardOptions = String.valueOf(nonStandardOptions) + AspectJPreferences.getAdvancedOptions(currentProject);
        if (AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getShowWeaveMessages()) {
            nonStandardOptions = String.valueOf(nonStandardOptions) + " -showWeaveInfo";
        }
        return nonStandardOptions;
    }

    public boolean getPortingMode() {
        return false;
    }

    public boolean getPreprocessMode() {
        return false;
    }

    public boolean getSourceOnePointFourMode() {
        return false;
    }

    public boolean getStrictSpecMode() {
        return false;
    }

    public boolean getIncrementalMode() {
        IProject currentProject = AspectJPlugin.getDefault().getCurrentProject();
        boolean incrementalMode = AspectJPreferences.getIncrementalOption(currentProject);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getIncrementalMode called, returning :" + new Boolean(incrementalMode));
        }
        return incrementalMode;
    }

    public boolean getBuildAsm() {
        IProject currentProject = AspectJPlugin.getDefault().getCurrentProject();
        boolean buildAsm = AspectJPreferences.getBuildASMOption(currentProject);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getBuildAsm called, returning :" + new Boolean(buildAsm));
        }
        return buildAsm;
    }

    public boolean getShowWeaveMessages() {
        IProject currentProject = AspectJPlugin.getDefault().getCurrentProject();
        boolean showweavemessages = AspectJPreferences.getShowWeaveMessagesOption(currentProject);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getShowWeaveMessages called, returning :" + new Boolean(showweavemessages));
        }
        return showweavemessages;
    }

    public String getWorkingOutputPath() {
        return "";
    }

    public String getComplianceLevel() {
        return null;
    }

    public Set getDebugLevel() {
        return null;
    }

    public boolean getNoImportError() {
        return false;
    }

    public boolean getPreserveAllLocals() {
        return false;
    }

    public String getSourceCompatibilityLevel() {
        return null;
    }

    public Set getWarnings() {
        return null;
    }

    public boolean getUseJavacMode() {
        return false;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public String getOutJar() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String outputJar = AspectJPreferences.getProjectOutJar(thisProject);
        if (outputJar.trim().length() > 0 && !outputJar.startsWith("\\") && !outputJar.startsWith("/")) {
            String trimmedName = outputJar.trim();
            boolean prependProject = true;
            if (trimmedName.length() > 1 && trimmedName.charAt(1) == ':') {
                prependProject = false;
            }
            if (prependProject) {
                String projectBaseDirectory = thisProject.getLocation().toOSString();
                outputJar = new String(String.valueOf(projectBaseDirectory) + File.separator + outputJar.trim());
            }
        }
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getOutJar called, returning :" + outputJar);
        }
        return outputJar;
    }

    public Set getInJars() {
        return null;
    }

    public Set getInPath() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String[] v = AspectJPreferences.getProjectInPath(thisProject);
        String inpath = this.expandVariables(v[0], v[2]);
        inpath = this.fullyQualifyPathEntries(inpath);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getInPath called, returning :" + inpath);
        }
        if (inpath.length() == 0) {
            return null;
        }
        return this.mapStringToSet(inpath, false);
    }

    private String expandVariables(String path, String eKinds) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(path, File.pathSeparator);
        StringTokenizer strTok2 = new StringTokenizer(eKinds, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            int entryKind = Integer.parseInt(strTok2.nextToken());
            if (entryKind == 4) {
                String exp;
                int slashPos = current.indexOf("/", 0);
                if (slashPos != -1) {
                    exp = JavaCore.getClasspathVariable((String)current.substring(0, slashPos)).toOSString();
                    resultBuffer.append(exp);
                    resultBuffer.append(current.substring(slashPos));
                } else {
                    exp = JavaCore.getClasspathVariable((String)current).toOSString();
                    resultBuffer.append(exp);
                }
            } else {
                resultBuffer.append(current);
            }
            resultBuffer.append(File.pathSeparator);
        }
        return resultBuffer.toString();
    }

    private String fullyQualifyPathEntries(String inputPath) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(inputPath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            File f = new File(current);
            if (f.exists() && f.isAbsolute()) {
                resultBuffer.append(current);
            } else {
                String projectName = null;
                int slashPos = current.indexOf("/", 1);
                projectName = slashPos != -1 ? current.substring(1, slashPos) : current.substring(1);
                IProject project = AspectJPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.getLocation() != null) {
                    String projectPath = project.getLocation().toString();
                    if (slashPos != -1) {
                        resultBuffer.append(String.valueOf(projectPath) + "/" + current.substring(slashPos + 1));
                    } else {
                        resultBuffer.append(projectPath);
                    }
                } else {
                    AJDTEventTrace.generalEvent("AspectJ path entry " + current + " does not exist. Ignoring.");
                    if (AspectJUIPlugin.DEBUG_BUILDER) {
                        System.out.println("BuildOptionsAdapter.fullyQualifyPathEntries detected path entry " + current + " does not exist");
                    }
                }
            }
            resultBuffer.append(File.pathSeparator);
        }
        String result = resultBuffer.toString();
        if (result.endsWith(File.pathSeparator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Set getAspectPath() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String[] v = AspectJPreferences.getProjectAspectPath(thisProject);
        String aspectpath = this.expandVariables(v[0], v[2]);
        aspectpath = this.fullyQualifyPathEntries(aspectpath);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getAspectPath called, returning :" + aspectpath);
        }
        if (aspectpath.length() == 0) {
            return null;
        }
        return this.mapStringToSet(aspectpath, false);
    }

    private Set mapStringToSet(String input, boolean validateFiles) {
        if (input.length() == 0) {
            return null;
        }
        String inputCopy = input;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("Converting ]" + input + "[");
        }
        HashSet<File> fileSet = new HashSet<File>();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + f.toString() + "[");
                }
            } else {
                fileSet.add(f);
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + f.toString() + "[");
                }
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + f.toString() + "[");
                }
            } else {
                fileSet.add(f);
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + f.toString() + "[");
                }
            }
        }
        if (validateFiles && invalidEntries.length() != 0) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleWarning("The following jar files do not exist and are being ignored:\n" + invalidEntries.toString());
        }
        return fileSet;
    }

    public Set getSourceRoots() {
        return null;
    }

    static {
        Factory factory = new Factory("BuildOptionsAdapter.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.runtime.CoreException-<missing>-"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getJavaOptionsMap-org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter----java.util.Map-"), 38);
    }
}

