/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.builder.CoreProjectProperties;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.ui.ajde.RuntimeClasspathCalculator;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class ProjectProperties
extends CoreProjectProperties
implements ProjectPropertiesAdapter {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;

    public List getProjectSourceFiles() {
        IProject activeProject = AspectJPlugin.getDefault().getCurrentProject();
        return this.getProjectSourceFiles(activeProject, CoreUtils.ASPECTJ_SOURCE_FILTER);
    }

    public List getProjectSourceFiles(IProject project, CoreUtils.FilenameFilter filter) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null) {
            return pbc.getActiveBuildConfiguration().getIncludedJavaFiles(filter);
        }
        return new ArrayList(0);
    }

    public String getOldClasspath() {
        StringBuffer classpath = new StringBuffer();
        try {
            IProject proj = AspectJPlugin.getDefault().getCurrentProject();
            IJavaProject jp = JavaCore.create((IProject)proj);
            IRuntimeClasspathEntry[] rtcp = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)jp);
            HashSet<String> cp = new HashSet<String>();
            int i = 0;
            while (i < rtcp.length) {
                IRuntimeClasspathEntry[] resolved = RuntimeClasspathCalculator.resolveRuntimeClasspathEntry(rtcp[i], jp);
                int j = 0;
                while (j < resolved.length) {
                    cp.add(resolved[j].getLocation());
                    ++j;
                }
                ++i;
            }
            Iterator it = cp.iterator();
            while (it.hasNext()) {
                classpath.append(it.next());
                classpath.append(File.pathSeparator);
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        if (AspectJUIPlugin.isDebugging) {
            System.out.println("Using classpath: " + classpath);
        }
        return classpath.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getJavaProjectClasspath(IProject project, Set projectClasspathSet, Set circularDependencyPreventer, boolean processingDependantProjects) throws CoreException {
        String projectLocalPrefix = String.valueOf(File.separator) + project.getName();
        String prependPath = project.getLocation().removeLastSegments(1).toOSString();
        IJavaProject jProject = JavaCore.create((IProject)project);
        String outputLocation = jProject.getOutputLocation().toOSString();
        if (processingDependantProjects) {
            projectClasspathSet.add(String.valueOf(prependPath) + outputLocation);
        }
        IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
        int i = 0;
        while (i < classpathEntries.length) {
            block9: {
                String cpstring = classpathEntries[i].getPath().toOSString();
                if (!processingDependantProjects || classpathEntries[i].isExported()) {
                    switch (classpathEntries[i].getEntryKind()) {
                        case 1: {
                            if (cpstring == null || !cpstring.startsWith(projectLocalPrefix)) break;
                            cpstring = String.valueOf(prependPath) + cpstring;
                            break;
                        }
                        case 2: {
                            String name = classpathEntries[i].getPath().lastSegment();
                            IProject projectDependancy = AspectJPlugin.getWorkspace().getRoot().getProject(name);
                            if (projectDependancy.exists() && projectDependancy.isOpen() && projectDependancy.hasNature("org.eclipse.jdt.core.javanature") && !circularDependencyPreventer.contains(projectDependancy)) {
                                circularDependencyPreventer.add(projectDependancy);
                                this.getJavaProjectClasspath(projectDependancy, projectClasspathSet, circularDependencyPreventer, true);
                            }
                            break block9;
                        }
                        case 3: {
                            cpstring = String.valueOf(prependPath) + cpstring;
                        }
                    }
                    projectClasspathSet.add(cpstring);
                }
            }
            ++i;
        }
    }

    public String getExecutionArgs() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        return AspectJPreferences.getCompilerOptions(project);
    }

    public void clearMarkers(boolean recurse) {
        IProject currProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            currProject.deleteMarkers("org.eclipse.jdt.core.problem", false, recurse ? 2 : 0);
            currProject.deleteMarkers("org.eclipse.ajdt.ui.problemmarker", true, recurse ? 2 : 0);
            currProject.deleteMarkers("org.eclipse.core.resources.taskmarker", true, recurse ? 2 : 0);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_2, ajc$tjp_3);
        }
    }

    public IResource findResource(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(fullPath);
        return root.getFileForLocation((IPath)path);
    }

    private String toCanonical(String path) {
        if (path.charAt(1) == ':' && (path.charAt(0) >= 'a' && path.charAt(0) <= 'z' || path.charAt(0) >= 'A' && path.charAt(0) <= 'Z')) {
            return String.valueOf(Character.toUpperCase(path.charAt(0))) + path.substring(1);
        }
        return path;
    }

    public IResource findResource(String fullPath, IProject p) {
        String toMatch = this.toCanonical(fullPath.replace('\\', '/'));
        try {
            IJavaProject jp = JavaCore.create((IProject)p);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                IPath pe;
                IClasspathEntry e = cpes[i];
                if (e.getEntryKind() == 3 && (pe = e.getPath()).segment(0).equals(p.getName())) {
                    IProject iproj;
                    String postfix;
                    Path postfixPath;
                    IResource ires = p.findMember(pe.removeFirstSegments(1));
                    if (ires instanceof IFolder) {
                        IFolder f = (IFolder)ires;
                        if (toMatch.startsWith(this.toCanonical(f.getLocation().toString())) && f.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(f.getLocation().toString().length()))))) {
                            return f.findMember((IPath)postfixPath);
                        }
                    } else if (ires instanceof IProject && toMatch.startsWith(this.toCanonical((iproj = (IProject)ires).getLocation().toString())) && iproj.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(iproj.getLocation().toString().length()))))) {
                        return iproj.findMember((IPath)postfixPath);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = root.getLocation();
        Path path = new Path(fullPath);
        if (rootPath.isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(rootPath.segmentCount());
        }
        IResource ret = p.findMember((IPath)path);
        return ret;
    }

    public String getAspectjrtClasspath() {
        return CoreUtils.getAspectjrtClasspath();
    }

    private void getAllFiles(IResource[] resource_list, List allProjectFiles, Hashtable fileToResourceHt, CoreUtils.FilenameFilter filter, BuildConfiguration bc) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir instanceof IContainer) {
                    this.getAllFiles(((IContainer)ir).members(), allProjectFiles, fileToResourceHt, filter, bc);
                } else if (filter.accept(ir.getName()) && bc.isIncluded(ir)) {
                    allProjectFiles.add(new File(ir.getLocation().toOSString()));
                    if (fileToResourceHt != null) {
                        fileToResourceHt.put(new File(ir.getLocation().toOSString()), ir);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_6, ajc$tjp_7);
        }
    }

    private void getProjectRelativePaths(IResource[] resource_list, List allProjectFiles, CoreUtils.FilenameFilter filter, int trimSegments) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir instanceof IContainer) {
                    this.getProjectRelativePaths(((IContainer)ir).members(), allProjectFiles, filter, trimSegments);
                } else if (filter.accept(ir.getName())) {
                    String[] segments = ir.getProjectRelativePath().segments();
                    String path = "";
                    int j = trimSegments;
                    while (j < segments.length) {
                        path = String.valueOf(path) + segments[j];
                        if (j < segments.length - 1) {
                            path = String.valueOf(path) + '/';
                        }
                        ++j;
                    }
                    allProjectFiles.add(path);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_8, ajc$tjp_9);
        }
    }

    public List getBuildConfigFiles() {
        ArrayList<String> lstFiles_Strings = new ArrayList<String>();
        List lstFiles_IResources = AspectJUIPlugin.getDefault().getListOfConfigFilesForCurrentProject();
        Iterator iter = lstFiles_IResources.iterator();
        while (iter.hasNext()) {
            IResource ir = (IResource)iter.next();
            lstFiles_Strings.add(ir.getFullPath().toOSString());
        }
        return lstFiles_Strings;
    }

    public Set getInJars() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getInJars();
    }

    public Map getSourcePathResources() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        HashMap<String, File> map = new HashMap<String, File>();
        try {
            String realOutputLocation;
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            IPath workspaceRelativeOutputPath = jProject.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                realOutputLocation = jProject.getResource().getLocation().toOSString();
            } else {
                IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                realOutputLocation = out.getLocation().toOSString();
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    IClasspathEntry sourceEntry = classpathEntries[i];
                    IPath sourcePath = sourceEntry.getPath();
                    ArrayList files = new ArrayList();
                    sourcePath = sourcePath.removeFirstSegments(1);
                    IResource[] srcContainer = new IResource[]{project.findMember(sourcePath)};
                    this.getProjectRelativePaths(srcContainer, files, CoreUtils.RESOURCE_FILTER, srcContainer[0].getFullPath().segmentCount() - 1);
                    ArrayList linkedSrcFolders = this.getLinkedChildFolders(srcContainer[0]);
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        String relPath = (String)it.next();
                        String fullPath = this.getResourceFullPath(srcContainer[0], relPath, linkedSrcFolders);
                        if (fullPath.startsWith(realOutputLocation) || relPath.endsWith(".classpath") || relPath.endsWith(".project") || relPath.endsWith(".ajsym") || relPath.endsWith(".lst")) continue;
                        File file = new File(fullPath);
                        map.put(relPath, file);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_10, ajc$tjp_11);
            JavaModelException jmEx = javaModelException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("ajErrorDialogTitle"), AspectJUIPlugin.getResourceString("jmCoreException"), jmEx);
        }
        return map;
    }

    public String getOutJar() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getOutJar();
    }

    public Set getSourceRoots() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getSourceRoots();
    }

    public Set getAspectPath() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getAspectPath();
    }

    private ArrayList getLinkedChildFolders(IResource resource) {
        ArrayList<IResource> resultList = new ArrayList<IResource>();
        if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IFolder && children[i].isLinked()) {
                        resultList.add(children[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_12, ajc$tjp_13);
            }
        }
        return resultList;
    }

    private String getResourceFullPath(IResource srcContainer, String relPath, ArrayList linkedFolders) {
        String result = null;
        if (relPath.lastIndexOf(47) != -1) {
            Iterator it = linkedFolders.iterator();
            while (it.hasNext()) {
                IFolder folder = (IFolder)it.next();
                String linkedFolderName = folder.getName();
                if (relPath.indexOf(String.valueOf(linkedFolderName) + "/") != 0) continue;
                result = String.valueOf(folder.getLocation().toString()) + relPath.substring(linkedFolderName.length());
                result = result.replace('/', File.separatorChar);
                break;
            }
        }
        if (result == null) {
            result = String.valueOf(srcContainer.getLocation().toOSString()) + File.separator + relPath;
        }
        return result;
    }

    public Set getInpath() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getInPath();
    }

    static {
        Factory factory = new Factory("ProjectProperties.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.ProjectProperties"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.runtime.CoreException-<missing>-"), 123);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOldClasspath-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties----java.lang.String-"), 101);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.jdt.core.JavaModelException-jmEx-"), 599);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSourcePathResources-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties----java.util.Map-"), 544);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.runtime.CoreException-<missing>-"), 656);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLinkedChildFolders-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.resources.IResource:-resource:--java.util.ArrayList-"), 645);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 329);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-clearMarkers-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-boolean:-recurse:--void-"), 315);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 409);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-findResource-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.String:org.eclipse.core.resources.IProject:-fullPath:p:--org.eclipse.core.resources.IResource-"), 364);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 472);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAllFiles-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-[Lorg.eclipse.core.resources.IResource;:java.util.List:java.util.Hashtable:org.eclipse.ajdt.internal.core.CoreUtils$FilenameFilter:org.eclipse.ajdt.buildconfigurator.BuildConfiguration:-resource_list:allProjectFiles:fileToResourceHt:filter:bc:--void-"), 447);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 496);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getProjectRelativePaths-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-[Lorg.eclipse.core.resources.IResource;:java.util.List:org.eclipse.ajdt.internal.core.CoreUtils$FilenameFilter:int:-resource_list:allProjectFiles:filter:trimSegments:--void-"), 480);
    }
}

