/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.File;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.resources.AJDTIcon;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AdviceActionDelegate
extends AbstractRulerActionDelegate {
    IEditorPart editor = null;
    IVerticalRulerInfo rulerInfo = null;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        String id;
        if (!(targetEditor == null || (id = targetEditor.getSite().getId()).equals("org.eclipse.jdt.ui.CompilationUnitEditor") || id.equals("org.eclipse.jdt.ui.ClassFileEditor") || id.equals("org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor"))) {
            targetEditor = null;
        }
        this.editor = targetEditor;
        super.setActiveEditor(callerAction, targetEditor);
    }

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.rulerInfo = rulerInfo;
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        try {
            IFileEditorInput ifep = (IFileEditorInput)this.editor.getEditorInput();
            IFile ifile = ifep.getFile();
            int linenumber = this.rulerInfo.getLineOfLastMouseButtonActivity();
            Integer clickedLine = new Integer(linenumber + 1);
            IMarker[] markers = ifile.findMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
            MenuManager adviceSubmenu = null;
            boolean adviceSubmenuInitialized = false;
            if (markers != null && markers.length != 0) {
                int j = 0;
                while (j < markers.length) {
                    IMarker m = markers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String textLabel = (String)m.getAttribute("message");
                        AJDTMenuAction ama = new AJDTMenuAction(textLabel, m);
                        if (!adviceSubmenuInitialized) {
                            adviceSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.adviceInAffect"));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IContributionItem)adviceSubmenu);
                            adviceSubmenuInitialized = true;
                        }
                        adviceSubmenu.add((IAction)ama);
                    }
                    ++j;
                }
            }
            IMarker[] sMarkers = ifile.findMarkers("org.eclipse.ajdt.ui.sourceadvicemarker", true, 2);
            MenuManager sourceAdviceSubmenu = null;
            boolean sourceAdviceSubmenuInitialized = false;
            if (sMarkers != null && sMarkers.length != 0) {
                int j = 0;
                while (j < sMarkers.length) {
                    IMarker m = sMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String textLabel = (String)m.getAttribute("message");
                        AJDTMenuAction ama = new AJDTMenuAction(textLabel, m);
                        if (!sourceAdviceSubmenuInitialized) {
                            sourceAdviceSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.adviceAffects"));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IContributionItem)sourceAdviceSubmenu);
                            sourceAdviceSubmenuInitialized = true;
                        }
                        sourceAdviceSubmenu.add((IAction)ama);
                    }
                    ++j;
                }
            }
            IMarker[] decMarkers = ifile.findMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
            MenuManager declaresSubmenu = null;
            MenuManager declarationSubmenu = null;
            MenuManager annotationSubmenu = null;
            MenuManager annotatesSubmenu = null;
            boolean declaresSubmenuInitialized = false;
            boolean declarationSubmenuInitialized = false;
            boolean annotationSubmenuInitialized = false;
            boolean annotatesSubmenuInitialized = false;
            if (decMarkers != null && decMarkers.length != 0) {
                int j = 0;
                while (j < decMarkers.length) {
                    IMarker m = decMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        AJDTMenuAction ama;
                        String textLabel;
                        if (m.getType().equals("org.eclipse.ajdt.ui.annotatedmarker")) {
                            textLabel = (String)m.getAttribute("message");
                            ama = new AJDTMenuAction(textLabel, m);
                            if (!annotationSubmenuInitialized) {
                                annotationSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.annotations"));
                                if (!(adviceSubmenuInitialized || sourceAdviceSubmenuInitialized || declarationSubmenuInitialized || annotatesSubmenuInitialized || declaresSubmenuInitialized)) {
                                    manager.add((IContributionItem)new Separator());
                                }
                                manager.add((IContributionItem)annotationSubmenu);
                                annotationSubmenuInitialized = true;
                            }
                            annotationSubmenu.add((IAction)ama);
                        } else if (m.getType().equals("org.eclipse.ajdt.ui.sourceannotatedmarker")) {
                            textLabel = (String)m.getAttribute("message");
                            ama = new AJDTMenuAction(textLabel, m);
                            if (!annotatesSubmenuInitialized) {
                                annotatesSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.annotationAffects"));
                                if (!(adviceSubmenuInitialized || sourceAdviceSubmenuInitialized || declarationSubmenuInitialized || annotationSubmenuInitialized || declaresSubmenuInitialized)) {
                                    manager.add((IContributionItem)new Separator());
                                }
                                manager.add((IContributionItem)annotatesSubmenu);
                                annotatesSubmenuInitialized = true;
                            }
                            annotatesSubmenu.add((IAction)ama);
                        } else if (m.getType().equals("org.eclipse.ajdt.ui.sourceitdmarker")) {
                            textLabel = (String)m.getAttribute("message");
                            ama = new AJDTMenuAction(textLabel, m);
                            if (!declaresSubmenuInitialized) {
                                declaresSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.declaredOn"));
                                if (!(adviceSubmenuInitialized || sourceAdviceSubmenuInitialized || annotationSubmenuInitialized || annotatesSubmenuInitialized || declarationSubmenuInitialized)) {
                                    manager.add((IContributionItem)new Separator());
                                }
                                manager.add((IContributionItem)declaresSubmenu);
                                declaresSubmenuInitialized = true;
                            }
                            declaresSubmenu.add((IAction)ama);
                        } else {
                            textLabel = (String)m.getAttribute("message");
                            ama = new AJDTMenuAction(textLabel, m);
                            if (!declarationSubmenuInitialized) {
                                declarationSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.aspectDeclarations"));
                                if (!(adviceSubmenuInitialized || sourceAdviceSubmenuInitialized || annotationSubmenuInitialized || annotatesSubmenuInitialized || declaresSubmenuInitialized)) {
                                    manager.add((IContributionItem)new Separator());
                                }
                                manager.add((IContributionItem)declarationSubmenu);
                                declarationSubmenuInitialized = true;
                            }
                            declarationSubmenu.add((IAction)ama);
                        }
                    }
                    ++j;
                }
            }
            IMarker[] probMarkers = ifile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            MenuManager problemSubmenu = null;
            boolean problemSubmenuInitialized = false;
            if (probMarkers != null && probMarkers.length != 0) {
                int j = 0;
                while (j < probMarkers.length) {
                    IMarker m = probMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String loc;
                        int relCount = 0;
                        if ((loc = (String)m.getAttribute("relatedLocations-" + relCount++)) != null) {
                            while (loc != null) {
                                String[] s = loc.split(":::");
                                String resName = s[0].substring(s[0].lastIndexOf(File.separator) + 1);
                                String textLabel = AspectJUIPlugin.getFormattedResourceString("EditorRulerContextMenu.relatedLocation.message", new String[]{resName, s[1]});
                                RelatedLocationMenuAction ama = new RelatedLocationMenuAction(textLabel, loc);
                                if (!problemSubmenuInitialized) {
                                    problemSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.relatedLocations"));
                                    if (!(adviceSubmenuInitialized || sourceAdviceSubmenuInitialized || declarationSubmenuInitialized || annotatesSubmenuInitialized || annotationSubmenuInitialized)) {
                                        manager.add((IContributionItem)new Separator());
                                    }
                                    manager.add((IContributionItem)problemSubmenu);
                                    problemSubmenuInitialized = true;
                                }
                                problemSubmenu.add((IAction)ama);
                                loc = (String)m.getAttribute("relatedLocations-" + relCount++);
                            }
                        }
                    }
                    ++j;
                }
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception whilst extending ruler context menu with advice items", ce);
        }
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;

            public void run() {
                IEditorStatusLine fStatusLine;
                IEditorPart iEditorPart = AdviceActionDelegate.this.editor;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException2 = classNotFoundException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, this, ajc$tjp_0, ajc$tjp_1);
                        throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                    }
                }
                if ((fStatusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
                    fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }

            static {
                Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$1-java.lang.ClassNotFoundException-<missing>-"), 548);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$1----void-"), 548);
            }
        });
    }

    static {
        Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.core.runtime.CoreException-ce-"), 322);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-menuAboutToShow-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.jface.action.IMenuManager:-manager:--void-"), 105);
    }

    abstract class BaseAJDTMenuAction
    extends Action {
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;

        BaseAJDTMenuAction(String s) {
            super(s);
        }

        abstract String getJumpLocation();

        public void run() {
            block8: {
                try {
                    String[] s = this.getJumpLocation().split(":::");
                    String filepath = s[0];
                    String linenumber = s[1];
                    IResource r = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(filepath);
                    if (r == null) {
                        r = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(filepath, AspectJPlugin.getDefault().getCurrentProject());
                    }
                    IResource ir = r;
                    IMarker jumpMarker = null;
                    if (ir != null && ir.exists()) {
                        try {
                            jumpMarker = ir.createMarker("org.eclipse.core.resources.textmarker");
                            jumpMarker.setAttribute("lineNumber", new Integer(linenumber).intValue());
                        }
                        catch (CoreException coreException) {
                            CoreException coreException2 = coreException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                            CoreException ce = coreException2;
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Unable to build jump marker in AdviceMenuAction run method", ce);
                        }
                        try {
                            IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)jumpMarker, (boolean)true);
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_2, ajc$tjp_1);
                            Exception e = exception2;
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception whilst asking editor to jump to advice location", e);
                        }
                        break block8;
                    }
                    AdviceActionDelegate.this.report("Could not find resource.");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    IndexOutOfBoundsException indexOutOfBoundsException2 = indexOutOfBoundsException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(indexOutOfBoundsException2, (Object)this, ajc$tjp_3, ajc$tjp_1);
                    IndexOutOfBoundsException ioobe = indexOutOfBoundsException2;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("Problem parsing marker jump location (probably!)", ioobe);
                }
            }
        }

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction-org.eclipse.core.runtime.CoreException-ce-"), 394);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction----void-"), 366);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction-java.lang.Exception-e-"), 407);
            ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction-java.lang.IndexOutOfBoundsException-ioobe-"), 419);
        }
    }

    class RelatedLocationMenuAction
    extends BaseAJDTMenuAction {
        private String jumpLocation;

        RelatedLocationMenuAction(String s, String jumpLocation) {
            super(s);
            this.jumpLocation = jumpLocation;
            this.setImageDescriptor(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.jcu_obj.gif"));
        }

        String getJumpLocation() {
            return this.jumpLocation;
        }
    }

    class AJDTMenuAction
    extends BaseAJDTMenuAction {
        private IMarker adviceMarker;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;

        AJDTMenuAction(String s, IMarker marker) {
            super(s);
            this.adviceMarker = marker;
            ImageDescriptor descriptor = null;
            String acckind = marker.getAttribute("acckind", "");
            if (acckind.length() == 2) {
                char markerKind = acckind.charAt(0);
                char markerAcc = acckind.charAt(1);
                IProgramElement.Accessibility acc = null;
                IProgramElement.Kind kind = null;
                if (markerKind == 'M') {
                    kind = IProgramElement.Kind.METHOD;
                } else if (markerKind == 'F') {
                    kind = IProgramElement.Kind.FIELD;
                } else if (markerKind == 'C') {
                    kind = IProgramElement.Kind.CODE;
                } else if (markerKind == 'A') {
                    kind = IProgramElement.Kind.ASPECT;
                }
                if (markerAcc == 'G') {
                    acc = IProgramElement.Accessibility.PUBLIC;
                } else if (markerAcc == 'Y') {
                    acc = IProgramElement.Accessibility.PROTECTED;
                } else if (markerAcc == 'B') {
                    acc = IProgramElement.Accessibility.PACKAGE;
                } else if (markerAcc == 'R') {
                    acc = IProgramElement.Accessibility.PRIVATE;
                }
                if (kind != null) {
                    AbstractIcon icon = AspectJImages.registry().getStructureIcon(kind, acc);
                    descriptor = ((AJDTIcon)icon).getImageDescriptor();
                }
            }
            if (descriptor == null) {
                String runtimeTest = AspectJUIPlugin.getResourceString("AspectJEditor.runtimetest");
                boolean hasRuntimeTest = false;
                if (s.endsWith(runtimeTest)) {
                    hasRuntimeTest = true;
                }
                if (s.indexOf(".before(") != -1) {
                    descriptor = hasRuntimeTest ? AspectJImages.DYNAMIC_BEFORE_ADVICE.getImageDescriptor() : AspectJImages.BEFORE_ADVICE.getImageDescriptor();
                } else if (s.indexOf(".after(") != -1 || s.indexOf(".afterReturning(") != -1 || s.indexOf(".afterThrowing(") != -1) {
                    descriptor = hasRuntimeTest ? AspectJImages.DYNAMIC_AFTER_ADVICE.getImageDescriptor() : AspectJImages.AFTER_ADVICE.getImageDescriptor();
                } else if (s.indexOf(".around(") != -1) {
                    descriptor = hasRuntimeTest ? AspectJImages.DYNAMIC_AROUND_ADVICE.getImageDescriptor() : AspectJImages.AROUND_ADVICE.getImageDescriptor();
                }
            }
            if (descriptor == null) {
                descriptor = AspectJImages.ITD.getImageDescriptor();
            }
            this.setImageDescriptor(descriptor);
        }

        String getJumpLocation() {
            try {
                return (String)this.adviceMarker.getAttribute("sourceLocationOfAdvice");
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                CoreException ce = coreException2;
                AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception whilst executing AdviceMenuAction run method", ce);
                return null;
            }
        }

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$AJDTMenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$AJDTMenuAction-org.eclipse.core.runtime.CoreException-ce-"), 533);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getJumpLocation-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$AJDTMenuAction----java.lang.String-"), 531);
        }
    }
}

