/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.internal.ui.CompilerPropertyPage;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class AspectJPreferences {
    public static final String COMPILER_OPTIONS = "org.eclipse.ajdt.core.compiler.nonStandardOptions";
    public static final String AJDE_JAR = "ajde.jar";
    public static final String JAVA_OR_AJ_EXT = "aspectjPreferences.fileExt";
    public static final String ADVICE_DECORATOR = "aspectjPreferences.adviceDec";
    public static final String ACTIVE_CONFIG = "org.eclipse.ajdt.ui.activeBuildConfiguration";
    public static final String OUT_JAR = "org.eclipse.ajdt.ui.outJar";
    public static final String ASPECTPATH = "org.eclipse.ajdt.ui.aspectPath";
    public static final String ASPECTPATH_CON_KINDS = "org.eclipse.ajdt.ui.aspectPath.contentKind";
    public static final String ASPECTPATH_ENT_KINDS = "org.eclipse.ajdt.ui.aspectPath.entryKind";
    public static final String INPATH = "org.eclipse.ajdt.ui.inPath";
    public static final String INPATH_CON_KINDS = "org.eclipse.ajdt.ui.inPath.contentKind";
    public static final String INPATH_ENT_KINDS = "org.eclipse.ajdt.ui.inPath.entryKind";
    public static final String ASPECTJ_OUTLINE = "org.eclipse.ajdt.ui.ajoutline2";
    public static final String AUTOBUILD_SUPPRESSED = "org.eclipse.ajdt.ui.preferences.autobuildSuppressed";
    public static final String AJDT_PREF_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.ajdtPrefConfigDone";
    public static final String PREF_RUN_FOR_AJDT_VERSION = "org.eclipse.ajdt.ui.preferences.prefRunForAjdtVersion";
    public static final String PERFORM_AUTO_BUILDER_MIGRATION = "org.eclipse.ajdt.ui.preferences.perform.auto.migration";
    public static final String AUTO_BUILDER_MIGRATION_SETTING = "org.eclipse.ajdt.ui.preferences.auto.migration.setting";
    public static final String PDE_AUTO_IMPORT_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.pdeAutoImportConfigDone";
    public static final String PDE_AUTO_REMOVE_IMPORT_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.pdeAutoRemoveImportConfigDone";
    public static final String ASK_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.askPdeAutoImport";
    public static final String DO_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.doPdeAutoImport";
    public static final String ASK_PDE_AUTO_REMOVE_IMPORT = "org.eclipse.ajdt.ui.preferences.askPdeAutoRemoveImport";
    public static final String DO_PDE_AUTO_REMOVE_IMPORT = "org.eclipse.ajdt.ui.preferences.doPdeAutoRemoveImport";
    public static final String VALUE_ERROR = "error";
    public static final String VALUE_WARNING = "warning";
    public static final String VALUE_IGNORE = "ignore";
    public static final String VALUE_ENABLED = "enabled";
    public static final String VALUE_DISABLED = "disabled";
    public static final String OPTION_UseProjectSettings = "org.eclipse.ajdt.core.compiler.useProjectSettings";
    public static final String OPTION_ReportInvalidAbsoluteTypeName = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public static final String OPTION_ReportInvalidWildcardTypeName = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public static final String OPTION_ReportUnresolvableMember = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public static final String OPTION_ReportTypeNotExposedToWeaver = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public static final String OPTION_ReportShadowNotInStructure = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public static final String OPTION_ReportUnmatchedSuperTypeInCall = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public static final String OPTION_ReportCannotImplementLazyTJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public static final String OPTION_ReportNeedSerialVersionUIDField = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public static final String OPTION_ReportIncompatibleSerialVersion = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public static final String OPTION_ReportNoInterfaceCtorJoinpoint = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public static final String OPTION_noJoinpointsForBridgeMethods = "org.aspectj.ajdt.core.compiler.lint.noJoinpointsForBridgeMethods";
    public static final String OPTION_cantMatchArrayTypeOnVarargs = "org.aspectj.ajdt.core.compiler.lint.cantMatchArrayTypeOnVarargs";
    public static final String OPTION_enumAsTargetForDecpIgnored = "org.aspectj.ajdt.core.compiler.lint.enumAsTargetForDecpIgnored";
    public static final String OPTION_annotationAsTargetForDecpIgnored = "org.aspectj.ajdt.core.compiler.lint.annotationAsTargetForDecpIgnored";
    public static final String OPTION_adviceDidNotMatch = "org.aspectj.ajdt.core.compiler.lint.adviceDidNotMatch";
    public static final String OPTION_invalidTargetForAnnotation = "org.aspectj.ajdt.core.compiler.lint.invalidTargetForAnnotation";
    public static final String OPTION_elementAlreadyAnnotated = "org.aspectj.ajdt.core.compiler.lint.elementAlreadyAnnotated";
    public static final String OPTION_runtimeExceptionNotSoftened = "org.aspectj.ajdt.core.compiler.lint.runtimeExceptionNotSoftened";
    public static final String OPTION_NoWeave = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public static final String OPTION_XSerializableAspects = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public static final String OPTION_XLazyThisJoinPoint = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public static final String OPTION_XNoInline = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public static final String OPTION_XReweavable = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    public static final String OPTION_XReweavableCompress = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    public static final String OPTION_Incremental = "org.aspectj.ajdt.core.compiler.BuildOptions.incrementalMode";
    public static final String OPTION_BuildASM = "org.aspectj.ajdt.core.compiler.BuildOptions.buildAsm";
    public static final String OPTION_WeaveMessages = "org.aspectj.ajdt.core.compiler.BuildOptions.showweavemessages";
    private static String[][] lintKeysName;
    private static String XlintProperties;
    public static final String AJDOC_COMMAND = "ajdocCommand";
    private static boolean isShowing;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;

    static {
        Factory factory = new Factory("AspectJPreferences.java", Class.forName("org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 278);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setUsingProjectSettings-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:boolean:boolean:-project:isUsingProjectSettings:overwriteExistingProjectSettings:--void-"), 262);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-java.lang.NumberFormatException-<missing>-"), 631);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-fromContentKind-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-java.lang.String:-cKinds:--java.lang.String-"), 623);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-java.lang.NumberFormatException-<missing>-"), 651);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-fromEntryKind-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-java.lang.String:-eKinds:--java.lang.String-"), 637);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 735);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setProjectAspectPath-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.lang.String:java.lang.String:java.lang.String:-project:path:cKinds:eKinds:--void-"), 694);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 818);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setProjectInPath-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.lang.String:java.lang.String:java.lang.String:-project:path:cKinds:eKinds:--void-"), 777);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-java.io.IOException-<missing>-"), 299);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-writeLintOptionsFile-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.io.File:-thisProject:optsFile:--void-"), 284);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 550);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setActiveBuildConfigurationName-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.lang.String:-project:configName:--void-"), 540);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 564);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setCompilerOptions-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.lang.String:-project:value:--void-"), 555);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 592);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setProjectOutJar-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.lang.String:-project:value:--void-"), 583);
        lintKeysName = new String[][]{{OPTION_ReportInvalidAbsoluteTypeName, "invalidAbsoluteTypeName"}, {OPTION_ReportInvalidWildcardTypeName, "invalidWildcardTypeName"}, {OPTION_ReportUnresolvableMember, "unresolvableMember"}, {OPTION_ReportTypeNotExposedToWeaver, "typeNotExposedToWeaver"}, {OPTION_ReportShadowNotInStructure, "shadowNotInStructure"}, {OPTION_ReportUnmatchedSuperTypeInCall, "unmatchedSuperTypeInCall"}, {OPTION_ReportCannotImplementLazyTJP, "canNotImplementLazyTjp"}, {OPTION_ReportNeedSerialVersionUIDField, "needsSerialVersionUIDField"}, {OPTION_ReportIncompatibleSerialVersion, "brokeSerialVersionCompatibility"}, {OPTION_ReportNoInterfaceCtorJoinpoint, "noInterfaceCtorJoinpoint"}, {OPTION_noJoinpointsForBridgeMethods, "noJoinpointsForBridgeMethods"}, {OPTION_cantMatchArrayTypeOnVarargs, "cantMatchArrayTypeOnVarargs"}, {OPTION_enumAsTargetForDecpIgnored, "enumAsTargetForDecpIgnored"}, {OPTION_annotationAsTargetForDecpIgnored, "annotationAsTargetForDecpIgnored"}, {OPTION_adviceDidNotMatch, "adviceDidNotMatch"}, {OPTION_invalidTargetForAnnotation, "invalidTargetForAnnotation"}, {OPTION_elementAlreadyAnnotated, "elementAlreadyAnnotated"}, {OPTION_runtimeExceptionNotSoftened, "runtimeExceptionNotSoftened"}};
        XlintProperties = "Xlint.properties";
        isShowing = false;
    }

    public static String getFileExt() {
        boolean javaOrAjExt = AspectJPreferences.getJavaOrAjExt();
        return javaOrAjExt ? ".java" : ".aj";
    }

    private static boolean getJavaOrAjExt() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(JAVA_OR_AJ_EXT);
    }

    public static String getLintOptions(IProject thisProject) {
        File optsFile = AspectJUIPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        AspectJPreferences.writeLintOptionsFile(thisProject, optsFile);
        return " -Xlintfile \"" + optsFile + "\" ";
    }

    public static boolean getShowWeaveMessagesOption(IProject thisProject) {
        return AspectJPreferences.getBooleanPrefValue(thisProject, OPTION_WeaveMessages);
    }

    public static boolean getBuildASMOption(IProject thisProject) {
        return AspectJPreferences.getBooleanPrefValue(thisProject, OPTION_BuildASM);
    }

    public static boolean getIncrementalOption(IProject thisProject) {
        return AspectJPreferences.getBooleanPrefValue(thisProject, OPTION_Incremental);
    }

    public static boolean isUsingProjectSettings(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
        if (projectNode == null) {
            return false;
        }
        return projectNode.getBoolean(OPTION_UseProjectSettings, false);
    }

    public static void setUsingProjectSettings(IProject project, boolean isUsingProjectSettings) {
        AspectJPreferences.setUsingProjectSettings(project, isUsingProjectSettings, true);
    }

    public static void setUsingProjectSettings(IProject project, boolean isUsingProjectSettings, boolean overwriteExistingProjectSettings) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
        if (isUsingProjectSettings) {
            projectNode.putBoolean(OPTION_UseProjectSettings, true);
            if (overwriteExistingProjectSettings) {
                CompilerPropertyPage.setDefaults(projectNode);
            } else {
                CompilerPropertyPage.setDefaultsIfValueNotAlreadySet(projectNode);
            }
        } else {
            projectNode.remove(OPTION_UseProjectSettings);
            CompilerPropertyPage.removeValues(projectNode);
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            BackingStoreException backingStoreException2 = backingStoreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(backingStoreException2, ajc$tjp_0, ajc$tjp_1);
        }
    }

    private static void writeLintOptionsFile(IProject thisProject, File optsFile) {
        try {
            FileWriter writer = new FileWriter(optsFile);
            int i = 0;
            while (i < lintKeysName.length) {
                String value = AspectJPreferences.getStringPrefValue(thisProject, lintKeysName[i][0]);
                if (value.equals("")) {
                    value = VALUE_WARNING;
                }
                writer.write(String.valueOf(lintKeysName[i][1]) + " = " + value);
                writer.write(System.getProperty("line.separator"));
                ++i;
            }
            writer.close();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_2, ajc$tjp_3);
        }
    }

    public static String getAdvancedOptions(IProject project) {
        String opts = " ";
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_NoWeave)) {
            opts = String.valueOf(opts) + "-XnoWeave ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XSerializableAspects)) {
            opts = String.valueOf(opts) + "-XserializableAspects ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XLazyThisJoinPoint)) {
            opts = String.valueOf(opts) + "-XlazyTjp ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XNoInline)) {
            opts = String.valueOf(opts) + "-XnoInline ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XReweavable)) {
            opts = String.valueOf(opts) + "-Xreweavable ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XReweavableCompress)) {
            opts = String.valueOf(opts) + "-Xreweavable:compress ";
        }
        return opts;
    }

    public static boolean isAspectJOutlineEnabled() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASPECTJ_OUTLINE);
    }

    public static boolean isAdviceDecoratorActive() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ADVICE_DECORATOR);
    }

    public static boolean isAutobuildSuppressed() {
        return false;
    }

    public static void setAJDTPrefConfigDone(boolean done, String version) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(AJDT_PREF_CONFIG_DONE, done);
        store.setValue(PREF_RUN_FOR_AJDT_VERSION, version);
    }

    public static boolean isAJDTPrefConfigDone(String version) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String prefsAJDTVersion = store.getString(PREF_RUN_FOR_AJDT_VERSION);
        return version.equals(prefsAJDTVersion) ? store.getBoolean(AJDT_PREF_CONFIG_DONE) : false;
    }

    public static boolean isAJDTPrefConfigShowing() {
        return isShowing;
    }

    public static boolean isAutoBuilderMigrationEnabled() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PERFORM_AUTO_BUILDER_MIGRATION);
    }

    public static void setAutoBuilderMigrationEnabled(boolean enabled) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PERFORM_AUTO_BUILDER_MIGRATION, enabled);
    }

    public static boolean isAutoBuilderMigrationSetToRemoveOldBuilder() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(AUTO_BUILDER_MIGRATION_SETTING);
    }

    public static void setAutoBuilderMigrationRemoveOldBuilder(boolean remove) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(AUTO_BUILDER_MIGRATION_SETTING, remove);
    }

    public static void setAJDTPrefConfigShowing(boolean showing) {
        isShowing = showing;
    }

    public static void setAskPDEAutoImport(boolean ask) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(ASK_PDE_AUTO_IMPORT, ask);
    }

    public static boolean askPDEAutoImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASK_PDE_AUTO_IMPORT);
    }

    public static void setPDEAutoImportConfigDone(boolean done) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PDE_AUTO_IMPORT_CONFIG_DONE, done);
    }

    public static boolean isPDEAutoImportConfigDone() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PDE_AUTO_IMPORT_CONFIG_DONE);
    }

    public static void setDoPDEAutoImport(boolean doImport) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(DO_PDE_AUTO_IMPORT, doImport);
    }

    public static boolean doPDEAutoImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DO_PDE_AUTO_IMPORT);
    }

    public static void setAskPDEAutoRemoveImport(boolean ask) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(ASK_PDE_AUTO_REMOVE_IMPORT, ask);
    }

    public static boolean askPDEAutoRemoveImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASK_PDE_AUTO_REMOVE_IMPORT);
    }

    public static void setPDEAutoRemoveImportConfigDone(boolean done) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PDE_AUTO_REMOVE_IMPORT_CONFIG_DONE, done);
    }

    public static boolean isPDEAutoRemoveImportConfigDone() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PDE_AUTO_REMOVE_IMPORT_CONFIG_DONE);
    }

    public static void setDoPDEAutoRemoveImport(boolean doImport) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(DO_PDE_AUTO_REMOVE_IMPORT, doImport);
    }

    public static boolean doPDEAutoRemoveImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DO_PDE_AUTO_REMOVE_IMPORT);
    }

    public static String getActiveBuildConfigurationName(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        return projectNode.get(ACTIVE_CONFIG, "");
    }

    public static void setActiveBuildConfigurationName(IProject project, String configName) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        projectNode.put(ACTIVE_CONFIG, configName);
        if (configName.equals(BuildConfiguration.STANDARD_BUILD_CONFIGURATION_FILE)) {
            projectNode.remove(ACTIVE_CONFIG);
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            BackingStoreException backingStoreException2 = backingStoreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(backingStoreException2, ajc$tjp_4, ajc$tjp_5);
        }
    }

    public static void setCompilerOptions(IProject project, String value) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        projectNode.put(COMPILER_OPTIONS, value);
        if (value.length() == 0) {
            projectNode.remove(COMPILER_OPTIONS);
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            BackingStoreException backingStoreException2 = backingStoreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(backingStoreException2, ajc$tjp_6, ajc$tjp_7);
        }
    }

    public static String getCompilerOptions(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
        return projectNode.get(COMPILER_OPTIONS, "");
    }

    public static String getProjectOutJar(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        return projectNode.get(OUT_JAR, "");
    }

    public static void setProjectOutJar(IProject project, String value) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        projectNode.put(OUT_JAR, value);
        if (value.length() == 0) {
            projectNode.remove(OUT_JAR);
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            BackingStoreException backingStoreException2 = backingStoreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(backingStoreException2, ajc$tjp_8, ajc$tjp_9);
        }
    }

    private static String toContentKind(String contentStr) {
        int content = 0;
        if (contentStr.equals("SOURCE")) {
            content = 1;
        } else if (contentStr.equals("BINARY")) {
            content = 2;
        }
        return new Integer(content).toString();
    }

    private static String toEntryKind(String entryStr) {
        int entry = 0;
        if (entryStr.equals("SOURCE")) {
            entry = 3;
        } else if (entryStr.equals("LIBRARY")) {
            entry = 1;
        } else if (entryStr.equals("PROJECT")) {
            entry = 2;
        } else if (entryStr.equals("VARIABLE")) {
            entry = 4;
        } else if (entryStr.equals("CONTAINER")) {
            entry = 5;
        }
        return new Integer(entry).toString();
    }

    private static String fromContentKind(String cKinds) {
        String contentStr = "unknown";
        try {
            int content = Integer.parseInt(cKinds);
            if (content == 1) {
                contentStr = "SOURCE";
            } else if (content == 2) {
                contentStr = "BINARY";
            }
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = numberFormatException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(numberFormatException2, ajc$tjp_10, ajc$tjp_11);
        }
        return contentStr;
    }

    private static String fromEntryKind(String eKinds) {
        String entryStr = "unknown";
        try {
            int entry = Integer.parseInt(eKinds);
            if (entry == 3) {
                entryStr = "SOURCE";
            } else if (entry == 1) {
                entryStr = "LIBRARY";
            } else if (entry == 2) {
                entryStr = "PROJECT";
            } else if (entry == 4) {
                entryStr = "VARIABLE";
            } else if (entry == 5) {
                entryStr = "CONTAINER";
            }
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = numberFormatException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(numberFormatException2, ajc$tjp_12, ajc$tjp_13);
        }
        return entryStr;
    }

    public static String[] getProjectAspectPath(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        String pathString = "";
        int index = 1;
        String value = projectNode.get(ASPECTPATH + index, "");
        while (value.length() > 0) {
            pathString = String.valueOf(pathString) + value;
            pathString = String.valueOf(pathString) + File.pathSeparator;
            value = projectNode.get(ASPECTPATH + ++index, "");
        }
        String contentString = "";
        index = 1;
        value = projectNode.get(ASPECTPATH_CON_KINDS + index, "");
        while (value.length() > 0) {
            contentString = String.valueOf(contentString) + AspectJPreferences.toContentKind(value.toUpperCase());
            contentString = String.valueOf(contentString) + File.pathSeparator;
            value = projectNode.get(ASPECTPATH_CON_KINDS + ++index, "");
        }
        String entryString = "";
        index = 1;
        value = projectNode.get(ASPECTPATH_ENT_KINDS + index, "");
        while (value.length() > 0) {
            entryString = String.valueOf(entryString) + AspectJPreferences.toEntryKind(value.toUpperCase());
            entryString = String.valueOf(entryString) + File.pathSeparator;
            value = projectNode.get(ASPECTPATH_ENT_KINDS + ++index, "");
        }
        return new String[]{pathString, contentString, entryString};
    }

    public static void setProjectAspectPath(IProject project, String path, String cKinds, String eKinds) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        int index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(ASPECTPATH + index, tok.nextToken());
            ++index;
        }
        while (projectNode.get(ASPECTPATH + index, "").length() > 0) {
            projectNode.remove(ASPECTPATH + index);
            ++index;
        }
        tok = new StringTokenizer(cKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(ASPECTPATH_CON_KINDS + index, AspectJPreferences.fromContentKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(ASPECTPATH_CON_KINDS + index, "").length() > 0) {
            projectNode.remove(ASPECTPATH_CON_KINDS + index);
            ++index;
        }
        tok = new StringTokenizer(eKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(ASPECTPATH_ENT_KINDS + index, AspectJPreferences.fromEntryKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(ASPECTPATH_ENT_KINDS + index, "").length() > 0) {
            projectNode.remove(ASPECTPATH_ENT_KINDS + index);
            ++index;
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            BackingStoreException backingStoreException2 = backingStoreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(backingStoreException2, ajc$tjp_14, ajc$tjp_15);
        }
    }

    public static String[] getProjectInPath(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        String pathString = "";
        int index = 1;
        String value = projectNode.get(INPATH + index, "");
        while (value.length() > 0) {
            pathString = String.valueOf(pathString) + value;
            pathString = String.valueOf(pathString) + File.pathSeparator;
            value = projectNode.get(INPATH + ++index, "");
        }
        String contentString = "";
        index = 1;
        value = projectNode.get(INPATH_CON_KINDS + index, "");
        while (value.length() > 0) {
            contentString = String.valueOf(contentString) + AspectJPreferences.toContentKind(value.toUpperCase());
            contentString = String.valueOf(contentString) + File.pathSeparator;
            value = projectNode.get(INPATH_CON_KINDS + ++index, "");
        }
        String entryString = "";
        index = 1;
        value = projectNode.get(INPATH_ENT_KINDS + index, "");
        while (value.length() > 0) {
            entryString = String.valueOf(entryString) + AspectJPreferences.toEntryKind(value.toUpperCase());
            entryString = String.valueOf(entryString) + File.pathSeparator;
            value = projectNode.get(INPATH_ENT_KINDS + ++index, "");
        }
        return new String[]{pathString, contentString, entryString};
    }

    public static void setProjectInPath(IProject project, String path, String cKinds, String eKinds) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        int index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(INPATH + index, tok.nextToken());
            ++index;
        }
        while (projectNode.get(INPATH + index, "").length() > 0) {
            projectNode.remove(INPATH + index);
            ++index;
        }
        tok = new StringTokenizer(cKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(INPATH_CON_KINDS + index, AspectJPreferences.fromContentKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(INPATH_CON_KINDS + index, "").length() > 0) {
            projectNode.remove(INPATH_CON_KINDS + index);
            ++index;
        }
        tok = new StringTokenizer(eKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(INPATH_ENT_KINDS + index, AspectJPreferences.fromEntryKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(INPATH_ENT_KINDS + index, "").length() > 0) {
            projectNode.remove(INPATH_ENT_KINDS + index);
            ++index;
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            BackingStoreException backingStoreException2 = backingStoreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(backingStoreException2, ajc$tjp_16, ajc$tjp_17);
        }
    }

    public static String getStringPrefValue(IProject project, String key) {
        if (AspectJPreferences.isUsingProjectSettings(project)) {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
            String v = projectNode.get(key, "");
            return v;
        }
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getString(key);
    }

    private static boolean getBooleanPrefValue(IProject project, String key) {
        if (AspectJPreferences.isUsingProjectSettings(project)) {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
            boolean v = projectNode.getBoolean(key, false);
            return v;
        }
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(key);
    }
}

