/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.wizards.InPathBlock;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class InPathPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private IProject thisProject;
    protected InPathBlock fInPathBlock;
    private static final String PAGE_SETTINGS = "InPathPropertyPage";
    private static final String INDEX = "pageIndex";
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    /*
     * WARNING - void declaration
     */
    protected Control createContents(Composite composite) {
        void parent;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$1$ce66e616(this);
        this.noDefaultAndApplyButton();
        this.thisProject = this.getProject();
        Control result = this.thisProject == null || !AspectJPlugin.isAJProject((IProject)this.thisProject) ? this.createWithoutJava((Composite)parent) : (!this.thisProject.isOpen() ? this.createForClosedProject((Composite)parent) : this.createWithJava((Composite)parent, this.thisProject));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            IJavaElement elem;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassNotFoundException classNotFoundException2 = classNotFoundException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                }
            }
            if ((elem = (IJavaElement)adaptable.getAdapter((Class)clazz)) instanceof IJavaProject) {
                return ((IJavaProject)elem).getProject();
            }
        }
        return null;
    }

    private Control createWithoutJava(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString((String)"BuildPathsPropertyPage.no_java_project.message"));
        this.fInPathBlock = null;
        this.setValid(true);
        return label;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString((String)"BuildPathsPropertyPage.closed_project.message"));
        this.fInPathBlock = null;
        this.setValid(true);
        return label;
    }

    protected Control createWithJava(Composite parent, IProject project) {
        this.fInPathBlock = new InPathBlock(this, this.getSettings().getInt(INDEX));
        IClasspathEntry[] initalInpath = null;
        try {
            initalInpath = this.getInitialInpathValue(project);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("InPathProp.exceptionInitializingInpath.title"), AspectJUIPlugin.getResourceString("InPathProp.exceptionInitializingInpath.message"), ce);
        }
        this.fInPathBlock.init(JavaCore.create((IProject)project), null, initalInpath);
        return this.fInPathBlock.createControl(parent);
    }

    private IClasspathEntry[] getInitialInpathValue(IProject project) throws CoreException {
        ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>();
        String[] v = AspectJPreferences.getProjectInPath(project);
        if (v == null) {
            return null;
        }
        String paths = v[0];
        String cKinds = v[1];
        String eKinds = v[2];
        if (paths != null && paths.length() > 0 && cKinds != null && cKinds.length() > 0 && eKinds != null && eKinds.length() > 0) {
            StringTokenizer sTokPaths = new StringTokenizer(paths, File.pathSeparator);
            StringTokenizer sTokCKinds = new StringTokenizer(cKinds, File.pathSeparator);
            StringTokenizer sTokEKinds = new StringTokenizer(eKinds, File.pathSeparator);
            if (sTokPaths.countTokens() == sTokCKinds.countTokens() && sTokPaths.countTokens() == sTokEKinds.countTokens()) {
                while (sTokPaths.hasMoreTokens()) {
                    ClasspathEntry entry = new ClasspathEntry(Integer.parseInt(sTokCKinds.nextToken()), Integer.parseInt(sTokEKinds.nextToken()), (IPath)new Path(sTokPaths.nextToken()), new IPath[0], new IPath[0], null, null, null, false);
                    result.add(entry);
                }
            }
        }
        if (result.size() > 0) {
            return result.toArray(new IClasspathEntry[0]);
        }
        return null;
    }

    protected IDialogSettings getSettings() {
        IDialogSettings pathSettings = AspectJUIPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = pathSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = pathSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 1);
        }
        return pageSettings;
    }

    public boolean performOk() {
        boolean bl;
        block6: {
            if (this.fInPathBlock != null) {
                Shell shell = this.getControl().getShell();
                IRunnableWithProgress runnable = new IRunnableWithProgress(){
                    private static final JoinPoint.StaticPart ajc$tjp_0;
                    private static final JoinPoint.StaticPart ajc$tjp_1;

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            InPathPropertyPage.this.fInPathBlock.configureJavaProject(monitor);
                        }
                        catch (CoreException coreException) {
                            CoreException coreException2 = coreException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
                            CoreException e = coreException2;
                            throw new InvocationTargetException(e);
                        }
                    }

                    static {
                        Factory factory = new Factory("InPathPropertyPage.java", Class.forName("org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage$1"));
                        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage$1-org.eclipse.core.runtime.CoreException-e-"), 229);
                        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage$1-org.eclipse.core.runtime.IProgressMonitor:-monitor:-java.lang.reflect.InvocationTargetException:java.lang.InterruptedException:-void-"), 228);
                    }
                };
                WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
                try {
                    new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
                    PreferencesMessages.getString((String)"BuildPathsPropertyPage.error.title");
                    PreferencesMessages.getString((String)"BuildPathsPropertyPage.error.message");
                    bl = false;
                    break block6;
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_6, ajc$tjp_5);
                    bl = false;
                    break block6;
                }
            }
            bl = true;
        }
        if (!PreferencePageBuilder.ajc$cflowStack$0.isValid()) {
            PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$8$d61cf77c(this);
        }
        if (PreferencePageBuilder.ajc$cflowStack$1.isValid()) {
            PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$9$a1481a1f(this);
        }
        return bl;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.build_path_property_page_context");
    }

    public IProject getThisProject() {
        return this.thisProject;
    }

    public void dispose() {
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$2$24dea784(this);
        super.dispose();
    }

    static {
        Factory factory = new Factory("InPathPropertyPage.java", Class.forName("org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage-java.lang.ClassNotFoundException-<missing>-"), 92);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getProject-org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage----org.eclipse.core.resources.IProject-"), 89);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage-org.eclipse.core.runtime.CoreException-ce-"), 145);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-createWithJava-org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage-org.eclipse.swt.widgets.Composite:org.eclipse.core.resources.IProject:-parent:project:--org.eclipse.swt.widgets.Control-"), 136);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage-java.lang.reflect.InvocationTargetException-<missing>-"), 237);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-performOk-org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage----boolean-"), 223);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.InPathPropertyPage-java.lang.InterruptedException-<missing>-"), 242);
    }
}

