/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.wizards.AspectPathLibrariesWorkbookPage;
import org.eclipse.ajdt.internal.ui.wizards.TabFolderLayout;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDisposer;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathOrderingWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceContainerWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class AspectPathBlock
implements PreferencePageBuilder.AJDTPathBlockPage {
    private IWorkspaceRoot fWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
    private ListDialogField fAspectPathList;
    private StatusInfo fAspectPathStatus;
    private StatusInfo fOutputFolderStatus;
    private StatusInfo fBuildPathStatus;
    private IJavaProject fCurrJProject;
    private IPath fOutputLocationPath;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private int fPageIndex;
    private SourceContainerWorkbookPage fSourceContainerPage;
    private AspectPathLibrariesWorkbookPage fLibrariesPage;
    private BuildPathBasePage fCurrPage;
    private List existingAspectPath;

    public AspectPathBlock(IStatusChangeListener context, int pageToShow) {
        this.fContext = context;
        this.fPageIndex = pageToShow;
        this.fSourceContainerPage = null;
        this.fLibrariesPage = null;
        this.fCurrPage = null;
        AspectPathAdapter adapter = new AspectPathAdapter();
        String[] buttonLabels = new String[]{AspectJUIPlugin.getResourceString("InPathBlock.order.up.button"), AspectJUIPlugin.getResourceString("InPathBlock.order.down.button")};
        this.fAspectPathList = new ListDialogField(null, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fAspectPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fAspectPathList.setLabelText(AspectJUIPlugin.getResourceString("AspectPathBlock.aspectpath.label"));
        this.fAspectPathList.setUpButtonIndex(0);
        this.fAspectPathList.setDownButtonIndex(1);
        this.fBuildPathStatus = new StatusInfo();
        this.fAspectPathStatus = new StatusInfo();
        this.fOutputFolderStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fAspectPathList) {
            this.updateAspectPathStatus();
        }
        this.doStatusLineUpdate();
    }

    public void init(IJavaProject jproject, IPath outputLocation, IClasspathEntry[] aspectpathEntries) {
        this.fCurrJProject = jproject;
        this.existingAspectPath = null;
        if (outputLocation == null) {
            outputLocation = this.getDefaultBuildPath(jproject);
        }
        if (aspectpathEntries != null) {
            this.existingAspectPath = this.getExistingEntries(aspectpathEntries);
        }
        if (this.existingAspectPath == null) {
            this.existingAspectPath = new ArrayList();
        }
        this.fOutputLocationPath = new Path(outputLocation.makeRelative().toString()).makeAbsolute();
        List list = this.existingAspectPath;
        ListDialogField listDialogField = this.fAspectPathList;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$7$5dca5dc3(listDialogField, list, this);
        listDialogField.setElements((Collection)list);
        if (this.fLibrariesPage != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        this.doStatusLineUpdate();
    }

    public void updateAspectPathStatus() {
        this.fAspectPathStatus.setOK();
        List elements = this.fAspectPathList.getElements();
        CPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fAspectPathStatus.setWarning(AspectJUIPlugin.getResourceString("AspectPathBlock.warning.EntryMissing"));
            } else {
                this.fAspectPathStatus.setWarning(AspectJUIPlugin.getResourceString("AspectPathBlock.warning.EntriesMissing"));
            }
        }
        this.updateBuildPathStatus();
    }

    private void doStatusLineUpdate() {
        IStatus res = this.findMostSevereStatus();
        this.fContext.statusChanged(res);
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
    }

    private IPath getDefaultBuildPath(IJavaProject jproj) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects")) {
            String outputLocationName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            return jproj.getProject().getFullPath().append(outputLocationName);
        }
        return jproj.getProject().getFullPath();
    }

    private ArrayList getExistingEntries(IClasspathEntry[] aspectpathEntries) {
        ArrayList<CPListElement> newAspectPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < aspectpathEntries.length) {
            IClasspathEntry curr = aspectpathEntries[i];
            newAspectPath.add(CPListElement.createFromExisting((IClasspathEntry)curr, (IJavaProject)this.fCurrJProject));
            ++i;
        }
        return newAspectPath;
    }

    private void updateBuildPathStatus() {
        List elements = this.fAspectPathList.getElements();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            --i;
        }
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])entries, (IPath)this.fOutputLocationPath);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fAspectPathStatus, this.fOutputFolderStatus, this.fBuildPathStatus});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(AspectJUIPlugin.getResourceString("AspectPathBlock.operationdesc_java"));
        monitor.beginTask("", 10);
        try {
            this.internalConfigureJavaProject(this.fAspectPathList.getElements(), monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }

    protected void internalConfigureJavaProject(List aspectPathEntries, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int nEntries = aspectPathEntries.size();
        IClasspathEntry[] aspectpath = new IClasspathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            CPListElement entry = (CPListElement)aspectPathEntries.get(i);
            aspectpath[i] = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry.getClasspathEntry());
            ++i;
        }
        monitor.worked(2);
        StringBuffer aspectpathBuffer = new StringBuffer();
        StringBuffer contentKindBuffer = new StringBuffer();
        StringBuffer entryKindBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < aspectpath.length) {
            aspectpathBuffer.append(aspectpath[i2].getPath());
            aspectpathBuffer.append(File.pathSeparator);
            contentKindBuffer.append(aspectpath[i2].getContentKind());
            contentKindBuffer.append(File.pathSeparator);
            entryKindBuffer.append(aspectpath[i2].getEntryKind());
            entryKindBuffer.append(File.pathSeparator);
            ++i2;
        }
        aspectpathBuffer = this.removeFinalPathSeparatorChar(aspectpathBuffer);
        contentKindBuffer = this.removeFinalPathSeparatorChar(contentKindBuffer);
        entryKindBuffer = this.removeFinalPathSeparatorChar(entryKindBuffer);
        AspectJPreferences.setProjectAspectPath(this.fCurrJProject.getProject(), aspectpathBuffer.toString(), contentKindBuffer.toString(), entryKindBuffer.toString());
        LaunchConfigurationManagementUtils.updateAspectPaths(this.fCurrJProject, this.existingAspectPath, aspectPathEntries);
    }

    private StringBuffer removeFinalPathSeparatorChar(StringBuffer buffer) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == File.pathSeparatorChar) {
            buffer = buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        IWorkbench workbench = AspectJUIPlugin.getDefault().getWorkbench();
        workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fLibrariesPage = new AspectPathLibrariesWorkbookPage(this.fWorkspaceRoot, this.fAspectPathList);
        TabItem item = new TabItem(folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("AspectPathBlock.tab.libraries"));
        item.setImage(imageRegistry.get("org.eclipse.jdt.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        ClasspathOrderingWorkbookPage ordpage = new ClasspathOrderingWorkbookPage(this.fAspectPathList);
        item = new TabItem(folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("InPathBlock.tab.inpath.order"));
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrJProject != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AspectPathBlock.this.tabChanged(e.item);
            }
        });
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.build_paths_context");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private class AspectPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        AspectPathAdapter() {
        }

        public void changeControlPressed(DialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            AspectPathBlock.this.buildPathDialogFieldChanged(field);
        }
    }
}

