/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerMessages;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AJJarPackagerUtil {
    static final String JAR_EXTENSION = "jar";
    static final String DESCRIPTION_EXTENSION = "jardesc";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    public static boolean askToCreateDirectory(Shell parent, File directory) {
        if (parent == null) {
            return false;
        }
        return AJJarPackagerUtil.queryDialog(parent, AJJarPackagerMessages.getString("JarPackage.confirmCreate.title"), AJJarPackagerMessages.getFormattedString("JarPackage.confirmCreate.message", directory.toString()));
    }

    public static List asResources(Object[] fSelectedElements) {
        if (fSelectedElements == null) {
            return null;
        }
        ArrayList<Object> selectedResources = new ArrayList<Object>(fSelectedElements.length);
        int i = 0;
        while (i < fSelectedElements.length) {
            Object element = fSelectedElements[i];
            if (element instanceof IJavaElement) {
                selectedResources.add(((IJavaElement)element).getResource());
            } else if (element instanceof IResource) {
                selectedResources.add(element);
            }
            ++i;
        }
        return selectedResources;
    }

    public static boolean askForOverwritePermission(Shell parent, String filePath) {
        if (parent == null) {
            return false;
        }
        return AJJarPackagerUtil.queryDialog(parent, AJJarPackagerMessages.getString("JarPackage.confirmReplace.title"), AJJarPackagerMessages.getFormattedString("JarPackage.confirmReplace.message", filePath));
    }

    static boolean canOverwrite(Shell parent, IFile file) {
        if (file.isAccessible()) {
            return true;
        }
        return AJJarPackagerUtil.askForOverwritePermission(parent, file.getFullPath().toString());
    }

    static String getMainClassName(JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() == null) {
            return "";
        }
        return jarPackage.getManifestMainClass().getFullyQualifiedName();
    }

    private static boolean queryDialog(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                returnValue[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    public static CoreException createCoreException(String message, Exception ex) {
        if (message == null) {
            message = "";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, message, (Throwable)ex));
    }

    public static boolean isMainClassValid(JarPackageData data, IRunnableContext context) {
        if (data == null) {
            return false;
        }
        IType mainClass = data.getManifestMainClass();
        if (mainClass == null) {
            return true;
        }
        try {
            IFile file = (IFile)mainClass.getResource();
            if (file == null || !AJJarPackagerUtil.contains(AJJarPackagerUtil.asResources(data.getElements()), file)) {
                return false;
            }
            return JavaModelUtil.hasMainMethod((IType)mainClass);
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_0, ajc$tjp_1);
            return false;
        }
    }

    static boolean contains(List resources, IFile file) {
        if (resources == null || file == null) {
            return false;
        }
        if (resources.contains(file)) {
            return true;
        }
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (resource == null || resource.getType() == 1) continue;
            List<IResource> children = null;
            try {
                children = Arrays.asList(((IContainer)resource).members());
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_2, ajc$tjp_3);
                continue;
            }
            if (children == null || !AJJarPackagerUtil.contains(children, file)) continue;
            return true;
        }
        return false;
    }

    static {
        Factory factory = new Factory("AJJarPackagerUtil.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerUtil"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerUtil-org.eclipse.jdt.core.JavaModelException-<missing>-"), 162);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isMainClassValid-org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerUtil-org.eclipse.jdt.ui.jarpackager.JarPackageData:org.eclipse.jface.operation.IRunnableContext:-data:context:--boolean-"), 146);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerUtil-org.eclipse.core.runtime.CoreException-<missing>-"), 181);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-contains-org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerUtil-java.util.List:org.eclipse.core.resources.IFile:-resources:file:--boolean-"), 168);
    }
}

