/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.pde.internal.ui.editor;

import org.eclipse.ajdt.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.ajdt.pde.internal.ui.editor.PDESection;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ui.parts.StructuredViewerPart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerSection
extends PDESection {
    protected StructuredViewerPart viewerPart;

    public StructuredViewerSection(PDEFormPage formPage, Composite parent, int style, String[] buttonLabels) {
        super(formPage, parent, style);
        this.viewerPart = this.createViewerPart(buttonLabels);
        this.viewerPart.setMinimumSize(50, 50);
        FormToolkit toolkit = formPage.getManagedForm().getToolkit();
        this.createClient(this.getSection(), toolkit);
    }

    protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.viewerPart.createControl(parent, style, span, toolkit);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                StructuredViewerSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.viewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = span;
        container.setLayout((Layout)layout);
        return container;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void buttonSelected(int index) {
    }

    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        ISelection selection = this.getViewerSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() > 1) {
            return;
        }
        Object target = ssel.getFirstElement();
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(target, objects);
        }
    }

    public boolean canPaste(Clipboard clipboard) {
        ISelection selection = this.getViewerSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() > 1) {
            return false;
        }
        Object target = ssel.getFirstElement();
        ModelDataTransfer modelTransfer = ModelDataTransfer.getInstance();
        Object[] objects = (Object[])clipboard.getContents((Transfer)modelTransfer);
        if (objects != null && objects.length > 0) {
            return this.canPaste(target, objects);
        }
        return false;
    }

    protected ISelection getViewerSelection() {
        return this.viewerPart.getViewer().getSelection();
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    protected boolean canPaste(Object target, Object[] objects) {
        return false;
    }

    public void setFocus() {
        this.viewerPart.getControl().setFocus();
    }
}

