/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.refactoring.ReaderInputStream;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class RenameFileExtensionsDialog
extends Dialog {
    private IProject project;
    private Button convertAllToJavaButton;
    private Button convertAllToAJButton;
    private Button convertAspectsToAJButton;
    private Button includeFilesNotInBuildButton;
    private Button updateBuildConfigsButton;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;

    public RenameFileExtensionsDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertFileExtensions"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.convertAspectsToAJButton = new Button(composite, 16);
        this.convertAspectsToAJButton.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertAspectsToAJAndClassesToJava"));
        this.convertAspectsToAJButton.setSelection(true);
        this.convertAllToAJButton = new Button(composite, 16);
        this.convertAllToAJButton.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertAllToAJ"));
        this.convertAllToJavaButton = new Button(composite, 16);
        this.convertAllToJavaButton.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertAllToJava"));
        new Label(composite, 0);
        this.includeFilesNotInBuildButton = new Button(composite, 32);
        this.includeFilesNotInBuildButton.setText(AspectJUIPlugin.getResourceString("Refactoring.IncludeFilesNotInBuild"));
        this.includeFilesNotInBuildButton.setSelection(true);
        this.updateBuildConfigsButton = new Button(composite, 32);
        this.updateBuildConfigsButton.setText(AspectJUIPlugin.getResourceString("Refactoring.UpdateBuildConfigs"));
        this.updateBuildConfigsButton.setSelection(true);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        boolean updateBuildConfigs = this.updateBuildConfigsButton.getSelection();
        AspectJUIPlugin.getDefault().disableBuildConfiguratorResourceChangeListener();
        if (this.convertAllToAJButton.getSelection()) {
            this.convertAllExtensions(true, this.includeFilesNotInBuildButton.getSelection(), updateBuildConfigs);
        } else if (this.convertAllToJavaButton.getSelection()) {
            this.convertAllExtensions(false, this.includeFilesNotInBuildButton.getSelection(), updateBuildConfigs);
        } else if (this.convertAspectsToAJButton.getSelection()) {
            this.convertAspectsToAJAndOthersToJava(this.includeFilesNotInBuildButton.getSelection(), updateBuildConfigs);
        }
        super.okPressed();
        AspectJUIPlugin.getDefault().enableBuildConfiguratorResourceChangeListener();
    }

    private void convertAspectsToAJAndOthersToJava(final boolean includeNonBuiltFiles, final boolean updateBuildConfigs) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;

            public void run(IProgressMonitor monitor) {
                Set aspects = StructureModelUtil.getAllAspects(RenameFileExtensionsDialog.this.project, true);
                IJavaProject jp = JavaCore.create((IProject)RenameFileExtensionsDialog.this.project);
                ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(jp);
                BuildConfiguration activeBuildConfig = pbc.getActiveBuildConfiguration();
                int numBuildConfigs = pbc.getBuildConfigurations().size();
                try {
                    IPackageFragment[] packages = jp.getPackageFragments();
                    monitor.beginTask(AspectJUIPlugin.getResourceString("Refactoring.ConvertingFileExtensions"), packages.length + 10 * numBuildConfigs);
                    HashMap oldToNewNames = new HashMap();
                    int i = 0;
                    while (i < packages.length) {
                        if (!packages[i].isReadOnly()) {
                            try {
                                ICompilationUnit[] files = packages[i].getCompilationUnits();
                                int j = 0;
                                while (j < files.length) {
                                    IResource resource = files[j].getResource();
                                    if (includeNonBuiltFiles || activeBuildConfig.isIncluded(resource)) {
                                        boolean isAspect = aspects.contains(resource);
                                        if (!isAspect && !activeBuildConfig.isIncluded(resource)) {
                                            isAspect = RenameFileExtensionsDialog.this.checkIsAspect(resource);
                                        }
                                        if (!isAspect && resource.getFileExtension().equals("aj")) {
                                            RenameFileExtensionsDialog.this.renameFile(false, resource, monitor, oldToNewNames);
                                        } else if (isAspect && resource.getFileExtension().equals("java")) {
                                            RenameFileExtensionsDialog.this.renameFile(true, resource, monitor, oldToNewNames);
                                        }
                                    }
                                    ++j;
                                }
                            }
                            catch (JavaModelException javaModelException) {
                                JavaModelException javaModelException2 = javaModelException;
                                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
                            }
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    if (updateBuildConfigs) {
                        RenameFileExtensionsDialog.this.updateBuildConfigurations(oldToNewNames, RenameFileExtensionsDialog.this.project, monitor);
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException3 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_2, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("RenameFileExtensionsDialog.java", Class.forName("org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1-org.eclipse.jdt.core.JavaModelException-<missing>-"), 226);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 168);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1-org.eclipse.jdt.core.JavaModelException-<missing>-"), 235);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_2, ajc$tjp_1);
        }
    }

    private boolean checkIsAspect(IResource resource) {
        if (resource instanceof IFile) {
            IJavaElement jEl = JavaCore.create((IResource)resource);
            if (jEl instanceof ICompilationUnit) {
                try {
                    IType[] types = ((ICompilationUnit)jEl).getAllTypes();
                    if (types.length == 0) {
                        return true;
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException2 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_3, ajc$tjp_4);
                }
            } else {
                AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit((IFile)resource);
                if (unit != null) {
                    try {
                        IType[] types = unit.getAllTypes();
                        int i = 0;
                        while (i < types.length) {
                            if (types[i] instanceof AspectElement) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        JavaModelException javaModelException3 = javaModelException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, (Object)this, ajc$tjp_5, ajc$tjp_4);
                    }
                }
            }
        }
        return false;
    }

    private void convertAllExtensions(final boolean convertToAJ, final boolean includeNotBuiltFiles, final boolean updateBuildConfigs) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;

            public void run(IProgressMonitor monitor) {
                IJavaProject jp = JavaCore.create((IProject)RenameFileExtensionsDialog.this.project);
                ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(jp);
                BuildConfiguration activeBuildConfig = pbc.getActiveBuildConfiguration();
                int numBuildConfigs = pbc.getBuildConfigurations().size();
                try {
                    IPackageFragment[] packages = jp.getPackageFragments();
                    monitor.beginTask(AspectJUIPlugin.getResourceString("Refactoring.ConvertingFileExtensions"), packages.length + 10 * numBuildConfigs);
                    HashMap oldNamesToNewNames = new HashMap();
                    int i = 0;
                    while (i < packages.length) {
                        if (!packages[i].isReadOnly()) {
                            try {
                                ICompilationUnit[] files = packages[i].getCompilationUnits();
                                int j = 0;
                                while (j < files.length) {
                                    IResource resource = files[j].getResource();
                                    if ((includeNotBuiltFiles || activeBuildConfig.isIncluded(resource)) && (!convertToAJ && resource.getFileExtension().equals("aj") || convertToAJ && resource.getFileExtension().equals("java"))) {
                                        RenameFileExtensionsDialog.this.renameFile(convertToAJ, resource, monitor, oldNamesToNewNames);
                                    }
                                    ++j;
                                }
                            }
                            catch (JavaModelException javaModelException) {
                                JavaModelException javaModelException2 = javaModelException;
                                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
                            }
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    if (updateBuildConfigs) {
                        RenameFileExtensionsDialog.this.updateBuildConfigurations(oldNamesToNewNames, RenameFileExtensionsDialog.this.project, monitor);
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException3 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_2, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("RenameFileExtensionsDialog.java", Class.forName("org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2-org.eclipse.jdt.core.JavaModelException-<missing>-"), 345);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 305);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2-org.eclipse.jdt.core.JavaModelException-<missing>-"), 354);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_6, ajc$tjp_7);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_8, ajc$tjp_7);
        }
    }

    private void renameFile(boolean newExtensionIsAJ, IResource file, IProgressMonitor monitor, Map oldToNewNames) {
        String oldName = file.getName();
        String nameWithoutExtension = oldName.substring(0, oldName.indexOf(46));
        String newExtension = newExtensionIsAJ ? ".aj" : ".java";
        RenameResourceChange change = new RenameResourceChange(file, String.valueOf(nameWithoutExtension) + newExtension);
        try {
            change.perform(monitor);
            oldToNewNames.put(oldName, String.valueOf(nameWithoutExtension) + newExtension);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_9, ajc$tjp_10);
            CoreException e = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("Refactoring.ErrorRenamingResource"), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateBuildConfigurations(Map oldNamesToNewNames, IProject project, IProgressMonitor monitor) {
        pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        buildConfigs = pbc.getConfigurationFiles();
        i = 0;
        while (true) {
            block18: {
                block19: {
                    if (i >= buildConfigs.length) {
                        return;
                    }
                    br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(buildConfigs[i].getContents()));
                    }
                    catch (CoreException v0) {
                        var15_14 = v0;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(var15_14, (Object)this, RenameFileExtensionsDialog.ajc$tjp_11, RenameFileExtensionsDialog.ajc$tjp_12);
                        break block18;
                    }
                    sb = new StringBuffer();
                    try {
                        try {
                            line = br.readLine();
                            block12: while (true) {
                                if (line == null) {
                                    reader = new StringReader(sb.toString());
                                    buildConfigs[i].setContents((InputStream)new ReaderInputStream(reader), true, true, monitor);
                                }
                                iter = oldNamesToNewNames.keySet().iterator();
                                while (true) {
                                    if (!iter.hasNext()) {
                                        sb.append(line);
                                        sb.append(System.getProperty("line.separator"));
                                        line = br.readLine();
                                        continue block12;
                                    }
                                    oldName = (String)iter.next();
                                    newName = (String)oldNamesToNewNames.get(oldName);
                                    line = line.replaceAll(oldName, newName);
                                }
                                break;
                            }
                        }
                        catch (IOException v1) {
                            var16_15 = v1;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(var16_15, (Object)this, RenameFileExtensionsDialog.ajc$tjp_13, RenameFileExtensionsDialog.ajc$tjp_12);
                        }
                        catch (CoreException v2) {
                            var17_16 = v2;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(var17_16, (Object)this, RenameFileExtensionsDialog.ajc$tjp_14, RenameFileExtensionsDialog.ajc$tjp_12);
                        }
                    }
                    catch (Throwable var14_18) {
                        var13_13 = null;
                        monitor.worked(10);
                        try {
                            br.close();
                            throw var14_18;
                        }
                        catch (IOException v3) {
                            var18_17 = v3;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(var18_17, (Object)this, RenameFileExtensionsDialog.ajc$tjp_15, RenameFileExtensionsDialog.ajc$tjp_12);
                        }
                        throw var14_18;
                    }
                    {
                        var13_13 = null;
                    }
                    monitor.worked(10);
                    ** try [egrp 3[TRYBLOCK] [1 : 296->304)] { 
lbl67:
                    // 1 sources

                    br.close();
                    break block19;
lbl69:
                    // 1 sources

                    catch (IOException v4) {
                        var18_17 = v4;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(var18_17, (Object)this, RenameFileExtensionsDialog.ajc$tjp_15, RenameFileExtensionsDialog.ajc$tjp_12);
                    }
                }
                c = pbc.getBuildConfigurations();
                var10_10 = c.iterator();
                while (var10_10.hasNext()) {
                    config = (BuildConfiguration)var10_10.next();
                    config.update(true);
                }
            }
            ++i;
        }
    }

    static {
        Factory factory = new Factory("RenameFileExtensionsDialog.java", Class.forName("org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.reflect.InvocationTargetException-<missing>-"), 244);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-convertAspectsToAJAndOthersToJava-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-boolean:boolean:-includeNonBuiltFiles:updateBuildConfigs:--void-"), 164);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-renameFile-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-boolean:org.eclipse.core.resources.IResource:org.eclipse.core.runtime.IProgressMonitor:java.util.Map:-newExtensionIsAJ:file:monitor:oldToNewNames:--void-"), 381);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-org.eclipse.core.runtime.CoreException-<missing>-"), 411);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateBuildConfigurations-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.util.Map:org.eclipse.core.resources.IProject:org.eclipse.core.runtime.IProgressMonitor:-oldNamesToNewNames:project:monitor:--void-"), 403);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.io.IOException-<missing>-"), 431);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-org.eclipse.core.runtime.CoreException-<missing>-"), 432);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.io.IOException-<missing>-"), 437);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.InterruptedException-<missing>-"), 245);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-org.eclipse.jdt.core.JavaModelException-<missing>-"), 269);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkIsAspect-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-org.eclipse.core.resources.IResource:-resource:--boolean-"), 259);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-org.eclipse.jdt.core.JavaModelException-<missing>-"), 282);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.reflect.InvocationTargetException-<missing>-"), 363);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-convertAllExtensions-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-boolean:boolean:boolean:-convertToAJ:includeNotBuiltFiles:updateBuildConfigs:--void-"), 303);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.InterruptedException-<missing>-"), 364);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-org.eclipse.core.runtime.CoreException-e-"), 390);
    }
}

