/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.visualiser.NodeHolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class StructureModelUtil {
    private static String activeConfigFile;
    private static Hashtable annotationsCache;
    private static Hashtable processedAnnotationsCache;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("StructureModelUtil.java", Class.forName("org.eclipse.ajdt.ui.visualiser.StructureModelUtil"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.visualiser.StructureModelUtil-java.lang.Exception-<missing>-"), 313);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getLinesToAspectMap-org.eclipse.ajdt.ui.visualiser.StructureModelUtil-java.lang.String:boolean:-sourceFilePath:needIndividualNodes:--java.util.Map-"), 187);
        activeConfigFile = "";
        annotationsCache = new Hashtable();
        processedAnnotationsCache = new Hashtable();
    }

    public static Map getLinesToAspectMap(String sourceFilePath) {
        return StructureModelUtil.getLinesToAspectMap(sourceFilePath, false);
    }

    public static Set getAllAspects(IProject project, boolean returnIResources) {
        HashSet<IProgramElement> aspects = new HashSet<IProgramElement>();
        AJModel.initialiseAJDE((IProject)project);
        List packages = StructureModelUtil.getPackagesInModel();
        Iterator iterator = packages.iterator();
        while (iterator.hasNext()) {
            Object[] progNodes = (Object[])iterator.next();
            IProgramElement packageNode = (IProgramElement)progNodes[0];
            List files = StructureModelUtil.getFilesInPackage(packageNode);
            Iterator it = files.iterator();
            block1: while (it.hasNext()) {
                IProgramElement fileNode = (IProgramElement)it.next();
                List children = fileNode.getChildren();
                Iterator iter = children.iterator();
                block2: while (iter.hasNext()) {
                    IProgramElement child = (IProgramElement)iter.next();
                    if (child.getKind().equals(IProgramElement.Kind.ASPECT)) {
                        aspects.add(fileNode);
                        continue block1;
                    }
                    List innerChildren = child.getChildren();
                    Iterator innerIterator = innerChildren.iterator();
                    while (innerIterator.hasNext()) {
                        IProgramElement element = (IProgramElement)innerIterator.next();
                        if (!element.getKind().equals(IProgramElement.Kind.ASPECT)) continue;
                        aspects.add(fileNode);
                        continue block2;
                    }
                }
            }
        }
        if (returnIResources) {
            HashSet<IResource> resources = new HashSet<IResource>();
            Iterator iter = aspects.iterator();
            while (iter.hasNext()) {
                IProgramElement element = (IProgramElement)iter.next();
                String path = element.getSourceLocation().getSourceFile().getAbsolutePath();
                IResource resource = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(path, project);
                if (resource == null) {
                    resource = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(path);
                }
                resources.add(resource);
            }
            aspects = resources;
        }
        return aspects;
    }

    public static void wipeCache() {
        annotationsCache.clear();
        processedAnnotationsCache.clear();
        activeConfigFile = Ajde.getDefault().getConfigurationManager().getActiveConfigFile();
    }

    public static Map getLinesToAspectMap(String sourceFilePath, boolean needIndividualNodes) {
        String cacheKey;
        HashMap aspectMap;
        if (activeConfigFile == null || !activeConfigFile.equals(Ajde.getDefault().getConfigurationManager().getActiveConfigFile())) {
            StructureModelUtil.wipeCache();
        }
        if ((aspectMap = (HashMap)processedAnnotationsCache.get(cacheKey = String.valueOf(sourceFilePath) + (needIndividualNodes ? "T" : "F"))) != null) {
            return aspectMap;
        }
        try {
            Map annotationsMap = null;
            annotationsMap = (Map)annotationsCache.get(sourceFilePath);
            if (annotationsMap == null) {
                annotationsMap = AsmManager.getDefault().getInlineAnnotations(sourceFilePath, true, true);
                if (sourceFilePath != null && annotationsMap != null) {
                    annotationsCache.put(sourceFilePath, annotationsMap);
                }
            }
            aspectMap = new HashMap();
            if (annotationsMap == null) {
                return aspectMap;
            }
            Set keys = annotationsMap.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                List annotations = (List)annotationsMap.get(key);
                Iterator it2 = annotations.iterator();
                while (it2.hasNext()) {
                    IRelationship declares;
                    IRelationship intertypeDecls;
                    IProgramElement node = (IProgramElement)it2.next();
                    IRelationshipMap irm = AsmManager.getDefault().getRelationshipMap();
                    Vector toStore = new Vector();
                    IRelationship advises = irm.get(node, IRelationship.Kind.ADVICE, "advised by", false, false);
                    List toStoreNoRuntimeTest = StructureModelUtil.processTargets(advises, needIndividualNodes, node);
                    toStore.addAll(toStoreNoRuntimeTest);
                    advises = irm.get(node, IRelationship.Kind.ADVICE, "advised by", true, false);
                    List toStoreWithRuntimeTest = StructureModelUtil.processTargets(advises, needIndividualNodes, node);
                    toStore.addAll(toStoreWithRuntimeTest);
                    if (needIndividualNodes) {
                        IRelationship advisesR = irm.get(node, IRelationship.Kind.ADVICE, "advises", false, false);
                        List toStoreNoRuntimeTestR = StructureModelUtil.processTargets(advisesR, needIndividualNodes, node);
                        toStore.addAll(toStoreNoRuntimeTestR);
                        advisesR = irm.get(node, IRelationship.Kind.ADVICE, "advises", true, false);
                        List toStoreWithRuntimeTestR = StructureModelUtil.processTargets(advisesR, needIndividualNodes, node);
                        toStore.addAll(toStoreWithRuntimeTestR);
                    }
                    IRelationship annotated = irm.get(node, IRelationship.Kind.DECLARE_INTER_TYPE, "annotated by", false, false);
                    List toStoreAnnotated = StructureModelUtil.processTargets(annotated, needIndividualNodes, node);
                    toStore.addAll(toStoreAnnotated);
                    if (needIndividualNodes) {
                        IRelationship annotates = irm.get(node, IRelationship.Kind.DECLARE_INTER_TYPE, "annotates", false, false);
                        List toStoreAnnotates = StructureModelUtil.processTargets(annotates, needIndividualNodes, node);
                        toStore.addAll(toStoreAnnotates);
                    }
                    if ((intertypeDecls = irm.get(node, IRelationship.Kind.DECLARE_INTER_TYPE, "aspect declarations", false, false)) != null) {
                        List toStoreIntertypeDecls = StructureModelUtil.processTargets(intertypeDecls, needIndividualNodes, node);
                        toStore.addAll(toStoreIntertypeDecls);
                    }
                    if (needIndividualNodes && (declares = irm.get(node, IRelationship.Kind.DECLARE_INTER_TYPE, "declared on", false, false)) != null) {
                        List toStoreDecls = StructureModelUtil.processTargets(declares, needIndividualNodes, node);
                        toStore.addAll(toStoreDecls);
                    }
                    if (toStore == null || toStore.size() == 0) continue;
                    aspectMap.put(key, toStore);
                }
            }
            processedAnnotationsCache.put(cacheKey, aspectMap);
            return aspectMap;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(exception2, ajc$tjp_0, ajc$tjp_1);
            return null;
        }
    }

    private static List processTargets(IRelationship advises, boolean needIndividualNodes, IProgramElement sourceNode) {
        Vector<NodeHolder> aspectsAndAdvice = new Vector<NodeHolder>();
        if (advises != null) {
            List targets = advises.getTargets();
            Iterator it4 = targets.iterator();
            while (it4.hasNext()) {
                IProgramElement pNode;
                String targetHandle = (String)it4.next();
                if (targetHandle == null || (pNode = AsmManager.getDefault().getHierarchy().findElementForHandle(targetHandle)) == null) continue;
                if (needIndividualNodes && (pNode.getKind() == IProgramElement.Kind.METHOD || pNode.getKind() == IProgramElement.Kind.CODE || pNode.getKind() == IProgramElement.Kind.CONSTRUCTOR || pNode.getKind() == IProgramElement.Kind.ASPECT || pNode.getKind() == IProgramElement.Kind.CLASS || pNode.getKind() == IProgramElement.Kind.FIELD)) {
                    String adviceType = "advises";
                    if (advises.getName().equals("annotates") || advises.getName().equals("declared on")) {
                        adviceType = advises.getName();
                    }
                    if (sourceNode.getExtraInfo() != null) {
                        adviceType = String.valueOf(adviceType) + sourceNode.getExtraInfo().getExtraAdviceInformation();
                    }
                    NodeHolder noddyHolder = new NodeHolder(pNode, advises.hasRuntimeTest(), adviceType);
                    aspectsAndAdvice.add(noddyHolder);
                    continue;
                }
                if (pNode.getKind() == IProgramElement.Kind.ADVICE || StructureModelUtil.isIntertypeKind(pNode.getKind()) || pNode.getKind() == IProgramElement.Kind.FILE_JAVA) {
                    IProgramElement theAspect = null;
                    if (needIndividualNodes) {
                        String adviceType = "";
                        if (pNode.getExtraInfo() != null) {
                            adviceType = pNode.getExtraInfo().getExtraAdviceInformation();
                        }
                        NodeHolder noddyHolder = new NodeHolder(pNode, advises.hasRuntimeTest(), adviceType);
                        aspectsAndAdvice.add(noddyHolder);
                        continue;
                    }
                    theAspect = pNode.getKind() == IProgramElement.Kind.FILE_JAVA ? pNode : pNode.getParent();
                    aspectsAndAdvice.add((NodeHolder)theAspect);
                    continue;
                }
                if (pNode.getKind() == IProgramElement.Kind.DECLARE_ERROR) {
                    aspectsAndAdvice.add((NodeHolder)pNode.getParent());
                    continue;
                }
                if (pNode.getKind() != IProgramElement.Kind.DECLARE_WARNING) continue;
                aspectsAndAdvice.add((NodeHolder)pNode.getParent());
            }
        }
        return aspectsAndAdvice;
    }

    private static boolean isIntertypeKind(IProgramElement.Kind kind) {
        if (kind == IProgramElement.Kind.INTER_TYPE_METHOD) {
            return true;
        }
        if (kind == IProgramElement.Kind.INTER_TYPE_FIELD) {
            return true;
        }
        if (kind == IProgramElement.Kind.INTER_TYPE_PARENT) {
            return true;
        }
        if (kind == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
            return true;
        }
        if (kind == IProgramElement.Kind.DECLARE_PARENTS) {
            return true;
        }
        if (kind == IProgramElement.Kind.DECLARE_ANNOTATION_AT_CONSTRUCTOR) {
            return true;
        }
        if (kind == IProgramElement.Kind.DECLARE_ANNOTATION_AT_FIELD) {
            return true;
        }
        if (kind == IProgramElement.Kind.DECLARE_ANNOTATION_AT_METHOD) {
            return true;
        }
        return kind == IProgramElement.Kind.DECLARE_ANNOTATION_AT_TYPE;
    }

    public static Set getAspectsAffectingPackage(IProgramElement packageNode) {
        List files = StructureModelUtil.getFilesInPackage(packageNode);
        HashSet aspects = new HashSet();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            IProgramElement fileNode = (IProgramElement)it.next();
            Map adviceMap = StructureModelUtil.getLinesToAspectMap(fileNode.getSourceLocation().getSourceFile().getAbsolutePath());
            Collection values = adviceMap.values();
            Iterator it2 = values.iterator();
            while (it2.hasNext()) {
                aspects.add(it2.next());
            }
        }
        return aspects;
    }

    public static List getPackagesInModel() {
        ArrayList<Object[]> packages = new ArrayList<Object[]>();
        IHierarchy model = Ajde.getDefault().getStructureModelManager().getHierarchy();
        if (model.equals(IHierarchy.NO_STRUCTURE)) {
            return null;
        }
        Object[] o = new Object[]{model.getRoot(), "<default>"};
        packages.add(o);
        return StructureModelUtil.getPackagesHelper(model.getRoot(), IProgramElement.Kind.PACKAGE, null, packages);
    }

    private static List getPackagesHelper(IProgramElement node, IProgramElement.Kind kind, String prename, List matches) {
        if (kind == null || node.getKind().equals(kind)) {
            prename = prename == null ? node.toString() : String.valueOf(prename) + "." + node;
            Object[] o = new Object[]{node, prename};
            matches.add(o);
        }
        if (node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement nextNode = (IProgramElement)it.next();
                StructureModelUtil.getPackagesHelper(nextNode, kind, prename, matches);
            }
        }
        return matches;
    }

    private List sortElements(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortingComparator comparator = new SortingComparator();
        Arrays.sort(temp, comparator);
        List<Object> newResources = Arrays.asList(temp);
        return newResources;
    }

    private static List sortArray(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortArrayComparator comparator = new SortArrayComparator();
        Arrays.sort(temp, comparator);
        List<Object> newElements = Arrays.asList(temp);
        return newElements;
    }

    public static List getFilesInPackage(IProgramElement packageNode) {
        if (packageNode == null) {
            return null;
        }
        List packageContents = packageNode.getChildren();
        ArrayList<IProgramElement> files = new ArrayList<IProgramElement>();
        if (packageContents != null) {
            Iterator it = packageContents.iterator();
            while (it.hasNext()) {
                IProgramElement packageItem = (IProgramElement)it.next();
                if (packageItem.getKind() != IProgramElement.Kind.FILE_JAVA && packageItem.getKind() != IProgramElement.Kind.FILE_ASPECTJ) continue;
                files.add(packageItem);
            }
        }
        return files;
    }

    private class SortingComparator
    implements Comparator {
        SortingComparator() {
        }

        public int compare(Object o1, Object o2) {
            IProgramElement p1 = (IProgramElement)o1;
            IProgramElement p2 = (IProgramElement)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }

    private static class SortArrayComparator
    implements Comparator {
        SortArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object[] array1 = (Object[])o1;
            Object[] array2 = (Object[])o2;
            IProgramElement p1 = (IProgramElement)array1[1];
            IProgramElement p2 = (IProgramElement)array2[1];
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }
}

