/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.core.builder.BuildClasspathResolver;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CoreProjectProperties
implements ProjectPropertiesAdapter {
    private String cachedClasspath = null;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    public String getProjectName() {
        return AspectJPlugin.getDefault().getCurrentProject().getName();
    }

    public String getClassToExecute() {
        System.err.println("*** AJ Plugin: ProjectProperties.getClassToExecute NOT IMPLEMENTED ***");
        return null;
    }

    public String getRootProjectDir() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        return project.getLocation().toOSString();
    }

    public List getBuildConfigFiles() {
        return null;
    }

    public String getDefaultBuildConfigFile() {
        String defaultLstFile = String.valueOf(AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString()) + File.separator + ".generated.lst";
        return defaultLstFile;
    }

    public String getLastActiveBuildConfigFile() {
        String currentLstFile = AspectJPlugin.getBuildConfigurationFile(AspectJPlugin.getDefault().getCurrentProject());
        return currentLstFile;
    }

    public List getProjectSourceFiles() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        ArrayList sourceFiles = new ArrayList();
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                IPath path;
                IResource res;
                if (cpes[i].getEntryKind() == 3 && (res = project.findMember((path = cpes[i].getPath()).removeFirstSegments(1))) != null && res.getType() == 2) {
                    List l = this.allFiles((IContainer)((IFolder)res));
                    sourceFiles.addAll(l);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        return sourceFiles;
    }

    private List allFiles(IContainer folder) {
        final ArrayList contents = new ArrayList();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res.getType() == 1 && CoreUtils.ASPECTJ_SOURCE_FILTER.accept(res.getName())) {
                        contents.add(res.getLocation().toFile());
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
        }
        return contents;
    }

    public String getProjectSourcePath() {
        IProject p = AspectJPlugin.getDefault().getCurrentProject();
        return p.getLocation().toOSString();
    }

    public String getClasspath() {
        if (this.cachedClasspath != null) {
            return this.cachedClasspath;
        }
        IProject proj = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jp = JavaCore.create((IProject)proj);
        this.cachedClasspath = new BuildClasspathResolver().getClasspath(AspectJPlugin.getWorkspace().getRoot(), jp);
        return this.cachedClasspath;
    }

    public void flushClasspathCache() {
        this.cachedClasspath = null;
    }

    public String getOutputPath() {
        IPath workspaceRelativeOutputPath;
        IProject currProject = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)currProject);
        try {
            workspaceRelativeOutputPath = jProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_4, ajc$tjp_5);
            return currProject.getLocation().toOSString();
        }
        if (workspaceRelativeOutputPath.segmentCount() == 1) {
            return jProject.getResource().getLocation().toOSString();
        }
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        return out.getLocation().toOSString();
    }

    public String getBootClasspath() {
        return null;
    }

    public String getExecutionArgs() {
        return "";
    }

    public String getVmArgs() {
        return null;
    }

    public Set getInJars() {
        return null;
    }

    public Set getInpath() {
        return null;
    }

    public Map getSourcePathResources() {
        return null;
    }

    public String getOutJar() {
        return "";
    }

    public Set getSourceRoots() {
        return null;
    }

    public Set getAspectPath() {
        return null;
    }

    static {
        Factory factory = new Factory("CoreProjectProperties.java", Class.forName("org.eclipse.ajdt.core.builder.CoreProjectProperties"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 114);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getProjectSourceFiles-org.eclipse.ajdt.core.builder.CoreProjectProperties----java.util.List-"), 98);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.core.runtime.CoreException-<missing>-"), 135);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-allFiles-org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.core.resources.IContainer:-folder:--java.util.List-"), 123);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 180);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOutputPath-org.eclipse.ajdt.core.builder.CoreProjectProperties----java.lang.String-"), 175);
    }
}

