/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class AJModel {
    private static AJModel instance;
    private IProject beingBuilt = null;
    private Map projectModelMap = new HashMap();
    private static String lastLoadedConfigFile;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    private AJModel() {
    }

    public static AJModel getInstance() {
        if (instance == null) {
            instance = new AJModel();
        }
        return instance;
    }

    private AJProjectModel getModelForProject(IProject project) {
        AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
        if (pm == null) {
            AJModel.initialiseAJDE(project);
            this.createMap(project);
            pm = (AJProjectModel)this.projectModelMap.get(project);
        }
        return pm;
    }

    public List getRelatedElements(AJRelationshipType rel, IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return null;
        }
        return pm.getRelatedElements(rel, je);
    }

    public boolean isAdvised(IJavaElement je) {
        if (je == null) {
            return false;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return false;
        }
        IProject project = jp.getProject();
        if (project == null) {
            return false;
        }
        if (!project.isAccessible()) {
            return false;
        }
        AJProjectModel pm = this.getModelForProject(project);
        if (pm == null) {
            return false;
        }
        return pm.isAdvised(je);
    }

    public List getExtraChildren(IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        IProject project = jp.getProject();
        if (project == null) {
            return null;
        }
        if (!project.isAccessible()) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(project);
        if (pm == null) {
            return null;
        }
        return pm.getExtraChildren(je);
    }

    public void createMap(final IProject project) {
        final long start = System.currentTimeMillis();
        final AJProjectModel projectModel = new AJProjectModel(project);
        this.projectModelMap.put(project, projectModel);
        try {
            AspectJPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    projectModel.createProjectMap();
                    long elapsed = System.currentTimeMillis() - start;
                    AJLog.log("Created AJDT relationship map for project " + project.getName() + " in " + elapsed + "ms");
                }
            }, null);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public void clearMap(IProject project) {
        this.projectModelMap.remove(project);
        AJLog.log("Cleared AJDT relationship map for project " + project.getName());
    }

    public void aboutToBuild(IProject project) {
        this.beingBuilt = project;
    }

    public List getAllRelationships(IProject project, AJRelationshipType[] rels) {
        AJProjectModel pm = this.getModelForProject(project);
        if (pm == null) {
            return null;
        }
        return pm.getAllRelationships(rels);
    }

    public int getJavaElementLineNumber(IJavaElement je) {
        if (je == null) {
            return -1;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return -1;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return -1;
        }
        return pm.getJavaElementLineNumber(je);
    }

    public String getJavaElementLinkName(IJavaElement je) {
        if (je == null) {
            return "";
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return je.getElementName();
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return je.getElementName();
        }
        return pm.getJavaElementLinkName(je);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        IResource res = this.programElementToResource(ipe);
        if (res != null && res instanceof IFile) {
            IFile file = (IFile)res;
            AJProjectModel pm = this.getModelForProject(file.getProject());
            if (pm == null) {
                return null;
            }
            return pm.getCorrespondingJavaElement(ipe);
        }
        return null;
    }

    private IResource programElementToResource(IProgramElement ipe) {
        try {
            String fileString = ipe.getSourceLocation().getSourceFile().getCanonicalPath();
            IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                String root;
                if (projects[i].isOpen() && AspectJPlugin.isAJProject(projects[i]) && fileString.startsWith(root = CoreUtils.getProjectRootDirectory(projects[i]))) {
                    String path = fileString.substring(root.length());
                    Path ipath = new Path(path);
                    IResource res = projects[i].findMember((IPath)ipath);
                    return res;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException2, this, ajc$tjp_2, ajc$tjp_3);
        }
        return null;
    }

    public static void initialiseAJDE(IProject withProject) {
        String configFile = AspectJPlugin.getBuildConfigurationFile(withProject);
        if (!configFile.equals(lastLoadedConfigFile)) {
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(configFile);
            lastLoadedConfigFile = configFile;
        }
    }

    static {
        Factory factory = new Factory("AJModel.java", Class.forName("org.eclipse.ajdt.core.model.AJModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJModel-org.eclipse.core.runtime.CoreException-<missing>-"), 189);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createMap-org.eclipse.ajdt.core.model.AJModel-org.eclipse.core.resources.IProject:-project:--void-"), 177);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJModel-java.io.IOException-<missing>-"), 350);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-programElementToResource-org.eclipse.ajdt.core.model.AJModel-org.aspectj.asm.IProgramElement:-ipe:--org.eclipse.core.resources.IResource-"), 327);
    }
}

