/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.Relationship;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;

public class AJProjectModel {
    IProject project;
    private Map ipeToije = new HashMap();
    private Map jeLinkNames = new HashMap();
    private Map perRelMap = new HashMap();
    private Map kindMap = new HashMap();
    private Map extraChildren = new HashMap();
    private Map lineNumbers = new HashMap();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    public AJProjectModel(IProject project) {
        this.project = project;
        this.kindMap.put("advises", AJRelationshipManager.ADVISES);
        this.kindMap.put("advised by", AJRelationshipManager.ADVISED_BY);
        this.kindMap.put("declared on", AJRelationshipManager.DECLARED_ON);
        this.kindMap.put("aspect declarations", AJRelationshipManager.ASPECT_DECLARATIONS);
        this.kindMap.put("matched by", AJRelationshipManager.MATCHED_BY);
        this.kindMap.put("matches declare", AJRelationshipManager.MATCHES_DECLARE);
        this.kindMap.put("annotates", AJRelationshipManager.ANNOTATES);
        this.kindMap.put("annotated by", AJRelationshipManager.ANNOTATED_BY);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        return (IJavaElement)this.ipeToije.get(ipe);
    }

    public List getRelatedElements(AJRelationshipType rel, IJavaElement je) {
        Map relMap = (Map)this.perRelMap.get(rel);
        if (relMap == null) {
            return null;
        }
        return (List)relMap.get(je);
    }

    public List getAllRelationships(AJRelationshipType[] rels) {
        ArrayList<AJRelationship> allRels = new ArrayList<AJRelationship>();
        int i = 0;
        while (i < rels.length) {
            Map relMap = (Map)this.perRelMap.get(rels[i]);
            if (relMap != null) {
                Iterator iter = relMap.keySet().iterator();
                while (iter.hasNext()) {
                    IJavaElement source = (IJavaElement)iter.next();
                    List targetList = (List)relMap.get(source);
                    Iterator iter2 = targetList.iterator();
                    while (iter2.hasNext()) {
                        IJavaElement target = (IJavaElement)iter2.next();
                        allRels.add(new AJRelationship(source, rels[i], target));
                    }
                }
            }
            ++i;
        }
        return allRels;
    }

    public boolean isAdvised(IJavaElement je) {
        List advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, je);
        if (advisedBy != null && advisedBy.size() > 0) {
            return true;
        }
        List extras = this.getExtraChildren(je);
        if (extras != null) {
            Iterator iter = extras.iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, element);
                if (advisedBy == null || advisedBy.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getJavaElementLineNumber(IJavaElement je) {
        Integer i = (Integer)this.lineNumbers.get(je);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public String getJavaElementLinkName(IJavaElement je) {
        return (String)this.jeLinkNames.get(je);
    }

    public List getExtraChildren(IJavaElement je) {
        return (List)this.extraChildren.get(je);
    }

    public void createProjectMap() {
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFolder) {
                        return true;
                    }
                    if (resource instanceof IFile) {
                        IFile f = (IFile)resource;
                        if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(f.getName())) {
                            AJProjectModel.this.createMapForFile(f);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        this.processRelationships();
    }

    private void processRelationships() {
        IRelationshipMap asmRelMap = AsmManager.getDefault().getRelationshipMap();
        Iterator iter = asmRelMap.getEntries().iterator();
        while (iter.hasNext()) {
            String sourceOfRelationship = (String)iter.next();
            IProgramElement ipe = AsmManager.getDefault().getHierarchy().findElementForHandle(sourceOfRelationship);
            List relationships = asmRelMap.get(ipe);
            if (relationships == null) continue;
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                Relationship rel = (Relationship)iterator.next();
                List targets = rel.getTargets();
                Iterator iterator2 = targets.iterator();
                while (iterator2.hasNext()) {
                    ArrayList<IJavaElement> l;
                    AJRelationshipType ajRel;
                    String t = (String)iterator2.next();
                    IProgramElement link = AsmManager.getDefault().getHierarchy().findElementForHandle(t);
                    IJavaElement sourceEl = (IJavaElement)this.ipeToije.get(ipe);
                    IJavaElement targetEl = (IJavaElement)this.ipeToije.get(link);
                    if (targetEl == null && link.getParent() == null) {
                        targetEl = new AJCodeElement(null, 0, "injar aspect: " + link.getName());
                    }
                    if ((ajRel = (AJRelationshipType)this.kindMap.get(rel.getName())) == null || sourceEl == null || targetEl == null) continue;
                    HashMap<IJavaElement, ArrayList<IJavaElement>> relMap = (HashMap<IJavaElement, ArrayList<IJavaElement>>)this.perRelMap.get(ajRel);
                    if (relMap == null) {
                        relMap = new HashMap<IJavaElement, ArrayList<IJavaElement>>();
                        this.perRelMap.put(ajRel, relMap);
                    }
                    if ((l = (ArrayList<IJavaElement>)relMap.get(sourceEl)) == null) {
                        l = new ArrayList<IJavaElement>();
                        relMap.put(sourceEl, l);
                    }
                    l.add(targetEl);
                }
            }
        }
    }

    private void createMapForFile(IFile file) {
        IProject project = file.getProject();
        if (project == null || !project.isOpen() || !AspectJPlugin.isAJProject(project)) {
            return;
        }
        String path = file.getRawLocation().toOSString();
        HashMap annotationsMap = AsmManager.getDefault().getInlineAnnotations(path, true, true);
        if (annotationsMap == null) {
            return;
        }
        AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(file);
        if (unit == null && file.getName().endsWith(".java")) {
            unit = JavaCore.createCompilationUnitFrom((IFile)file);
        }
        if (unit == null) {
            return;
        }
        if (unit instanceof AJCompilationUnit) {
            try {
                unit.reconcile(0, false, null, null);
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_2, ajc$tjp_3);
            }
        }
        Set keys = annotationsMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            List annotations = (List)annotationsMap.get(key);
            Iterator it2 = annotations.iterator();
            while (it2.hasNext()) {
                IProgramElement node = (IProgramElement)it2.next();
                ISourceLocation sl = node.getSourceLocation();
                int fff = 0;
                String declare = "declare ";
                if (node.toLinkLabelString().indexOf(declare) != -1) {
                    fff = declare.length();
                }
                boolean subElement = false;
                int offset = sl.getOffset();
                if (offset == 0) {
                    subElement = true;
                    offset = node.getParent().getSourceLocation().getOffset();
                }
                try {
                    IJavaElement el = unit.getElementAt(offset + fff);
                    if (subElement) {
                        IJavaElement parent = el;
                        el = new AJCodeElement((JavaElement)parent, sl.getLine(), node.toLabelString());
                        ArrayList<IJavaElement> l = (ArrayList<IJavaElement>)this.extraChildren.get(parent);
                        if (l == null) {
                            l = new ArrayList<IJavaElement>();
                            this.extraChildren.put(parent, l);
                        }
                        l.add(el);
                    }
                    if (el == null) continue;
                    this.ipeToije.put(node, el);
                    this.jeLinkNames.put(el, node.toLinkLabelString());
                    this.lineNumbers.put(el, new Integer(sl.getLine()));
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException3 = javaModelException;
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_4, ajc$tjp_3);
                }
            }
        }
    }

    private void dumpModel() {
        System.out.println("AJDT model for project: " + this.project.getName());
        Iterator iter = this.kindMap.keySet().iterator();
        while (iter.hasNext()) {
            String kind = (String)iter.next();
            AJRelationshipType rel = (AJRelationshipType)this.kindMap.get(kind);
            Map relMap = (Map)this.perRelMap.get(rel);
            if (relMap == null) continue;
            Iterator iter2 = relMap.keySet().iterator();
            while (iter2.hasNext()) {
                IJavaElement je = (IJavaElement)iter2.next();
                List related = (List)relMap.get(je);
                Iterator iter3 = related.iterator();
                while (iter3.hasNext()) {
                    IJavaElement el = (IJavaElement)iter3.next();
                    System.out.println("    " + this.getJavaElementLinkName(je) + " --" + kind + "-> " + this.getJavaElementLinkName(el));
                    System.out.println("    " + je.hashCode() + " --" + kind + "-> " + el.hashCode());
                    System.out.println("    " + je.getHandleIdentifier() + " --" + kind + "-> " + el.getHandleIdentifier());
                }
            }
        }
        System.out.println("End of model");
    }

    static {
        Factory factory = new Factory("AJProjectModel.java", Class.forName("org.eclipse.ajdt.core.model.AJProjectModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.core.runtime.CoreException-<missing>-"), 171);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createProjectMap-org.eclipse.ajdt.core.model.AJProjectModel----void-"), 155);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.jdt.core.JavaModelException-<missing>-"), 287);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createMapForFile-org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.core.resources.IFile:-file:--void-"), 246);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.jdt.core.JavaModelException-<missing>-"), 343);
    }
}

