/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.codeconversion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.codeconversion.ConversionOptions;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;

public class AspectsConvertingParser
implements TerminalTokens {
    public char[] content;
    private Set typeReferences;
    private Set usedIdentifiers;
    private ConversionOptions options;
    private ArrayList replacements;
    protected Scanner scanner;
    private static final char[] throwing;
    private static final char[] returning;
    private static final char[] percflow;
    private static final char[] percflowbelow;
    private static final char[] perthis;
    private static final char[] pertarget;
    private static final char[] issingleton;
    private static final char[] classs;
    private static final char[] privileged;
    private static final String thizString = "thiz";
    private boolean insidePointcutDesignator;
    private boolean insideAspect;
    private boolean insideAspectDeclaration;
    int posColon;
    char[] tjpRefs2 = "org.aspectj.lang.JoinPoint thisJoinPoint; org.aspectj.lang.JoinPoint.StaticPart thisJoinPointStaticPart;".toCharArray();
    char[] tjpRefs = "".toCharArray();
    private char[] spaceAndDot = new char[]{' ', '.'};
    char[] endThrow = new char[]{'(', ':'};
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("AspectsConvertingParser.java", Class.forName("org.eclipse.ajdt.internal.codeconversion.AspectsConvertingParser"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.codeconversion.AspectsConvertingParser-org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException-<missing>-"), 150);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-convert-org.eclipse.ajdt.internal.codeconversion.AspectsConvertingParser-org.eclipse.ajdt.internal.codeconversion.ConversionOptions:-options:--java.util.ArrayList-"), 127);
        throwing = "throwing".toCharArray();
        returning = "returning".toCharArray();
        percflow = "percflow".toCharArray();
        percflowbelow = "percflowbelow".toCharArray();
        perthis = "perthis".toCharArray();
        pertarget = "pertarget".toCharArray();
        issingleton = "issingleton".toCharArray();
        classs = "class ".toCharArray();
        privileged = "          ".toCharArray();
    }

    public AspectsConvertingParser(char[] content) {
        this.content = content;
        this.typeReferences = new HashSet();
        this.usedIdentifiers = new HashSet();
        this.replacements = new ArrayList(5);
    }

    public ArrayList convert(ConversionOptions options) {
        this.options = options;
        boolean insertThisJoinPointReferences = options.isThisJoinPointReferencesEnabled();
        boolean addReferencesForOrganizeImports = options.isDummyTypeReferencesForOrganizeImportsEnabled();
        boolean isSimulateContextSwitchNecessary = options.getTargetType() != null;
        this.scanner = new Scanner();
        this.scanner.setSource(this.content);
        this.insidePointcutDesignator = false;
        this.insideAspect = false;
        this.insideAspectDeclaration = false;
        this.replacements.clear();
        this.typeReferences.clear();
        this.usedIdentifiers.clear();
        block11: while (true) {
            int tok;
            try {
                tok = this.scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                InvalidInputException invalidInputException2 = invalidInputException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invalidInputException2, this, ajc$tjp_0, ajc$tjp_1);
                continue;
            }
            if (tok == 75) break;
            switch (tok) {
                case 22: {
                    if (!this.insideAspect) continue block11;
                    char[] name = this.scanner.getCurrentIdentifierSource();
                    if (this.insideAspectDeclaration && !this.insidePointcutDesignator) {
                        if (CharOperation.equals((char[])percflow, (char[])name)) {
                            this.startPointcutDesignator();
                        } else if (CharOperation.equals((char[])percflowbelow, (char[])name)) {
                            this.startPointcutDesignator();
                        } else if (CharOperation.equals((char[])perthis, (char[])name)) {
                            this.startPointcutDesignator();
                        } else if (CharOperation.equals((char[])pertarget, (char[])name)) {
                            this.startPointcutDesignator();
                        } else if (CharOperation.equals((char[])issingleton, (char[])name)) {
                            this.startPointcutDesignator();
                        }
                    }
                    if (CharOperation.equals((char[])throwing, (char[])name)) {
                        this.consumeRetOrThro();
                    } else if (CharOperation.equals((char[])returning, (char[])name)) {
                        this.consumeRetOrThro();
                    } else if (this.insidePointcutDesignator && Character.isUpperCase(name[0])) {
                        this.typeReferences.add(new String(name));
                    }
                    if (!isSimulateContextSwitchNecessary) break;
                    this.usedIdentifiers.add(new String(name));
                    break;
                }
                case 72: {
                    if (!this.insideAspect) continue block11;
                    this.startPointcutDesignator();
                    break;
                }
                case 28: {
                    if (!this.insidePointcutDesignator) break;
                    this.endPointcutDesignator();
                    break;
                }
                case 2: {
                    if (!this.insideAspect || this.insidePointcutDesignator) continue block11;
                    this.processPotentialIntertypeDeclaration();
                    break;
                }
                case 74: {
                    if (this.insidePointcutDesignator) {
                        this.endPointcutDesignator();
                        if (insertThisJoinPointReferences && !this.insideAspectDeclaration) {
                            this.addReplacement(this.scanner.getCurrentTokenStartPosition() + 1, 0, this.tjpRefs2);
                        }
                    }
                    this.insideAspectDeclaration = false;
                    break;
                }
                case 29: {
                    this.insideAspect = true;
                    this.insideAspectDeclaration = true;
                    int pos = this.scanner.getCurrentTokenStartPosition();
                    this.addReplacement(pos, classs.length, classs);
                    break;
                }
                case 31: {
                    int pos = this.scanner.getCurrentTokenStartPosition();
                    this.addReplacement(pos, privileged.length, privileged);
                }
            }
        }
        if (addReferencesForOrganizeImports) {
            this.addReferences();
        }
        if (isSimulateContextSwitchNecessary) {
            this.simulateContextSwitch(options.getCodeCompletePosition(), options.getTargetType());
        }
        this.applyReplacements();
        return this.replacements;
    }

    private void simulateContextSwitch(int position, char[] targetType) {
        int pos = this.findInsertionPosition(position - 1) + 1;
        int len = 0;
        if (this.content[pos] == 't' && this.content[pos + 1] == 'h' && this.content[pos + 2] == 'i' && this.content[pos + 3] == 's' && !Character.isJavaIdentifierPart(this.content[pos + 4])) {
            len = 4;
        }
        String ident = this.findFreeIdentifier();
        char[] toInsert = (String.valueOf(new String(targetType)) + ' ' + ident + ';' + ident + '.').toCharArray();
        this.addReplacement(pos, len, toInsert);
    }

    private String findFreeIdentifier() {
        int i = 0;
        String ident = thizString + i;
        while (this.usedIdentifiers.contains(ident)) {
            ident = thizString + ++i;
        }
        return ident;
    }

    private int findInsertionPosition(int pos) {
        char ch = this.content[pos];
        int currentPos = pos--;
        if (Character.isWhitespace(ch)) {
            currentPos = this.findPreviousNonSpace(pos);
            if (currentPos == -1) {
                return pos;
            }
            ch = this.content[currentPos];
            if (ch == '.') {
                return this.findInsertionPosition(--currentPos);
            }
            return pos;
        }
        if (Character.isJavaIdentifierPart(ch)) {
            while (Character.isJavaIdentifierPart(ch)) {
                ch = this.content[--currentPos];
            }
            return this.findInsertionPosition(currentPos);
        }
        if (ch == '.') {
            return this.findInsertionPosition(pos);
        }
        if (ch == ')') {
            --currentPos;
            int bracketCounter = 1;
            while (currentPos >= 0) {
                ch = this.content[currentPos];
                if (bracketCounter == 0) break;
                if (ch == ')') {
                    ++bracketCounter;
                }
                if (ch == '(' && --bracketCounter < 0) {
                    return -1;
                }
                --currentPos;
            }
            return this.findInsertionPosition(currentPos);
        }
        return pos;
    }

    private void applyReplacements() {
        ListIterator iter = this.replacements.listIterator();
        int offset = 0;
        while (iter.hasNext()) {
            Replacement ins = (Replacement)iter.next();
            ins.posAfter = ins.posBefore + offset;
            this.replace(ins.posAfter, ins.length, ins.text);
            offset += ins.lengthAdded;
        }
    }

    private void replace(int pos, int length, char[] text) {
        if (length != text.length) {
            int toAdd = text.length - length;
            char[] temp = new char[this.content.length + toAdd];
            System.arraycopy(this.content, 0, temp, 0, pos);
            System.arraycopy(this.content, pos, temp, pos + toAdd, this.content.length - pos);
            this.content = temp;
        }
        System.arraycopy(text, 0, this.content, pos, text.length);
    }

    private void startPointcutDesignator() {
        if (this.insidePointcutDesignator) {
            return;
        }
        this.insidePointcutDesignator = true;
        this.posColon = this.scanner.getCurrentTokenStartPosition();
    }

    private void endPointcutDesignator() {
        this.insidePointcutDesignator = false;
        int posSemi = this.scanner.getCurrentTokenStartPosition();
        int len = posSemi - this.posColon;
        char[] empty = new char[len];
        int i = 0;
        while (i < empty.length) {
            empty[i] = 32;
            ++i;
        }
        this.addReplacement(this.posColon, len, empty);
    }

    private void processPotentialIntertypeDeclaration() {
        int pos = this.scanner.getCurrentTokenStartPosition();
        int nonspace1 = this.findPreviousNonSpace(pos - 1);
        if (nonspace1 == -1) {
            return;
        }
        if (!Character.isJavaIdentifierPart(this.content[nonspace1])) {
            return;
        }
        int space = this.findPreviousSpace(nonspace1);
        if (space == -1) {
            return;
        }
        int nonspace2 = this.findPreviousNonSpace(space);
        if (nonspace2 == -1) {
            return;
        }
        if (!Character.isJavaIdentifierPart(this.content[nonspace2])) {
            return;
        }
        int spaceordot = this.findPrevious(this.spaceAndDot, nonspace1);
        if (spaceordot == -1) {
            return;
        }
        if (Character.isUpperCase(this.content[spaceordot + 1])) {
            char[] rep = new char[]{'$'};
            this.addReplacement(pos, 1, rep);
            if (this.content[spaceordot] == ' ') {
                String type = new String(this.content, space + 1, pos - space - 1);
                boolean validIdentifier = true;
                int i = 0;
                while (validIdentifier && i < type.length()) {
                    char c = type.charAt(i);
                    if (i == 0) {
                        if (!Character.isJavaIdentifierStart(c)) {
                            validIdentifier = false;
                        }
                    } else if (!Character.isJavaIdentifierPart(c)) {
                        validIdentifier = false;
                    }
                    ++i;
                }
                if (validIdentifier) {
                    this.typeReferences.add(type);
                }
            } else {
                do {
                    this.addReplacement(spaceordot, 1, rep);
                    --spaceordot;
                } while (this.content[spaceordot = this.findPrevious(this.spaceAndDot, spaceordot)] == '.');
            }
            if (this.options.isAddAjcTagToIntertypesEnabled()) {
                this.addReplacement(spaceordot + 1, 0, "ajc$".toCharArray());
            }
        }
    }

    public int findPrevious(char ch, int pos) {
        while (pos >= 0) {
            if (this.content[pos] == ch) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    public int findPrevious(char[] chs, int pos) {
        while (pos >= 0) {
            int i = 0;
            while (i < chs.length) {
                if (this.content[pos] == chs[i]) {
                    return pos;
                }
                ++i;
            }
            --pos;
        }
        return -1;
    }

    public int findPreviousSpace(int pos) {
        while (pos >= 0) {
            if (Character.isWhitespace(this.content[pos])) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    public int findPreviousNonSpace(int pos) {
        while (pos >= 0) {
            if (!Character.isWhitespace(this.content[pos])) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    public int findNext(char[] chs, int pos) {
        while (pos < this.content.length) {
            int i = 0;
            while (i < chs.length) {
                if (this.content[pos] == chs[i]) {
                    return pos;
                }
                ++i;
            }
            ++pos;
        }
        return -1;
    }

    public void consumeRetOrThro() {
        int pos = this.scanner.getCurrentTokenStartPosition();
        char[] content = this.scanner.source;
        int end = this.findNext(this.endThrow, pos);
        if (end == -1) {
            return;
        }
        char[] temp = null;
        if (content[end] == this.endThrow[0]) {
            if ((pos = this.findPrevious(')', pos)) == -1) {
                return;
            }
            int advicebracket = this.findPrevious('(', pos);
            if (advicebracket == -1) {
                return;
            }
            temp = new char[end - pos + 1];
            temp[0] = this.bracketsContainSomething(advicebracket) && this.bracketsContainSomething(end) ? 44 : 32;
            int i = 1;
            while (i < temp.length) {
                temp[i] = 32;
                ++i;
            }
        } else {
            temp = new char[end - pos];
            int i = 0;
            while (i < temp.length) {
                temp[i] = 32;
                ++i;
            }
        }
        this.addReplacement(pos, temp.length, temp);
    }

    private boolean bracketsContainSomething(int start) {
        while (++start < this.content.length) {
            if (this.content[start] == ')') {
                return false;
            }
            if (!Character.isJavaIdentifierPart(this.content[start])) continue;
            return true;
        }
        return false;
    }

    private int findLast(char ch) {
        int pos = this.content.length;
        while (--pos >= 0) {
            if (this.content[pos] == ch) break;
        }
        return pos;
    }

    void addReferences() {
        if (this.typeReferences == null) {
            return;
        }
        int pos = this.findLast('}');
        if (pos < 0) {
            return;
        }
        StringBuffer temp = new StringBuffer(this.typeReferences.size() * 10);
        Iterator iter = this.typeReferences.iterator();
        int varCount = 1;
        while (iter.hasNext()) {
            String ref = (String)iter.next();
            temp.append(ref);
            temp.append(" x");
            temp.append(varCount++);
            temp.append(';');
        }
        char[] decls = new char[temp.length()];
        temp.getChars(0, decls.length, decls, 0);
        this.addReplacement(pos, 0, decls);
    }

    void addReplacement(int pos, int length, char[] text) {
        int last = this.replacements.size() - 1;
        while (last >= 0) {
            if (((Replacement)this.replacements.get((int)last)).posBefore < pos) break;
            --last;
        }
        this.replacements.add(last + 1, new Replacement(pos, length, text));
    }

    public static boolean conflictsWithAJEdit(int offset, int length, ArrayList replacements) {
        int i = 0;
        while (i < replacements.size()) {
            Replacement ins = (Replacement)replacements.get(i);
            if (offset >= ins.posAfter && offset < ins.posAfter + ins.length) {
                return true;
            }
            if (offset < ins.posAfter && offset + length > ins.posAfter) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int translatePositionToBeforeChanges(int posAfter, ArrayList replacements) {
        Replacement ins;
        int offset = 0;
        int i = 0;
        while (i < replacements.size()) {
            ins = (Replacement)replacements.get(i);
            if (ins.posAfter > posAfter) break;
            offset += ins.lengthAdded;
            ++i;
        }
        if (i > 0) {
            int diff;
            ins = (Replacement)replacements.get(i - 1);
            if (ins.posAfter + ins.text.length > posAfter && (diff = posAfter - ins.posAfter) > ins.length) {
                offset += diff - ins.length;
            }
        }
        return posAfter - offset;
    }

    public static int translatePositionToAfterChanges(int posBefore, ArrayList replacements) {
        int i = 0;
        while (i < replacements.size()) {
            Replacement ins = (Replacement)replacements.get(i);
            if (ins.posAfter <= posBefore) {
                posBefore += ins.lengthAdded;
            } else {
                return posBefore;
            }
            ++i;
        }
        return posBefore;
    }

    public class Replacement {
        public int posBefore;
        public int posAfter;
        public int length;
        public char[] text;
        public int lengthAdded;

        public Replacement(int pos, int length, char[] text) {
            this.posBefore = pos;
            this.posAfter = -1;
            this.length = length;
            this.text = text;
            this.lengthAdded = text.length - length;
        }
    }
}

