/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.osgi.framework.Bundle;

public class CoreUtils {
    private static String aspectjrtPath;
    public static final FilenameFilter ASPECTJ_SOURCE_ONLY_FILTER;
    public static final FilenameFilter ASPECTJ_SOURCE_FILTER;
    public static final FilenameFilter RESOURCE_FILTER;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    static {
        Factory factory = new Factory("CoreUtils.java", Class.forName("org.eclipse.ajdt.internal.core.CoreUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.CoreUtils-java.io.IOException-<missing>-"), 101);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getAspectjrtClasspath-org.eclipse.ajdt.internal.core.CoreUtils----java.lang.String-"), 82);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 328);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getOutputLocationPaths-org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.core.resources.IProject:-project:--java.util.List-"), 298);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 162);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getRequiredClassFolderProjects-org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.core.resources.IProject:-project:--[Lorg.eclipse.core.resources.IProject;-"), 148);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 184);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 250);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getDependingProjects-org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.core.resources.IProject:-project:--java.util.List-"), 206);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 254);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 285);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getExportedEntries-org.eclipse.ajdt.internal.core.CoreUtils-org.eclipse.core.resources.IProject:-project:--[Lorg.eclipse.jdt.core.IClasspathEntry;-"), 265);
        aspectjrtPath = null;
        ASPECTJ_SOURCE_ONLY_FILTER = new FilenameFilter(){

            public boolean accept(String name) {
                return name.endsWith(".aj");
            }
        };
        ASPECTJ_SOURCE_FILTER = new FilenameFilter(){

            public boolean accept(String name) {
                return name.endsWith(".java") || name.endsWith(".aj");
            }
        };
        RESOURCE_FILTER = new FilenameFilter(){

            public boolean accept(String name) {
                return !name.endsWith(".java") && !name.endsWith(".aj") && !name.endsWith(".class");
            }
        };
    }

    public static String getProjectRootDirectory(IProject project) {
        return project.getLocation().toOSString();
    }

    public static String getAspectjrtClasspath() {
        if (aspectjrtPath == null) {
            StringBuffer cpath = new StringBuffer();
            Bundle ajdeBundle = Platform.getBundle((String)"org.aspectj.runtime");
            String pluginLoc = null;
            if (ajdeBundle != null) {
                URL installLoc = ajdeBundle.getEntry("/");
                URL resolved = null;
                try {
                    resolved = Platform.resolve((URL)installLoc);
                    pluginLoc = resolved.toExternalForm();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_0, ajc$tjp_1);
                }
            }
            if (pluginLoc != null && pluginLoc.startsWith("file:")) {
                cpath.append(pluginLoc.substring("file:".length()));
                cpath.append("aspectjrt.jar");
            }
            if (new File(cpath.toString()).exists()) {
                aspectjrtPath = cpath.toString();
            } else {
                IPath rootPath = AspectJPlugin.getWorkspace().getRoot().getLocation();
                IPath installPath = rootPath.removeLastSegments(1);
                cpath = new StringBuffer().append(installPath.toOSString());
                cpath.append(File.separator);
                cpath.append("workspace");
                cpath.append(File.separator);
                cpath.append("org.aspectj.runtime");
                cpath.append(File.separator);
                cpath.append("aspectjrt.jar");
                if (new File(cpath.toString()).exists()) {
                    aspectjrtPath = cpath.toString();
                }
            }
        }
        return aspectjrtPath;
    }

    public static IProject[] getRequiredClassFolderProjects(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return new IProject[0];
        }
        ArrayList<IProject> requiredProjects = new ArrayList<IProject>();
        IProject[] projectsInWorkspace = AspectJPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projectsInWorkspace.length) {
            block10: {
                block11: {
                    try {
                        if (!projectsInWorkspace[i].isOpen()) break block10;
                        if (!projectsInWorkspace[i].hasNature("org.eclipse.jdt.core.javanature")) {
                        }
                        break block11;
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_2, ajc$tjp_3);
                    }
                    break block10;
                }
                IProject proj = projectsInWorkspace[i];
                List outputLocationPaths = CoreUtils.getOutputLocationPaths(proj);
                Iterator iterator = outputLocationPaths.iterator();
                block5: while (iterator.hasNext()) {
                    IPath path = (IPath)iterator.next();
                    try {
                        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                        int j = 0;
                        while (j < cpEntry.length) {
                            IClasspathEntry entry = cpEntry[j];
                            int entryKind = entry.getEntryKind();
                            IPath entryPath = entry.getPath();
                            if (entryKind == 1 && entryPath.equals((Object)path)) {
                                requiredProjects.add(projectsInWorkspace[i]);
                                break block5;
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        JavaModelException javaModelException2 = javaModelException;
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_4, ajc$tjp_3);
                        break;
                    }
                }
            }
            ++i;
        }
        IProject[] projects = requiredProjects.toArray(new IProject[0]);
        return projects;
    }

    public static List getDependingProjects(IProject project) {
        ArrayList<IProject[]> projects = new ArrayList<IProject[]>();
        IProject[] projectsInWorkspace = AspectJPlugin.getWorkspace().getRoot().getProjects();
        List outputLocationPaths = CoreUtils.getOutputLocationPaths(project);
        IClasspathEntry[] exportedEntries = CoreUtils.getExportedEntries(project);
        ArrayList<IProject> classFolderDependingProjects = new ArrayList<IProject>();
        ArrayList<IProject> exportedLibraryDependingProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < projectsInWorkspace.length) {
            block11: {
                if (!projectsInWorkspace[i].equals((Object)project) && projectsInWorkspace[i].isOpen()) {
                    try {
                        JavaProject javaProject;
                        if (!projectsInWorkspace[i].hasNature("org.eclipse.jdt.core.javanature") || (javaProject = (JavaProject)JavaCore.create((IProject)projectsInWorkspace[i])) == null) break block11;
                        try {
                            IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                            int j = 0;
                            while (j < cpEntry.length) {
                                IClasspathEntry entry = cpEntry[j];
                                if (entry.getEntryKind() == 1) {
                                    Iterator iter = outputLocationPaths.iterator();
                                    while (iter.hasNext()) {
                                        IPath path = (IPath)iter.next();
                                        if (!entry.getPath().equals((Object)path)) continue;
                                        classFolderDependingProjects.add(projectsInWorkspace[i]);
                                        break block11;
                                    }
                                    int k = 0;
                                    while (k < exportedEntries.length) {
                                        if (entry.getPath().equals((Object)exportedEntries[k].getPath())) {
                                            exportedLibraryDependingProjects.add(projectsInWorkspace[i]);
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                        }
                        catch (JavaModelException javaModelException) {
                            JavaModelException javaModelException2 = javaModelException;
                            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_5, ajc$tjp_6);
                        }
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_7, ajc$tjp_6);
                    }
                }
            }
            ++i;
        }
        projects.add(0, classFolderDependingProjects.toArray(new IProject[0]));
        projects.add(1, exportedLibraryDependingProjects.toArray(new IProject[0]));
        return projects;
    }

    private static IClasspathEntry[] getExportedEntries(IProject project) {
        ArrayList<IClasspathEntry> exportedEntries = new ArrayList<IClasspathEntry>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return new IClasspathEntry[0];
        }
        try {
            IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
            int j = 0;
            while (j < cpEntry.length) {
                IClasspathEntry entry = cpEntry[j];
                if (entry.isExported() && entry.getEntryKind() == 1) {
                    IClasspathEntry nonExportedEntry = JavaCore.newLibraryEntry((IPath)entry.getPath(), null, null);
                    exportedEntries.add(nonExportedEntry);
                }
                ++j;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_8, ajc$tjp_9);
        }
        return exportedEntries.toArray(new IClasspathEntry[exportedEntries.size()]);
    }

    public static List getOutputLocationPaths(IProject project) {
        ArrayList<IPath> outputLocations = new ArrayList<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return outputLocations;
        }
        try {
            IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
            int j = 0;
            while (j < cpEntry.length) {
                IClasspathEntry entry = cpEntry[j];
                int contentKind = entry.getContentKind();
                if (contentKind == 10 && entry.getOutputLocation() != null) {
                    outputLocations.add(entry.getOutputLocation());
                }
                ++j;
            }
            if (outputLocations.size() == 0) {
                outputLocations.add(javaProject.getOutputLocation());
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_10, ajc$tjp_11);
        }
        return outputLocations;
    }

    public static interface FilenameFilter {
        public boolean accept(String var1);
    }
}

