/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation. 
 * It is mirrored in org.aspectj.org.eclipse.jdt.core.compiler public package where it is API. 
 * The mirror implementation is using the backward compatible ITerminalSymbols constant 
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens 
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer. 
 * This integer is used to represent the terminal when computing a parsing action. 
 * 
 * Disclaimer : These constant values are generated automatically using a Java 
 * grammar, therefore their actual values are subject to change if new keywords 
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	// AspectJ Extension (generated)
	   public final static int
	     TokenNameIdentifier = 22,
	      TokenNameabstract = 63,
	      TokenNameassert = 79,
	      TokenNameboolean = 39,
	      TokenNamebreak = 80,
	      TokenNamebyte = 40,
	      TokenNamecase = 94,
	      TokenNamecatch = 95,
	      TokenNamechar = 41,
	      TokenNameclass = 89,
	      TokenNamecontinue = 81,
	      TokenNamedefault = 113,
	      TokenNamedo = 82,
	      TokenNamedouble = 42,
	      TokenNameelse = 96,
	      TokenNameenum = 114,
	      TokenNameextends = 90,
	      TokenNamefalse = 54,
	      TokenNamefinal = 64,
	      TokenNamefinally = 97,
	      TokenNamefloat = 43,
	      TokenNamefor = 83,
	      TokenNameif = 84,
	      TokenNameimplements = 100,
	      TokenNameimport = 93,
	      TokenNameinstanceof = 13,
	      TokenNameint = 44,
	      TokenNameinterface = 98,
	      TokenNamelong = 45,
	      TokenNamenative = 65,
	      TokenNamenew = 51,
	      TokenNamenull = 55,
	      TokenNamepackage = 91,
	      TokenNameprivate = 66,
	      TokenNameprotected = 67,
	      TokenNamepublic = 68,
	      TokenNamereturn = 85,
	      TokenNameshort = 46,
	      TokenNamestatic = 52,
	      TokenNamestrictfp = 69,
	      TokenNamesuper = 48,
	      TokenNameswitch = 86,
	      TokenNamesynchronized = 53,
	      TokenNamethis = 49,
	      TokenNamethrow = 87,
	      TokenNamethrows = 99,
	      TokenNametransient = 70,
	      TokenNametrue = 56,
	      TokenNametry = 88,
	      TokenNamevoid = 47,
	      TokenNamevolatile = 71,
	      TokenNamewhile = 78,
	      TokenNameaspect = 29,
	      TokenNamepointcut = 32,
	      TokenNamearound = 36,
	      TokenNamebefore = 34,
	      TokenNameafter = 35,
	      TokenNamedeclare = 33,
	      TokenNameprivileged = 31,
	      TokenNameIntegerLiteral = 57,
	      TokenNameLongLiteral = 58,
	      TokenNameFloatingPointLiteral = 59,
	      TokenNameDoubleLiteral = 60,
	      TokenNameCharacterLiteral = 61,
	      TokenNameStringLiteral = 62,
	      TokenNamePLUS_PLUS = 9,
	      TokenNameMINUS_MINUS = 10,
	      TokenNameEQUAL_EQUAL = 18,
	      TokenNameLESS_EQUAL = 16,
	      TokenNameGREATER_EQUAL = 17,
	      TokenNameNOT_EQUAL = 19,
	      TokenNameLEFT_SHIFT = 15,
	      TokenNameRIGHT_SHIFT = 8,
	      TokenNameUNSIGNED_RIGHT_SHIFT = 11,
	      TokenNamePLUS_EQUAL = 101,
	      TokenNameMINUS_EQUAL = 102,
	      TokenNameMULTIPLY_EQUAL = 103,
	      TokenNameDIVIDE_EQUAL = 104,
	      TokenNameAND_EQUAL = 105,
	      TokenNameOR_EQUAL = 106,
	      TokenNameXOR_EQUAL = 107,
	      TokenNameREMAINDER_EQUAL = 108,
	      TokenNameLEFT_SHIFT_EQUAL = 109,
	      TokenNameRIGHT_SHIFT_EQUAL = 110,
	      TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 111,
	      TokenNameOR_OR = 25,
	      TokenNameAND_AND = 24,
	      TokenNamePLUS = 1,
	      TokenNameMINUS = 3,
	      TokenNameNOT = 73,
	      TokenNameREMAINDER = 5,
	      TokenNameXOR = 23,
	      TokenNameAND = 20,
	      TokenNameMULTIPLY = 4,
	      TokenNameOR = 26,
	      TokenNameTWIDDLE = 76,
	      TokenNameDIVIDE = 6,
	      TokenNameGREATER = 14,
	      TokenNameLESS = 7,
	      TokenNameLPAREN = 21,
	      TokenNameRPAREN = 30,
	      TokenNameLBRACE = 74,
	      TokenNameRBRACE = 38,
	      TokenNameLBRACKET = 12,
	      TokenNameRBRACKET = 77,
	      TokenNameSEMICOLON = 28,
	      TokenNameQUESTION = 27,
	      TokenNameCOLON = 72,
	      TokenNameCOMMA = 37,
	      TokenNameDOT = 2,
	      TokenNameEQUAL = 92,
	      TokenNameAT = 50,
	      TokenNameELLIPSIS = 112,
	      TokenNameEOF = 75,
	      TokenNameERROR = 115;
}
