/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.util.ImageCache;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

class BufferedGraphicsSource
implements GraphicsSource {
    private Image imageBuffer;
    private GC imageGC;
    private GC controlGC;
    private Control control;
    private Rectangle inUse;
    static ArrayList list = new ArrayList();

    public BufferedGraphicsSource(Control c) {
        this.control = c;
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((AbstractCollection)list).remove(BufferedGraphicsSource.this);
            }
        });
        list.add(this);
    }

    public void flushGraphics(Rectangle region) {
        if (this.inUse.isEmpty()) {
            return;
        }
        this.controlGC.drawImage(this.getImage(), 0, 0, this.inUse.width, this.inUse.height, this.inUse.x, this.inUse.y, this.inUse.width, this.inUse.height);
        this.controlGC.dispose();
        this.imageGC.dispose();
        ImageCache.checkin(this.imageBuffer);
    }

    public Graphics getGraphics(Rectangle region) {
        if (this.control == null || this.control.isDisposed()) {
            return null;
        }
        Point ptSWT = this.control.getSize();
        this.inUse = new Rectangle(0, 0, ptSWT.x, ptSWT.y);
        this.inUse.intersect(region);
        if (this.inUse.isEmpty()) {
            return null;
        }
        this.imageBuffer = ImageCache.checkout(this.inUse.getSize(), this);
        this.imageGC = new GC((Drawable)this.getImage());
        this.controlGC = new GC((Drawable)this.control);
        this.imageGC.setBackground(this.controlGC.getBackground());
        this.imageGC.setForeground(this.controlGC.getForeground());
        this.imageGC.setFont(this.controlGC.getFont());
        this.imageGC.setLineStyle(this.controlGC.getLineStyle());
        this.imageGC.setLineWidth(this.controlGC.getLineWidth());
        this.imageGC.setXORMode(this.controlGC.getXORMode());
        SWTGraphics g = new SWTGraphics(this.imageGC);
        ((Graphics)g).translate(this.inUse.getLocation().negate());
        ((Graphics)g).setClip(region);
        ((Graphics)g).clipRect(new Rectangle(0, 0, ptSWT.x, ptSWT.y));
        return g;
    }

    protected Image getImage() {
        return this.imageBuffer;
    }

    protected GC getImageGC() {
        return this.imageGC;
    }
}

