/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.internal.preference;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VisualiserPreferencesDialog
extends Dialog
implements IPreferencePageContainer {
    public static final String PREF_DLG_TITLE_IMG = "visualiser_preference_dialog_title_image";
    public static final String PREF_DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    private Label titleImage;
    private CLabel messageLabel;
    protected Color titleAreaColor;
    private String message = "";
    private Composite titleArea;
    private Color normalMsgAreaBackground;
    private Color errorMsgAreaBackground;
    private Image messageImage;
    private Image errorMsgImage;
    private boolean showingError = false;
    private VisualiserPreferencePage visPage;
    private String errorMessage;
    static /* synthetic */ Class class$0;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.preference.PreferenceDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile((Class)clazz, (String)"images/pref_dialog_title.gif"));
    }

    public VisualiserPreferencesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite titleComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        titleComposite.setLayoutData((Object)new GridData(768));
        this.createTitleArea(titleComposite);
        Composite pageContainer = this.createPageContainer(composite);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 450;
        pageContainer.setLayoutData((Object)gd);
        pageContainer.setFont(parent.getFont());
        Label separator = new Label(composite, 258);
        gd = new GridData(768);
        separator.setLayoutData((Object)gd);
        return composite;
    }

    private Composite createTitleArea(Composite parent) {
        this.titleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        Color foreground = JFaceColors.getBannerForeground((Display)display);
        GridData layoutData = new GridData(1808);
        this.titleArea.setLayout((Layout)layout);
        this.titleArea.setLayoutData((Object)layoutData);
        this.titleArea.setBackground(background);
        RGB rgb = new RGB(171, 168, 165);
        final Color borderColor = new Color((Device)this.titleArea.getDisplay(), rgb);
        this.titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(borderColor);
                Rectangle bounds = VisualiserPreferencesDialog.this.titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (VisualiserPreferencesDialog.this.titleAreaColor != null) {
                    VisualiserPreferencesDialog.this.titleAreaColor.dispose();
                }
                if (VisualiserPreferencesDialog.this.errorMsgAreaBackground != null) {
                    VisualiserPreferencesDialog.this.errorMsgAreaBackground.dispose();
                }
                borderColor.dispose();
            }
        });
        this.messageLabel = new CLabel(this.titleArea, 16384);
        JFaceColors.setColors((Control)this.messageLabel, (Color)foreground, (Color)background);
        this.messageLabel.setText(" ");
        this.messageLabel.setFont(JFaceResources.getBannerFont());
        GridData gd = new GridData(1808);
        this.messageLabel.setLayoutData((Object)gd);
        this.titleImage = new Label(this.titleArea, 16384);
        this.titleImage.setBackground(background);
        this.titleImage.setImage(JFaceResources.getImage((String)PREF_DLG_TITLE_IMG));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.titleImage.setLayoutData((Object)gd);
        return this.titleArea;
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage == null ? newErrorMessage == null : this.errorMessage.equals(newErrorMessage)) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
                this.messageLabel.setBackground(this.normalMsgAreaBackground);
                this.messageLabel.setImage(null);
                this.titleImage.setImage(JFaceResources.getImage((String)PREF_DLG_TITLE_IMG));
            }
            if (this.message == null) {
                this.message = "";
            }
            this.messageLabel.setText(this.message);
            this.messageLabel.setImage(this.messageImage);
            this.messageLabel.setToolTipText(this.message);
        } else {
            this.messageLabel.setText(this.errorMessage);
            this.messageLabel.setToolTipText(this.errorMessage);
            if (!this.showingError) {
                this.showingError = true;
                if (this.errorMsgAreaBackground == null) {
                    this.errorMsgAreaBackground = JFaceColors.getErrorBackground((Display)this.messageLabel.getDisplay());
                    this.errorMsgImage = JFaceResources.getImage((String)PREF_DLG_IMG_TITLE_ERROR);
                }
                this.normalMsgAreaBackground = this.messageLabel.getBackground();
                this.messageLabel.setBackground(this.errorMsgAreaBackground);
                this.messageLabel.setImage(this.errorMsgImage);
                this.titleImage.setImage(null);
            }
        }
        this.titleArea.layout(true);
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new FillLayout());
        this.visPage = new VisualiserPreferencePage();
        this.visPage.setContainer(this);
        this.visPage.setTitle(VisualiserPlugin.getResourceString("VisualiserPreferencePage.title"));
        if (this.visPage.getControl() == null) {
            this.visPage.createControl(result);
        }
        return result;
    }

    public IPreferenceStore getPreferenceStore() {
        return VisualiserPlugin.getDefault().getPreferenceStore();
    }

    public void updateButtons() {
    }

    public void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    public void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)PREF_DLG_IMG_TITLE_ERROR);
                }
            }
        }
        this.showMessage(newMessage, newImage);
    }

    private void showMessage(String newMessage, Image newImage) {
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        if (this.message == null) {
            this.message = "";
        }
        this.messageImage = newImage;
        if (!this.showingError) {
            this.messageLabel.setText(this.message);
            this.messageLabel.setImage(this.messageImage);
            this.messageLabel.setToolTipText(this.message);
        }
    }

    public void updateMessage() {
        String pageMessage = this.visPage.getMessage();
        int pageMessageType = 0;
        if (pageMessage != null) {
            pageMessageType = ((IMessageProvider)this.visPage).getMessageType();
        }
        String pageErrorMessage = this.visPage.getErrorMessage();
        if (pageMessage == null && pageErrorMessage == null) {
            this.messageLabel.setFont(JFaceResources.getBannerFont());
        } else {
            this.messageLabel.setFont(JFaceResources.getDialogFont());
        }
        if (pageMessage == null) {
            this.setMessage(this.visPage.getTitle());
        } else {
            this.setMessage(pageMessage, pageMessageType);
        }
        this.setErrorMessage(pageErrorMessage);
    }

    public void updateTitle() {
    }

    public boolean close() {
        if (this.visPage != null) {
            this.visPage.dispose();
        }
        return super.close();
    }

    protected void okPressed() {
        this.visPage.performOk();
        super.okPressed();
    }
}

