/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IMember;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.ISourceRange;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaConventions;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryType;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModel;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.SourceRange;
import org.aspectj.org.eclipse.jdt.internal.core.util.ReferenceInfoAdapter;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class SourceMapper
extends ReferenceInfoAdapter
implements ISourceElementRequestor,
SuffixConstants {
    public static boolean VERBOSE = false;
    private static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return Util.isJavaLikeFileName(name);
        }
    };
    protected HashSet rootPaths;
    protected BinaryType binaryType;
    protected IPath sourcePath;
    protected String rootPath;
    protected static String[] fgEmptyStringArray = new String[0];
    protected HashMap fParameterNames;
    protected HashMap fSourceRanges;
    public static SourceRange fgUnknownRange = new SourceRange(-1, 0);
    protected int[] fMemberDeclarationStart;
    protected SourceRange[] fMemberNameRange;
    protected String[] fMemberName;
    protected char[][][] fMethodParameterNames;
    protected char[][][] fMethodParameterTypes;
    protected IJavaElement searchedElement;
    private HashMap importsTable;
    private HashMap importsCounterTable;
    IType[] types;
    int[] typeDeclarationStarts;
    SourceRange[] typeNameRanges;
    int typeDepth;
    int anonymousCounter;
    int anonymousClassName;
    String encoding;
    Map options;
    private boolean areRootPathsComputed = false;

    public SourceMapper() {
    }

    public SourceMapper(IPath sourcePath, String rootPath, Map options) {
        this.options = options;
        try {
            this.encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (rootPath != null) {
            this.rootPaths = new HashSet();
            this.rootPaths.add(rootPath);
        }
        this.sourcePath = sourcePath;
        this.fSourceRanges = new HashMap();
        this.fParameterNames = new HashMap();
        this.importsTable = new HashMap();
        this.importsCounterTable = new HashMap();
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand, int modifiers) {
        int importsCounter;
        char[][] imports = (char[][])this.importsTable.get(this.binaryType);
        if (imports == null) {
            imports = new char[5][];
            importsCounter = 0;
        } else {
            importsCounter = (Integer)this.importsCounterTable.get(this.binaryType);
        }
        if (imports.length == importsCounter) {
            char[][] cArray = imports;
            imports = new char[importsCounter * 2][];
            System.arraycopy(cArray, 0, imports, 0, importsCounter);
        }
        if (onDemand) {
            int nameLength = name.length;
            char[] cArray = name;
            name = new char[nameLength + 2];
            System.arraycopy(cArray, 0, name, 0, nameLength);
            name[nameLength] = 46;
            name[nameLength + 1] = 42;
        }
        imports[importsCounter++] = name;
        this.importsTable.put(this.binaryType, imports);
        this.importsCounterTable.put(this.binaryType, new Integer(importsCounter));
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
    }

    public void acceptProblem(IProblem problem) {
    }

    public void close() {
        this.fSourceRanges = null;
        this.fParameterNames = null;
    }

    private String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return fgEmptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return fgEmptyStringArray;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            String typeSig = Signature.createTypeSignature(typeNames[i], false);
            int lastIndex = typeSig.lastIndexOf(46);
            if (lastIndex == -1) {
                typeSigs[i] = typeSig;
            } else {
                int arrayEnd = 0;
                while (typeSig.charAt(arrayEnd) == '[') {
                    ++arrayEnd;
                }
                typeSigs[i] = String.valueOf(typeSig.substring(0, arrayEnd)) + 'Q' + typeSig.substring(lastIndex + 1, typeSig.length());
            }
            ++i;
        }
        return typeSigs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void computeAllRootPaths(IPackageFragmentRoot root) {
        long time;
        block39: {
            File file;
            Object target;
            boolean containsADefaultPackage;
            HashSet<String> firstLevelPackageNames;
            block41: {
                Object var15_28;
                block38: {
                    block40: {
                        if (this.rootPaths == null) {
                            this.rootPaths = new HashSet();
                        }
                        time = 0L;
                        if (VERBOSE) {
                            System.out.println("compute all root paths for " + root.getElementName());
                            time = System.currentTimeMillis();
                        }
                        firstLevelPackageNames = new HashSet<String>();
                        containsADefaultPackage = false;
                        if (!root.isArchive()) break block40;
                        JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)root;
                        JavaModelManager manager = JavaModelManager.getJavaModelManager();
                        ZipFile zip = null;
                        try {
                            try {
                                zip = manager.getZipFile(jarPackageFragmentRoot.getPath());
                                Enumeration<? extends ZipEntry> entries = zip.entries();
                                while (entries.hasMoreElements()) {
                                    ZipEntry entry = entries.nextElement();
                                    String entryName = entry.getName();
                                    if (entry.isDirectory()) continue;
                                    int index = entryName.indexOf(47);
                                    if (index != -1 && org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) {
                                        String firstLevelPackageName = entryName.substring(0, index);
                                        IStatus status = JavaConventions.validatePackageName(firstLevelPackageName);
                                        if (!status.isOK() && status.getSeverity() != 2) continue;
                                        firstLevelPackageNames.add(firstLevelPackageName);
                                        continue;
                                    }
                                    if (!org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) continue;
                                    containsADefaultPackage = true;
                                }
                            }
                            catch (CoreException entries) {}
                        }
                        catch (Throwable throwable) {
                            Object var15_27 = null;
                            manager.closeZipFile(zip);
                            throw throwable;
                        }
                        {
                            var15_28 = null;
                            manager.closeZipFile(zip);
                            break block38;
                        }
                    }
                    target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), root.getPath(), true);
                    if (target instanceof IResource) {
                        IResource resource = (IResource)target;
                        if (resource instanceof IContainer) {
                            try {
                                IResource[] members = ((IContainer)resource).members();
                                int i = 0;
                                int max = members.length;
                                while (i < max) {
                                    IResource member = members[i];
                                    if (member.getType() == 2) {
                                        firstLevelPackageNames.add(member.getName());
                                    } else if (org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(member.getName())) {
                                        containsADefaultPackage = true;
                                    }
                                    ++i;
                                }
                            }
                            catch (CoreException e) {}
                        }
                    } else if (target instanceof File && (file = (File)target).isDirectory()) {
                        File[] files = file.listFiles();
                        int i = 0;
                        int max = files.length;
                        while (i < max) {
                            File currentFile = files[i];
                            if (currentFile.isDirectory()) {
                                firstLevelPackageNames.add(currentFile.getName());
                            } else if (org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(currentFile.getName())) {
                                containsADefaultPackage = true;
                            }
                            ++i;
                        }
                    }
                }
                if (!org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block41;
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                ZipFile zip = null;
                try {
                    try {
                        zip = manager.getZipFile(this.sourcePath);
                        Enumeration<? extends ZipEntry> entries = zip.entries();
                        while (entries.hasMoreElements()) {
                            String entryName;
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory() || !Util.isJavaLikeFileName(entryName = entry.getName())) continue;
                            Path path = new Path(entryName);
                            int segmentCount = path.segmentCount();
                            if (segmentCount > 1) {
                                int i = 0;
                                int max = path.segmentCount() - 1;
                                while (i < max) {
                                    if (firstLevelPackageNames.contains(path.segment(i))) {
                                        this.rootPaths.add(path.uptoSegment(i).toString());
                                    }
                                    if (i == max - 1 && containsADefaultPackage) {
                                        this.rootPaths.add(path.uptoSegment(max).toString());
                                    }
                                    ++i;
                                }
                                continue;
                            }
                            if (!containsADefaultPackage) continue;
                            this.rootPaths.add("");
                        }
                    }
                    catch (CoreException coreException) {}
                }
                catch (Throwable throwable) {
                    var15_28 = null;
                    manager.closeZipFile(zip);
                    throw throwable;
                }
                {
                    var15_28 = null;
                    manager.closeZipFile(zip);
                    break block39;
                }
            }
            target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
            if (target instanceof IResource) {
                if (target instanceof IContainer) {
                    this.computeRootPath((IContainer)target, firstLevelPackageNames, containsADefaultPackage);
                }
            } else if (target instanceof File && (file = (File)target).isDirectory()) {
                this.computeRootPath(file, firstLevelPackageNames, containsADefaultPackage);
            }
        }
        if (VERBOSE) {
            System.out.println("Found " + this.rootPaths.size() + " root paths");
            System.out.println("Spent " + (System.currentTimeMillis() - time) + "ms");
        }
        this.areRootPathsComputed = true;
    }

    private void computeRootPath(File directory, HashSet firstLevelPackageNames, boolean hasDefaultPackage) {
        File[] files = directory.listFiles();
        boolean hasSubDirectories = false;
        int i = 0;
        int max = files.length;
        while (i < max) {
            File parentDir;
            File file = files[i];
            if (file.isDirectory()) {
                hasSubDirectories = true;
                if (firstLevelPackageNames.contains(file.getName())) {
                    Path fullPath = new Path(file.getParentFile().getPath());
                    IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                    this.rootPaths.add(rootPathEntry.toString());
                    break;
                }
                this.computeRootPath(file, firstLevelPackageNames, hasDefaultPackage);
            } else if (i == max - 1 && !hasSubDirectories && hasDefaultPackage && (parentDir = file.getParentFile()).list(FILENAME_FILTER).length != 0) {
                Path fullPath = new Path(parentDir.getPath());
                IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                this.rootPaths.add(rootPathEntry.toString());
            }
            ++i;
        }
    }

    private void computeRootPath(IContainer container, HashSet firstLevelPackageNames, boolean hasDefaultPackage) {
        try {
            IResource[] resources = container.members();
            boolean hasSubDirectories = false;
            int i = 0;
            int max = resources.length;
            while (i < max) {
                IResource resource = resources[i];
                if (resource.getType() == 2) {
                    hasSubDirectories = true;
                    if (firstLevelPackageNames.contains(resource.getName())) {
                        IPath fullPath = container.getFullPath();
                        IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        this.rootPaths.add(rootPathEntry.toString());
                        break;
                    }
                    this.computeRootPath((IContainer)((IFolder)resource), firstLevelPackageNames, hasDefaultPackage);
                }
                if (i == max - 1 && !hasSubDirectories && hasDefaultPackage) {
                    boolean hasJavaSourceFile = false;
                    int j = 0;
                    while (j < max) {
                        if (Util.isJavaLikeFileName(resources[i].getName())) {
                            hasJavaSourceFile = true;
                            break;
                        }
                        ++j;
                    }
                    if (hasJavaSourceFile) {
                        IPath fullPath = container.getFullPath();
                        IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        this.rootPaths.add(rootPathEntry.toString());
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        ++this.typeDepth;
        if (this.typeDepth == this.types.length) {
            this.types = new IType[this.typeDepth * 2];
            System.arraycopy(this.types, 0, this.types, 0, this.typeDepth);
            this.typeNameRanges = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.typeNameRanges, 0, this.typeNameRanges, 0, this.typeDepth);
            this.typeDeclarationStarts = new int[this.typeDepth * 2];
            System.arraycopy(this.typeDeclarationStarts, 0, this.typeDeclarationStarts, 0, this.typeDepth);
            this.fMemberName = new String[this.typeDepth * 2];
            System.arraycopy(this.fMemberName, 0, this.fMemberName, 0, this.typeDepth);
            this.fMemberDeclarationStart = new int[this.typeDepth * 2];
            System.arraycopy(this.fMemberDeclarationStart, 0, this.fMemberDeclarationStart, 0, this.typeDepth);
            this.fMemberNameRange = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.fMemberNameRange, 0, this.fMemberNameRange, 0, this.typeDepth);
            this.fMethodParameterTypes = new char[this.typeDepth * 2][][];
            System.arraycopy(this.fMethodParameterTypes, 0, this.fMethodParameterTypes, 0, this.typeDepth);
            this.fMethodParameterNames = new char[this.typeDepth * 2][][];
            System.arraycopy(this.fMethodParameterNames, 0, this.fMethodParameterNames, 0, this.typeDepth);
        }
        if (typeInfo.name.length == 0) {
            ++this.anonymousCounter;
            this.types[this.typeDepth] = this.anonymousCounter == this.anonymousClassName ? this.getType(this.binaryType.getElementName()) : this.getType(new String(typeInfo.name));
        } else {
            this.types[this.typeDepth] = this.getType(new String(typeInfo.name));
        }
        this.typeNameRanges[this.typeDepth] = new SourceRange(typeInfo.nameSourceStart, typeInfo.nameSourceEnd - typeInfo.nameSourceStart + 1);
        this.typeDeclarationStarts[this.typeDepth] = typeInfo.declarationStart;
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbstractMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        if (this.typeDepth >= 0) {
            this.fMemberDeclarationStart[this.typeDepth] = fieldInfo.declarationStart;
            this.fMemberNameRange[this.typeDepth] = new SourceRange(fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd - fieldInfo.nameSourceStart + 1);
            this.fMemberName[this.typeDepth] = new String(fieldInfo.name);
        }
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbstractMethod(methodInfo);
    }

    private void enterAbstractMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        if (this.typeDepth >= 0) {
            this.fMemberName[this.typeDepth] = new String(methodInfo.name);
            this.fMemberNameRange[this.typeDepth] = new SourceRange(methodInfo.nameSourceStart, methodInfo.nameSourceEnd - methodInfo.nameSourceStart + 1);
            this.fMemberDeclarationStart[this.typeDepth] = methodInfo.declarationStart;
            this.fMethodParameterTypes[this.typeDepth] = methodInfo.parameterTypes;
            this.fMethodParameterNames[this.typeDepth] = methodInfo.parameterNames;
        }
    }

    public void exitType(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType, new SourceRange(this.typeDeclarationStarts[this.typeDepth], declarationEnd - this.typeDeclarationStarts[this.typeDepth] + 1), this.typeNameRanges[this.typeDepth]);
            --this.typeDepth;
        }
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        this.exitAbstractMethod(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType.getField(this.fMemberName[this.typeDepth]), new SourceRange(this.fMemberDeclarationStart[this.typeDepth], declarationEnd - this.fMemberDeclarationStart[this.typeDepth] + 1), this.fMemberNameRange[this.typeDepth]);
        }
    }

    public void exitInitializer(int declarationEnd) {
    }

    public void exitMethod(int declarationEnd, int defaultValueStart, int defaultValueEnd) {
        this.exitAbstractMethod(declarationEnd);
    }

    private void exitAbstractMethod(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            SourceRange sourceRange = new SourceRange(this.fMemberDeclarationStart[this.typeDepth], declarationEnd - this.fMemberDeclarationStart[this.typeDepth] + 1);
            IMethod method = currentType.getMethod(this.fMemberName[this.typeDepth], this.convertTypeNamesToSigs(this.fMethodParameterTypes[this.typeDepth]));
            this.setSourceRange(method, sourceRange, this.fMemberNameRange[this.typeDepth]);
            this.setMethodParameterNames(method, this.fMethodParameterNames[this.typeDepth]);
        }
    }

    public char[] findSource(IType type) {
        if (!type.isBinary()) {
            return null;
        }
        BinaryType parent = (BinaryType)type.getDeclaringType();
        BinaryType declType = (BinaryType)type;
        while (parent != null) {
            declType = parent;
            parent = (BinaryType)declType.getDeclaringType();
        }
        IBinaryType info = null;
        try {
            info = (IBinaryType)declType.getElementInfo();
        }
        catch (JavaModelException e) {
            return null;
        }
        String simpleSourceFileName = declType.sourceFileName(info);
        if (simpleSourceFileName == null) {
            return null;
        }
        return this.findSource(type, simpleSourceFileName);
    }

    public char[] findSource(IType type, String simpleSourceFileName) {
        long time = 0L;
        if (VERBOSE) {
            time = System.currentTimeMillis();
        }
        PackageFragment pkgFrag = (PackageFragment)type.getPackageFragment();
        String name = Util.concatWith(pkgFrag.names, simpleSourceFileName, '/');
        char[] source = null;
        if (!this.areRootPathsComputed) {
            this.computeAllRootPaths((IPackageFragmentRoot)type.getPackageFragment().getParent());
        }
        if (this.rootPath != null) {
            source = this.getSourceForRootPath(this.rootPath, name);
        }
        if (source == null && this.rootPaths != null) {
            Iterator iterator = this.rootPaths.iterator();
            while (iterator.hasNext()) {
                String currentRootPath = (String)iterator.next();
                if (currentRootPath.equals(this.rootPath) || (source = this.getSourceForRootPath(currentRootPath, name)) == null) continue;
                this.rootPath = currentRootPath;
                break;
            }
        }
        if (VERBOSE) {
            System.out.println("spent " + (System.currentTimeMillis() - time) + "ms for " + type.getElementName());
        }
        return source;
    }

    private char[] getSourceForRootPath(String currentRootPath, String name) {
        String newFullName = !currentRootPath.equals("") ? (currentRootPath.endsWith("/") ? String.valueOf(currentRootPath) + name : String.valueOf(currentRootPath) + '/' + name) : name;
        return this.findSource(newFullName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] findSource(String fullName) {
        char[] source;
        block11: {
            source = null;
            if (!org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block11;
            ZipEntry entry = null;
            ZipFile zip = null;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            try {
                try {
                    zip = manager.getZipFile(this.sourcePath);
                    entry = zip.getEntry(fullName);
                    if (entry != null) {
                        source = this.readSource(entry, zip);
                    }
                }
                catch (CoreException e) {
                    char[] cArray = null;
                    Object var7_14 = null;
                    manager.closeZipFile(zip);
                    return cArray;
                }
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                manager.closeZipFile(zip);
                throw throwable;
            }
            {
                Object var7_16 = null;
                manager.closeZipFile(zip);
                return source;
            }
        }
        Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
        if (target instanceof IResource) {
            if (!(target instanceof IContainer)) return source;
            IResource res = ((IContainer)target).findMember(fullName);
            if (!(res instanceof IFile)) return source;
            try {
                return Util.getResourceContentsAsCharArray((IFile)res);
            }
            catch (JavaModelException e) {
                return source;
            }
        }
        if (!(target instanceof File)) return source;
        File file = (File)target;
        if (!file.isDirectory()) return source;
        File sourceFile = new File(file, fullName);
        if (!sourceFile.isFile()) return source;
        try {
            return org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(sourceFile, this.encoding);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return source;
    }

    public SourceRange getNameRange(IJavaElement element) {
        SourceRange[] ranges;
        if (element.getElementType() == 9 && ((IMember)element).isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle((IMethod)element, false);
            element = el[1] != null && this.fSourceRanges.get(el[0]) == null ? this.getUnqualifiedMethodHandle((IMethod)element, true)[0] : el[0];
        }
        if ((ranges = (SourceRange[])this.fSourceRanges.get(element)) == null) {
            return fgUnknownRange;
        }
        return ranges[1];
    }

    public char[][] getMethodParameterNames(IMethod method) {
        char[][] parameterNames;
        if (method.isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle(method, false);
            method = el[1] != null && this.fParameterNames.get(el[0]) == null ? (IMethod)this.getUnqualifiedMethodHandle(method, true)[0] : (IMethod)el[0];
        }
        if ((parameterNames = (char[][])this.fParameterNames.get(method)) == null) {
            return null;
        }
        return parameterNames;
    }

    public SourceRange getSourceRange(IJavaElement element) {
        SourceRange[] ranges;
        if (element.getElementType() == 9 && ((IMember)element).isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle((IMethod)element, false);
            element = el[1] != null && this.fSourceRanges.get(el[0]) == null ? this.getUnqualifiedMethodHandle((IMethod)element, true)[0] : el[0];
        }
        if ((ranges = (SourceRange[])this.fSourceRanges.get(element)) == null) {
            return fgUnknownRange;
        }
        return ranges[0];
    }

    protected IType getType(String typeName) {
        if (typeName.length() == 0) {
            IJavaElement classFile = this.binaryType.getParent();
            String classFileName = classFile.getElementName();
            StringBuffer newClassFileName = new StringBuffer();
            int lastDollar = classFileName.lastIndexOf(36);
            int i = 0;
            while (i <= lastDollar) {
                newClassFileName.append(classFileName.charAt(i));
                ++i;
            }
            newClassFileName.append(Integer.toString(this.anonymousCounter));
            newClassFileName.append(SuffixConstants.SUFFIX_class);
            PackageFragment pkg = (PackageFragment)classFile.getParent();
            return new BinaryType(new ClassFile(pkg, newClassFileName.toString()), typeName);
        }
        if (this.binaryType.getElementName().equals(typeName)) {
            return this.binaryType;
        }
        return this.binaryType.getType(typeName);
    }

    protected IJavaElement[] getUnqualifiedMethodHandle(IMethod method, boolean noDollar) {
        boolean hasDollar = false;
        String[] qualifiedParameterTypes = method.getParameterTypes();
        String[] unqualifiedParameterTypes = new String[qualifiedParameterTypes.length];
        int i = 0;
        while (i < qualifiedParameterTypes.length) {
            StringBuffer unqualifiedName = new StringBuffer();
            String qualifiedName = qualifiedParameterTypes[i];
            int count = 0;
            while (qualifiedName.charAt(count) == '[') {
                unqualifiedName.append('[');
                ++count;
            }
            char currentChar = qualifiedName.charAt(count);
            if (currentChar == 'L' || currentChar == 'T') {
                unqualifiedName.append('Q');
                String simpleName = Signature.getSimpleName(qualifiedName.substring(count + 1));
                int lastDollar = simpleName.lastIndexOf(36);
                hasDollar |= lastDollar != -1;
                int start = noDollar ? lastDollar + 1 : 0;
                boolean sigStart = false;
                int j = start;
                int length = simpleName.length();
                while (j < length) {
                    char current = simpleName.charAt(j);
                    switch (current) {
                        case '+': 
                        case '-': 
                        case ';': 
                        case '<': {
                            unqualifiedName.append(current);
                            sigStart = true;
                            break;
                        }
                        default: {
                            if (sigStart) {
                                if (current == 'T') {
                                    unqualifiedName.append('Q');
                                } else {
                                    unqualifiedName.append(current);
                                }
                                sigStart = false;
                                break;
                            }
                            unqualifiedName.append(current);
                        }
                    }
                    ++j;
                }
            } else {
                unqualifiedName.append(qualifiedName.substring(count, qualifiedName.length()));
            }
            unqualifiedParameterTypes[i] = unqualifiedName.toString();
            ++i;
        }
        IJavaElement[] result = new IJavaElement[2];
        result[0] = ((IType)method.getParent()).getMethod(method.getElementName(), unqualifiedParameterTypes);
        if (hasDollar) {
            result[1] = result[0];
        }
        return result;
    }

    public void mapSource(IType type, char[] contents) {
        this.mapSource(type, contents, null);
    }

    public synchronized ISourceRange mapSource(IType type, char[] contents, IJavaElement elementToFind) {
        HashMap oldSourceRanges;
        block13: {
            this.binaryType = (BinaryType)type;
            if (this.fSourceRanges.get(type) != null) {
                return elementToFind != null ? this.getNameRange(elementToFind) : null;
            }
            this.importsTable.remove(this.binaryType);
            this.importsCounterTable.remove(this.binaryType);
            this.searchedElement = elementToFind;
            this.types = new IType[1];
            this.typeDeclarationStarts = new int[1];
            this.typeNameRanges = new SourceRange[1];
            this.typeDepth = -1;
            this.fMemberDeclarationStart = new int[1];
            this.fMemberName = new String[1];
            this.fMemberNameRange = new SourceRange[1];
            this.fMethodParameterTypes = new char[1][][];
            this.fMethodParameterNames = new char[1][][];
            this.anonymousCounter = 0;
            oldSourceRanges = (HashMap)this.fSourceRanges.clone();
            try {
                SourceRange range;
                DefaultProblemFactory factory = new DefaultProblemFactory();
                SourceElementParser parser = null;
                boolean isAnonymousClass = false;
                char[] fullName = null;
                this.anonymousClassName = 0;
                IBinaryType info = null;
                try {
                    info = (IBinaryType)this.binaryType.getElementInfo();
                    isAnonymousClass = info.isAnonymous();
                    fullName = info.getName();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                if (isAnonymousClass) {
                    String eltName = this.binaryType.getParent().getElementName();
                    eltName = eltName.substring(eltName.lastIndexOf(36) + 1, eltName.length());
                    try {
                        this.anonymousClassName = Integer.parseInt(eltName);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                boolean doFullParse = this.hasToRetrieveSourceRangesForLocalClass(fullName);
                parser = new SourceElementParser(this, factory, new CompilerOptions(this.options), doFullParse);
                IJavaElement javaElement = this.binaryType.getCompilationUnit();
                if (javaElement == null) {
                    javaElement = this.binaryType.getParent();
                }
                parser.parseCompilationUnit(new BasicCompilationUnit(contents, null, this.binaryType.sourceFileName(info), javaElement), doFullParse);
                if (elementToFind == null) break block13;
                SourceRange sourceRange = range = this.getNameRange(elementToFind);
                Object var13_18 = null;
                if (elementToFind != null) {
                    this.fSourceRanges = oldSourceRanges;
                }
                this.binaryType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                return sourceRange;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                if (elementToFind != null) {
                    this.fSourceRanges = oldSourceRanges;
                }
                this.binaryType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                throw throwable;
            }
        }
        ISourceRange iSourceRange = null;
        Object var13_19 = null;
        if (elementToFind != null) {
            this.fSourceRanges = oldSourceRanges;
        }
        this.binaryType = null;
        this.searchedElement = null;
        this.types = null;
        this.typeDeclarationStarts = null;
        this.typeNameRanges = null;
        this.typeDepth = -1;
        return iSourceRange;
    }

    private char[] readSource(ZipEntry entry, ZipFile zip) {
        try {
            byte[] bytes = org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(entry, zip);
            if (bytes != null) {
                return org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.bytesToChar(bytes, this.encoding);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected void setMethodParameterNames(IMethod method, char[][] parameterNames) {
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        this.fParameterNames.put(method, parameterNames);
    }

    protected void setSourceRange(IJavaElement element, SourceRange sourceRange, SourceRange nameRange) {
        this.fSourceRanges.put(element, new SourceRange[]{sourceRange, nameRange});
    }

    public char[][] getImports(BinaryType type) {
        char[][] imports = (char[][])this.importsTable.get(type);
        if (imports != null) {
            int importsCounter = (Integer)this.importsCounterTable.get(type);
            if (imports.length != importsCounter) {
                char[][] cArray = imports;
                imports = new char[importsCounter][];
                System.arraycopy(cArray, 0, imports, 0, importsCounter);
            }
            this.importsTable.put(type, imports);
        }
        return imports;
    }

    private boolean hasToRetrieveSourceRangesForLocalClass(char[] eltName) {
        if (eltName == null) {
            return false;
        }
        int length = eltName.length;
        int dollarIndex = CharOperation.indexOf('$', eltName, 0);
        while (dollarIndex != -1) {
            int nameStart = dollarIndex + 1;
            if (nameStart == length) {
                return false;
            }
            if (Character.isDigit(eltName[nameStart])) {
                return true;
            }
            dollarIndex = CharOperation.indexOf('$', eltName, nameStart);
        }
        return false;
    }
}

