/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.internal.tools.PointcutExpressionImpl;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.ThisOrTargetPointcut;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutPrimitives;

public class PointcutParser {
    private Set supportedPrimitives;

    public static Set getAllSupportedPointcutPrimitives() {
        HashSet<PointcutPrimitives> primitives = new HashSet<PointcutPrimitives>();
        primitives.add(PointcutPrimitives.ADVICE_EXECUTION);
        primitives.add(PointcutPrimitives.ARGS);
        primitives.add(PointcutPrimitives.CALL);
        primitives.add(PointcutPrimitives.EXECUTION);
        primitives.add(PointcutPrimitives.GET);
        primitives.add(PointcutPrimitives.HANDLER);
        primitives.add(PointcutPrimitives.INITIALIZATION);
        primitives.add(PointcutPrimitives.PRE_INITIALIZATION);
        primitives.add(PointcutPrimitives.SET);
        primitives.add(PointcutPrimitives.STATIC_INITIALIZATION);
        primitives.add(PointcutPrimitives.TARGET);
        primitives.add(PointcutPrimitives.THIS);
        primitives.add(PointcutPrimitives.WITHIN);
        primitives.add(PointcutPrimitives.WITHIN_CODE);
        return primitives;
    }

    public PointcutParser() {
        this.supportedPrimitives = PointcutParser.getAllSupportedPointcutPrimitives();
    }

    public PointcutParser(Set supportedPointcutKinds) {
        this.supportedPrimitives = supportedPointcutKinds;
        Iterator iter = supportedPointcutKinds.iterator();
        while (iter.hasNext()) {
            PointcutPrimitives element = (PointcutPrimitives)iter.next();
            if (element != PointcutPrimitives.IF && element != PointcutPrimitives.CFLOW && element != PointcutPrimitives.CFLOW_BELOW) continue;
            throw new UnsupportedOperationException("Cannot handle if, cflow, and cflowbelow primitives");
        }
    }

    public PointcutExpression parsePointcutExpression(String expression) throws UnsupportedOperationException, IllegalArgumentException {
        PointcutExpressionImpl pcExpr = null;
        try {
            Pointcut pc = new PatternParser(expression).parsePointcut();
            this.validateAgainstSupportedPrimitives(pc);
            pc.resolve();
            pcExpr = new PointcutExpressionImpl(pc, expression);
        }
        catch (ParserException pEx) {
            throw new IllegalArgumentException(pEx.getMessage());
        }
        return pcExpr;
    }

    Set getSupportedPrimitives() {
        return this.supportedPrimitives;
    }

    private void validateAgainstSupportedPrimitives(Pointcut pc) {
        switch (pc.getPointcutKind()) {
            case 5: {
                this.validateAgainstSupportedPrimitives(((AndPointcut)pc).getLeft());
                this.validateAgainstSupportedPrimitives(((AndPointcut)pc).getRight());
                break;
            }
            case 4: {
                if (this.supportedPrimitives.contains(PointcutPrimitives.ARGS)) break;
                throw new UnsupportedOperationException("args is not supported by this parser");
            }
            case 10: {
                throw new UnsupportedOperationException("cflow and cflowbelow are not supported by this parser");
            }
            case 13: {
                if (this.supportedPrimitives.contains(PointcutPrimitives.HANDLER)) break;
                throw new UnsupportedOperationException("handler is not supported by this parser");
            }
            case 9: 
            case 14: 
            case 15: {
                throw new UnsupportedOperationException("if is not supported by this parser");
            }
            case 1: {
                this.validateKindedPointcut((KindedPointcut)pc);
                break;
            }
            case 7: {
                this.validateAgainstSupportedPrimitives(((NotPointcut)pc).getNegatedPointcut());
                break;
            }
            case 6: {
                this.validateAgainstSupportedPrimitives(((OrPointcut)pc).getLeft());
                this.validateAgainstSupportedPrimitives(((OrPointcut)pc).getRight());
                break;
            }
            case 8: {
                throw new UnsupportedOperationException("if pointcuts and reference pointcuts are not supported by this parser");
            }
            case 3: {
                boolean isThis = ((ThisOrTargetPointcut)pc).isThis();
                if (isThis && !this.supportedPrimitives.contains(PointcutPrimitives.THIS)) {
                    throw new UnsupportedOperationException("this is not supported by this parser");
                }
                if (this.supportedPrimitives.contains(PointcutPrimitives.TARGET)) break;
                throw new UnsupportedOperationException("target is not supported by this parser");
            }
            case 2: {
                if (this.supportedPrimitives.contains(PointcutPrimitives.WITHIN)) break;
                throw new UnsupportedOperationException("within is not supported by this parser");
            }
            case 12: {
                if (this.supportedPrimitives.contains(PointcutPrimitives.WITHIN_CODE)) break;
                throw new UnsupportedOperationException("withincode is not supported by this parser");
            }
            default: {
                throw new UnsupportedOperationException("Unknown pointcut kind: " + pc.getPointcutKind());
            }
        }
    }

    private void validateKindedPointcut(KindedPointcut pc) {
        Shadow.Kind kind = pc.getKind();
        if (kind == Shadow.MethodCall || kind == Shadow.ConstructorCall) {
            if (!this.supportedPrimitives.contains(PointcutPrimitives.CALL)) {
                throw new UnsupportedOperationException("call is not supported by this parser");
            }
        } else if (kind == Shadow.MethodExecution || kind == Shadow.ConstructorExecution) {
            if (!this.supportedPrimitives.contains(PointcutPrimitives.EXECUTION)) {
                throw new UnsupportedOperationException("execution is not supported by this parser");
            }
        } else if (kind == Shadow.AdviceExecution) {
            if (!this.supportedPrimitives.contains(PointcutPrimitives.ADVICE_EXECUTION)) {
                throw new UnsupportedOperationException("adviceexecution is not supported by this parser");
            }
        } else if (kind == Shadow.FieldGet) {
            if (!this.supportedPrimitives.contains(PointcutPrimitives.GET)) {
                throw new UnsupportedOperationException("get is not supported by this parser");
            }
        } else if (kind == Shadow.FieldSet) {
            if (!this.supportedPrimitives.contains(PointcutPrimitives.SET)) {
                throw new UnsupportedOperationException("set is not supported by this parser");
            }
        } else if (kind == Shadow.Initialization) {
            if (!this.supportedPrimitives.contains(PointcutPrimitives.INITIALIZATION)) {
                throw new UnsupportedOperationException("initialization is not supported by this parser");
            }
        } else if (kind == Shadow.PreInitialization) {
            if (!this.supportedPrimitives.contains(PointcutPrimitives.PRE_INITIALIZATION)) {
                throw new UnsupportedOperationException("preinitialization is not supported by this parser");
            }
        } else if (kind == Shadow.StaticInitialization && !this.supportedPrimitives.contains(PointcutPrimitives.STATIC_INITIALIZATION)) {
            throw new UnsupportedOperationException("staticinitialization is not supported by this parser");
        }
    }
}

