/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.Relationship;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AJInjarElement;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;

public class AJProjectModel {
    private static final int MODEL_VERSION = 101;
    private static final String MODEL_FILE = ".elementMap";
    IProject project;
    private Map ipeToije = new HashMap();
    private Map jeLinkNames = new HashMap();
    private Map[] perRelMaps = new Map[]{new HashMap(), new HashMap()};
    private Map kindMap = new HashMap();
    private Map extraChildren = new HashMap();
    private Set hasRuntime = new HashSet();
    private Map lineNumbers = new HashMap();
    private Persistence persistence;
    private int relsCount;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    public AJProjectModel(IProject project) {
        this.project = project;
        this.kindMap.put("advises", AJRelationshipManager.ADVISES);
        this.kindMap.put("advised by", AJRelationshipManager.ADVISED_BY);
        this.kindMap.put("declared on", AJRelationshipManager.DECLARED_ON);
        this.kindMap.put("aspect declarations", AJRelationshipManager.ASPECT_DECLARATIONS);
        this.kindMap.put("matched by", AJRelationshipManager.MATCHED_BY);
        this.kindMap.put("matches declare", AJRelationshipManager.MATCHES_DECLARE);
        this.kindMap.put("annotates", AJRelationshipManager.ANNOTATES);
        this.kindMap.put("annotated by", AJRelationshipManager.ANNOTATED_BY);
        this.kindMap.put("softens", AJRelationshipManager.SOFTENS);
        this.kindMap.put("softened by", AJRelationshipManager.SOFTENED_BY);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        return (IJavaElement)this.ipeToije.get(ipe);
    }

    private Persistence getPersistence() {
        if (this.persistence == null) {
            this.persistence = new Persistence();
        }
        return this.persistence;
    }

    public void saveModel() {
        this.getPersistence().saveModel();
    }

    public void loadModel() {
        if (!this.getPersistence().isPersisted()) {
            return;
        }
        AJLog.logStart("Load serialized element map");
        boolean worked = this.getPersistence().loadModel();
        AJLog.logEnd("Load serialized element map", String.valueOf(this.relsCount) + " rels in project: " + this.project.getName());
        if (!worked && this.getPersistence().isPersisted()) {
            AJLog.log("Loading model failed for project: " + this.project.getName());
        }
    }

    public List getRelatedElements(AJRelationshipType rel, IJavaElement je) {
        Map relMap1 = (Map)this.perRelMaps[0].get(rel);
        Map relMap2 = (Map)this.perRelMaps[1].get(rel);
        List l1 = null;
        List l2 = null;
        if (relMap1 != null) {
            l1 = (List)relMap1.get(je);
        }
        if (relMap2 != null) {
            l2 = (List)relMap2.get(je);
        }
        if (l1 == null && l2 == null) {
            return null;
        }
        if (l2 == null) {
            return l1;
        }
        if (l1 == null) {
            return l2;
        }
        ArrayList combined = new ArrayList(l1);
        combined.addAll(l2);
        return combined;
    }

    public List getAllRelationships(AJRelationshipType[] rels) {
        ArrayList<AJRelationship> allRels = new ArrayList<AJRelationship>();
        int i = 0;
        while (i < rels.length) {
            int j = 0;
            while (j <= 1) {
                Map relMap = (Map)this.perRelMaps[j].get(rels[i]);
                if (relMap != null) {
                    Iterator iter = relMap.keySet().iterator();
                    while (iter.hasNext()) {
                        IJavaElement source = (IJavaElement)iter.next();
                        List targetList = (List)relMap.get(source);
                        Iterator iter2 = targetList.iterator();
                        while (iter2.hasNext()) {
                            IJavaElement target = (IJavaElement)iter2.next();
                            allRels.add(new AJRelationship(source, rels[i], target, j == 0));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return allRels;
    }

    public boolean isAdvised(IJavaElement je) {
        List advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, je);
        if (advisedBy != null && advisedBy.size() > 0) {
            return true;
        }
        List extras = this.getExtraChildren(je);
        if (extras != null) {
            Iterator iter = extras.iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, element);
                if (advisedBy == null || advisedBy.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRuntimeTest(IJavaElement je) {
        return this.hasRuntime.contains(je);
    }

    public int getJavaElementLineNumber(IJavaElement je) {
        Integer i = (Integer)this.lineNumbers.get(je);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public String getJavaElementLinkName(IJavaElement je) {
        return (String)this.jeLinkNames.get(je);
    }

    public List getExtraChildren(IJavaElement je) {
        return (List)this.extraChildren.get(je);
    }

    public void createProjectMap() {
        AJLog.logStart("Create element map");
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFolder) {
                        return true;
                    }
                    if (resource instanceof IFile) {
                        IFile f = (IFile)resource;
                        if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(f.getName())) {
                            AJProjectModel.this.createMapForFile(f);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        this.processRelationships();
        AJLog.logEnd("Create element map", String.valueOf(this.relsCount) + " rels in project: " + this.project.getName());
    }

    private void processRelationships() {
        this.relsCount = 0;
        IRelationshipMap asmRelMap = AsmManager.getDefault().getRelationshipMap();
        Iterator iter = asmRelMap.getEntries().iterator();
        while (iter.hasNext()) {
            String sourceOfRelationship = (String)iter.next();
            IProgramElement ipe = AsmManager.getDefault().getHierarchy().findElementForHandle(sourceOfRelationship);
            List relationships = asmRelMap.get(ipe);
            if (relationships == null) continue;
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                Relationship rel = (Relationship)iterator.next();
                List targets = rel.getTargets();
                Iterator iterator2 = targets.iterator();
                while (iterator2.hasNext()) {
                    ArrayList<IJavaElement> l;
                    Map perRelMap;
                    HashMap<IJavaElement, ArrayList<IJavaElement>> relMap;
                    AJRelationshipType ajRel;
                    String t = (String)iterator2.next();
                    IProgramElement link = AsmManager.getDefault().getHierarchy().findElementForHandle(t);
                    IJavaElement sourceEl = (IJavaElement)this.ipeToije.get(ipe);
                    IJavaElement targetEl = (IJavaElement)this.ipeToije.get(link);
                    if (targetEl == null && link.getParent() == null) {
                        String name = "injar aspect: " + link.getName();
                        targetEl = new AJInjarElement("injar aspect: " + link.getName());
                        this.jeLinkNames.put(targetEl, name);
                        this.lineNumbers.put(targetEl, new Integer(0));
                    }
                    if ((ajRel = (AJRelationshipType)this.kindMap.get(rel.getName())) == null || sourceEl == null || targetEl == null) continue;
                    if (sourceEl instanceof AdviceElement && rel.hasRuntimeTest()) {
                        this.hasRuntime.add(sourceEl);
                    }
                    if ((relMap = (HashMap<IJavaElement, ArrayList<IJavaElement>>)(perRelMap = rel.hasRuntimeTest() ? this.perRelMaps[0] : this.perRelMaps[1]).get(ajRel)) == null) {
                        relMap = new HashMap<IJavaElement, ArrayList<IJavaElement>>();
                        perRelMap.put(ajRel, relMap);
                    }
                    if ((l = (ArrayList<IJavaElement>)relMap.get(sourceEl)) == null) {
                        l = new ArrayList<IJavaElement>();
                        relMap.put(sourceEl, l);
                    }
                    l.add(targetEl);
                    ++this.relsCount;
                }
            }
        }
    }

    private void createMapForFile(IFile file) {
        IProject project = file.getProject();
        if (project == null || !project.isOpen() || !AspectJPlugin.isAJProject(project)) {
            return;
        }
        String path = file.getRawLocation().toOSString();
        HashMap annotationsMap = AsmManager.getDefault().getInlineAnnotations(path, true, true);
        if (annotationsMap == null) {
            return;
        }
        AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(file);
        if (unit == null && file.getName().endsWith(".java")) {
            unit = JavaCore.createCompilationUnitFrom((IFile)file);
        }
        if (unit == null) {
            return;
        }
        if (unit instanceof AJCompilationUnit) {
            try {
                unit.reconcile(0, false, null, null);
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_2, ajc$tjp_3);
            }
        }
        Set keys = annotationsMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            List annotations = (List)annotationsMap.get(key);
            Iterator it2 = annotations.iterator();
            while (it2.hasNext()) {
                IProgramElement node = (IProgramElement)it2.next();
                ISourceLocation sl = node.getSourceLocation();
                int fff = 0;
                String declare = "declare ";
                if (node.toLinkLabelString().indexOf(declare) != -1) {
                    fff = declare.length();
                }
                boolean subElement = false;
                int offset = sl.getOffset();
                if (offset == 0) {
                    subElement = true;
                    offset = node.getParent().getSourceLocation().getOffset();
                }
                try {
                    IJavaElement el = unit.getElementAt(offset + fff);
                    if (subElement) {
                        IJavaElement parent = el;
                        el = new AJCodeElement((JavaElement)parent, sl.getLine(), node.toLabelString());
                        ArrayList<IJavaElement> l = (ArrayList<IJavaElement>)this.extraChildren.get(parent);
                        if (l == null) {
                            l = new ArrayList<IJavaElement>();
                            this.extraChildren.put(parent, l);
                        }
                        l.add(el);
                    }
                    if (el == null) continue;
                    this.ipeToije.put(node, el);
                    this.jeLinkNames.put(el, node.toLinkLabelString());
                    this.lineNumbers.put(el, new Integer(sl.getLine()));
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException3 = javaModelException;
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_4, ajc$tjp_3);
                }
            }
        }
    }

    private void dumpModel() {
        System.out.println("AJDT model for project: " + this.project.getName());
        Iterator iter = this.kindMap.keySet().iterator();
        while (iter.hasNext()) {
            String kind = (String)iter.next();
            AJRelationshipType rel = (AJRelationshipType)this.kindMap.get(kind);
            int i = 0;
            while (i <= 1) {
                Map relMap = (Map)this.perRelMaps[i].get(rel);
                if (relMap != null) {
                    Iterator iter2 = relMap.keySet().iterator();
                    while (iter2.hasNext()) {
                        IJavaElement je = (IJavaElement)iter2.next();
                        List related = (List)relMap.get(je);
                        Iterator iter3 = related.iterator();
                        while (iter3.hasNext()) {
                            IJavaElement el = (IJavaElement)iter3.next();
                            System.out.println("    " + this.getJavaElementLinkName(je) + " --" + kind + "-> " + this.getJavaElementLinkName(el));
                            System.out.println("    " + je.hashCode() + " --" + kind + "-> " + el.hashCode());
                            System.out.println("    " + je.getHandleIdentifier() + " --" + kind + "-> " + el.getHandleIdentifier());
                        }
                    }
                }
                ++i;
            }
        }
        System.out.println("End of model");
    }

    static {
        Factory factory = new Factory("AJProjectModel.java", Class.forName("org.eclipse.ajdt.core.model.AJProjectModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.core.runtime.CoreException-<missing>-"), 261);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createProjectMap-org.eclipse.ajdt.core.model.AJProjectModel----void-"), 244);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.jdt.core.JavaModelException-<missing>-"), 394);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createMapForFile-org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.core.resources.IFile:-file:--void-"), 353);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.jdt.core.JavaModelException-<missing>-"), 450);
    }

    private class Persistence {
        private static final int RUNTIME_OFFSET = 100;
        private Map idMap;
        private int idCount;
        private List elementList;
        private AJRelationshipType[] relTypes = new AJRelationshipType[]{AJRelationshipManager.ADVISES, AJRelationshipManager.ADVISED_BY, AJRelationshipManager.DECLARED_ON, AJRelationshipManager.ASPECT_DECLARATIONS, AJRelationshipManager.MATCHED_BY, AJRelationshipManager.MATCHES_DECLARE, AJRelationshipManager.ANNOTATES, AJRelationshipManager.ANNOTATED_BY, AJRelationshipManager.SOFTENS, AJRelationshipManager.SOFTENED_BY};
        private Map relIDs = new HashMap();
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;
        private static final JoinPoint.StaticPart ajc$tjp_4;
        private static final JoinPoint.StaticPart ajc$tjp_5;
        private static final JoinPoint.StaticPart ajc$tjp_6;

        public Persistence() {
            int i = 0;
            while (i < this.relTypes.length) {
                this.relIDs.put(this.relTypes[i], new Integer(i));
                ++i;
            }
        }

        public boolean isPersisted() {
            File modelFile = new File(this.getFileName());
            return modelFile.exists();
        }

        private String getFileName() {
            return AspectJPlugin.getDefault().getStateLocation().append(String.valueOf(AJProjectModel.this.project.getName()) + AJProjectModel.MODEL_FILE).toOSString();
        }

        public void saveModel() {
            String filename = this.getFileName();
            try {
                FileOutputStream fos = new FileOutputStream(filename);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                this.saveVersion(oos);
                this.saveJavaElements(oos);
                this.saveRelationships(oos);
                this.saveExtraChildren(oos);
                oos.flush();
                fos.flush();
                oos.close();
                fos.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(fileNotFoundException2, this, ajc$tjp_0, ajc$tjp_1);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException2, this, ajc$tjp_2, ajc$tjp_1);
            }
        }

        public boolean loadModel() {
            if (!this.isPersisted()) {
                return false;
            }
            this.getFileName();
            try {
                FileInputStream fis = new FileInputStream(this.getFileName());
                ObjectInputStream ois = new ObjectInputStream(fis);
                int version = this.loadVersion(ois);
                if (version == 101) {
                    this.loadJavaElements(ois);
                    this.loadRelationships(ois);
                    this.loadExtraChildren(ois);
                }
                ois.close();
                fis.close();
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, this, ajc$tjp_3, ajc$tjp_4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(fileNotFoundException2, this, ajc$tjp_5, ajc$tjp_4);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException2, this, ajc$tjp_6, ajc$tjp_4);
            }
            return false;
        }

        private int getID(IJavaElement el) {
            return (Integer)this.idMap.get(el);
        }

        void saveVersion(ObjectOutputStream oos) throws IOException {
            oos.writeInt(101);
        }

        int loadVersion(ObjectInputStream ois) throws IOException {
            return ois.readInt();
        }

        void saveJavaElements(ObjectOutputStream oos) throws IOException {
            this.idMap = new HashMap();
            this.idCount = 0;
            int numElements = AJProjectModel.this.lineNumbers.keySet().size();
            oos.writeInt(numElements);
            Iterator iter = AJProjectModel.this.lineNumbers.keySet().iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                this.idMap.put(element, new Integer(this.idCount++));
                String handleIdentifier = element.getHandleIdentifier().intern();
                oos.writeObject(handleIdentifier);
                String linkName = (String)AJProjectModel.this.jeLinkNames.get(element);
                oos.writeObject(linkName);
                Integer lineNum = (Integer)AJProjectModel.this.lineNumbers.get(element);
                oos.writeInt(lineNum);
            }
        }

        void loadJavaElements(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            int numElements = ois.readInt();
            this.elementList = new ArrayList(numElements);
            int i = 0;
            while (i < numElements) {
                String handleIdentifier = (String)ois.readObject();
                IJavaElement element = AspectJCore.create(handleIdentifier);
                this.elementList.add(element);
                String linkName = (String)ois.readObject();
                AJProjectModel.this.jeLinkNames.put(element, linkName);
                Integer lineNum = new Integer(ois.readInt());
                AJProjectModel.this.lineNumbers.put(element, lineNum);
                ++i;
            }
        }

        private int encodeRelType(AJRelationshipType rel, boolean hasRuntimeTest) {
            int id = (Integer)this.relIDs.get(rel);
            if (hasRuntimeTest) {
                id += 100;
            }
            return id;
        }

        private AJRelationshipType decodeRelType(int id) {
            if (id >= 100) {
                id -= 100;
            }
            return this.relTypes[id];
        }

        private boolean hasRuntimeTest(int id) {
            return id >= 100;
        }

        void saveRelationships(ObjectOutputStream oos) throws IOException {
            Map relMap;
            int i;
            AJRelationshipType rel;
            int numRelTypes = 0;
            Iterator iter = AJProjectModel.this.kindMap.values().iterator();
            while (iter.hasNext()) {
                rel = (AJRelationshipType)iter.next();
                i = 0;
                while (i <= 1) {
                    relMap = (Map)AJProjectModel.this.perRelMaps[i].get(rel);
                    if (relMap != null) {
                        ++numRelTypes;
                    }
                    ++i;
                }
            }
            oos.writeInt(numRelTypes);
            iter = AJProjectModel.this.kindMap.values().iterator();
            while (iter.hasNext()) {
                rel = (AJRelationshipType)iter.next();
                i = 0;
                while (i <= 1) {
                    relMap = (Map)AJProjectModel.this.perRelMaps[i].get(rel);
                    if (relMap != null) {
                        oos.writeInt(this.encodeRelType(rel, i == 0));
                        oos.writeInt(relMap.size());
                        Iterator iter2 = relMap.keySet().iterator();
                        while (iter2.hasNext()) {
                            IJavaElement source = (IJavaElement)iter2.next();
                            oos.writeInt(this.getID(source));
                            List targetList = (List)relMap.get(source);
                            oos.writeInt(targetList.size());
                            Iterator iter3 = targetList.iterator();
                            while (iter3.hasNext()) {
                                IJavaElement target = (IJavaElement)iter3.next();
                                oos.writeInt(this.getID(target));
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        void loadRelationships(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            AJProjectModel.this.relsCount = 0;
            int numRelTypes = ois.readInt();
            int i = 0;
            while (i < numRelTypes) {
                int relType = ois.readInt();
                int numRels = ois.readInt();
                AJRelationshipType ajRel = this.decodeRelType(relType);
                this.hasRuntimeTest(relType);
                Map perRelMap = this.hasRuntimeTest(relType) ? AJProjectModel.this.perRelMaps[0] : AJProjectModel.this.perRelMaps[1];
                HashMap relMap = (HashMap)perRelMap.get(ajRel);
                if (relMap == null) {
                    relMap = new HashMap();
                    perRelMap.put(ajRel, relMap);
                }
                int j = 0;
                while (j < numRels) {
                    ArrayList<IJavaElement> l;
                    int sourceID = ois.readInt();
                    IJavaElement sourceEl = (IJavaElement)this.elementList.get(sourceID);
                    if (this.hasRuntimeTest(relType)) {
                        AJProjectModel.this.hasRuntime.add(sourceEl);
                    }
                    if ((l = (ArrayList<IJavaElement>)relMap.get(sourceEl)) == null) {
                        l = new ArrayList<IJavaElement>();
                        relMap.put(sourceEl, l);
                    }
                    int numTargets = ois.readInt();
                    int k = 0;
                    while (k < numTargets) {
                        int targetID = ois.readInt();
                        IJavaElement targetEl = (IJavaElement)this.elementList.get(targetID);
                        l.add(targetEl);
                        AJProjectModel aJProjectModel = AJProjectModel.this;
                        aJProjectModel.relsCount = aJProjectModel.relsCount + 1;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }

        void saveExtraChildren(ObjectOutputStream oos) throws IOException {
            int numParents = AJProjectModel.this.extraChildren.size();
            oos.writeInt(numParents);
            Iterator iter = AJProjectModel.this.extraChildren.keySet().iterator();
            while (iter.hasNext()) {
                IJavaElement parent = (IJavaElement)iter.next();
                oos.writeObject(parent.getHandleIdentifier());
                List children = (List)AJProjectModel.this.extraChildren.get(parent);
                oos.writeInt(children.size());
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    IJavaElement child = (IJavaElement)iterator.next();
                    oos.writeInt(this.getID(child));
                }
            }
        }

        void loadExtraChildren(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            int numParents = ois.readInt();
            int i = 0;
            while (i < numParents) {
                String parentHandle = (String)ois.readObject();
                IJavaElement parent = AspectJCore.create(parentHandle);
                int numChildren = ois.readInt();
                ArrayList<IJavaElement> children = new ArrayList<IJavaElement>(numChildren);
                int j = 0;
                while (j < numChildren) {
                    int childID = ois.readInt();
                    IJavaElement je = (IJavaElement)this.elementList.get(childID);
                    children.add(je);
                    ++j;
                }
                AJProjectModel.this.extraChildren.put(parent, children);
                ++i;
            }
        }

        static {
            Factory factory = new Factory("AJProjectModel.java", Class.forName("org.eclipse.ajdt.core.model.AJProjectModel$Persistence"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.FileNotFoundException-<missing>-"), 544);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-saveModel-org.eclipse.ajdt.core.model.AJProjectModel$Persistence----void-"), 530);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.IOException-<missing>-"), 545);
            ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.lang.ClassNotFoundException-<missing>-"), 569);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-loadModel-org.eclipse.ajdt.core.model.AJProjectModel$Persistence----boolean-"), 551);
            ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.FileNotFoundException-<missing>-"), 570);
            ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.IOException-<missing>-"), 571);
        }
    }
}

