/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.ajdt.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.IBuildObject;

public class BuildUndoManager
extends ModelUndoManager {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    public BuildUndoManager(PDEFormEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    protected String getPageId(Object obj) {
        if (obj instanceof IBuildEntry) {
            return "build";
        }
        return null;
    }

    protected void execute(IModelChangedEvent event, boolean undo) {
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        IBuildModel model = (IBuildModel)event.getChangeProvider();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(model, elements);
                    break;
                }
                this.executeAdd(model, elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(model, elements);
                    break;
                }
                this.executeRemove(model, elements);
                break;
            }
            case 3: {
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(IBuildModel model, Object[] elements) {
        IBuild build = model.getBuild();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof IBuildEntry) {
                    build.add((IBuildEntry)element);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    private void executeRemove(IBuildModel model, Object[] elements) {
        IBuild build = model.getBuild();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof IBuildEntry) {
                    build.remove((IBuildEntry)element);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        if (element instanceof BuildObject) {
            BuildObject bobj = (BuildObject)element;
            try {
                bobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_4, ajc$tjp_5);
            }
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        IBuildObject bobj;
        Object obj;
        if (event.getChangeType() == 3 && (obj = event.getChangedObjects()[0]) instanceof IBuildObject && !((bobj = (IBuildObject)event.getChangedObjects()[0]) instanceof IBuild) && !bobj.isInTheModel()) {
            return;
        }
        super.modelChanged(event);
    }

    static {
        Factory factory = new Factory("BuildUndoManager.java", Class.forName("org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager-org.eclipse.core.runtime.CoreException-<missing>-"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-executeAdd-org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager-org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel:[Ljava.lang.Object;:-model:elements:--void-"), 72);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager-org.eclipse.core.runtime.CoreException-<missing>-"), 97);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-executeRemove-org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager-org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel:[Ljava.lang.Object;:-model:elements:--void-"), 87);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager-org.eclipse.core.runtime.CoreException-<missing>-"), 110);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-executeChange-org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager-java.lang.Object:java.lang.String:java.lang.Object:java.lang.Object:-element:propertyName:oldValue:newValue:--void-"), 106);
    }
}

