/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.menu;

import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.menu.AddBuildConfigurationAction;
import org.eclipse.ajdt.buildconfigurator.menu.BuildConfigurationSelectedAction;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class DynamicBuildConfigurationMenu
extends MenuManager
implements IBuildConfigurationChangedListener {
    BuildConfigurator buildconf;
    IContributionItem separator = new Separator();
    private ImageDescriptor id = AspectJImages.BC_TICK.getImageDescriptor();

    public DynamicBuildConfigurationMenu(String menuID) {
        super(AspectJUIPlugin.getResourceString("BCLabels.ConfigurationSelectionMenu"), menuID);
        this.buildconf = BuildConfigurator.getBuildConfigurator();
        this.buildconf.addBuildConfigurationChangedListener(this);
        AddBuildConfigurationAction addAction = new AddBuildConfigurationAction();
        addAction.setEnabled(false);
        this.add((IAction)addAction);
    }

    public void buildConfigurationChanged(final ProjectBuildConfigurator pbc) {
        UIJob job = new UIJob("BuildConfiguration update build menu"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                new AddBuildConfigurationAction();
                DynamicBuildConfigurationMenu.this.rebuildMenu(pbc);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    private void rebuildMenu(ProjectBuildConfigurator pbc) {
        AddBuildConfigurationAction addAction = new AddBuildConfigurationAction();
        if (pbc == null) {
            this.removeAll();
            this.setVisible(true);
            addAction.setEnabled(false);
            this.add(this.separator);
            this.add((IAction)addAction);
            return;
        }
        Util.Comparable[] bcs = pbc.getBuildConfigurations().toArray(new BuildConfiguration[0]);
        Util.sort((Util.Comparable[])bcs);
        final BuildConfiguration activeBuildConfiguration = pbc.getActiveBuildConfiguration();
        final BuildConfiguration[] bcs2 = new BuildConfiguration[bcs.length];
        System.arraycopy(bcs, 0, bcs2, 0, bcs.length);
        Display.getDefault().asyncExec(new Runnable((IAction)addAction){
            private final /* synthetic */ IAction val$addAction;
            {
                this.val$addAction = iAction;
            }

            public void run() {
                DynamicBuildConfigurationMenu.this.removeAll();
                int i = 0;
                while (i < bcs2.length) {
                    BuildConfigurationSelectedAction act = new BuildConfigurationSelectedAction(bcs2[i]);
                    if (bcs2[i] == activeBuildConfiguration) {
                        act.setImageDescriptor(DynamicBuildConfigurationMenu.this.id);
                    }
                    DynamicBuildConfigurationMenu.this.add((IAction)act);
                    ++i;
                }
                DynamicBuildConfigurationMenu.this.add(DynamicBuildConfigurationMenu.this.separator);
                DynamicBuildConfigurationMenu.this.add(this.val$addAction);
                DynamicBuildConfigurationMenu.this.setVisible(true);
            }
        });
    }

    public boolean isDynamic() {
        return true;
    }
}

