/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.internal.builder.BuilderUtils;
import org.eclipse.ajdt.internal.ui.dialogs.AJCUTypeInfo;
import org.eclipse.ajdt.internal.ui.dialogs.AJTypeInfoLabelProvider;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class TypeSelectionDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fElementKinds;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;

    public TypeSelectionDialog(Shell parent, IRunnableContext context, int elementKinds, IJavaSearchScope scope) {
        super(parent, (ILabelProvider)new AJTypeInfoLabelProvider(16), (ILabelProvider)new AJTypeInfoLabelProvider(40));
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)scope);
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKinds = elementKinds;
        this.setUpperListLabel(JavaUIMessages.getString((String)"TypeSelectionDialog.upperLabel"));
        this.setLowerListLabel(JavaUIMessages.getString((String)"TypeSelectionDialog.lowerLabel"));
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        this.fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)new TypeFilterMatcher());
        this.fFilteredList.setComparator((Comparator)new StringComparator());
        return list;
    }

    public int open() {
        final ArrayList typeList = new ArrayList();
        try {
            if (this.isCacheUpToDate()) {
                AllTypesCache.getTypes((IJavaSearchScope)this.fScope, (int)this.fElementKinds, null, typeList);
            } else {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        AllTypesCache.getTypes((IJavaSearchScope)TypeSelectionDialog.this.fScope, (int)TypeSelectionDialog.this.fElementKinds, (IProgressMonitor)monitor, (Collection)typeList);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                };
                this.fRunnableContext.run(true, true, runnable);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            InvocationTargetException e = invocationTargetException2;
            ExceptionHandler.handle((InvocationTargetException)e, (String)JavaUIMessages.getString((String)"TypeSelectionDialog.error3Title"), (String)JavaUIMessages.getString((String)"TypeSelectionDialog.error3Message"));
            return 1;
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_2, ajc$tjp_1);
            return 1;
        }
        typeList.addAll(this.getAspectJTypes(this.fScope));
        if (typeList.isEmpty()) {
            String title = JavaUIMessages.getString((String)"TypeSelectionDialog.notypes.title");
            String message = JavaUIMessages.getString((String)"TypeSelectionDialog.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        Object[] typeRefs = typeList.toArray(new TypeInfo[typeList.size()]);
        this.setElements(typeRefs);
        return super.open();
    }

    private List getAspectJTypes(IJavaSearchScope scope) {
        ArrayList<AJCUTypeInfo> ajTypes = new ArrayList<AJCUTypeInfo>();
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IJavaProject jp;
                if (projects[i].hasNature("org.eclipse.ajdt.ui.ajnature") && (jp = JavaCore.create((IProject)projects[i])) != null) {
                    IPath[] paths = scope.enclosingProjectsAndJars();
                    int a = 0;
                    while (a < paths.length) {
                        if (paths[a].equals((Object)jp.getPath())) {
                            List ajCus = AJCompilationUnitManager.INSTANCE.getAJCompilationUnits(jp);
                            Iterator iter = ajCus.iterator();
                            while (iter.hasNext()) {
                                AJCompilationUnit unit = (AJCompilationUnit)iter.next();
                                IType[] types = unit.getAllTypes();
                                int j = 0;
                                while (j < types.length) {
                                    if (types[j] instanceof AspectElement) {
                                        char[][] enclosingTypes = BuilderUtils.getEnclosingTypes(types[j]);
                                        AJCUTypeInfo info = new AJCUTypeInfo(types[j].getPackageFragment().getElementName(), types[j].getElementName(), enclosingTypes, types[j].isInterface(), types[j] instanceof AspectElement, jp.getElementName(), unit.getPackageFragmentRoot().getElementName(), unit.getElementName().substring(0, unit.getElementName().lastIndexOf(46)), "aj", (IJavaElement)unit);
                                        ajTypes.add(info);
                                    }
                                    ++j;
                                }
                            }
                        }
                        ++a;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_3, ajc$tjp_4);
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_5, ajc$tjp_4);
            }
            ++i;
        }
        return ajTypes;
    }

    protected void computeResult() {
        TypeInfo ref = (TypeInfo)this.getLowerSelectedElement();
        if (ref == null) {
            return;
        }
        try {
            IType type = ref.resolveType(this.fScope);
            if (type == null) {
                String title = JavaUIMessages.getString((String)"TypeSelectionDialog.errorTitle");
                String message = JavaUIMessages.getFormattedString((String)"TypeSelectionDialog.dialogMessage", (String)ref.getPath());
                MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                this.setResult(null);
            } else {
                ArrayList<IType> result = new ArrayList<IType>(1);
                result.add(type);
                this.setResult(result);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_6, ajc$tjp_7);
            JavaModelException e = javaModelException2;
            String string = JavaUIMessages.getString((String)"TypeSelectionDialog.errorTitle");
            String message = JavaUIMessages.getString((String)"TypeSelectionDialog.errorMessage");
            ErrorDialog.openError((Shell)this.getShell(), (String)string, (String)message, (IStatus)e.getStatus());
            this.setResult(null);
        }
    }

    private boolean isCacheUpToDate() throws InvocationTargetException, InterruptedException {
        final boolean[] result = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    result[0] = AllTypesCache.isCacheUpToDate((IProgressMonitor)monitor);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
        return result[0];
    }

    static {
        Factory factory = new Factory("TypeSelectionDialog.java", Class.forName("org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog-java.lang.reflect.InvocationTargetException-e-"), 205);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-open-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog----int-"), 189);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog-java.lang.InterruptedException-<missing>-"), 208);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog-org.eclipse.jdt.core.JavaModelException-<missing>-"), 273);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAspectJTypes-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog-org.eclipse.jdt.core.search.IJavaSearchScope:-scope:--java.util.List-"), 234);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog-org.eclipse.core.runtime.CoreException-<missing>-"), 274);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog-org.eclipse.jdt.core.JavaModelException-e-"), 305);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-computeResult-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog----void-"), 286);
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        TypeFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
            int qualifierIndex = pattern.lastIndexOf(".");
            if (qualifierIndex == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern), ignoreCase, igoreWildCards);
            } else {
                this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern.substring(qualifierIndex + 1)), ignoreCase, igoreWildCards);
            }
        }

        public boolean match(Object element) {
            if (!(element instanceof TypeInfo)) {
                return false;
            }
            TypeInfo type = (TypeInfo)element;
            if (!this.fMatcher.match(type.getTypeName())) {
                return false;
            }
            if (this.fQualifierMatcher == null) {
                return true;
            }
            return this.fQualifierMatcher.match(type.getTypeContainerName());
        }

        private String adjustPattern(String pattern) {
            int length = pattern.length();
            if (length > 0) {
                switch (pattern.charAt(length - 1)) {
                    case '<': {
                        pattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case '*': {
                        break;
                    }
                    default: {
                        pattern = String.valueOf(pattern) + '*';
                    }
                }
            }
            return pattern;
        }
    }

    private static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object left, Object right) {
            String leftString = (String)left;
            String rightString = (String)right;
            if (Strings.isLowerCase((char)leftString.charAt(0)) && !Strings.isLowerCase((char)rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase((char)rightString.charAt(0)) && !Strings.isLowerCase((char)leftString.charAt(0))) {
                return -1;
            }
            int result = leftString.compareToIgnoreCase(rightString);
            if (result == 0) {
                result = leftString.compareTo(rightString);
            }
            return result;
        }
    }
}

