/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewAspectCreationWizardPage
extends WizardPage
implements Listener {
    private Button createMainButton;
    private Button modPublicButton;
    private Button modAbstractButton;
    private Button modFinalButton;
    private Button modPrivilegedButton;
    private Button modStaticButton;
    private Button packageBrowseButton;
    private Button sourceBrowseButton;
    private Button enclosingTypeButton;
    private Button enclosingBrowseButton;
    private Button supertypeBrowseButton;
    private Button addInterfaceButton;
    private Button removeInterfaceButton;
    private Button instantiationButton;
    private Button instSingletonButton;
    private Button instPerthisButton;
    private Button instPertargetButton;
    private Button instPercflowButton;
    private Button instPercflowbelowButton;
    private Button instPertypewithinButton;
    private Label packageLabel;
    private org.eclipse.swt.widgets.List interfaceList;
    private Text sourceText;
    private Text packageText;
    private Text nameText;
    private Text enclosingText;
    private Text extendsText;
    private String initialSourceString;
    private String initialPackageString;
    private String initialEnclosingTypeString;
    private IStructuredSelection currentSelection;
    private IWorkbench workbench;
    private IJavaProject jproject;
    private IPackageFragmentRoot fCurrRoot;
    private IJavaElement jelem;
    private IType fCurrEnclosingType;
    private IFile dotjavaFile;
    private static final Status okStatus;
    private static final int SOURCE_STATUS = 0;
    private static final int PACKAGE_STATUS = 1;
    private static final int ENCLOSING_STATUS = 2;
    private static final int NAME_STATUS = 3;
    private Status[] statusArray = new Status[4];
    private static String lineDelimiter;
    private ImportManager imports;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;

    static {
        Factory factory = new Factory("NewAspectCreationWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.JavaModelException-<missing>-"), 213);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-initSourceFolder-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.IJavaElement:-elem:--void-"), 197);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.ui.PartInitException-<missing>-"), 1085);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-finish-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage----boolean-"), 1063);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.JavaModelException-<missing>-"), 1123);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createNewFile-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage----org.eclipse.core.resources.IFile-"), 1097);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.core.runtime.CoreException-<missing>-"), 1204);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createInnerType-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage----void-"), 1167);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-java.lang.InterruptedException-<missing>-"), 1229);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createType-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.core.resources.IFile:java.io.InputStream:-newFile:initialContents:--boolean-"), 1211);
        ajc$tjp_18 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-java.lang.reflect.InvocationTargetException-<missing>-"), 1231);
        ajc$tjp_19 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.core.runtime.CoreException-<missing>-"), 1249);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.JavaModelException-<missing>-"), 727);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-doTemplate-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-java.lang.String:java.lang.String:-typeContent:lineDelimiter:--java.lang.String-"), 1241);
        ajc$tjp_21 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.core.runtime.CoreException-<missing>-"), 1279);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getTypeComment-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.ICompilationUnit:-parentCU:--java.lang.String-"), 1263);
        ajc$tjp_23 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.compiler.InvalidInputException-<missing>-"), 1296);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isValidComment-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-java.lang.String:-template:--boolean-"), 1286);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateEnclosingStatus-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage----void-"), 660);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-java.lang.ClassNotFoundException-<missing>-"), 927);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-chooseSourceContainer-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.IJavaElement:-initElement:--org.eclipse.jdt.core.IPackageFragmentRoot-"), 927);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-java.lang.ClassNotFoundException-<missing>-"), 928);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-java.lang.ClassNotFoundException-<missing>-"), 928);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage-org.eclipse.jdt.core.JavaModelException-<missing>-"), 980);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-choosePackage-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage----org.eclipse.jdt.core.IPackageFragment-"), 974);
        okStatus = new Status(0, "org.eclipse.ajdt.ui", 0, "", null);
        lineDelimiter = System.getProperty("line.separator", "\n");
    }

    public NewAspectCreationWizardPage(String pageName, IWorkbench workbench, IStructuredSelection selection) {
        super(pageName);
        this.setPageComplete(false);
        this.currentSelection = selection;
        this.setTitle(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.title"));
        this.setDescription(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.description"));
        this.workbench = workbench;
        this.init();
    }

    public void init() {
        this.jelem = NewAspectUtils.getInitialJavaElement(this.currentSelection);
        this.initSourceFolder(this.jelem);
        this.initPackage(this.jelem);
        this.initEnclosingType(this.jelem);
    }

    private void initSourceFolder(IJavaElement elem) {
        this.initialSourceString = "";
        if (elem != null) {
            this.fCurrRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)elem);
            if (this.fCurrRoot == null || this.fCurrRoot.isArchive()) {
                this.jproject = elem.getJavaProject();
                if (this.jproject != null && this.jproject.exists()) {
                    this.fCurrRoot = null;
                    try {
                        IPackageFragmentRoot[] roots = this.jproject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                this.fCurrRoot = roots[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        JavaModelException javaModelException2 = javaModelException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    }
                }
            }
            if (this.fCurrRoot != null) {
                this.initialSourceString = this.fCurrRoot.getPath().makeRelative().toString();
            }
        }
    }

    private void initPackage(IJavaElement elem) {
        IPackageFragment pack;
        this.initialPackageString = "";
        if (elem != null && (pack = (IPackageFragment)elem.getAncestor(4)) != null) {
            this.initialPackageString = pack.getElementName();
        }
    }

    private void initEnclosingType(IJavaElement elem) {
        IType enclosingType = null;
        if (elem != null) {
            IType typeInCU = (IType)elem.getAncestor(7);
            if (typeInCU != null) {
                if (typeInCU.getCompilationUnit() != null) {
                    enclosingType = typeInCU;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
                if (cu != null) {
                    enclosingType = cu.findPrimaryType();
                }
            }
        }
        this.initialEnclosingTypeString = enclosingType != null ? enclosingType.getFullyQualifiedName() : "";
    }

    public void createControl(Composite parent) {
        int ncol;
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 4;
        composite.setLayout((Layout)gl);
        new Label(composite, 0).setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.sourceFolder.label"));
        this.sourceText = new Text(composite, 2048);
        this.sourceText.setText(this.initialSourceString);
        this.updateSourceStatus();
        GridData gd = new GridData(768);
        gd.horizontalSpan = ncol - 2;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.sourceText.setLayoutData((Object)gd);
        this.sourceBrowseButton = new Button(composite, 8);
        this.sourceBrowseButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.sourceFolder.button"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = NewAspectUtils.getButtonWidthHint(this.sourceBrowseButton);
        this.sourceBrowseButton.setLayoutData((Object)gd);
        this.packageLabel = new Label(composite, 0);
        this.packageLabel.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.package.label"));
        this.packageText = new Text(composite, 2048);
        this.packageText.setText(this.initialPackageString);
        this.updatePackageStatus();
        gd = new GridData(768);
        gd.horizontalSpan = ncol - 2;
        gd.grabExcessHorizontalSpace = true;
        this.packageText.setLayoutData((Object)gd);
        this.packageBrowseButton = new Button(composite, 8);
        this.packageBrowseButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.package.button"));
        this.packageBrowseButton.addListener(13, (Listener)this);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = NewAspectUtils.getButtonWidthHint(this.packageBrowseButton);
        this.packageBrowseButton.setLayoutData((Object)gd);
        if (this.statusArray[0] != okStatus) {
            this.packageBrowseButton.setEnabled(false);
        }
        this.enclosingTypeButton = new Button(composite, 32);
        this.enclosingTypeButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.enclosingType.label"));
        this.enclosingTypeButton.addListener(13, (Listener)this);
        this.enclosingText = new Text(composite, 2048);
        this.enclosingText.setText(this.initialEnclosingTypeString);
        this.enclosingText.setEnabled(false);
        this.updateEnclosingStatus();
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = ncol - 2;
        this.enclosingText.setLayoutData((Object)gd);
        this.enclosingBrowseButton = new Button(composite, 8);
        this.enclosingBrowseButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.enclosingType.button"));
        this.enclosingBrowseButton.addListener(13, (Listener)this);
        this.enclosingBrowseButton.setEnabled(false);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = NewAspectUtils.getButtonWidthHint(this.enclosingBrowseButton);
        this.enclosingBrowseButton.setLayoutData((Object)gd);
        NewAspectUtils.createLine(composite, ncol);
        new Label(composite, 0).setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.typeName.label"));
        this.nameText = new Text(composite, 2048);
        this.updateNameStatus();
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = ncol - 2;
        this.nameText.setLayoutData((Object)gd);
        NewAspectUtils.createBlank(composite);
        new Label(composite, 0).setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.modifiers.label"));
        Composite modComposite = new Composite(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = ncol - 2;
        modComposite.setLayoutData((Object)gd);
        GridLayout mgl = new GridLayout();
        mgl.marginWidth = 0;
        mgl.marginHeight = 0;
        mgl.numColumns = 5;
        modComposite.setLayout((Layout)mgl);
        this.modPublicButton = new Button(modComposite, 32);
        this.modPublicButton.setSelection(true);
        this.modPublicButton.setText("public");
        this.modAbstractButton = new Button(modComposite, 32);
        this.modAbstractButton.setSelection(false);
        this.modAbstractButton.setText("abstract");
        this.modFinalButton = new Button(modComposite, 32);
        this.modFinalButton.setSelection(false);
        this.modFinalButton.setText("final");
        this.modPrivilegedButton = new Button(modComposite, 32);
        this.modPrivilegedButton.setSelection(false);
        this.modPrivilegedButton.setText("privileged");
        this.modStaticButton = new Button(modComposite, 32);
        this.modStaticButton.setSelection(false);
        this.modStaticButton.setEnabled(false);
        this.modStaticButton.setText("static");
        NewAspectUtils.createBlank(composite);
        this.instantiationButton = new Button(composite, 32);
        this.instantiationButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.instantiation.label"));
        this.instantiationButton.setSelection(false);
        this.instantiationButton.addListener(13, (Listener)this);
        Composite instComposite = new Composite(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = ncol - 2;
        instComposite.setLayoutData((Object)gd);
        GridLayout igl = new GridLayout();
        igl.marginWidth = 0;
        igl.marginHeight = 0;
        igl.numColumns = 3;
        instComposite.setLayout((Layout)igl);
        this.instSingletonButton = new Button(instComposite, 16);
        this.instSingletonButton.setEnabled(false);
        this.instSingletonButton.setSelection(true);
        this.instSingletonButton.setText("issingleton");
        this.instPerthisButton = new Button(instComposite, 16);
        this.instPerthisButton.setEnabled(false);
        this.instPerthisButton.setSelection(false);
        this.instPerthisButton.setText("perthis");
        this.instPertargetButton = new Button(instComposite, 16);
        this.instPertargetButton.setEnabled(false);
        this.instPertargetButton.setSelection(false);
        this.instPertargetButton.setText("pertarget");
        this.instPercflowButton = new Button(instComposite, 16);
        this.instPercflowButton.setEnabled(false);
        this.instPercflowButton.setSelection(false);
        this.instPercflowButton.setText("percflow");
        this.instPercflowbelowButton = new Button(instComposite, 16);
        this.instPercflowbelowButton.setEnabled(false);
        this.instPercflowbelowButton.setSelection(false);
        this.instPercflowbelowButton.setText("percflowbelow");
        this.instPertypewithinButton = new Button(instComposite, 16);
        this.instPertypewithinButton.setEnabled(false);
        this.instPertypewithinButton.setSelection(false);
        this.instPertypewithinButton.setText("pertypewithin");
        NewAspectUtils.createBlank(composite);
        new Label(composite, 0).setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.supertype.label"));
        this.extendsText = new Text(composite, 2048);
        this.extendsText.setText("java.lang.Object");
        gd = new GridData(768);
        gd.horizontalSpan = ncol - 2;
        gd.grabExcessHorizontalSpace = true;
        this.extendsText.setLayoutData((Object)gd);
        this.supertypeBrowseButton = new Button(composite, 8);
        this.supertypeBrowseButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.enclosingType.button"));
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = NewAspectUtils.getButtonWidthHint(this.supertypeBrowseButton);
        this.supertypeBrowseButton.setLayoutData((Object)gd);
        this.supertypeBrowseButton.addListener(13, (Listener)this);
        Label interfaceLabel = new Label(composite, 0);
        interfaceLabel.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.interfaces.label"));
        gd = new GridData(2);
        interfaceLabel.setLayoutData((Object)gd);
        this.interfaceList = new org.eclipse.swt.widgets.List(composite, 2050);
        gd = new GridData(1808);
        gd.horizontalSpan = ncol - 2;
        this.interfaceList.setLayoutData((Object)gd);
        Composite contents = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        this.addInterfaceButton = new Button(contents, 8);
        this.addInterfaceButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.interfaces.add.button"));
        this.addInterfaceButton.addListener(13, (Listener)this);
        gd = new GridData(768);
        gd.widthHint = NewAspectUtils.getButtonWidthHint(this.addInterfaceButton);
        this.addInterfaceButton.setLayoutData((Object)gd);
        NewAspectUtils.createBlank(contents);
        this.removeInterfaceButton = new Button(contents, 8);
        this.removeInterfaceButton.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.interfaces.remove.button"));
        this.removeInterfaceButton.addListener(13, (Listener)this);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = NewAspectUtils.getButtonWidthHint(this.removeInterfaceButton);
        this.sourceBrowseButton.setLayoutData((Object)gd);
        this.removeInterfaceButton.setLayoutData((Object)gd);
        Label stubsLabel = new Label(composite, 0);
        stubsLabel.setText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.methodStubs.label"));
        gd = new GridData();
        gd.horizontalSpan = ncol;
        stubsLabel.setLayoutData((Object)gd);
        NewAspectUtils.createBlank(composite);
        this.createMainButton = new Button(composite, 32);
        this.createMainButton.setSelection(false);
        this.createMainButton.setText("public static void main(String[] args)");
        gd = new GridData(768);
        gd.horizontalSpan = ncol - 1;
        this.createMainButton.setLayoutData((Object)gd);
        this.setControl((Control)composite);
        this.sourceText.addListener(2, (Listener)this);
        this.packageText.addListener(2, (Listener)this);
        this.nameText.addListener(2, (Listener)this);
        this.enclosingText.addListener(2, (Listener)this);
    }

    public boolean isPageComplete() {
        if (this.statusArray[0] == null || this.statusArray[0].matches(4)) {
            return false;
        }
        if (this.statusArray[1] == null || this.statusArray[1].matches(4)) {
            return false;
        }
        return this.statusArray[3] != null && !this.statusArray[3].matches(4);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameText.setFocus();
        }
    }

    private void updateNameStatus() {
        this.statusArray[3] = okStatus;
        if (NewAspectUtils.isTextNonEmpty(this.nameText)) {
            String typeName = this.getTypeName();
            if (typeName.indexOf(46) != -1) {
                this.statusArray[3] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.Name_field_cannot_be_qualified"), null);
            } else {
                IStatus val = JavaConventions.validateJavaTypeName((String)typeName);
                if (val.matches(4)) {
                    this.statusArray[3] = new Status(4, "org.eclipse.ajdt.ui", 0, val.getMessage(), null);
                } else if (val.matches(2)) {
                    this.statusArray[3] = new Status(2, "org.eclipse.ajdt.ui", 0, val.getMessage(), null);
                }
            }
        } else {
            this.statusArray[3] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.Name_field_cannot_be_empty"), null);
        }
    }

    private void updateSourceStatus() {
        this.statusArray[0] = okStatus;
        if (!NewAspectUtils.isTextNonEmpty(this.sourceText)) {
            this.statusArray[0] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.Source_folder_cannot_be_empty"), null);
        } else {
            Path path = new Path(this.sourceText.getText());
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res == null) {
                this.statusArray[0] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.Source_folder_does_not_exist"), null);
            }
        }
    }

    private void updatePackageStatus() {
        this.statusArray[1] = okStatus;
        if (NewAspectUtils.isTextNonEmpty(this.packageText)) {
            IStatus val = JavaConventions.validatePackageName((String)this.packageText.getText());
            if (val.matches(4)) {
                this.statusArray[1] = new Status(4, "org.eclipse.ajdt.ui", 0, val.getMessage(), null);
            } else if (val.matches(2)) {
                this.statusArray[1] = new Status(2, "org.eclipse.ajdt.ui", 0, val.getMessage(), null);
            }
        }
    }

    private void updateEnclosingStatus() {
        this.statusArray[2] = okStatus;
        if (!this.enclosingTypeButton.getSelection()) {
            return;
        }
        this.fCurrEnclosingType = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        String enclName = this.enclosingText.getText();
        if (enclName.length() == 0) {
            this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingTypeEnterName"), null);
            return;
        }
        try {
            IType type = this.findType(root.getJavaProject(), enclName);
            if (type == null) {
                this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingTypeNotExists"), null);
                return;
            }
            if (type.getCompilationUnit() == null) {
                this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingNotInCU"), null);
                return;
            }
            if (!JavaModelUtil.isEditable((ICompilationUnit)type.getCompilationUnit())) {
                this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingNotEditable"), null);
                return;
            }
            this.fCurrEnclosingType = type;
            IPackageFragmentRoot enclosingRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)type);
            if (!enclosingRoot.equals(root)) {
                this.statusArray[2] = new Status(2, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.warning.EnclosingNotInSourceFolder"), null);
            }
            return;
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
            this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingTypeNotExists"), null);
            return;
        }
    }

    public void handleEvent(Event event) {
        IType iType;
        if (event.widget == this.nameText) {
            this.updateNameStatus();
        } else if (event.widget == this.sourceText) {
            this.updateSourceStatus();
            if (this.statusArray[0] == okStatus) {
                this.packageBrowseButton.setEnabled(true);
            } else {
                this.packageBrowseButton.setEnabled(false);
            }
        } else if (event.widget == this.packageText) {
            this.updatePackageStatus();
        } else if (event.widget == this.enclosingText) {
            this.updateEnclosingStatus();
        } else if (event.widget == this.sourceBrowseButton) {
            IPackageFragmentRoot newSource = this.chooseSourceContainer(this.jelem);
            if (newSource != null) {
                this.sourceText.setText(newSource.getPath().makeRelative().toString());
                this.fCurrRoot = newSource;
                this.updateSourceStatus();
            }
            if (this.statusArray[0] == okStatus) {
                this.packageBrowseButton.setEnabled(true);
            } else {
                this.packageBrowseButton.setEnabled(false);
            }
        } else if (event.widget == this.packageBrowseButton) {
            IPackageFragment newPack = this.choosePackage();
            if (newPack != null) {
                this.packageText.setText(newPack.getElementName());
                this.updatePackageStatus();
            }
        } else if (event.widget == this.enclosingTypeButton) {
            if (this.enclosingTypeButton.getSelection()) {
                this.enclosingText.setEnabled(true);
                this.enclosingBrowseButton.setEnabled(true);
                this.packageLabel.setEnabled(false);
                this.packageText.setEnabled(false);
                this.packageBrowseButton.setEnabled(false);
                this.modStaticButton.setEnabled(true);
                this.modStaticButton.setSelection(true);
            } else {
                this.enclosingText.setEnabled(false);
                this.enclosingBrowseButton.setEnabled(false);
                this.packageLabel.setEnabled(true);
                this.packageText.setEnabled(true);
                this.packageBrowseButton.setEnabled(true);
                this.modStaticButton.setEnabled(false);
                this.modStaticButton.setSelection(false);
            }
            this.updateEnclosingStatus();
        } else if (event.widget == this.addInterfaceButton) {
            SuperInterfaceSelectionDialog dialog = new SuperInterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.interfaceList, this.jproject);
            dialog.setTitle(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.InterfacesDialog.class.title"));
            dialog.setMessage(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.InterfacesDialog.message"));
            dialog.open();
        } else if (event.widget == this.removeInterfaceButton) {
            String[] selected = this.interfaceList.getSelection();
            int i = 0;
            while (i < selected.length) {
                this.interfaceList.remove(selected[i]);
                ++i;
            }
        } else if (event.widget == this.enclosingBrowseButton) {
            IType type = this.chooseEnclosingType();
            if (type != null) {
                this.enclosingText.setText(type.getFullyQualifiedName());
                this.updateEnclosingStatus();
            }
        } else if (event.widget == this.instantiationButton) {
            boolean iset = this.instantiationButton.getSelection();
            this.instSingletonButton.setEnabled(iset);
            this.instPerthisButton.setEnabled(iset);
            this.instPertargetButton.setEnabled(iset);
            this.instPercflowButton.setEnabled(iset);
            this.instPercflowbelowButton.setEnabled(iset);
            this.instPertypewithinButton.setEnabled(iset);
        } else if (event.widget == this.supertypeBrowseButton && (iType = this.chooseSuperType()) != null) {
            this.extendsText.setText(iType.getFullyQualifiedName());
        }
        this.applyToStatusLine(this.mostSevereStatus());
        this.getWizard().getContainer().updateButtons();
    }

    private IType findType(IJavaProject project, String typeName) throws JavaModelException {
        if (project.exists()) {
            return project.findType(typeName);
        }
        return null;
    }

    private IStatus mostSevereStatus() {
        IStatus s_error = this.severityMatch(4);
        if (s_error != null) {
            return s_error;
        }
        IStatus s_warn = this.severityMatch(2);
        if (s_warn != null) {
            return s_warn;
        }
        IStatus s_info = this.severityMatch(1);
        if (s_info != null) {
            return s_info;
        }
        return okStatus;
    }

    private IStatus severityMatch(int sev) {
        int i = 0;
        while (i < this.statusArray.length) {
            if (this.statusArray[i].matches(sev)) {
                return this.statusArray[i];
            }
            ++i;
        }
        return null;
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    public String getTypeName() {
        return this.nameText.getText();
    }

    private IType chooseEnclosingType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root});
        org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog dialog = new org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 0, scope);
        dialog.setTitle(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.ChooseEnclosingTypeDialog.title"));
        dialog.setMessage(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.ChooseEnclosingTypeDialog.description"));
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IPackageFragmentRoot chooseSourceContainer(IJavaElement initElement) {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
                throw new NoClassDefFoundError(classNotFoundException2.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException3 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException3, (Object)this, ajc$tjp_6, ajc$tjp_5);
                throw new NoClassDefFoundError(classNotFoundException3.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException4 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException4, (Object)this, ajc$tjp_7, ajc$tjp_5);
                throw new NoClassDefFoundError(classNotFoundException4.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class[] acceptedClasses = classArray;
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException javaModelException) {
                        JavaModelException javaModelException2 = javaModelException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }

            static {
                Factory factory = new Factory("NewAspectCreationWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$1-org.eclipse.jdt.core.JavaModelException-<missing>-"), 934);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-select-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$1-org.eclipse.jface.viewers.Viewer:java.lang.Object:java.lang.Object:-viewer:parent:element:--boolean-"), 931);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.FolderSelectionDialog.title"));
        dialog.setMessage(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.FolderSelectionDialog.message"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        dialog.setInitialSelection((Object)initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_8, ajc$tjp_9);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.ChoosePackageDialog.title"));
        dialog.setMessage(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.ChoosePackageDialog.message"));
        dialog.setEmptyListMessage(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.ChoosePackageDialog.empty"));
        dialog.setElements(packages);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    private IType chooseSuperType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 5, scope);
        dialog.setTitle(AspectJUIPlugin.getResourceString("NewTypeWizardPage.SuperClassDialog.title"));
        dialog.setMessage(AspectJUIPlugin.getResourceString("NewTypeWizardPage.SuperClassDialog.message"));
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IPackageFragment getPackageFragment() {
        return this.fCurrRoot.getPackageFragment(this.packageText.getText());
    }

    public IType getEnclosingType() {
        if (this.enclosingTypeButton.getSelection()) {
            return this.fCurrEnclosingType;
        }
        return null;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public boolean finish() {
        if (this.enclosingTypeButton.getSelection()) {
            this.createInnerType();
            return true;
        }
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        InputStream initialContents = this.getInitialContents();
        this.createType(newFile, initialContents);
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            PartInitException partInitException2 = partInitException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException2, (Object)this, ajc$tjp_10, ajc$tjp_11);
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)newFile, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        AJDTEventTrace.newAspectCreated(newFile);
        return true;
    }

    private IFile createNewFile() {
        String sourceName = this.sourceText.getText();
        Path path = new Path(sourceName);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = workspaceRoot.findMember((IPath)path);
        IProject proj = res.getProject();
        IResource pack = null;
        String packName = this.packageText.getText();
        if (res.getType() == 2) {
            IFolder folder = (IFolder)res;
            pack = folder.findMember(packName);
        } else if (res.getType() == 4) {
            pack = ((IProject)res).findMember(packName);
        } else {
            return null;
        }
        if (pack == null) {
            IJavaProject jproject = JavaCore.create((IProject)proj);
            IPackageFragmentRoot root = jproject.getPackageFragmentRoot(res);
            try {
                IPackageFragment frag = root.createPackageFragment(packName, true, null);
                pack = frag.getResource();
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_12, ajc$tjp_13);
            }
        }
        String aspectName = this.getTypeName();
        String extName = AspectJPreferences.getFileExt();
        IPath newpath = pack.getFullPath().append(String.valueOf(aspectName) + extName);
        IFile newfile = workspaceRoot.getFile(newpath);
        if (extName.equals(".java")) {
            this.dotjavaFile = newfile;
        } else {
            IPath dummyPath = newpath.removeFileExtension().addFileExtension("java");
            this.dotjavaFile = workspaceRoot.getFile(dummyPath);
        }
        return newfile;
    }

    protected InputStream getInitialContents() {
        String contents = this.constructTypeStub();
        String sb = this.doTemplate(contents, lineDelimiter);
        return new ByteArrayInputStream(sb.getBytes());
    }

    private String getInnerTypeContents(ICompilationUnit cu, int indent) {
        StringBuffer content = new StringBuffer();
        content.append(lineDelimiter);
        String comment = this.getTypeComment(cu);
        if (comment != null) {
            content.append(comment);
            content.append(lineDelimiter);
        }
        content.append(this.constructTypeStub());
        return this.codeFormat(content.toString(), indent, lineDelimiter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createInnerType() {
        try {
            IType enclosingType = this.getEnclosingType();
            IFile enclosingFile = null;
            if (enclosingType.getResource().getType() == 1) {
                enclosingFile = (IFile)enclosingType.getResource();
            }
            ICompilationUnit parentCU = enclosingType.getCompilationUnit();
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)parentCU);
            IEditorInput input = editor.getEditorInput();
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            manager.connect(input);
            try {
                ICompilationUnit workingCopy = manager.getWorkingCopy(input);
                IBuffer buf = workingCopy.getBuffer();
                String originalContent = buf.getContents();
                int pos = NewAspectUtils.getInnerInsertionPoint(originalContent, enclosingType.getElementName());
                int indent = NewAspectUtils.getIndentUsed((IJavaElement)enclosingType) + 1;
                String formattedContent = this.getInnerTypeContents(workingCopy, indent);
                buf.replace(pos, 0, formattedContent);
                String importContent = this.imports.getImports();
                if (importContent.length() > 0) {
                    int importPos = NewAspectUtils.getInnerImportsInsertionPoint(originalContent.substring(0, pos));
                    buf.replace(importPos, 0, String.valueOf(lineDelimiter) + importContent);
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                manager.disconnect(input);
                throw throwable;
            }
            {
                Object var15_17 = null;
            }
            manager.disconnect(input);
            AJDTEventTrace.newAspectCreated(enclosingFile);
            return;
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_14, ajc$tjp_15);
        }
    }

    public boolean createType(final IFile newFile, final InputStream initialContents) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.CreatingAspect.message"), 2000);
                        newFile.create(initialContents, false, monitor);
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var2_5 = null;
                }
                monitor.done();
            }

            static {
                Factory factory = new Factory("NewAspectCreationWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$2"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$2-org.eclipse.core.runtime.CoreException-<missing>-"), 1220);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-execute-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$2-org.eclipse.core.runtime.IProgressMonitor:-monitor:-org.eclipse.core.runtime.CoreException:java.lang.InterruptedException:-void-"), 1215);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_16, ajc$tjp_17);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_18, ajc$tjp_17);
            return true;
        }
        return true;
    }

    private String doTemplate(String typeContent, String lineDelimiter) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)this.dotjavaFile);
        try {
            String imp = this.imports.getImports();
            String typeComment = String.valueOf(imp) + this.getTypeComment(cu);
            String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cu, (String)typeComment, (String)typeContent, (String)lineDelimiter);
            return content;
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_19, ajc$tjp_20);
            return "";
        }
    }

    protected String getTypeComment(ICompilationUnit parentCU) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc")) {
            try {
                StringBuffer typeName = new StringBuffer();
                if (this.enclosingTypeButton.getSelection()) {
                    typeName.append(JavaModelUtil.getTypeQualifiedName((IType)this.getEnclosingType())).append('.');
                }
                typeName.append(this.getTypeName());
                String comment = CodeGeneration.getTypeComment((ICompilationUnit)parentCU, (String)typeName.toString(), (String)String.valueOf('\n'));
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_21, ajc$tjp_22);
            }
        }
        return "";
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (next == 1001 || next == 1003 || next == 1002) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            InvalidInputException invalidInputException2 = invalidInputException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invalidInputException2, (Object)this, ajc$tjp_23, ajc$tjp_24);
            return false;
        }
    }

    private String getInterfaceString() {
        String[] interfaces = this.interfaceList.getItems();
        if (interfaces.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("implements ");
        int i = 0;
        while (i < interfaces.length) {
            sb.append(this.imports.addImport(interfaces[i]));
            if (i < interfaces.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(" ");
        return sb.toString();
    }

    private String getInstantiationString() {
        String s = "";
        if (this.instantiationButton.getSelection()) {
            if (this.instSingletonButton.getSelection()) {
                s = "issingleton() ";
            } else if (this.instPerthisButton.getSelection()) {
                s = "perthis(pointcut_name()) ";
            } else if (this.instPertargetButton.getSelection()) {
                s = "pertarget(pointcut_name()) ";
            } else if (this.instPercflowButton.getSelection()) {
                s = "percflow(pointcut_name()) ";
            } else if (this.instPercflowbelowButton.getSelection()) {
                s = "percflowbelow(pointcut_name()) ";
            } else if (this.instPertypewithinButton.getSelection()) {
                s = "pertypewithin(type_pattern) ";
            }
        }
        return s;
    }

    private String constructTypeStub() {
        String extText;
        this.imports = new ImportManager();
        StringBuffer sb = new StringBuffer();
        if (this.modPublicButton.getSelection()) {
            sb.append("public ");
        }
        if (this.modAbstractButton.getSelection()) {
            sb.append("abstract ");
        }
        if (this.modFinalButton.getSelection()) {
            sb.append("final ");
        }
        if (this.modPrivilegedButton.getSelection()) {
            sb.append("privileged ");
        }
        if (this.modStaticButton.getSelection()) {
            sb.append("static ");
        }
        sb.append("aspect " + this.getTypeName() + " " + this.getInstantiationString());
        if (NewAspectUtils.isTextNonEmpty(this.extendsText) && !(extText = this.extendsText.getText()).equals("java.lang.Object")) {
            sb.append("extends " + this.imports.addImport(extText) + " ");
        }
        sb.append(this.getInterfaceString());
        sb.append("{");
        sb.append(lineDelimiter);
        if (this.createMainButton.getSelection()) {
            sb.append(lineDelimiter);
            sb.append("\tpublic static void main(String[] args) {");
            sb.append(lineDelimiter);
            sb.append("\t}");
        }
        sb.append(lineDelimiter);
        sb.append("}");
        sb.append(lineDelimiter);
        return sb.toString();
    }

    private String codeFormat(String sourceString, int initialIndentationLevel, String lineDelim) {
        return CodeFormatterUtil.format((int)4, (String)sourceString, (int)initialIndentationLevel, null, (String)lineDelim, (IJavaProject)this.jproject);
    }

    public static class NewAspectUtils {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;
        private static final JoinPoint.StaticPart ajc$tjp_4;
        private static final JoinPoint.StaticPart ajc$tjp_5;
        private static final JoinPoint.StaticPart ajc$tjp_6;

        public static void createBlank(Composite parent) {
            new Label(parent, 0);
        }

        public static void createLine(Composite parent, int ncol) {
            Label line = new Label(parent, 259);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = ncol;
            line.setLayoutData((Object)gridData);
        }

        public static boolean isTextNonEmpty(Text t) {
            String s = t.getText();
            return s != null && s.trim().length() > 0;
        }

        public static int getButtonWidthHint(Button button) {
            if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
                button.setFont(JFaceResources.getDialogFont());
            }
            GC gc = new GC((Drawable)button);
            gc.setFont(button.getFont());
            FontMetrics fFontMetrics = gc.getFontMetrics();
            gc.dispose();
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fFontMetrics, (int)61);
            return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        }

        protected static IJavaElement getInitialJavaElement(IStructuredSelection selection) {
            Object selectedElement;
            IJavaProject jelem = null;
            if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)selectedElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException2 = classNotFoundException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(classNotFoundException2, ajc$tjp_0, ajc$tjp_1);
                        throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                    }
                }
                if ((jelem = (IJavaElement)adaptable.getAdapter((Class)clazz)) == null) {
                    IResource resource;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ClassNotFoundException classNotFoundException3 = classNotFoundException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(classNotFoundException3, ajc$tjp_2, ajc$tjp_1);
                            throw new NoClassDefFoundError(classNotFoundException3.getMessage());
                        }
                    }
                    if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null && resource.getType() != 8) {
                        while (jelem == null && resource.getType() != 4) {
                            resource = resource.getParent();
                            Class<?> clazz3 = class$0;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassNotFoundException classNotFoundException4 = classNotFoundException;
                                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(classNotFoundException4, ajc$tjp_3, ajc$tjp_1);
                                    throw new NoClassDefFoundError(classNotFoundException4.getMessage());
                                }
                            }
                            jelem = (IJavaElement)resource.getAdapter((Class)clazz3);
                        }
                        if (jelem == null) {
                            jelem = JavaCore.create((IResource)resource);
                        }
                    }
                }
            }
            if (jelem == null || jelem.getElementType() == 1) {
                try {
                    IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                    if (projects.length == 1) {
                        jelem = projects[0];
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException2 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_4, ajc$tjp_1);
                }
            }
            return jelem;
        }

        public static int getTabWidth() {
            try {
                return Integer.parseInt((String)JavaCore.getOptions().get("org.eclipse.jdt.core.formatter.tabulation.size"));
            }
            catch (NumberFormatException numberFormatException) {
                NumberFormatException numberFormatException2 = numberFormatException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(numberFormatException2, ajc$tjp_5, ajc$tjp_6);
                return 4;
            }
        }

        public static int getIndentUsed(IJavaElement elem) throws JavaModelException {
            ICompilationUnit cu;
            if (elem instanceof ISourceReference && (cu = (ICompilationUnit)elem.getAncestor(5)) != null) {
                int offset;
                IBuffer buf = cu.getBuffer();
                int i = offset = ((ISourceReference)elem).getSourceRange().getOffset();
                while (i > 0 && !NewAspectUtils.isLineDelimiterChar(buf.getChar(i - 1))) {
                    --i;
                }
                return NewAspectUtils.computeIndent(buf.getText(i, offset - i), NewAspectUtils.getTabWidth());
            }
            return 0;
        }

        public static boolean isLineDelimiterChar(char ch) {
            return ch == '\n' || ch == '\r';
        }

        public static boolean isIndentChar(char ch) {
            return Character.isWhitespace(ch) && !NewAspectUtils.isLineDelimiterChar(ch);
        }

        public static int computeIndent(String line, int tabWidth) {
            int result = 0;
            int blanks = 0;
            int size = line.length();
            int i = 0;
            while (i < size) {
                char c = line.charAt(i);
                if (c == '\t') {
                    ++result;
                    blanks = 0;
                } else if (NewAspectUtils.isIndentChar(c)) {
                    if (++blanks == tabWidth) {
                        ++result;
                        blanks = 0;
                    }
                } else {
                    return result;
                }
                ++i;
            }
            return result;
        }

        public static int getInnerInsertionPoint(String contents, String name) {
            char prev = '\u0000';
            boolean inShortComment = false;
            boolean inLongComment = false;
            int i = 0;
            while (i < contents.length()) {
                char c = contents.charAt(i);
                if (prev != '\u0000') {
                    int pos;
                    if (prev == '/' && c == '*') {
                        inLongComment = true;
                    }
                    if (!inLongComment && prev == '/' && c == '/') {
                        inShortComment = true;
                    }
                    if (!inShortComment && !inLongComment && contents.regionMatches(i, name, 0, name.length()) && (pos = contents.indexOf("{", i + name.length())) != -1) {
                        return pos + 1;
                    }
                    if (prev == '*' && c == '/') {
                        inLongComment = false;
                    } else if (inShortComment && c == '\n') {
                        inShortComment = false;
                    }
                }
                prev = c;
                ++i;
            }
            return 0;
        }

        public static int getInnerImportsInsertionPoint(String contents) {
            int p;
            char prev = '\u0000';
            boolean inShortComment = false;
            boolean inLongComment = false;
            String importStatement = "import";
            String packageStatement = "package";
            int lastImportPos = -1;
            int packagePos = -1;
            int i = 0;
            while (i < contents.length()) {
                char c = contents.charAt(i);
                if (prev != '\u0000') {
                    if (prev == '/' && c == '*') {
                        inLongComment = true;
                    }
                    if (!inLongComment && prev == '/' && c == '/') {
                        inShortComment = true;
                    }
                    if (!inShortComment && !inLongComment) {
                        if (contents.regionMatches(i, importStatement, 0, importStatement.length())) {
                            lastImportPos = i;
                        } else if (contents.regionMatches(i, packageStatement, 0, packageStatement.length())) {
                            packagePos = i;
                        }
                    }
                    if (prev == '*' && c == '/') {
                        inLongComment = false;
                    } else if (inShortComment && c == '\n') {
                        inShortComment = false;
                    }
                }
                prev = c;
                ++i;
            }
            if (lastImportPos == -1 ? packagePos != -1 && (p = contents.indexOf(59, packagePos)) >= 0 : (p = contents.indexOf(59, lastImportPos)) >= 0) {
                return p + 1;
            }
            return 0;
        }

        static {
            Factory factory = new Factory("NewAspectCreationWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils-java.lang.ClassNotFoundException-<missing>-"), 1450);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c-getInitialJavaElement-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils-org.eclipse.jface.viewers.IStructuredSelection:-selection:--org.eclipse.jdt.core.IJavaElement-"), 1443);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils-java.lang.ClassNotFoundException-<missing>-"), 1453);
            ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils-java.lang.ClassNotFoundException-<missing>-"), 1460);
            ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 1479);
            ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils-java.lang.NumberFormatException-<missing>-"), 1489);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getTabWidth-org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage$NewAspectUtils----int-"), 1487);
        }
    }

    class ImportManager {
        private List importList = new ArrayList();

        ImportManager() {
        }

        public String addImport(String type) {
            int ind = type.lastIndexOf(".");
            if (ind == -1) {
                return type;
            }
            String pack = type.substring(0, ind + 1);
            if (!pack.equals("java.lang.")) {
                this.importList.add(type);
            }
            String name = type.substring(ind + 1);
            return name;
        }

        public String getImports() {
            if (this.importList.size() == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            Iterator i = this.importList.iterator();
            while (i.hasNext()) {
                sb.append("import ");
                sb.append(i.next());
                sb.append(";");
                sb.append(lineDelimiter);
            }
            return sb.toString();
        }
    }

    class TypedViewerFilter
    extends ViewerFilter {
        private Class[] fAcceptedTypes;
        private Object[] fRejectedElements;

        public TypedViewerFilter(Class[] acceptedTypes) {
            this(acceptedTypes, null);
        }

        public TypedViewerFilter(Class[] acceptedTypes, Object[] rejectedElements) {
            Assert.isNotNull((Object)acceptedTypes);
            this.fAcceptedTypes = acceptedTypes;
            this.fRejectedElements = rejectedElements;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int i;
            if (this.fRejectedElements != null) {
                i = 0;
                while (i < this.fRejectedElements.length) {
                    if (element.equals(this.fRejectedElements[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.fAcceptedTypes.length) {
                if (this.fAcceptedTypes[i].isInstance(element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    static class SuperInterfaceSelectionDialog
    extends org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog {
        private static final int ADD_ID = 1025;
        private org.eclipse.swt.widgets.List fList;
        private String[] fOldContent;

        public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, org.eclipse.swt.widgets.List list, IJavaProject p) {
            super(parent, context, 6, SuperInterfaceSelectionDialog.createSearchScope(p));
            this.fList = list;
            this.fOldContent = this.fList.getItems();
            this.setStatusLineAboveButtons(true);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1025, "Add", true);
            super.createButtonsForButtonBar(parent);
        }

        protected void cancelPressed() {
            this.fList.setItems(this.fOldContent);
            super.cancelPressed();
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 1025) {
                this.addSelectedInterface();
            }
            super.buttonPressed(buttonId);
        }

        protected void okPressed() {
            this.addSelectedInterface();
            super.okPressed();
        }

        private void addSelectedInterface() {
            Object ref = this.getLowerSelectedElement();
            if (ref instanceof TypeInfo) {
                String qualifiedName = ((TypeInfo)ref).getFullyQualifiedName();
                if (this.fList.indexOf(qualifiedName) == -1) {
                    this.fList.add(qualifiedName);
                }
                this.updateStatus((IStatus)new Status(1, "org.eclipse.ajdt.ui", 0, AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.SuperInterfaceSelectionDialog.interfaceadded.info"), null));
            }
        }

        private static IJavaSearchScope createSearchScope(IJavaProject p) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{p});
        }

        protected void handleDefaultSelected() {
            if (this.validateCurrentSelection()) {
                this.buttonPressed(1025);
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }
    }
}

