/**
 * Copyright (c) 2005 IBM and other contributors
 * All rights reserved. 
 * This program and the accompanying materials are made available 
 * under the terms of the Common Public License v1.0 
 * which accompanies this distribution and is available at 
 * http://www.eclipse.org/legal/cpl-v10.html 
 *  
 * Contributors: 
 *     Andy Clement     initial implementation 
 * ******************************************************************/

package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.util.List;

/**
 * Implementations of this interface get told interesting information about
 * decisions made in AjState objects.  Should help us improve incremental
 * compilation, and ease the testing of incremental compilation!
 *
 * Not yet complete, will expand as we determine what extra useful information
 * should be recorded.
 * 
 * @author AndyClement
 */
public interface IStateListener {

	public void detectedClassChangeInThisDir(File f);

	public void aboutToCompareClasspaths(List oldClasspath, List newClasspath);

	public void pathChangeDetected();

	public void buildSuccessful(boolean wasFullBuild);

}
