/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.contribution.xref.core.IXReferenceProvider;
import org.eclipse.contribution.xref.internal.core.XReferencePlugin;
import org.eclipse.contribution.xref.internal.core.XReferenceProviderDefinition;
import org.eclipse.contribution.xref.internal.core.XReferenceProviderManager$AjcClosure1;
import org.eclipse.contribution.xref.internal.core.ras.XRefCoreFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class XReferenceProviderManager {
    private static XReferenceProviderManager theManager;
    private List providerList;
    private static final String PROVIDERS_EXTENSION_POINT = "org.eclipse.contribution.xref.core.providers";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    private XReferenceProviderManager() {
    }

    public static XReferenceProviderManager getManager() {
        if (theManager == null) {
            theManager = new XReferenceProviderManager();
        }
        return theManager;
    }

    public List getProvidersFor(Object o) {
        ArrayList<IXReferenceProvider> providers = new ArrayList<IXReferenceProvider>();
        List registeredProviders = this.getRegisteredProviders();
        Iterator iter = registeredProviders.iterator();
        while (iter.hasNext()) {
            XReferenceProviderDefinition element = (XReferenceProviderDefinition)iter.next();
            if (!this.providesReferencesFor(o, element)) continue;
            providers.add(element.getProvider());
        }
        return providers;
    }

    public List getRegisteredProviders() {
        if (this.providerList == null) {
            this.providerList = new ArrayList();
            IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(PROVIDERS_EXTENSION_POINT);
            IExtension[] exs = exP.getExtensions();
            int i = 0;
            while (i < exs.length) {
                IConfigurationElement[] ces = exs[i].getConfigurationElements();
                int j = 0;
                while (j < ces.length) {
                    try {
                        XReferenceProviderDefinition def = new XReferenceProviderDefinition(ces[j]);
                        this.providerList.add(def);
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        XRefCoreFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
                        CoreException e = coreException2;
                        Status status = new Status(2, "org.eclipse.contribution.xref.core", 1, "Could not load provider " + ces[j].getAttribute("id"), (Throwable)e);
                        CoreException toLog = new CoreException((IStatus)status);
                        XReferencePlugin.log(toLog);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.providerList;
    }

    private boolean providesReferencesFor(Object o, XReferenceProviderDefinition element) {
        if (!element.isEnabled()) {
            return false;
        }
        IXReferenceProvider provider = element.getProvider();
        if (provider != null) {
            IXReferenceProvider iXReferenceProvider = provider;
            Object[] objectArray = new Object[]{this, iXReferenceProvider};
            Class[] servedClasses = (Class[])IXReferenceProvider.SafeExecution.aspectOf().ajc$around$org_eclipse_contribution_xref_core_IXReferenceProvider$SafeExecution$1$b538bdbd(new XReferenceProviderManager$AjcClosure1(objectArray));
            if (servedClasses != null) {
                int i = 0;
                while (i < servedClasses.length) {
                    if (servedClasses[i].isInstance(o)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    static {
        Factory factory = new Factory("XReferenceProviderManager.java", Class.forName("org.eclipse.contribution.xref.internal.core.XReferenceProviderManager"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.internal.core.XReferenceProviderManager-org.eclipse.core.runtime.CoreException-e-"), 86);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getRegisteredProviders-org.eclipse.contribution.xref.internal.core.XReferenceProviderManager----java.util.List-"), 73);
    }

    static final Class[] getClasses_aroundBody0(XReferenceProviderManager xReferenceProviderManager, IXReferenceProvider iXReferenceProvider) {
        return iXReferenceProvider.getClasses();
    }
}

